/*
 * Decompiled with CFR 0.152.
 */
package freemind.common;

import com.jgoodies.forms.builder.DefaultFormBuilder;
import freemind.common.PropertyBean;
import freemind.common.PropertyControl;
import freemind.common.TextTranslator;
import java.awt.Component;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.JCheckBox;
import javax.swing.JLabel;

public class BooleanProperty
extends PropertyBean
implements PropertyControl {
    public static final String FALSE_VALUE = "false";
    public static final String TRUE_VALUE = "true";
    protected String mFalseValue = "false";
    protected String mTrueValue = "true";
    String description;
    String label;
    JCheckBox mCheckBox = new JCheckBox();

    public BooleanProperty(String description, String label) {
        this.description = description;
        this.label = label;
        this.mCheckBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent pE) {
                BooleanProperty.this.firePropertyChangeEvent();
            }
        });
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public String getLabel() {
        return this.label;
    }

    @Override
    public void setValue(String value) {
        if (value == null || !value.toLowerCase().equals(this.mTrueValue) && !value.toLowerCase().equals(this.mFalseValue)) {
            throw new IllegalArgumentException("Cannot set a boolean to '" + value + "', allowed are " + this.mTrueValue + " and " + this.mFalseValue + ".");
        }
        this.mCheckBox.setSelected(value.toLowerCase().equals(this.mTrueValue));
    }

    @Override
    public String getValue() {
        return this.mCheckBox.isSelected() ? this.mTrueValue : this.mFalseValue;
    }

    @Override
    public void layout(DefaultFormBuilder builder, TextTranslator pTranslator) {
        JLabel label = builder.append(pTranslator.getText(this.getLabel()), (Component)this.mCheckBox);
        label.setToolTipText(pTranslator.getText(this.getDescription()));
    }

    @Override
    public void setEnabled(boolean pEnabled) {
        this.mCheckBox.setEnabled(pEnabled);
    }
}

