/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans;

import java.io.File;
import java.io.IOException;
import java.io.ObjectInput;
import java.net.URL;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.Set;
import java.util.jar.Manifest;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.Events;
import org.netbeans.InvalidException;
import org.netbeans.Module;
import org.netbeans.ModuleData;
import org.netbeans.ModuleManager;
import org.netbeans.ProxyClassLoader;
import org.netbeans.Util;
import org.openide.util.Exceptions;

final class NetigsoModule
extends Module {
    private static final Logger LOG = Logger.getLogger(NetigsoModule.class.getName());
    private final File jar;
    private final Manifest manifest;
    private int startLevel = -1;
    private InvalidException problem;

    public NetigsoModule(Manifest mani, File jar, ModuleManager mgr, Events ev, Object history, boolean reloadable, boolean autoload, boolean eager) throws IOException {
        super(mgr, ev, history, reloadable, autoload, eager);
        this.jar = jar;
        this.manifest = mani;
    }

    @Override
    ModuleData createData(ObjectInput in, Manifest mf) throws IOException {
        if (in != null) {
            return new ModuleData(in);
        }
        return new ModuleData(mf, this);
    }

    @Override
    boolean isNetigsoImpl() {
        return true;
    }

    @Override
    protected void parseManifest() throws InvalidException {
        throw new UnsupportedOperationException();
    }

    @Override
    public File getJarFile() {
        return this.jar;
    }

    @Override
    public List<File> getAllJars() {
        return Collections.singletonList(this.jar);
    }

    @Override
    public void setReloadable(boolean r) {
        this.reloadable = true;
    }

    @Override
    public void reload() throws IOException {
        this.mgr.netigso().reload(this);
    }

    final void start() throws IOException {
        ProxyClassLoader pcl = (ProxyClassLoader)this.classloader;
        try {
            Set<String> pkgs = this.mgr.netigso().createLoader(this, pcl, this.jar);
            pcl.addCoveredPackages(pkgs);
        }
        catch (IOException ex) {
            this.classloader = null;
            throw ex;
        }
    }

    @Override
    protected void classLoaderUp(Set<Module> parents) throws IOException {
        LOG.log(Level.FINE, "classLoaderUp {0}", this.getCodeNameBase());
        assert (this.classloader == null) : "already had " + this.classloader + " for " + (Object)((Object)this);
        this.classloader = new DelegateCL();
        this.mgr.netigsoLoaderUp(this);
    }

    @Override
    protected void classLoaderDown() {
        LOG.log(Level.FINE, "classLoaderDown {0}", this.getCodeNameBase());
        ProxyClassLoader pcl = (ProxyClassLoader)this.classloader;
        this.classloader = null;
        ClassLoader l = pcl.firstParent();
        if (l == null) {
            this.mgr.netigsoLoaderDown(this);
            return;
        }
        this.mgr.netigso().stopLoader(this, l);
    }

    @Override
    public ClassLoader getClassLoader() throws IllegalArgumentException {
        if (this.classloader == null) {
            try {
                this.classLoaderUp(null);
            }
            catch (IOException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
        if (this.classloader == null) {
            throw new IllegalArgumentException("No classloader for " + this.getCodeNameBase());
        }
        return this.classloader;
    }

    @Override
    public Set<Object> getProblems() {
        InvalidException ie = this.problem;
        return ie == null ? Collections.emptySet() : Collections.singleton(ie);
    }

    final void setProblem(InvalidException ie) {
        this.problem = ie;
    }

    @Override
    public Enumeration<URL> findResources(String resources) {
        return this.mgr.netigso().findResources(this, resources);
    }

    @Override
    protected void cleanup() {
    }

    @Override
    protected void destroy() {
    }

    @Override
    public boolean isFixed() {
        return false;
    }

    @Override
    public Manifest getManifest() {
        if (this.manifest != null) {
            return this.manifest;
        }
        try {
            return this.getManager().loadManifest(this.jar);
        }
        catch (IOException x) {
            Util.err.log(Level.WARNING, "While loading manifest for " + (Object)((Object)this), x);
            return new Manifest();
        }
    }

    public Object getLocalizedAttribute(String attr) {
        return null;
    }

    @Override
    public String toString() {
        return "Netigso: " + this.jar;
    }

    @Override
    final int getStartLevelImpl() {
        return this.startLevel;
    }

    final void setStartLevel(int startLevel) {
        this.startLevel = startLevel;
    }

    private final class DelegateCL
    extends ProxyClassLoader
    implements Util.ModuleProvider {
        public DelegateCL() {
            super(new ClassLoader[0], false);
        }

        private ProxyClassLoader delegate() {
            ClassLoader l = this.firstParent();
            assert (l != null);
            return (ProxyClassLoader)l;
        }

        @Override
        public URL findResource(String name) {
            try {
                return this.delegate().findResource(name);
            }
            catch (IllegalStateException ex) {
                LOG.log(Level.SEVERE, "Can't load " + name, ex);
                return null;
            }
        }

        @Override
        public Enumeration<URL> findResources(String name) throws IOException {
            try {
                return this.delegate().findResources(name);
            }
            catch (IllegalStateException ex) {
                throw new IOException("Can't load " + name, ex);
            }
        }

        @Override
        protected Class<?> doLoadClass(String pkg, String name) {
            try {
                return this.delegate().doLoadClass(pkg, name);
            }
            catch (IllegalStateException ex) {
                LOG.log(Level.INFO, "Can't load " + name + " in package " + pkg, ex);
                return null;
            }
        }

        @Override
        protected Class loadClass(String name, boolean resolve) throws ClassNotFoundException {
            try {
                return this.delegate().loadClass(name, resolve);
            }
            catch (IllegalStateException ex) {
                throw new ClassNotFoundException("Can't load " + name, ex);
            }
        }

        public String toString() {
            ClassLoader l = this.firstParent();
            return l == null ? "Netigso[uninitialized]" : "Netigso[" + l.toString() + "]";
        }

        @Override
        public Module getModule() {
            return NetigsoModule.this;
        }
    }
}

