/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.language.cpp.plugins;

import java.io.File;
import java.util.Set;
import java.util.concurrent.Callable;
import javax.inject.Inject;
import org.gradle.api.Action;
import org.gradle.api.Incubating;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.ConfigurationContainer;
import org.gradle.api.artifacts.PublishArtifact;
import org.gradle.api.attributes.Usage;
import org.gradle.api.component.SoftwareComponent;
import org.gradle.api.internal.artifacts.publish.ArchivePublishArtifact;
import org.gradle.api.internal.project.ProjectInternal;
import org.gradle.api.internal.tasks.TaskContainerInternal;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.plugins.AppliedPlugin;
import org.gradle.api.provider.Provider;
import org.gradle.api.provider.ProviderFactory;
import org.gradle.api.tasks.TaskContainer;
import org.gradle.api.tasks.bundling.AbstractArchiveTask;
import org.gradle.api.tasks.bundling.Zip;
import org.gradle.language.cpp.CppLibrary;
import org.gradle.language.cpp.CppPlatform;
import org.gradle.language.cpp.internal.DefaultCppLibrary;
import org.gradle.language.cpp.internal.DefaultCppSharedLibrary;
import org.gradle.language.cpp.internal.DefaultCppStaticLibrary;
import org.gradle.language.cpp.internal.MainLibraryVariant;
import org.gradle.language.cpp.internal.NativeVariant;
import org.gradle.language.cpp.plugins.CppBasePlugin;
import org.gradle.language.internal.DefaultBinaryCollection;
import org.gradle.language.internal.NativeComponentFactory;
import org.gradle.language.nativeplatform.internal.toolchains.ToolChainSelector;
import org.gradle.nativeplatform.Linkage;

@Incubating
public class CppLibraryPlugin
implements Plugin<ProjectInternal> {
    private final NativeComponentFactory componentFactory;
    private final ToolChainSelector toolChainSelector;

    @Inject
    public CppLibraryPlugin(NativeComponentFactory componentFactory, ToolChainSelector toolChainSelector) {
        this.componentFactory = componentFactory;
        this.toolChainSelector = toolChainSelector;
    }

    public void apply(ProjectInternal project) {
        project.getPluginManager().apply(CppBasePlugin.class);
        TaskContainerInternal tasks = project.getTasks();
        ConfigurationContainer configurations = project.getConfigurations();
        final ObjectFactory objectFactory = project.getObjects();
        final ProviderFactory providers = project.getProviders();
        final DefaultCppLibrary library = this.componentFactory.newInstance(CppLibrary.class, DefaultCppLibrary.class, "main");
        project.getExtensions().add(CppLibrary.class, "library", (Object)library);
        project.getComponents().add((Object)library);
        library.getBaseName().set((Object)project.getName());
        project.afterEvaluate((Action)new Action<Project>((TaskContainer)tasks){
            final /* synthetic */ TaskContainer val$tasks;
            {
                this.val$tasks = taskContainer;
            }

            public void execute(final Project project) {
                String linkageNameSuffix;
                library.getLinkage().lockNow();
                if (((Set)library.getLinkage().get()).isEmpty()) {
                    throw new IllegalArgumentException("A linkage needs to be specified for the library.");
                }
                boolean sharedLibs = ((Set)library.getLinkage().get()).contains(Linkage.SHARED);
                boolean staticLibs = ((Set)library.getLinkage().get()).contains(Linkage.STATIC);
                ToolChainSelector.Result<CppPlatform> result = CppLibraryPlugin.this.toolChainSelector.select(CppPlatform.class);
                final Usage linkUsage = (Usage)objectFactory.named(Usage.class, "native-link");
                final Usage runtimeUsage = (Usage)objectFactory.named(Usage.class, "native-runtime");
                final MainLibraryVariant mainVariant = library.getMainPublication();
                Configuration apiElements = library.getApiElements();
                Provider publicHeaders = providers.provider((Callable)new Callable<File>(){

                    @Override
                    public File call() throws Exception {
                        Set files = library.getPublicHeaderDirs().getFiles();
                        if (files.size() != 1) {
                            throw new UnsupportedOperationException(String.format("The C++ library plugin currently requires exactly one public header directory, however there are %d directories configured: %s", files.size(), files));
                        }
                        return (File)files.iterator().next();
                    }
                });
                apiElements.getOutgoing().artifact((Object)publicHeaders);
                project.getPluginManager().withPlugin("maven-publish", (Action)new Action<AppliedPlugin>(){

                    public void execute(AppliedPlugin appliedPlugin) {
                        Zip headersZip = (Zip)val$tasks.create("cppHeaders", Zip.class);
                        headersZip.from(new Object[]{library.getPublicHeaderFiles()});
                        headersZip.setDestinationDir(new File(project.getBuildDir(), "headers"));
                        headersZip.setClassifier("cpp-api-headers");
                        headersZip.setArchiveName("cpp-api-headers.zip");
                        mainVariant.addArtifact((PublishArtifact)new ArchivePublishArtifact((AbstractArchiveTask)headersZip));
                    }
                });
                if (sharedLibs) {
                    linkageNameSuffix = staticLibs ? "Shared" : "";
                    DefaultCppSharedLibrary debugSharedLibrary = library.addSharedLibrary("debug" + linkageNameSuffix, true, false, result.getTargetPlatform(), result.getToolChain(), result.getPlatformToolProvider());
                    library.addSharedLibrary("release" + linkageNameSuffix, true, true, result.getTargetPlatform(), result.getToolChain(), result.getPlatformToolProvider());
                    library.getDevelopmentBinary().set((Object)debugSharedLibrary);
                    ((DefaultBinaryCollection)library.getBinaries()).whenElementKnown(DefaultCppSharedLibrary.class, new Action<DefaultCppSharedLibrary>(){

                        public void execute(DefaultCppSharedLibrary library) {
                            Configuration linkElements = (Configuration)library.getLinkElements().get();
                            Configuration runtimeElements = (Configuration)library.getRuntimeElements().get();
                            NativeVariant variant = new NativeVariant(library.getNames(), linkUsage, linkElements, runtimeUsage, runtimeElements);
                            mainVariant.addVariant((SoftwareComponent)variant);
                        }
                    });
                }
                if (staticLibs) {
                    linkageNameSuffix = sharedLibs ? "Static" : "";
                    DefaultCppStaticLibrary debugStaticLibrary = library.addStaticLibrary("debug" + linkageNameSuffix, true, false, result.getTargetPlatform(), result.getToolChain(), result.getPlatformToolProvider());
                    library.addStaticLibrary("release" + linkageNameSuffix, true, true, result.getTargetPlatform(), result.getToolChain(), result.getPlatformToolProvider());
                    if (!sharedLibs) {
                        library.getDevelopmentBinary().set((Object)debugStaticLibrary);
                    }
                    ((DefaultBinaryCollection)library.getBinaries()).whenElementKnown(DefaultCppStaticLibrary.class, new Action<DefaultCppStaticLibrary>(){

                        public void execute(DefaultCppStaticLibrary library) {
                            Configuration linkElements = (Configuration)library.getLinkElements().get();
                            Configuration runtimeElements = (Configuration)library.getRuntimeElements().get();
                            NativeVariant variant = new NativeVariant(library.getNames(), linkUsage, linkElements, runtimeUsage, runtimeElements);
                            mainVariant.addVariant((SoftwareComponent)variant);
                        }
                    });
                }
                ((DefaultBinaryCollection)library.getBinaries()).realizeNow();
            }
        });
    }
}

