/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.publication.maven.internal.action;

import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.maven.model.Model;
import org.apache.maven.model.io.xpp3.MavenXpp3Reader;
import org.apache.maven.repository.internal.MavenRepositorySystemSession;
import org.apache.maven.repository.internal.SnapshotMetadataGeneratorFactory;
import org.apache.maven.repository.internal.VersionsMetadataGeneratorFactory;
import org.codehaus.plexus.DefaultContainerConfiguration;
import org.codehaus.plexus.DefaultPlexusContainer;
import org.codehaus.plexus.PlexusContainer;
import org.codehaus.plexus.PlexusContainerException;
import org.codehaus.plexus.classworlds.ClassWorld;
import org.codehaus.plexus.classworlds.realm.ClassRealm;
import org.codehaus.plexus.component.repository.exception.ComponentLookupException;
import org.gradle.api.GradleException;
import org.gradle.api.publication.maven.internal.action.LoggingMavenTransferListener;
import org.gradle.api.publication.maven.internal.action.MavenPublishAction;
import org.gradle.api.publication.maven.internal.action.SnapshotVersionManager;
import org.gradle.internal.UncheckedException;
import org.sonatype.aether.RepositoryException;
import org.sonatype.aether.RepositorySystem;
import org.sonatype.aether.RepositorySystemSession;
import org.sonatype.aether.artifact.Artifact;
import org.sonatype.aether.artifact.ArtifactType;
import org.sonatype.aether.impl.Deployer;
import org.sonatype.aether.impl.MetadataGeneratorFactory;
import org.sonatype.aether.impl.internal.DefaultDeployer;
import org.sonatype.aether.impl.internal.SimpleLocalRepositoryManager;
import org.sonatype.aether.repository.LocalRepositoryManager;
import org.sonatype.aether.transfer.TransferListener;
import org.sonatype.aether.util.DefaultRepositorySystemSession;
import org.sonatype.aether.util.artifact.DefaultArtifact;

abstract class AbstractMavenPublishAction
implements MavenPublishAction {
    private final PlexusContainer container;
    private final DefaultRepositorySystemSession session;
    private final List<Artifact> attached = new ArrayList<Artifact>();
    private final Artifact pomArtifact;
    private final Artifact metadataArtifact;
    private Artifact mainArtifact;
    private SnapshotVersionManager snapshotVersionManager = new SnapshotVersionManager();

    protected AbstractMavenPublishAction(File pomFile, File metadataFile, List<File> wagonJars) {
        this.container = this.newPlexusContainer(wagonJars);
        this.session = new MavenRepositorySystemSession();
        this.session.setTransferListener((TransferListener)new LoggingMavenTransferListener());
        Model pom = this.parsePom(pomFile);
        this.pomArtifact = new DefaultArtifact(pom.getGroupId(), pom.getArtifactId(), "pom", pom.getVersion()).setFile(pomFile);
        this.metadataArtifact = this.toGradleMetadataArtifact(pom, metadataFile);
        this.mainArtifact = this.createTypedArtifact(pom.getPackaging(), null);
    }

    private Artifact toGradleMetadataArtifact(Model pom, File metadataFile) {
        if (metadataFile == null || !metadataFile.exists()) {
            return null;
        }
        return new DefaultArtifact(pom.getGroupId(), pom.getArtifactId(), "module", pom.getVersion()).setFile(metadataFile);
    }

    public void setLocalMavenRepositoryLocation(File localMavenRepository) {
        this.session.setLocalRepositoryManager((LocalRepositoryManager)new SimpleLocalRepositoryManager(localMavenRepository));
    }

    public void produceLegacyMavenMetadata() {
        this.session.getConfigProperties().put("maven.metadata.legacy", "true");
    }

    @Override
    public void setMainArtifact(File file) {
        this.mainArtifact = this.mainArtifact.setFile(file);
    }

    @Override
    public void addAdditionalArtifact(File file, String type, String classifier) {
        this.attached.add(this.createTypedArtifact(type, classifier).setFile(file));
    }

    @Override
    public void publish() {
        ArrayList<Artifact> artifacts = new ArrayList<Artifact>();
        if (this.mainArtifact.getFile() != null) {
            artifacts.add(this.mainArtifact);
        }
        artifacts.add(this.pomArtifact);
        if (this.metadataArtifact != null) {
            artifacts.add(this.metadataArtifact);
        }
        for (Artifact artifact : this.attached) {
            File file = artifact.getFile();
            if (file == null || !file.isFile()) continue;
            artifacts.add(artifact);
        }
        try {
            this.publishArtifacts(artifacts, this.newRepositorySystem(), (RepositorySystemSession)this.session);
        }
        catch (RepositoryException e) {
            throw new GradleException(e.getMessage(), (Throwable)e);
        }
    }

    protected abstract void publishArtifacts(Collection<Artifact> var1, RepositorySystem var2, RepositorySystemSession var3) throws RepositoryException;

    protected PlexusContainer getContainer() {
        return this.container;
    }

    private PlexusContainer newPlexusContainer(List<File> wagonJars) {
        try {
            ClassWorld world = new ClassWorld("plexus.core", ClassWorld.class.getClassLoader());
            ClassRealm classRealm = new ClassRealm(world, "plexus.core", ClassWorld.class.getClassLoader());
            if (wagonJars != null) {
                for (File jar : wagonJars) {
                    classRealm.addURL(jar.toURI().toURL());
                }
            }
            return new DefaultPlexusContainer(new DefaultContainerConfiguration().setRealm(classRealm));
        }
        catch (PlexusContainerException e) {
            throw UncheckedException.throwAsUncheckedException((Throwable)e);
        }
        catch (MalformedURLException e) {
            throw UncheckedException.throwAsUncheckedException((Throwable)e);
        }
    }

    private RepositorySystem newRepositorySystem() {
        try {
            DefaultDeployer deployer = (DefaultDeployer)this.getContainer().lookup(Deployer.class);
            deployer.setMetadataFactories(null);
            deployer.addMetadataGeneratorFactory((MetadataGeneratorFactory)new VersionsMetadataGeneratorFactory());
            deployer.addMetadataGeneratorFactory((MetadataGeneratorFactory)new SnapshotMetadataGeneratorFactory());
            deployer.addMetadataGeneratorFactory((MetadataGeneratorFactory)this.snapshotVersionManager);
            return (RepositorySystem)this.container.lookup(RepositorySystem.class);
        }
        catch (ComponentLookupException e) {
            throw UncheckedException.throwAsUncheckedException((Throwable)e);
        }
    }

    private Model parsePom(File pomFile) {
        FileReader reader = null;
        try {
            reader = new FileReader(pomFile);
            Model model = new MavenXpp3Reader().read((Reader)reader, false);
            return model;
        }
        catch (Exception e) {
            throw UncheckedException.throwAsUncheckedException((Throwable)e);
        }
        finally {
            try {
                reader.close();
            }
            catch (IOException e) {
                throw UncheckedException.throwAsUncheckedException((Throwable)e);
            }
        }
    }

    private Artifact createTypedArtifact(String type, String classifier) {
        String extension = type;
        ArtifactType stereotype = this.session.getArtifactTypeRegistry().get(type);
        if (stereotype != null) {
            extension = stereotype.getExtension();
            if (classifier == null) {
                classifier = stereotype.getClassifier();
            }
        }
        return new DefaultArtifact(this.pomArtifact.getGroupId(), this.pomArtifact.getArtifactId(), classifier, extension, this.pomArtifact.getVersion());
    }

    public void setUniqueVersion(boolean uniqueVersion) {
        this.snapshotVersionManager.setUniqueVersion(uniqueVersion);
    }
}

