/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.tasks;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.Callable;
import org.apache.commons.io.IOUtils;
import org.gradle.api.DefaultTask;
import org.gradle.api.tasks.CacheableTask;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.OutputFile;
import org.gradle.api.tasks.TaskAction;
import org.gradle.internal.UncheckedException;
import org.gradle.internal.util.PropertiesUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@CacheableTask
public class WriteProperties
extends DefaultTask {
    private final Map<String, Callable<String>> deferredProperties = Maps.newHashMap();
    private final Map<String, String> properties = Maps.newHashMap();
    private String lineSeparator = "\n";
    private Object outputFile;
    private String comment;
    private String encoding = "ISO_8859_1";

    @Input
    public Map<String, String> getProperties() {
        ImmutableMap.Builder propertiesBuilder = ImmutableMap.builder();
        propertiesBuilder.putAll(this.properties);
        try {
            for (Map.Entry<String, Callable<String>> e : this.deferredProperties.entrySet()) {
                propertiesBuilder.put((Object)e.getKey(), (Object)e.getValue().call());
            }
        }
        catch (Exception e) {
            throw UncheckedException.throwAsUncheckedException((Throwable)e);
        }
        return propertiesBuilder.build();
    }

    public void setProperties(Map<String, Object> properties) {
        this.properties.clear();
        this.properties(properties);
    }

    public void property(final String name, final Object value) {
        WriteProperties.checkForNullValue(name, value);
        if (value instanceof Callable) {
            this.deferredProperties.put(name, new Callable<String>(){

                @Override
                public String call() throws Exception {
                    Object futureValue = ((Callable)value).call();
                    WriteProperties.checkForNullValue(name, futureValue);
                    return String.valueOf(futureValue);
                }
            });
        } else {
            this.properties.put(name, String.valueOf(value));
        }
    }

    public void properties(Map<String, Object> properties) {
        for (Map.Entry<String, Object> e : properties.entrySet()) {
            this.property(e.getKey(), e.getValue());
        }
    }

    @Input
    public String getLineSeparator() {
        return this.lineSeparator;
    }

    public void setLineSeparator(String lineSeparator) {
        this.lineSeparator = lineSeparator;
    }

    @Input
    @Optional
    public String getComment() {
        return this.comment;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    @Input
    public String getEncoding() {
        return this.encoding;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    @OutputFile
    public File getOutputFile() {
        return this.getProject().file(this.outputFile);
    }

    public void setOutputFile(File outputFile) {
        this.outputFile = outputFile;
    }

    public void setOutputFile(Object outputFile) {
        this.outputFile = outputFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @TaskAction
    public void writeProperties() throws IOException {
        Charset charset = Charset.forName(this.getEncoding());
        BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(this.getOutputFile()));
        try {
            Properties propertiesToWrite = new Properties();
            propertiesToWrite.putAll(this.getProperties());
            PropertiesUtils.store((Properties)propertiesToWrite, (OutputStream)out, (String)this.getComment(), (Charset)charset, (String)this.getLineSeparator());
        }
        finally {
            IOUtils.closeQuietly((OutputStream)out);
        }
    }

    private static void checkForNullValue(String key, Object value) {
        Preconditions.checkNotNull((Object)value, (String)"Property '%s' is not allowed to have a null value.", (Object[])new Object[]{key});
    }
}

