/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.ide.plugins;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Writer;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.diagnostic.PluginException;
import org.jetbrains.kotlin.com.intellij.ide.ClassUtilCore;
import org.jetbrains.kotlin.com.intellij.ide.IdeBundle;
import org.jetbrains.kotlin.com.intellij.ide.StartupProgress;
import org.jetbrains.kotlin.com.intellij.ide.plugins.IdeaPluginDescriptor;
import org.jetbrains.kotlin.com.intellij.ide.plugins.IdeaPluginDescriptorImpl;
import org.jetbrains.kotlin.com.intellij.ide.plugins.PluginClassCache;
import org.jetbrains.kotlin.com.intellij.ide.plugins.PluginXmlPathResolver;
import org.jetbrains.kotlin.com.intellij.ide.plugins.cl.PluginClassLoader;
import org.jetbrains.kotlin.com.intellij.openapi.application.Application;
import org.jetbrains.kotlin.com.intellij.openapi.application.ApplicationManager;
import org.jetbrains.kotlin.com.intellij.openapi.application.PathManager;
import org.jetbrains.kotlin.com.intellij.openapi.application.impl.ApplicationInfoImpl;
import org.jetbrains.kotlin.com.intellij.openapi.diagnostic.Logger;
import org.jetbrains.kotlin.com.intellij.openapi.extensions.AreaInstance;
import org.jetbrains.kotlin.com.intellij.openapi.extensions.AreaListener;
import org.jetbrains.kotlin.com.intellij.openapi.extensions.ExtensionPoint;
import org.jetbrains.kotlin.com.intellij.openapi.extensions.Extensions;
import org.jetbrains.kotlin.com.intellij.openapi.extensions.ExtensionsArea;
import org.jetbrains.kotlin.com.intellij.openapi.extensions.LogProvider;
import org.jetbrains.kotlin.com.intellij.openapi.extensions.PluginId;
import org.jetbrains.kotlin.com.intellij.openapi.extensions.impl.PicoPluginExtensionInitializationException;
import org.jetbrains.kotlin.com.intellij.openapi.util.BuildNumber;
import org.jetbrains.kotlin.com.intellij.openapi.util.Condition;
import org.jetbrains.kotlin.com.intellij.openapi.util.Couple;
import org.jetbrains.kotlin.com.intellij.openapi.util.JDOMUtil;
import org.jetbrains.kotlin.com.intellij.openapi.util.io.FileUtil;
import org.jetbrains.kotlin.com.intellij.openapi.util.io.StreamUtil;
import org.jetbrains.kotlin.com.intellij.openapi.util.text.StringUtil;
import org.jetbrains.kotlin.com.intellij.util.ArrayUtil;
import org.jetbrains.kotlin.com.intellij.util.Function;
import org.jetbrains.kotlin.com.intellij.util.LineSeparator;
import org.jetbrains.kotlin.com.intellij.util.PathUtil;
import org.jetbrains.kotlin.com.intellij.util.ReflectionUtil;
import org.jetbrains.kotlin.com.intellij.util.SmartList;
import org.jetbrains.kotlin.com.intellij.util.containers.ContainerUtil;
import org.jetbrains.kotlin.com.intellij.util.containers.JBIterable;
import org.jetbrains.kotlin.com.intellij.util.containers.MultiMap;
import org.jetbrains.kotlin.com.intellij.util.execution.ParametersListUtil;
import org.jetbrains.kotlin.com.intellij.util.graph.CachingSemiGraph;
import org.jetbrains.kotlin.com.intellij.util.graph.DFSTBuilder;
import org.jetbrains.kotlin.com.intellij.util.graph.Graph;
import org.jetbrains.kotlin.com.intellij.util.graph.GraphGenerator;
import org.jetbrains.kotlin.com.intellij.util.graph.InboundSemiGraph;
import org.jetbrains.kotlin.com.intellij.util.io.URLUtil;
import org.jetbrains.kotlin.com.intellij.util.lang.UrlClassLoader;
import org.jetbrains.kotlin.com.intellij.util.xmlb.JDOMXIncluder;
import org.jetbrains.kotlin.com.intellij.util.xmlb.XmlSerializationException;
import org.jetbrains.kotlin.gnu.trove.THashMap;
import org.jetbrains.kotlin.gnu.trove.THashSet;
import org.jetbrains.kotlin.gnu.trove.TObjectIntHashMap;
import org.jetbrains.kotlin.org.jdom.Document;

public class PluginManagerCore {
    private static final Logger LOG = Logger.getInstance(PluginManagerCore.class);
    private static final TObjectIntHashMap<PluginId> ourId2Index = new TObjectIntHashMap();
    private static final Map<String, IdeaPluginDescriptorImpl> ourModulesToContainingPlugins = new THashMap<String, IdeaPluginDescriptorImpl>();
    private static final PluginClassCache ourPluginClasses = new PluginClassCache();
    private static List<String> ourDisabledPlugins;
    private static MultiMap<String, String> ourBrokenPluginVersions;
    private static IdeaPluginDescriptor[] ourPlugins;
    static String myPluginError;
    static List<String> myPlugins2Disable;
    static LinkedHashSet<String> myPlugins2Enable;
    public static String BUILD_NUMBER;
    private static List<Runnable> myDisablePluginListeners;

    @NotNull
    public static IdeaPluginDescriptor[] getPlugins() {
        IdeaPluginDescriptor[] ideaPluginDescriptorArray = PluginManagerCore.getPlugins(null);
        if (ideaPluginDescriptorArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/ide/plugins/PluginManagerCore", "getPlugins"));
        }
        return ideaPluginDescriptorArray;
    }

    @NotNull
    public static synchronized IdeaPluginDescriptor[] getPlugins(@Nullable StartupProgress progress) {
        if (ourPlugins == null) {
            PluginManagerCore.initPlugins(progress);
        }
        if (ourPlugins == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/ide/plugins/PluginManagerCore", "getPlugins"));
        }
        return ourPlugins;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void loadDisabledPlugins(@NotNull String configPath, @NotNull Collection<String> disabledPlugins) {
        if (configPath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configPath", "org/jetbrains/kotlin/com/intellij/ide/plugins/PluginManagerCore", "loadDisabledPlugins"));
        }
        if (disabledPlugins == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "disabledPlugins", "org/jetbrains/kotlin/com/intellij/ide/plugins/PluginManagerCore", "loadDisabledPlugins"));
        }
        File file2 = new File(configPath, "disabled_plugins.txt");
        List<String> requiredPlugins = StringUtil.split(System.getProperty("idea.required.plugins.id", ""), ",");
        if (file2.isFile()) {
            try {
                try (BufferedReader reader = new BufferedReader(new FileReader(file2));){
                    String id;
                    while ((id = reader.readLine()) != null) {
                        if (requiredPlugins.contains(id = id.trim())) continue;
                        disabledPlugins.add(id);
                    }
                }
                finally {
                    if (!requiredPlugins.isEmpty()) {
                        PluginManagerCore.savePluginsList(disabledPlugins, false, new File(PathManager.getConfigPath(), "disabled_plugins.txt"));
                        PluginManagerCore.fireEditDisablePlugins();
                    }
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    @NotNull
    public static List<String> getDisabledPlugins() {
        if (ourDisabledPlugins == null) {
            ourDisabledPlugins = new ArrayList<String>();
            if (System.getProperty("idea.ignore.disabled.plugins") == null && !PluginManagerCore.isUnitTestMode()) {
                PluginManagerCore.loadDisabledPlugins(PathManager.getConfigPath(), ourDisabledPlugins);
            }
        }
        List<String> list2 = ourDisabledPlugins;
        if (list2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/ide/plugins/PluginManagerCore", "getDisabledPlugins"));
        }
        return list2;
    }

    public static boolean isBrokenPlugin(@NotNull IdeaPluginDescriptor descriptor2) {
        if (descriptor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/kotlin/com/intellij/ide/plugins/PluginManagerCore", "isBrokenPlugin"));
        }
        PluginId pluginId = descriptor2.getPluginId();
        if (pluginId == null) {
            return true;
        }
        return PluginManagerCore.getBrokenPluginVersions().get(pluginId.getIdString()).contains(descriptor2.getVersion());
    }

    @NotNull
    private static MultiMap<String, String> getBrokenPluginVersions() {
        if (ourBrokenPluginVersions == null) {
            ourBrokenPluginVersions = MultiMap.createSet();
            if (System.getProperty("idea.ignore.disabled.plugins") == null && !PluginManagerCore.isUnitTestMode()) {
                BufferedReader br = new BufferedReader(new InputStreamReader(PluginManagerCore.class.getResourceAsStream("/brokenPlugins.txt")));
                try {
                    String s;
                    while ((s = br.readLine()) != null) {
                        List<String> tokens;
                        if ((s = s.trim()).startsWith("//") || (tokens = ParametersListUtil.parse(s)).isEmpty()) continue;
                        if (tokens.size() == 1) {
                            throw new RuntimeException("brokenPlugins.txt is broken. The line contains plugin name, but does not contains version: " + s);
                        }
                        String pluginId = tokens.get(0);
                        List<String> versions = tokens.subList(1, tokens.size());
                        ourBrokenPluginVersions.putValues(pluginId, versions);
                    }
                }
                catch (IOException e) {
                    throw new RuntimeException("Failed to read /brokenPlugins.txt", e);
                }
                finally {
                    StreamUtil.closeStream(br);
                }
            }
        }
        MultiMap<String, String> multiMap = ourBrokenPluginVersions;
        if (multiMap == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/ide/plugins/PluginManagerCore", "getBrokenPluginVersions"));
        }
        return multiMap;
    }

    private static boolean isUnitTestMode() {
        Application app = ApplicationManager.getApplication();
        return app != null && app.isUnitTestMode();
    }

    private static void fireEditDisablePlugins() {
        if (myDisablePluginListeners != null) {
            for (Runnable listener : myDisablePluginListeners) {
                listener.run();
            }
        }
    }

    public static void savePluginsList(@NotNull Collection<String> ids, boolean append2, @NotNull File plugins) throws IOException {
        if (ids == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ids", "org/jetbrains/kotlin/com/intellij/ide/plugins/PluginManagerCore", "savePluginsList"));
        }
        if (plugins == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "plugins", "org/jetbrains/kotlin/com/intellij/ide/plugins/PluginManagerCore", "savePluginsList"));
        }
        if (!plugins.isFile()) {
            FileUtil.ensureCanCreateFile(plugins);
        }
        PluginManagerCore.writePluginsList(ids, new BufferedWriter(new FileWriter(plugins, append2)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writePluginsList(@NotNull Collection<String> ids, @NotNull Writer writer) throws IOException {
        if (ids == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ids", "org/jetbrains/kotlin/com/intellij/ide/plugins/PluginManagerCore", "writePluginsList"));
        }
        if (writer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "writer", "org/jetbrains/kotlin/com/intellij/ide/plugins/PluginManagerCore", "writePluginsList"));
        }
        Object[] sortedIds = ArrayUtil.toStringArray(ids);
        Arrays.sort(sortedIds);
        try {
            for (Object id : sortedIds) {
                writer.write((String)id);
                writer.write(LineSeparator.getSystemLineSeparator().getSeparatorString());
            }
        }
        finally {
            writer.close();
        }
    }

    public static Logger getLogger() {
        return LoggerHolder.ourLogger;
    }

    static boolean isModuleDependency(@NotNull PluginId dependentPluginId) {
        if (dependentPluginId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dependentPluginId", "org/jetbrains/kotlin/com/intellij/ide/plugins/PluginManagerCore", "isModuleDependency"));
        }
        return dependentPluginId.getIdString().startsWith("org.jetbrains.kotlin.com.intellij.module");
    }

    public static void checkDependants(@NotNull IdeaPluginDescriptor pluginDescriptor, @NotNull Function<PluginId, IdeaPluginDescriptor> pluginId2Descriptor, @NotNull Condition<PluginId> check2) {
        if (pluginDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pluginDescriptor", "org/jetbrains/kotlin/com/intellij/ide/plugins/PluginManagerCore", "checkDependants"));
        }
        if (pluginId2Descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pluginId2Descriptor", "org/jetbrains/kotlin/com/intellij/ide/plugins/PluginManagerCore", "checkDependants"));
        }
        if (check2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "check", "org/jetbrains/kotlin/com/intellij/ide/plugins/PluginManagerCore", "checkDependants"));
        }
        PluginManagerCore.checkDependants(pluginDescriptor, pluginId2Descriptor, check2, new THashSet<PluginId>());
    }

    private static boolean checkDependants(@NotNull IdeaPluginDescriptor pluginDescriptor, @NotNull Function<PluginId, IdeaPluginDescriptor> pluginId2Descriptor, @NotNull Condition<PluginId> check2, @NotNull Set<PluginId> processed) {
        if (pluginDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pluginDescriptor", "org/jetbrains/kotlin/com/intellij/ide/plugins/PluginManagerCore", "checkDependants"));
        }
        if (pluginId2Descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pluginId2Descriptor", "org/jetbrains/kotlin/com/intellij/ide/plugins/PluginManagerCore", "checkDependants"));
        }
        if (check2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "check", "org/jetbrains/kotlin/com/intellij/ide/plugins/PluginManagerCore", "checkDependants"));
        }
        if (processed == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processed", "org/jetbrains/kotlin/com/intellij/ide/plugins/PluginManagerCore", "checkDependants"));
        }
        processed.add(pluginDescriptor.getPluginId());
        PluginId[] dependentPluginIds = pluginDescriptor.getDependentPluginIds();
        THashSet<PluginId> optionalDependencies = new THashSet<PluginId>(Arrays.asList(pluginDescriptor.getOptionalDependentPluginIds()));
        for (PluginId dependentPluginId : dependentPluginIds) {
            if (processed.contains(dependentPluginId) || PluginManagerCore.isModuleDependency(dependentPluginId) && (ourModulesToContainingPlugins.isEmpty() || ourModulesToContainingPlugins.containsKey(dependentPluginId.getIdString())) || optionalDependencies.contains(dependentPluginId)) continue;
            if (!check2.value(dependentPluginId)) {
                return false;
            }
            IdeaPluginDescriptor dependantPluginDescriptor = pluginId2Descriptor.fun(dependentPluginId);
            if (dependantPluginDescriptor == null || PluginManagerCore.checkDependants(dependantPluginDescriptor, pluginId2Descriptor, check2, processed)) continue;
            return false;
        }
        return true;
    }

    public static void addPluginClass(PluginId pluginId) {
        ourPluginClasses.addPluginClass(pluginId);
    }

    @Nullable
    public static PluginId getPluginByClassName(@NotNull String className2) {
        if (className2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "className", "org/jetbrains/kotlin/com/intellij/ide/plugins/PluginManagerCore", "getPluginByClassName"));
        }
        if (className2.startsWith("java.") || className2.startsWith("javax.") || className2.startsWith("kotlin.") || className2.startsWith("groovy.")) {
            return null;
        }
        for (IdeaPluginDescriptor descriptor2 : PluginManagerCore.getPlugins()) {
            if (!PluginManagerCore.hasLoadedClass(className2, descriptor2.getPluginClassLoader())) continue;
            PluginId id = descriptor2.getPluginId();
            return "org.jetbrains.kotlin.com.intellij".equals(id.getIdString()) ? null : id;
        }
        return null;
    }

    private static boolean hasLoadedClass(@NotNull String className2, ClassLoader loader) {
        if (className2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "className", "org/jetbrains/kotlin/com/intellij/ide/plugins/PluginManagerCore", "hasLoadedClass"));
        }
        if (loader instanceof UrlClassLoader) {
            return ((UrlClassLoader)loader).hasLoadedClass(className2);
        }
        try {
            return (Boolean)loader.getClass().getMethod("hasLoadedClass", String.class).invoke((Object)loader, className2);
        }
        catch (Exception e) {
            return false;
        }
    }

    private static boolean isDependent(@NotNull IdeaPluginDescriptor descriptor2, @NotNull PluginId on, @NotNull Map<PluginId, IdeaPluginDescriptor> map2, boolean checkModuleDependencies) {
        if (descriptor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/kotlin/com/intellij/ide/plugins/PluginManagerCore", "isDependent"));
        }
        if (on == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "on", "org/jetbrains/kotlin/com/intellij/ide/plugins/PluginManagerCore", "isDependent"));
        }
        if (map2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "map", "org/jetbrains/kotlin/com/intellij/ide/plugins/PluginManagerCore", "isDependent"));
        }
        for (PluginId id : descriptor2.getDependentPluginIds()) {
            if (ArrayUtil.contains(id, (Object[])descriptor2.getOptionalDependentPluginIds()) || !checkModuleDependencies && PluginManagerCore.isModuleDependency(id)) continue;
            if (id.equals(on)) {
                return true;
            }
            IdeaPluginDescriptor depDescriptor = map2.get(id);
            if (depDescriptor == null || !PluginManagerCore.isDependent(depDescriptor, on, map2, checkModuleDependencies)) continue;
            return true;
        }
        return false;
    }

    private static boolean hasModuleDependencies(@NotNull IdeaPluginDescriptor descriptor2) {
        PluginId[] dependentPluginIds;
        if (descriptor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/kotlin/com/intellij/ide/plugins/PluginManagerCore", "hasModuleDependencies"));
        }
        for (PluginId dependentPluginId : dependentPluginIds = descriptor2.getDependentPluginIds()) {
            if (!PluginManagerCore.isModuleDependency(dependentPluginId)) continue;
            return true;
        }
        return false;
    }

    private static boolean shouldLoadPlugins() {
        try {
            Class.forName("org.jetbrains.kotlin.com.intellij.openapi.extensions.Extensions");
        }
        catch (ClassNotFoundException e) {
            return false;
        }
        String loadPlugins = System.getProperty("idea.load.plugins");
        return loadPlugins == null || Boolean.TRUE.toString().equals(loadPlugins);
    }

    public static void configureExtensions() {
        Extensions.setLogProvider(new IdeaLogProvider());
        Extensions.registerAreaClass("IDEA_PROJECT", null);
        Extensions.registerAreaClass("IDEA_MODULE", "IDEA_PROJECT");
    }

    private static Method getAddUrlMethod(@NotNull ClassLoader loader) {
        if (loader == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "loader", "org/jetbrains/kotlin/com/intellij/ide/plugins/PluginManagerCore", "getAddUrlMethod"));
        }
        return ReflectionUtil.getDeclaredMethod(loader instanceof URLClassLoader ? URLClassLoader.class : loader.getClass(), "addURL", URL.class);
    }

    @Nullable
    private static ClassLoader createPluginClassLoader(@NotNull File[] classPath, @NotNull ClassLoader[] parentLoaders, @NotNull IdeaPluginDescriptor pluginDescriptor) {
        if (classPath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "classPath", "org/jetbrains/kotlin/com/intellij/ide/plugins/PluginManagerCore", "createPluginClassLoader"));
        }
        if (parentLoaders == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parentLoaders", "org/jetbrains/kotlin/com/intellij/ide/plugins/PluginManagerCore", "createPluginClassLoader"));
        }
        if (pluginDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pluginDescriptor", "org/jetbrains/kotlin/com/intellij/ide/plugins/PluginManagerCore", "createPluginClassLoader"));
        }
        if (pluginDescriptor.getUseIdeaClassLoader()) {
            try {
                ClassLoader loader = PluginManagerCore.class.getClassLoader();
                Method addUrlMethod = PluginManagerCore.getAddUrlMethod(loader);
                for (File aClassPath : classPath) {
                    File file2 = aClassPath.getCanonicalFile();
                    addUrlMethod.invoke((Object)loader, file2.toURI().toURL());
                }
                return loader;
            }
            catch (IOException | IllegalAccessException | InvocationTargetException e) {
                PluginManagerCore.getLogger().warn(e);
            }
        }
        PluginId pluginId = pluginDescriptor.getPluginId();
        File pluginRoot = pluginDescriptor.getPath();
        if (PluginManagerCore.isUnitTestMode()) {
            return null;
        }
        try {
            ArrayList<URL> urls = new ArrayList<URL>(classPath.length);
            for (File aClassPath : classPath) {
                File file3 = aClassPath.getCanonicalFile();
                urls.add(file3.toURI().toURL());
            }
            return new PluginClassLoader(urls, parentLoaders, pluginId, pluginDescriptor.getVersion(), pluginRoot);
        }
        catch (IOException e) {
            PluginManagerCore.getLogger().warn(e);
            return null;
        }
    }

    private static void logPlugins() {
        ArrayList<String> loadedBundled = new ArrayList<String>();
        ArrayList<String> disabled = new ArrayList<String>();
        ArrayList<String> loadedCustom = new ArrayList<String>();
        for (IdeaPluginDescriptor descriptor2 : ourPlugins) {
            String version = descriptor2.getVersion();
            String s = descriptor2.getName() + (version != null ? " (" + version + ")" : "");
            if (descriptor2.isEnabled()) {
                if (descriptor2.isBundled() || "IDEA CORE".equals(descriptor2.getName())) {
                    loadedBundled.add(s);
                    continue;
                }
                loadedCustom.add(s);
                continue;
            }
            disabled.add(s);
        }
        Collections.sort(loadedBundled);
        Collections.sort(loadedCustom);
        Collections.sort(disabled);
        PluginManagerCore.getLogger().info("Loaded bundled plugins: " + StringUtil.join(loadedBundled, ", "));
        if (!loadedCustom.isEmpty()) {
            PluginManagerCore.getLogger().info("Loaded custom plugins: " + StringUtil.join(loadedCustom, ", "));
        }
        if (!disabled.isEmpty()) {
            PluginManagerCore.getLogger().info("Disabled plugins: " + StringUtil.join(disabled, ", "));
        }
    }

    @NotNull
    private static ClassLoader[] getParentLoaders(@NotNull Map<PluginId, ? extends IdeaPluginDescriptor> idToDescriptorMap, @NotNull PluginId[] pluginIds) {
        if (idToDescriptorMap == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "idToDescriptorMap", "org/jetbrains/kotlin/com/intellij/ide/plugins/PluginManagerCore", "getParentLoaders"));
        }
        if (pluginIds == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pluginIds", "org/jetbrains/kotlin/com/intellij/ide/plugins/PluginManagerCore", "getParentLoaders"));
        }
        if (PluginManagerCore.isUnitTestMode()) {
            ClassLoader[] classLoaderArray = new ClassLoader[]{};
            if (classLoaderArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/ide/plugins/PluginManagerCore", "getParentLoaders"));
            }
            return classLoaderArray;
        }
        ArrayList<ClassLoader> classLoaders = new ArrayList<ClassLoader>();
        for (PluginId id : pluginIds) {
            IdeaPluginDescriptor pluginDescriptor = idToDescriptorMap.get(id);
            if (pluginDescriptor == null) continue;
            ClassLoader loader = pluginDescriptor.getPluginClassLoader();
            if (loader == null) {
                PluginManagerCore.getLogger().error("Plugin class loader should be initialized for plugin " + id);
            }
            classLoaders.add(loader);
        }
        ClassLoader[] classLoaderArray = classLoaders.toArray(new ClassLoader[classLoaders.size()]);
        if (classLoaderArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/ide/plugins/PluginManagerCore", "getParentLoaders"));
        }
        return classLoaderArray;
    }

    private static int countPlugins(@NotNull String pluginsPath) {
        String[] list2;
        if (pluginsPath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pluginsPath", "org/jetbrains/kotlin/com/intellij/ide/plugins/PluginManagerCore", "countPlugins"));
        }
        File configuredPluginsDir = new File(pluginsPath);
        if (configuredPluginsDir.exists() && (list2 = configuredPluginsDir.list()) != null) {
            return list2.length;
        }
        return 0;
    }

    private static void prepareLoadingPluginsErrorMessage(@NotNull List<String> errors) {
        if (errors == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "errors", "org/jetbrains/kotlin/com/intellij/ide/plugins/PluginManagerCore", "prepareLoadingPluginsErrorMessage"));
        }
        if (!errors.isEmpty()) {
            String errorMessage = IdeBundle.message("error.problems.found.loading.plugins", new Object[0]) + StringUtil.join(errors, "<p/>");
            Application app = ApplicationManager.getApplication();
            if (app != null && !app.isHeadlessEnvironment() && !app.isUnitTestMode()) {
                myPluginError = myPluginError == null ? errorMessage : myPluginError + "\n" + errorMessage;
            } else {
                PluginManagerCore.getLogger().error(errorMessage);
            }
        }
    }

    private static void addModulesAsDependents(@NotNull Map<PluginId, ? super IdeaPluginDescriptorImpl> map2) {
        if (map2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "map", "org/jetbrains/kotlin/com/intellij/ide/plugins/PluginManagerCore", "addModulesAsDependents"));
        }
        for (Map.Entry<String, IdeaPluginDescriptorImpl> entry : ourModulesToContainingPlugins.entrySet()) {
            map2.put(PluginId.getId(entry.getKey()), entry.getValue());
        }
    }

    @NotNull
    private static Comparator<IdeaPluginDescriptor> getPluginDescriptorComparator(@NotNull Map<PluginId, ? extends IdeaPluginDescriptor> idToDescriptorMap, @NotNull List<String> errors) {
        if (idToDescriptorMap == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "idToDescriptorMap", "org/jetbrains/kotlin/com/intellij/ide/plugins/PluginManagerCore", "getPluginDescriptorComparator"));
        }
        if (errors == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "errors", "org/jetbrains/kotlin/com/intellij/ide/plugins/PluginManagerCore", "getPluginDescriptorComparator"));
        }
        Graph<PluginId> graph2 = PluginManagerCore.createPluginIdGraph(idToDescriptorMap);
        DFSTBuilder<PluginId> builder = new DFSTBuilder<PluginId>(graph2);
        if (!builder.isAcyclic()) {
            String cyclePresentation;
            if (ApplicationManager.getApplication().isInternal()) {
                StringBuilder cycles = new StringBuilder();
                for (Collection<PluginId> component : builder.getComponents()) {
                    if (cycles.length() > 0) {
                        cycles.append(';');
                    }
                    for (PluginId id : component) {
                        idToDescriptorMap.get(id).setEnabled(false);
                        cycles.append(id.getIdString()).append(' ');
                    }
                }
                cyclePresentation = cycles.toString();
            } else {
                Couple<PluginId> circularDependency = builder.getCircularDependency();
                PluginId id = (PluginId)circularDependency.getFirst();
                PluginId parentId = (PluginId)circularDependency.getSecond();
                cyclePresentation = id + "->" + parentId + "->...->" + id;
            }
            errors.add(IdeBundle.message("error.plugins.should.not.have.cyclic.dependencies", new Object[0]) + " " + cyclePresentation);
        }
        Comparator<PluginId> idComparator = builder.comparator();
        Comparator comparator = (o1, o2) -> {
            PluginId pluginId1 = o1.getPluginId();
            PluginId pluginId2 = o2.getPluginId();
            if (pluginId1.getIdString().equals("org.jetbrains.kotlin.com.intellij")) {
                return -1;
            }
            if (pluginId2.getIdString().equals("org.jetbrains.kotlin.com.intellij")) {
                return 1;
            }
            return idComparator.compare(pluginId1, pluginId2);
        };
        if (comparator == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/ide/plugins/PluginManagerCore", "getPluginDescriptorComparator"));
        }
        return comparator;
    }

    @NotNull
    private static Graph<PluginId> createPluginIdGraph(final @NotNull Map<PluginId, ? extends IdeaPluginDescriptor> idToDescriptorMap) {
        if (idToDescriptorMap == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "idToDescriptorMap", "org/jetbrains/kotlin/com/intellij/ide/plugins/PluginManagerCore", "createPluginIdGraph"));
        }
        final ArrayList<PluginId> ids = new ArrayList<PluginId>(idToDescriptorMap.keySet());
        ids.sort((o1, o2) -> o2.getIdString().compareTo(o1.getIdString()));
        Graph<PluginId> graph2 = GraphGenerator.generate(CachingSemiGraph.cache(new InboundSemiGraph<PluginId>(){

            @Override
            public Collection<PluginId> getNodes() {
                return ids;
            }

            @Override
            public Iterator<PluginId> getIn(PluginId pluginId) {
                IdeaPluginDescriptor descriptor2 = (IdeaPluginDescriptor)idToDescriptorMap.get(pluginId);
                ArrayList<PluginId> plugins = new ArrayList<PluginId>();
                for (PluginId dependentPluginId : descriptor2.getDependentPluginIds()) {
                    PluginId realPluginId;
                    IdeaPluginDescriptor dep = (IdeaPluginDescriptor)idToDescriptorMap.get(dependentPluginId);
                    if (dep == null || !idToDescriptorMap.containsKey(realPluginId = dep.getPluginId())) continue;
                    plugins.add(realPluginId);
                }
                return plugins.iterator();
            }
        }));
        if (graph2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/ide/plugins/PluginManagerCore", "createPluginIdGraph"));
        }
        return graph2;
    }

    @Nullable
    private static IdeaPluginDescriptorImpl loadDescriptorFromDir(@NotNull File file2, @NotNull String fileName) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/kotlin/com/intellij/ide/plugins/PluginManagerCore", "loadDescriptorFromDir"));
        }
        if (fileName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileName", "org/jetbrains/kotlin/com/intellij/ide/plugins/PluginManagerCore", "loadDescriptorFromDir"));
        }
        File descriptorFile = new File(file2, "META-INF" + File.separator + fileName);
        if (descriptorFile.exists()) {
            try {
                IdeaPluginDescriptorImpl descriptor2 = new IdeaPluginDescriptorImpl(file2);
                descriptor2.readExternal(descriptorFile.toURI().toURL());
                return descriptor2;
            }
            catch (XmlSerializationException e) {
                PluginManagerCore.getLogger().info("Cannot load " + file2, e);
                PluginManagerCore.prepareLoadingPluginsErrorMessage(Collections.singletonList("File '" + file2.getName() + "' contains invalid plugin descriptor."));
            }
            catch (Throwable e) {
                PluginManagerCore.getLogger().info("Cannot load " + file2, e);
            }
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    private static IdeaPluginDescriptorImpl loadDescriptorFromJar(@NotNull File file2, @NotNull String fileName, @NotNull JDOMXIncluder.PathResolver pathResolver) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/kotlin/com/intellij/ide/plugins/PluginManagerCore", "loadDescriptorFromJar"));
        }
        if (fileName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileName", "org/jetbrains/kotlin/com/intellij/ide/plugins/PluginManagerCore", "loadDescriptorFromJar"));
        }
        if (pathResolver == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pathResolver", "org/jetbrains/kotlin/com/intellij/ide/plugins/PluginManagerCore", "loadDescriptorFromJar"));
        }
        try {
            URL jarURL = URLUtil.getJarEntryURL(file2, "META-INF/" + fileName);
            try (ZipFile zipFile2 = new ZipFile(file2);){
                ZipEntry entry = zipFile2.getEntry("META-INF/" + fileName);
                if (entry == null) return null;
                Document document = JDOMUtil.loadDocument(zipFile2.getInputStream(entry));
                IdeaPluginDescriptorImpl descriptor2 = new IdeaPluginDescriptorImpl(file2);
                descriptor2.readExternal(document, jarURL, pathResolver);
                IdeaPluginDescriptorImpl ideaPluginDescriptorImpl = descriptor2;
                return ideaPluginDescriptorImpl;
            }
        }
        catch (XmlSerializationException e) {
            PluginManagerCore.getLogger().info("Cannot load " + file2, e);
            PluginManagerCore.prepareLoadingPluginsErrorMessage(Collections.singletonList("File '" + file2.getName() + "' contains invalid plugin descriptor."));
            return null;
        }
        catch (Throwable e) {
            PluginManagerCore.getLogger().info("Cannot load " + file2, e);
        }
        return null;
    }

    @Nullable
    public static IdeaPluginDescriptorImpl loadDescriptor(@NotNull File file2, @NotNull String fileName) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/kotlin/com/intellij/ide/plugins/PluginManagerCore", "loadDescriptor"));
        }
        if (fileName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileName", "org/jetbrains/kotlin/com/intellij/ide/plugins/PluginManagerCore", "loadDescriptor"));
        }
        IdeaPluginDescriptorImpl descriptor2 = null;
        boolean directory = file2.isDirectory();
        if (directory) {
            descriptor2 = PluginManagerCore.loadDescriptorFromDir(file2, fileName);
            if (descriptor2 == null) {
                File libDir = new File(file2, "lib");
                if (!libDir.isDirectory()) {
                    return null;
                }
                File[] files2 = libDir.listFiles();
                if (files2 == null || files2.length == 0) {
                    return null;
                }
                Arrays.sort(files2, (o1, o2) -> {
                    if (file2 == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/kotlin/com/intellij/ide/plugins/PluginManagerCore", "lambda$loadDescriptor$2"));
                    }
                    if (o2.getName().startsWith(file2.getName())) {
                        return Integer.MAX_VALUE;
                    }
                    if (o1.getName().startsWith(file2.getName())) {
                        return -2147483647;
                    }
                    if (o2.getName().startsWith("resources")) {
                        return -2147483647;
                    }
                    if (o1.getName().startsWith("resources")) {
                        return Integer.MAX_VALUE;
                    }
                    return 0;
                });
                PluginXmlPathResolver pathResolver = new PluginXmlPathResolver(files2);
                for (File f : files2) {
                    IdeaPluginDescriptorImpl descriptor1;
                    if (FileUtil.isJarOrZip(f)) {
                        descriptor2 = PluginManagerCore.loadDescriptorFromJar(f, fileName, pathResolver);
                        if (descriptor2 == null) continue;
                        descriptor2.setPath(file2);
                        break;
                    }
                    if (!f.isDirectory() || (descriptor1 = PluginManagerCore.loadDescriptorFromDir(f, fileName)) == null) continue;
                    if (descriptor2 != null) {
                        PluginManagerCore.getLogger().info("Cannot load " + file2 + " because two or more plugin.xml's detected");
                        return null;
                    }
                    descriptor2 = descriptor1;
                    descriptor2.setPath(file2);
                }
            }
        } else if (StringUtil.endsWithIgnoreCase(file2.getName(), ".jar") && file2.exists()) {
            descriptor2 = PluginManagerCore.loadDescriptorFromJar(file2, fileName, JDOMXIncluder.DEFAULT_PATH_RESOLVER);
        }
        if (descriptor2 != null) {
            PluginManagerCore.resolveOptionalDescriptors(fileName, descriptor2, optionalDescriptorName -> {
                URL resource;
                if (file2 == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/kotlin/com/intellij/ide/plugins/PluginManagerCore", "lambda$loadDescriptor$3"));
                }
                IdeaPluginDescriptorImpl optionalDescriptor = PluginManagerCore.loadDescriptor(file2, optionalDescriptorName);
                if (optionalDescriptor == null && directory && (resource = PluginManagerCore.class.getClassLoader().getResource("META-INF/" + optionalDescriptorName)) != null) {
                    optionalDescriptor = PluginManagerCore.loadDescriptorFromResource(resource);
                }
                return optionalDescriptor;
            });
        }
        return descriptor2;
    }

    public static void resolveOptionalDescriptors(@NotNull String fileName, @NotNull IdeaPluginDescriptorImpl descriptor2, @NotNull Function<String, IdeaPluginDescriptorImpl> optionalDescriptorLoader) {
        if (fileName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileName", "org/jetbrains/kotlin/com/intellij/ide/plugins/PluginManagerCore", "resolveOptionalDescriptors"));
        }
        if (descriptor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/kotlin/com/intellij/ide/plugins/PluginManagerCore", "resolveOptionalDescriptors"));
        }
        if (optionalDescriptorLoader == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "optionalDescriptorLoader", "org/jetbrains/kotlin/com/intellij/ide/plugins/PluginManagerCore", "resolveOptionalDescriptors"));
        }
        Map<PluginId, String> optionalConfigs = descriptor2.getOptionalConfigs();
        if (optionalConfigs != null && !optionalConfigs.isEmpty()) {
            THashMap<PluginId, IdeaPluginDescriptorImpl> descriptors = new THashMap<PluginId, IdeaPluginDescriptorImpl>(optionalConfigs.size());
            for (Map.Entry<PluginId, String> entry : optionalConfigs.entrySet()) {
                String optionalDescriptorName = entry.getValue();
                if (fileName.equals(optionalDescriptorName)) {
                    PluginManagerCore.getLogger().info("recursive dependency (" + fileName + ") in " + descriptor2);
                    continue;
                }
                IdeaPluginDescriptorImpl optionalDescriptor = optionalDescriptorLoader.fun(optionalDescriptorName);
                if (optionalDescriptor == null) {
                    PluginManagerCore.getLogger().info("Cannot find optional descriptor " + optionalDescriptorName);
                    continue;
                }
                descriptors.put(entry.getKey(), optionalDescriptor);
            }
            descriptor2.setOptionalDescriptors(descriptors);
        }
    }

    public static void loadDescriptors(@NotNull File pluginsHome, @NotNull List<IdeaPluginDescriptorImpl> result2, @Nullable StartupProgress progress, int pluginsCount) {
        if (pluginsHome == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pluginsHome", "org/jetbrains/kotlin/com/intellij/ide/plugins/PluginManagerCore", "loadDescriptors"));
        }
        if (result2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "org/jetbrains/kotlin/com/intellij/ide/plugins/PluginManagerCore", "loadDescriptors"));
        }
        File[] files2 = pluginsHome.listFiles();
        if (files2 != null) {
            int i = result2.size();
            for (File file2 : files2) {
                int oldIndex;
                IdeaPluginDescriptorImpl descriptor2 = PluginManagerCore.loadDescriptor(file2, "plugin.xml");
                if (descriptor2 == null) continue;
                if (descriptor2.getName() == null) {
                    PluginManagerCore.getLogger().warn("Skipped plugin without name: " + descriptor2);
                }
                if (progress != null) {
                    progress.showProgress(descriptor2.getName(), 0.3f * ((float)(++i) / (float)pluginsCount));
                }
                if ((oldIndex = result2.indexOf(descriptor2)) >= 0) {
                    IdeaPluginDescriptorImpl oldDescriptor = result2.get(oldIndex);
                    if (StringUtil.compareVersionNumbers(oldDescriptor.getVersion(), descriptor2.getVersion()) >= 0) continue;
                    result2.set(oldIndex, descriptor2);
                    continue;
                }
                result2.add(descriptor2);
            }
        }
    }

    private static void filterBadPlugins(@NotNull List<? extends IdeaPluginDescriptor> result2, @NotNull Map<String, String> disabledPluginNames, @NotNull List<String> errors) {
        if (result2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "org/jetbrains/kotlin/com/intellij/ide/plugins/PluginManagerCore", "filterBadPlugins"));
        }
        if (disabledPluginNames == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "disabledPluginNames", "org/jetbrains/kotlin/com/intellij/ide/plugins/PluginManagerCore", "filterBadPlugins"));
        }
        if (errors == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "errors", "org/jetbrains/kotlin/com/intellij/ide/plugins/PluginManagerCore", "filterBadPlugins"));
        }
        THashMap<PluginId, IdeaPluginDescriptor> idToDescriptorMap = new THashMap<PluginId, IdeaPluginDescriptor>();
        boolean pluginsWithoutIdFound = false;
        Iterator<? extends IdeaPluginDescriptor> it = result2.iterator();
        while (it.hasNext()) {
            IdeaPluginDescriptor descriptor2 = it.next();
            PluginId id = descriptor2.getPluginId();
            if (id == null) {
                pluginsWithoutIdFound = true;
                continue;
            }
            if (idToDescriptorMap.containsKey(id)) {
                errors.add(IdeBundle.message("message.duplicate.plugin.id", new Object[0]) + id);
                it.remove();
                continue;
            }
            if (!descriptor2.isEnabled()) continue;
            idToDescriptorMap.put(id, descriptor2);
        }
        PluginManagerCore.addModulesAsDependents(idToDescriptorMap);
        SmartList<String> disabledPluginIds = new SmartList<String>();
        LinkedHashSet faultyDescriptors = new LinkedHashSet();
        Iterator<? extends IdeaPluginDescriptor> it2 = result2.iterator();
        while (it2.hasNext()) {
            IdeaPluginDescriptor pluginDescriptor = it2.next();
            PluginManagerCore.checkDependants(pluginDescriptor, idToDescriptorMap::get, pluginId -> {
                if (disabledPluginNames == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "disabledPluginNames", "org/jetbrains/kotlin/com/intellij/ide/plugins/PluginManagerCore", "lambda$filterBadPlugins$4"));
                }
                if (errors == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "errors", "org/jetbrains/kotlin/com/intellij/ide/plugins/PluginManagerCore", "lambda$filterBadPlugins$4"));
                }
                if (!idToDescriptorMap.containsKey(pluginId)) {
                    pluginDescriptor.setEnabled(false);
                    if (!pluginId.getIdString().startsWith("org.jetbrains.kotlin.com.intellij.module")) {
                        boolean disabled;
                        String pluginName;
                        faultyDescriptors.add(pluginId.getIdString());
                        disabledPluginIds.add(pluginDescriptor.getPluginId().getIdString());
                        String name = pluginDescriptor.getName();
                        IdeaPluginDescriptor descriptor2 = (IdeaPluginDescriptor)idToDescriptorMap.get(pluginId);
                        if (descriptor2 == null) {
                            pluginName = pluginId.getIdString();
                            if (disabledPluginNames.containsKey(pluginName)) {
                                pluginName = (String)disabledPluginNames.get(pluginName);
                            }
                        } else {
                            pluginName = descriptor2.getName();
                        }
                        errors.add(IdeBundle.message((disabled = PluginManagerCore.getDisabledPlugins().contains(pluginId.getIdString())) ? "error.required.plugin.disabled" : "error.required.plugin.not.installed", name, pluginName));
                    }
                    it2.remove();
                    return false;
                }
                return true;
            });
        }
        if (!disabledPluginIds.isEmpty()) {
            myPlugins2Disable = disabledPluginIds;
            myPlugins2Enable = faultyDescriptors;
            String error = "<br><a href=\"disable\">Disable ";
            if (disabledPluginIds.size() == 1) {
                PluginId pluginId2Disable = PluginId.getId((String)disabledPluginIds.iterator().next());
                error = error + (idToDescriptorMap.containsKey(pluginId2Disable) ? ((IdeaPluginDescriptor)idToDescriptorMap.get(pluginId2Disable)).getName() : pluginId2Disable.getIdString());
            } else {
                error = error + "not loaded plugins";
            }
            errors.add(error + "</a>");
            boolean possibleToEnable = true;
            for (String descriptor3 : faultyDescriptors) {
                if (disabledPluginNames.get(descriptor3) != null) continue;
                possibleToEnable = false;
                break;
            }
            if (possibleToEnable) {
                errors.add("<a href=\"enable\">Enable " + (faultyDescriptors.size() == 1 ? disabledPluginNames.get(faultyDescriptors.iterator().next()) : " all necessary plugins") + "</a>");
            }
            errors.add("<a href=\"edit\">Open plugin manager</a>");
        }
        if (pluginsWithoutIdFound) {
            errors.add(IdeBundle.message("error.plugins.without.id.found", new Object[0]));
        }
    }

    private static void loadDescriptorsFromClassPath(List<IdeaPluginDescriptorImpl> result2, ClassLoader loader, StartupProgress progress) {
        URL resource;
        HashSet<URL> urls = ContainerUtil.newHashSet();
        String platformPrefix = System.getProperty("idea.platform.prefix");
        if (platformPrefix != null && (resource = loader.getResource("META-INF/" + platformPrefix + "Plugin.xml")) != null) {
            urls.add(resource);
        }
        try {
            Enumeration<URL> enumeration = loader.getResources("META-INF/plugin.xml");
            while (enumeration.hasMoreElements()) {
                urls.add(enumeration.nextElement());
            }
        }
        catch (IOException e) {
            PluginManagerCore.getLogger().info(e);
            return;
        }
        int i = 0;
        for (URL url : urls) {
            IdeaPluginDescriptorImpl descriptor2 = PluginManagerCore.loadDescriptorFromResource(url);
            if (descriptor2 == null || result2.contains(descriptor2)) continue;
            descriptor2.setUseCoreClassLoader(true);
            result2.add(descriptor2);
            if (progress == null || "IDEA CORE".equals(descriptor2.getName())) continue;
            progress.showProgress("Plugin loaded: " + descriptor2.getName(), 0.3f * (float)(++i) / (float)urls.size());
        }
    }

    @Nullable
    private static IdeaPluginDescriptorImpl loadDescriptorFromResource(@NotNull URL resource) {
        if (resource == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resource", "org/jetbrains/kotlin/com/intellij/ide/plugins/PluginManagerCore", "loadDescriptorFromResource"));
        }
        try {
            if ("file".equals(resource.getProtocol())) {
                File descriptorFile = PluginManagerCore.urlToFile(resource);
                File pluginDir = descriptorFile.getParentFile().getParentFile();
                return PluginManagerCore.loadDescriptor(pluginDir, descriptorFile.getName());
            }
            if ("jar".equals(resource.getProtocol())) {
                String path2 = resource.getFile();
                File pluginJar = PluginManagerCore.urlToFile(new URL(path2.substring(0, path2.indexOf("!/"))));
                return PluginManagerCore.loadDescriptor(pluginJar, PathUtil.getFileName(path2));
            }
        }
        catch (Throwable e) {
            PluginManagerCore.getLogger().info("Cannot load " + resource, e);
        }
        return null;
    }

    private static File urlToFile(URL url) throws URISyntaxException, MalformedURLException {
        try {
            return new File(url.toURI());
        }
        catch (URISyntaxException e) {
            String str = url.toString();
            if (str.indexOf(32) > 0) {
                return new File(new URL(StringUtil.replace(str, " ", "%20")).toURI());
            }
            throw e;
        }
    }

    private static void loadDescriptorsFromProperty(@NotNull List<IdeaPluginDescriptorImpl> result2) {
        if (result2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "org/jetbrains/kotlin/com/intellij/ide/plugins/PluginManagerCore", "loadDescriptorsFromProperty"));
        }
        String pathProperty = System.getProperty("plugin.path");
        if (pathProperty == null) {
            return;
        }
        StringTokenizer t = new StringTokenizer(pathProperty, File.pathSeparator + ",");
        while (t.hasMoreTokens()) {
            String s = t.nextToken();
            IdeaPluginDescriptorImpl ideaPluginDescriptor = PluginManagerCore.loadDescriptor(new File(s), "plugin.xml");
            if (ideaPluginDescriptor == null) continue;
            result2.add(ideaPluginDescriptor);
        }
    }

    @NotNull
    public static IdeaPluginDescriptorImpl[] loadDescriptors(@Nullable StartupProgress progress, @NotNull List<String> errors) {
        if (errors == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "errors", "org/jetbrains/kotlin/com/intellij/ide/plugins/PluginManagerCore", "loadDescriptors"));
        }
        if (ClassUtilCore.isLoadingOfExternalPluginsDisabled()) {
            if (IdeaPluginDescriptorImpl.EMPTY_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/ide/plugins/PluginManagerCore", "loadDescriptors"));
            }
            return IdeaPluginDescriptorImpl.EMPTY_ARRAY;
        }
        ArrayList<IdeaPluginDescriptorImpl> result2 = new ArrayList<IdeaPluginDescriptorImpl>();
        int pluginsCount = PluginManagerCore.countPlugins(PathManager.getPluginsPath()) + PluginManagerCore.countPlugins(PathManager.getPreInstalledPluginsPath());
        PluginManagerCore.loadDescriptors(new File(PathManager.getPluginsPath()), result2, progress, pluginsCount);
        Application application = ApplicationManager.getApplication();
        boolean fromSources = false;
        if (application == null || !application.isUnitTestMode()) {
            int size = result2.size();
            PluginManagerCore.loadDescriptors(new File(PathManager.getPreInstalledPluginsPath()), result2, progress, pluginsCount);
            fromSources = size == result2.size();
        }
        PluginManagerCore.loadDescriptorsFromProperty(result2);
        PluginManagerCore.loadDescriptorsFromClassPath(result2, PluginManagerCore.class.getClassLoader(), fromSources ? progress : null);
        IdeaPluginDescriptorImpl[] ideaPluginDescriptorImplArray = PluginManagerCore.topoSortPlugins(result2, errors);
        if (ideaPluginDescriptorImplArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/ide/plugins/PluginManagerCore", "loadDescriptors"));
        }
        return ideaPluginDescriptorImplArray;
    }

    @NotNull
    public static IdeaPluginDescriptorImpl[] topoSortPlugins(@NotNull List<IdeaPluginDescriptorImpl> result2, @NotNull List<String> errors) {
        if (result2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "org/jetbrains/kotlin/com/intellij/ide/plugins/PluginManagerCore", "topoSortPlugins"));
        }
        if (errors == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "errors", "org/jetbrains/kotlin/com/intellij/ide/plugins/PluginManagerCore", "topoSortPlugins"));
        }
        IdeaPluginDescriptorImpl[] pluginDescriptors = result2.toArray(new IdeaPluginDescriptorImpl[result2.size()]);
        THashMap<PluginId, IdeaPluginDescriptorImpl> idToDescriptorMap = new THashMap<PluginId, IdeaPluginDescriptorImpl>();
        for (IdeaPluginDescriptorImpl descriptor2 : pluginDescriptors) {
            idToDescriptorMap.put(descriptor2.getPluginId(), descriptor2);
        }
        Arrays.sort(pluginDescriptors, PluginManagerCore.getPluginDescriptorComparator(idToDescriptorMap, errors));
        if (pluginDescriptors == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/ide/plugins/PluginManagerCore", "topoSortPlugins"));
        }
        return pluginDescriptors;
    }

    private static void mergeOptionalConfigs(@NotNull Map<PluginId, IdeaPluginDescriptorImpl> descriptors) {
        if (descriptors == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptors", "org/jetbrains/kotlin/com/intellij/ide/plugins/PluginManagerCore", "mergeOptionalConfigs"));
        }
        THashMap<PluginId, IdeaPluginDescriptorImpl> descriptorsWithModules = new THashMap<PluginId, IdeaPluginDescriptorImpl>(descriptors);
        PluginManagerCore.addModulesAsDependents(descriptorsWithModules);
        for (IdeaPluginDescriptorImpl descriptor2 : descriptors.values()) {
            Map<PluginId, IdeaPluginDescriptorImpl> optionalDescriptors = descriptor2.getOptionalDescriptors();
            if (optionalDescriptors == null || optionalDescriptors.isEmpty()) continue;
            for (Map.Entry<PluginId, IdeaPluginDescriptorImpl> entry : optionalDescriptors.entrySet()) {
                if (!descriptorsWithModules.containsKey(entry.getKey())) continue;
                descriptor2.mergeOptionalConfig(entry.getValue());
            }
        }
    }

    public static void initClassLoader(@NotNull ClassLoader parentLoader, @NotNull IdeaPluginDescriptorImpl descriptor2) {
        if (parentLoader == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parentLoader", "org/jetbrains/kotlin/com/intellij/ide/plugins/PluginManagerCore", "initClassLoader"));
        }
        if (descriptor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/kotlin/com/intellij/ide/plugins/PluginManagerCore", "initClassLoader"));
        }
        List<File> classPath = descriptor2.getClassPath();
        ClassLoader loader = PluginManagerCore.createPluginClassLoader(classPath.toArray(new File[classPath.size()]), new ClassLoader[]{parentLoader}, descriptor2);
        descriptor2.setLoader(loader);
    }

    static BuildNumber getBuildNumber() {
        return Holder.ourBuildNumber;
    }

    @Nullable
    private static String detectReasonToNotLoad(@NotNull IdeaPluginDescriptor descriptor2, @NotNull IdeaPluginDescriptor[] loaded) {
        String reasonToNotLoad;
        boolean checkModuleDependencies;
        if (descriptor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/kotlin/com/intellij/ide/plugins/PluginManagerCore", "detectReasonToNotLoad"));
        }
        if (loaded == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "loaded", "org/jetbrains/kotlin/com/intellij/ide/plugins/PluginManagerCore", "detectReasonToNotLoad"));
        }
        String idString = descriptor2.getPluginId().getIdString();
        if ("org.jetbrains.kotlin.com.intellij".equals(idString)) {
            return null;
        }
        String pluginId = System.getProperty("idea.load.plugins.id");
        if (pluginId == null) {
            if (descriptor2 instanceof IdeaPluginDescriptorImpl && !descriptor2.isEnabled()) {
                return "Plugin is not enabled";
            }
            if (!PluginManagerCore.shouldLoadPlugins()) {
                return "Plugins should not be loaded";
            }
        }
        List<String> pluginIds = pluginId == null ? null : StringUtil.split(pluginId, ",");
        boolean bl = checkModuleDependencies = !ourModulesToContainingPlugins.isEmpty() && !ourModulesToContainingPlugins.containsKey("org.jetbrains.kotlin.com.intellij.modules.all");
        if (checkModuleDependencies && !PluginManagerCore.hasModuleDependencies(descriptor2)) {
            return "Plugin does not include any module dependency tags in its plugin.xml therefore is assumed legacy and can be loaded only in IntelliJ IDEA";
        }
        String loadPluginCategory = System.getProperty("idea.load.plugins.category");
        if (loadPluginCategory != null) {
            reasonToNotLoad = loadPluginCategory.equals(descriptor2.getCategory()) ? null : "Plugin category doesn't match 'idea.load.plugins.category' value";
        } else {
            if (pluginIds != null) {
                String string = reasonToNotLoad = pluginIds.contains(idString) ? null : "'idea.load.plugins.id' doesn't contain this plugin id";
                if (reasonToNotLoad != null) {
                    THashMap<PluginId, IdeaPluginDescriptor> map2 = new THashMap<PluginId, IdeaPluginDescriptor>();
                    for (IdeaPluginDescriptor pluginDescriptor : loaded) {
                        map2.put(pluginDescriptor.getPluginId(), pluginDescriptor);
                    }
                    PluginManagerCore.addModulesAsDependents(map2);
                    for (String id : pluginIds) {
                        IdeaPluginDescriptor descriptorFromProperty = (IdeaPluginDescriptor)map2.get(PluginId.getId(id));
                        if (descriptorFromProperty == null || !PluginManagerCore.isDependent(descriptorFromProperty, descriptor2.getPluginId(), map2, checkModuleDependencies)) continue;
                        reasonToNotLoad = null;
                        break;
                    }
                }
            } else {
                String string = reasonToNotLoad = PluginManagerCore.getDisabledPlugins().contains(idString) ? "Plugin is disabled" : null;
            }
            if (reasonToNotLoad == null && descriptor2 instanceof IdeaPluginDescriptorImpl && PluginManagerCore.isIncompatible(descriptor2)) {
                return "Plugin since-build or until-build don't match this product's build number";
            }
        }
        return reasonToNotLoad;
    }

    public static boolean isIncompatible(@NotNull IdeaPluginDescriptor descriptor2) {
        if (descriptor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/kotlin/com/intellij/ide/plugins/PluginManagerCore", "isIncompatible"));
        }
        return PluginManagerCore.isIncompatible(descriptor2, PluginManagerCore.getBuildNumber());
    }

    public static boolean isIncompatible(@NotNull IdeaPluginDescriptor descriptor2, @Nullable BuildNumber buildNumber) {
        if (descriptor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/kotlin/com/intellij/ide/plugins/PluginManagerCore", "isIncompatible"));
        }
        if (buildNumber == null) {
            buildNumber = PluginManagerCore.getBuildNumber();
        }
        try {
            return PluginManagerCore.isIncompatible(buildNumber, descriptor2.getSinceBuild(), descriptor2.getUntilBuild(), descriptor2.getName(), descriptor2.toString());
        }
        catch (RuntimeException e) {
            LOG.error(e);
            return false;
        }
    }

    public static boolean isIncompatible(@NotNull BuildNumber buildNumber, @Nullable String sinceBuild, @Nullable String untilBuild, @Nullable String descriptorName, @Nullable String descriptorDebugString) {
        BuildNumber untilBuildNumber;
        BuildNumber sinceBuildNumber;
        if (buildNumber == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "buildNumber", "org/jetbrains/kotlin/com/intellij/ide/plugins/PluginManagerCore", "isIncompatible"));
        }
        if (!StringUtil.isEmpty(sinceBuild) && (sinceBuildNumber = BuildNumber.fromString(sinceBuild, descriptorName)).compareTo(buildNumber) > 0) {
            if (descriptorDebugString != null) {
                LOG.warn("Can't load " + descriptorDebugString + ": since build " + sinceBuildNumber + " does not match " + buildNumber);
            }
            return true;
        }
        if (!StringUtil.isEmpty(untilBuild) && (untilBuildNumber = BuildNumber.fromString(untilBuild, descriptorName)).compareTo(buildNumber) < 0) {
            if (descriptorDebugString != null) {
                LOG.warn("Can't load " + descriptorDebugString + ": until build " + untilBuildNumber + " does not match " + buildNumber);
            }
            return true;
        }
        return false;
    }

    private static void checkEssentialPluginsAreAvailable(IdeaPluginDescriptorImpl[] plugins) {
        Set<String> availableIds = ContainerUtil.map2Set(plugins, plugin -> plugin.getPluginId().getIdString());
        List<String> ids = ((ApplicationInfoImpl)ApplicationInfoImpl.getShadowInstance()).getEssentialPluginsIds();
        Set<String> missing = JBIterable.from(ids).filter(id -> !availableIds.contains(id)).toSet();
        if (!missing.isEmpty()) {
            throw new EssentialPluginMissingException(missing);
        }
    }

    private static void initializePlugins(@Nullable StartupProgress progress) {
        int i;
        PluginManagerCore.configureExtensions();
        ArrayList<String> errors = ContainerUtil.newArrayList();
        IdeaPluginDescriptorImpl[] pluginDescriptors = PluginManagerCore.loadDescriptors(progress, errors);
        PluginManagerCore.checkEssentialPluginsAreAvailable(pluginDescriptors);
        Class callerClass = ReflectionUtil.findCallerClass(1);
        assert (callerClass != null);
        ClassLoader parentLoader = callerClass.getClassLoader();
        final ArrayList<IdeaPluginDescriptorImpl> result2 = new ArrayList<IdeaPluginDescriptorImpl>();
        THashMap<PluginId, IdeaPluginDescriptorImpl> idToDescriptorMap = new THashMap<PluginId, IdeaPluginDescriptorImpl>();
        THashMap<String, String> disabledPluginNames = new THashMap<String, String>();
        SmartList<String> brokenPluginsList = new SmartList<String>();
        PluginManagerCore.fixDescriptors(pluginDescriptors, parentLoader, idToDescriptorMap, disabledPluginNames, brokenPluginsList, result2, errors);
        Graph<PluginId> graph2 = PluginManagerCore.createPluginIdGraph(idToDescriptorMap);
        DFSTBuilder<PluginId> builder = new DFSTBuilder<PluginId>(graph2);
        PluginManagerCore.prepareLoadingPluginsErrorMessage(errors);
        Comparator<PluginId> idComparator = builder.comparator();
        result2.sort((o1, o2) -> idComparator.compare(o1.getPluginId(), o2.getPluginId()));
        for (i = 0; i < result2.size(); ++i) {
            ourId2Index.put(((IdeaPluginDescriptorImpl)result2.get(i)).getPluginId(), i);
        }
        i = 0;
        for (IdeaPluginDescriptorImpl pluginDescriptor : result2) {
            if (pluginDescriptor.getPluginId().getIdString().equals("org.jetbrains.kotlin.com.intellij") || pluginDescriptor.isUseCoreClassLoader()) {
                pluginDescriptor.setLoader(parentLoader);
            } else {
                ClassLoader[] classLoaderArray;
                List<File> classPath = pluginDescriptor.getClassPath();
                PluginId[] dependentPluginIds = pluginDescriptor.getDependentPluginIds();
                ClassLoader[] parentLoaders = PluginManagerCore.getParentLoaders(idToDescriptorMap, dependentPluginIds);
                if (parentLoaders.length > 0) {
                    classLoaderArray = parentLoaders;
                } else {
                    ClassLoader[] classLoaderArray2 = new ClassLoader[1];
                    classLoaderArray = classLoaderArray2;
                    classLoaderArray2[0] = parentLoader;
                }
                ClassLoader pluginClassLoader = PluginManagerCore.createPluginClassLoader(classPath.toArray(new File[classPath.size()]), classLoaderArray, pluginDescriptor);
                pluginDescriptor.setLoader(pluginClassLoader);
            }
            if (progress == null) continue;
            progress.showProgress("", 0.3f + (float)i++ / (float)result2.size() * 0.35f);
        }
        PluginManagerCore.registerExtensionPointsAndExtensions(Extensions.getRootArea(), result2);
        Extensions.getRootArea().getExtensionPoint(Extensions.AREA_LISTENER_EXTENSION_POINT).registerExtension(new AreaListener(){

            @Override
            public void areaCreated(@NotNull String areaClass, @NotNull AreaInstance areaInstance) {
                if (areaClass == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "areaClass", "org/jetbrains/kotlin/com/intellij/ide/plugins/PluginManagerCore$2", "areaCreated"));
                }
                if (areaInstance == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "areaInstance", "org/jetbrains/kotlin/com/intellij/ide/plugins/PluginManagerCore$2", "areaCreated"));
                }
                PluginManagerCore.registerExtensionPointsAndExtensions(Extensions.getArea(areaInstance), result2);
            }

            @Override
            public void areaDisposing(@NotNull String areaClass, @NotNull AreaInstance areaInstance) {
                if (areaClass == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "areaClass", "org/jetbrains/kotlin/com/intellij/ide/plugins/PluginManagerCore$2", "areaDisposing"));
                }
                if (areaInstance == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "areaInstance", "org/jetbrains/kotlin/com/intellij/ide/plugins/PluginManagerCore$2", "areaDisposing"));
                }
            }
        });
        ourPlugins = pluginDescriptors;
    }

    public static void fixDescriptors(@NotNull IdeaPluginDescriptorImpl[] pluginDescriptors, @NotNull ClassLoader parentLoader, @NotNull Map<PluginId, IdeaPluginDescriptorImpl> idToDescriptorMap, @NotNull Map<String, String> disabledPluginNames, @NotNull List<String> brokenPluginsList, @NotNull List<IdeaPluginDescriptorImpl> result2, @NotNull List<String> errors) {
        if (pluginDescriptors == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pluginDescriptors", "org/jetbrains/kotlin/com/intellij/ide/plugins/PluginManagerCore", "fixDescriptors"));
        }
        if (parentLoader == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parentLoader", "org/jetbrains/kotlin/com/intellij/ide/plugins/PluginManagerCore", "fixDescriptors"));
        }
        if (idToDescriptorMap == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "idToDescriptorMap", "org/jetbrains/kotlin/com/intellij/ide/plugins/PluginManagerCore", "fixDescriptors"));
        }
        if (disabledPluginNames == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "disabledPluginNames", "org/jetbrains/kotlin/com/intellij/ide/plugins/PluginManagerCore", "fixDescriptors"));
        }
        if (brokenPluginsList == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "brokenPluginsList", "org/jetbrains/kotlin/com/intellij/ide/plugins/PluginManagerCore", "fixDescriptors"));
        }
        if (result2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "org/jetbrains/kotlin/com/intellij/ide/plugins/PluginManagerCore", "fixDescriptors"));
        }
        if (errors == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "errors", "org/jetbrains/kotlin/com/intellij/ide/plugins/PluginManagerCore", "fixDescriptors"));
        }
        PluginManagerCore.checkCanLoadPlugins(pluginDescriptors, parentLoader, disabledPluginNames, brokenPluginsList, result2);
        PluginManagerCore.filterBadPlugins(result2, disabledPluginNames, errors);
        if (!brokenPluginsList.isEmpty()) {
            errors.add("The following plugins are incompatible with the current IDE build: " + StringUtil.join(brokenPluginsList, ", "));
        }
        PluginManagerCore.fixDependencies(result2, idToDescriptorMap);
    }

    private static void checkCanLoadPlugins(@NotNull IdeaPluginDescriptorImpl[] pluginDescriptors, @NotNull ClassLoader parentLoader, @NotNull Map<String, String> disabledPluginNames, @NotNull List<String> brokenPluginsList, @NotNull List<IdeaPluginDescriptorImpl> result2) {
        if (pluginDescriptors == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pluginDescriptors", "org/jetbrains/kotlin/com/intellij/ide/plugins/PluginManagerCore", "checkCanLoadPlugins"));
        }
        if (parentLoader == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parentLoader", "org/jetbrains/kotlin/com/intellij/ide/plugins/PluginManagerCore", "checkCanLoadPlugins"));
        }
        if (disabledPluginNames == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "disabledPluginNames", "org/jetbrains/kotlin/com/intellij/ide/plugins/PluginManagerCore", "checkCanLoadPlugins"));
        }
        if (brokenPluginsList == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "brokenPluginsList", "org/jetbrains/kotlin/com/intellij/ide/plugins/PluginManagerCore", "checkCanLoadPlugins"));
        }
        if (result2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "org/jetbrains/kotlin/com/intellij/ide/plugins/PluginManagerCore", "checkCanLoadPlugins"));
        }
        for (IdeaPluginDescriptorImpl descriptor2 : pluginDescriptors) {
            String toNotLoadReason = PluginManagerCore.detectReasonToNotLoad(descriptor2, pluginDescriptors);
            if (toNotLoadReason == null && PluginManagerCore.isBrokenPlugin(descriptor2)) {
                brokenPluginsList.add(descriptor2.getName());
                toNotLoadReason = "This plugin version was marked as incompatible";
            }
            if (toNotLoadReason == null) {
                List<String> modules = descriptor2.getModules();
                if (modules != null) {
                    for (String module2 : modules) {
                        if (ourModulesToContainingPlugins.containsKey(module2)) continue;
                        ourModulesToContainingPlugins.put(module2, descriptor2);
                    }
                }
                result2.add(descriptor2);
                continue;
            }
            descriptor2.setEnabled(false);
            PluginManagerCore.getLogger().info(String.format("Plugin '%s' can't be loaded because: %s", descriptor2.getName(), toNotLoadReason));
            disabledPluginNames.put(descriptor2.getPluginId().getIdString(), descriptor2.getName());
            PluginManagerCore.initClassLoader(parentLoader, descriptor2);
        }
    }

    private static void fixDependencies(@NotNull List<IdeaPluginDescriptorImpl> result2, @NotNull Map<PluginId, IdeaPluginDescriptorImpl> idToDescriptorMap) {
        if (result2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "org/jetbrains/kotlin/com/intellij/ide/plugins/PluginManagerCore", "fixDependencies"));
        }
        if (idToDescriptorMap == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "idToDescriptorMap", "org/jetbrains/kotlin/com/intellij/ide/plugins/PluginManagerCore", "fixDependencies"));
        }
        for (IdeaPluginDescriptorImpl descriptor2 : result2) {
            idToDescriptorMap.put(descriptor2.getPluginId(), descriptor2);
        }
        IdeaPluginDescriptor corePluginDescriptor = idToDescriptorMap.get(PluginId.getId("org.jetbrains.kotlin.com.intellij"));
        assert (corePluginDescriptor != null) : "org.jetbrains.kotlin.com.intellij not found; platform prefix is " + System.getProperty("idea.platform.prefix");
        for (IdeaPluginDescriptorImpl descriptor3 : result2) {
            if (descriptor3 == corePluginDescriptor) continue;
            descriptor3.insertDependency(corePluginDescriptor);
        }
        PluginManagerCore.mergeOptionalConfigs(idToDescriptorMap);
        PluginManagerCore.addModulesAsDependents(idToDescriptorMap);
    }

    private static void registerExtensionPointsAndExtensions(@NotNull ExtensionsArea area, @NotNull List<IdeaPluginDescriptorImpl> loadedPlugins) {
        if (area == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "area", "org/jetbrains/kotlin/com/intellij/ide/plugins/PluginManagerCore", "registerExtensionPointsAndExtensions"));
        }
        if (loadedPlugins == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "loadedPlugins", "org/jetbrains/kotlin/com/intellij/ide/plugins/PluginManagerCore", "registerExtensionPointsAndExtensions"));
        }
        for (IdeaPluginDescriptorImpl descriptor2 : loadedPlugins) {
            descriptor2.registerExtensionPoints(area);
        }
        ExtensionPoint[] extensionPoints = area.getExtensionPoints();
        THashSet<String> epNames = new THashSet<String>(extensionPoints.length);
        for (ExtensionPoint point : extensionPoints) {
            epNames.add(point.getName());
        }
        for (IdeaPluginDescriptorImpl descriptor3 : loadedPlugins) {
            for (String epName : epNames) {
                descriptor3.registerExtensions(area, epName);
            }
        }
    }

    public static void registerExtensionPointAndExtensions(@NotNull File pluginRoot, @NotNull String fileName, @NotNull ExtensionsArea area) {
        if (pluginRoot == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pluginRoot", "org/jetbrains/kotlin/com/intellij/ide/plugins/PluginManagerCore", "registerExtensionPointAndExtensions"));
        }
        if (fileName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileName", "org/jetbrains/kotlin/com/intellij/ide/plugins/PluginManagerCore", "registerExtensionPointAndExtensions"));
        }
        if (area == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "area", "org/jetbrains/kotlin/com/intellij/ide/plugins/PluginManagerCore", "registerExtensionPointAndExtensions"));
        }
        IdeaPluginDescriptorImpl descriptor2 = pluginRoot.isDirectory() ? PluginManagerCore.loadDescriptorFromDir(pluginRoot, fileName) : PluginManagerCore.loadDescriptorFromJar(pluginRoot, fileName, JDOMXIncluder.DEFAULT_PATH_RESOLVER);
        if (descriptor2 != null) {
            PluginManagerCore.registerExtensionPointsAndExtensions(area, Collections.singletonList(descriptor2));
        } else {
            PluginManagerCore.getLogger().error("Cannot load " + fileName + " from " + pluginRoot);
        }
    }

    private static void initPlugins(@Nullable StartupProgress progress) {
        long start = System.currentTimeMillis();
        try {
            PluginManagerCore.initializePlugins(progress);
        }
        catch (PicoPluginExtensionInitializationException e) {
            throw new PluginException(e, e.getPluginId());
        }
        catch (RuntimeException e) {
            PluginManagerCore.getLogger().error(e);
            throw e;
        }
        PluginManagerCore.getLogger().info(ourPlugins.length + " plugins initialized in " + (System.currentTimeMillis() - start) + " ms");
        PluginManagerCore.logPlugins();
        ClassUtilCore.clearJarURLCache();
    }

    static class EssentialPluginMissingException
    extends RuntimeException {
        final Set<String> pluginIds;

        public EssentialPluginMissingException(@NotNull Set<String> ids) {
            if (ids == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ids", "org/jetbrains/kotlin/com/intellij/ide/plugins/PluginManagerCore$EssentialPluginMissingException", "<init>"));
            }
            this.pluginIds = ids;
        }
    }

    private static class IdeaLogProvider
    implements LogProvider {
        private IdeaLogProvider() {
        }

        @Override
        public void error(String message) {
            PluginManagerCore.getLogger().error(message);
        }

        @Override
        public void error(Throwable t) {
            PluginManagerCore.getLogger().error(t);
        }

        @Override
        public void warn(String message) {
            PluginManagerCore.getLogger().info(message);
        }
    }

    private static class LoggerHolder {
        private static final Logger ourLogger = Logger.getInstance("#com.intellij.ide.plugins.PluginManager");
    }

    private static class Holder {
        private static final BuildNumber ourBuildNumber = Holder.calcBuildNumber();

        private static BuildNumber calcBuildNumber() {
            BuildNumber ourBuildNumber = BuildNumber.fromString(System.getProperty("idea.plugins.compatible.build"));
            if (ourBuildNumber == null) {
                BuildNumber buildNumber = ourBuildNumber = BUILD_NUMBER == null ? null : BuildNumber.fromString(BUILD_NUMBER);
                if (ourBuildNumber == null) {
                    ourBuildNumber = BuildNumber.currentVersion();
                }
            }
            return ourBuildNumber;
        }
    }
}

