/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.psi.filters.element;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiModifier;
import org.jetbrains.kotlin.com.intellij.psi.PsiModifierList;
import org.jetbrains.kotlin.com.intellij.psi.PsiModifierListOwner;
import org.jetbrains.kotlin.com.intellij.psi.filters.ClassFilter;

public class ModifierFilter
extends ClassFilter {
    public final List<ModifierRestriction> myModifierRestrictions = new ArrayList<ModifierRestriction>();

    private ModifierFilter() {
        super(PsiModifierListOwner.class);
    }

    public ModifierFilter(@PsiModifier.ModifierConstant String modifier, boolean hasToBe) {
        this();
        this.addModifierRestriction(modifier, hasToBe);
    }

    public ModifierFilter(String ... modifiers2) {
        this();
        for (String modifier : modifiers2) {
            this.addModifierRestriction(modifier, true);
        }
    }

    private void addModifierRestriction(@PsiModifier.ModifierConstant String mod, boolean hasToBe) {
        this.myModifierRestrictions.add(new ModifierRestriction(mod, hasToBe));
    }

    @Override
    public boolean isAcceptable(Object element, PsiElement context) {
        if (element instanceof PsiModifierListOwner) {
            PsiModifierList list2 = ((PsiModifierListOwner)element).getModifierList();
            if (list2 == null) {
                return true;
            }
            for (ModifierRestriction psiModifier : this.myModifierRestrictions) {
                boolean shouldHave = psiModifier.myIsSet;
                if (shouldHave == list2.hasModifierProperty(psiModifier.myModifierName)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("modifiers(");
        Iterator<ModifierRestriction> iter = this.myModifierRestrictions.iterator();
        while (iter.hasNext()) {
            ModifierRestriction rest = iter.next();
            sb.append(rest.myModifierName).append("=").append(rest.myIsSet);
            if (!iter.hasNext()) continue;
            sb.append(", ");
        }
        sb.append(")");
        return sb.toString();
    }

    protected static final class ModifierRestriction {
        @PsiModifier.ModifierConstant
        public final String myModifierName;
        public final boolean myIsSet;

        ModifierRestriction(@PsiModifier.ModifierConstant String modifierName, boolean isSet) {
            this.myModifierName = modifierName;
            this.myIsSet = isSet;
        }
    }
}

