/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.psi.impl.compiled;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.openapi.util.AtomicNotNullLazyValue;
import org.jetbrains.kotlin.com.intellij.openapi.util.NotNullLazyValue;
import org.jetbrains.kotlin.com.intellij.psi.JavaElementVisitor;
import org.jetbrains.kotlin.com.intellij.psi.PsiClassType;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiElementVisitor;
import org.jetbrains.kotlin.com.intellij.psi.PsiJavaCodeReferenceElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiReferenceList;
import org.jetbrains.kotlin.com.intellij.psi.impl.compiled.ClsElementImpl;
import org.jetbrains.kotlin.com.intellij.psi.impl.compiled.ClsJavaCodeReferenceElementImpl;
import org.jetbrains.kotlin.com.intellij.psi.impl.compiled.ClsRepositoryPsiElement;
import org.jetbrains.kotlin.com.intellij.psi.impl.java.stubs.PsiClassReferenceListStub;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.SourceTreeToPsiMap;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.TreeElement;

public class ClsReferenceListImpl
extends ClsRepositoryPsiElement<PsiClassReferenceListStub>
implements PsiReferenceList {
    private static final ClsJavaCodeReferenceElementImpl[] EMPTY_REFS_ARRAY = new ClsJavaCodeReferenceElementImpl[0];
    private final NotNullLazyValue<ClsJavaCodeReferenceElementImpl[]> myRefs;

    public ClsReferenceListImpl(@NotNull PsiClassReferenceListStub stub) {
        if (stub == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stub", "org/jetbrains/kotlin/com/intellij/psi/impl/compiled/ClsReferenceListImpl", "<init>"));
        }
        super(stub);
        this.myRefs = new AtomicNotNullLazyValue<ClsJavaCodeReferenceElementImpl[]>(){

            @Override
            @NotNull
            protected ClsJavaCodeReferenceElementImpl[] compute() {
                String[] strings = ((PsiClassReferenceListStub)ClsReferenceListImpl.this.getStub()).getReferencedNames();
                if (strings.length > 0) {
                    ClsJavaCodeReferenceElementImpl[] refs = new ClsJavaCodeReferenceElementImpl[strings.length];
                    for (int i = 0; i < strings.length; ++i) {
                        refs[i] = new ClsJavaCodeReferenceElementImpl(ClsReferenceListImpl.this, strings[i]);
                    }
                    if (refs == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/impl/compiled/ClsReferenceListImpl$1", "compute"));
                    }
                    return refs;
                }
                ClsJavaCodeReferenceElementImpl[] clsJavaCodeReferenceElementImplArray = EMPTY_REFS_ARRAY;
                if (clsJavaCodeReferenceElementImplArray == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/impl/compiled/ClsReferenceListImpl$1", "compute"));
                }
                return clsJavaCodeReferenceElementImplArray;
            }
        };
    }

    @Override
    @NotNull
    public PsiJavaCodeReferenceElement[] getReferenceElements() {
        PsiJavaCodeReferenceElement[] psiJavaCodeReferenceElementArray = this.myRefs.getValue();
        if (psiJavaCodeReferenceElementArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/impl/compiled/ClsReferenceListImpl", "getReferenceElements"));
        }
        return psiJavaCodeReferenceElementArray;
    }

    @Override
    @NotNull
    public PsiElement[] getChildren() {
        PsiElement[] psiElementArray = this.getReferenceElements();
        if (psiElementArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/impl/compiled/ClsReferenceListImpl", "getChildren"));
        }
        return psiElementArray;
    }

    @Override
    @NotNull
    public PsiClassType[] getReferencedTypes() {
        PsiClassType[] psiClassTypeArray = ((PsiClassReferenceListStub)this.getStub()).getReferencedTypes();
        if (psiClassTypeArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/impl/compiled/ClsReferenceListImpl", "getReferencedTypes"));
        }
        return psiClassTypeArray;
    }

    @Override
    public PsiReferenceList.Role getRole() {
        return ((PsiClassReferenceListStub)this.getStub()).getRole();
    }

    @Override
    public void appendMirrorText(int indentLevel, @NotNull StringBuilder buffer) {
        if (buffer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "buffer", "org/jetbrains/kotlin/com/intellij/psi/impl/compiled/ClsReferenceListImpl", "appendMirrorText"));
        }
        String[] names2 = ((PsiClassReferenceListStub)this.getStub()).getReferencedNames();
        if (names2.length != 0) {
            switch (this.getRole()) {
                case EXTENDS_BOUNDS_LIST: 
                case EXTENDS_LIST: {
                    buffer.append("extends").append(' ');
                    break;
                }
                case IMPLEMENTS_LIST: {
                    buffer.append("implements").append(' ');
                    break;
                }
                case THROWS_LIST: {
                    buffer.append("throws").append(' ');
                    break;
                }
                case PROVIDES_WITH_LIST: {
                    buffer.append("with").append(' ');
                }
            }
            for (int i = 0; i < names2.length; ++i) {
                if (i > 0) {
                    buffer.append(", ");
                }
                buffer.append(names2[i]);
            }
        }
    }

    @Override
    public void setMirror(@NotNull TreeElement element) throws ClsElementImpl.InvalidMirrorException {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/kotlin/com/intellij/psi/impl/compiled/ClsReferenceListImpl", "setMirror"));
        }
        this.setMirrorCheckingType(element, null);
        ClsReferenceListImpl.setMirrors((PsiElement[])this.getReferenceElements(), (PsiElement[])((PsiReferenceList)SourceTreeToPsiMap.treeToPsiNotNull(element)).getReferenceElements());
    }

    @Override
    public void accept(@NotNull PsiElementVisitor visitor2) {
        if (visitor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visitor", "org/jetbrains/kotlin/com/intellij/psi/impl/compiled/ClsReferenceListImpl", "accept"));
        }
        if (visitor2 instanceof JavaElementVisitor) {
            ((JavaElementVisitor)visitor2).visitReferenceList(this);
        } else {
            visitor2.visitElement(this);
        }
    }

    @Override
    public String toString() {
        return "PsiReferenceList";
    }
}

