/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.util.text;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.openapi.util.text.CharSequenceWithStringHash;
import org.jetbrains.kotlin.com.intellij.openapi.util.text.StringUtil;
import org.jetbrains.kotlin.com.intellij.util.ArrayUtil;
import org.jetbrains.kotlin.com.intellij.util.text.ByteArrayCharSequence;
import org.jetbrains.kotlin.com.intellij.util.text.CharArrayCharSequence;
import org.jetbrains.kotlin.com.intellij.util.text.CharArrayExternalizable;
import org.jetbrains.kotlin.com.intellij.util.text.CharArrayUtil;
import org.jetbrains.kotlin.com.intellij.util.text.CharSequenceSubSequence;
import org.jetbrains.kotlin.com.intellij.util.text.ImmutableCharSequence;
import org.jetbrains.kotlin.com.intellij.util.text.MergingCharSequence;
import org.jetbrains.kotlin.com.intellij.util.text.StringFactory;

final class ImmutableText
extends ImmutableCharSequence
implements CharSequenceWithStringHash,
CharArrayExternalizable {
    private final Node myNode;
    private static final LeafNode EMPTY_NODE = new Leaf8BitNode(ArrayUtil.EMPTY_BYTE_ARRAY);
    private static final ImmutableText EMPTY = new ImmutableText(EMPTY_NODE);
    private transient int hash;
    private InnerLeaf myLastLeaf;

    private ImmutableText(Node node) {
        this.myNode = node;
    }

    static ImmutableText valueOf(@NotNull Object obj) {
        if (obj == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "obj", "org/jetbrains/kotlin/com/intellij/util/text/ImmutableText", "valueOf"));
        }
        if (obj instanceof ImmutableText) {
            return (ImmutableText)obj;
        }
        if (obj instanceof CharSequence) {
            return ((CharSequence)obj).length() == 0 ? EMPTY : ImmutableText.valueOf((CharSequence)obj);
        }
        return ImmutableText.valueOf(String.valueOf(obj));
    }

    private static ImmutableText valueOf(@NotNull CharSequence str) {
        if (str == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "str", "org/jetbrains/kotlin/com/intellij/util/text/ImmutableText", "valueOf"));
        }
        return new ImmutableText(ImmutableText.createLeafNode(str));
    }

    private static LeafNode createLeafNode(@NotNull CharSequence str) {
        if (str == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "str", "org/jetbrains/kotlin/com/intellij/util/text/ImmutableText", "createLeafNode"));
        }
        byte[] bytes = ImmutableText.toBytesIfPossible(str);
        if (bytes != null) {
            return new Leaf8BitNode(bytes);
        }
        char[] chars = new char[str.length()];
        CharArrayUtil.getChars(str, chars, 0, 0, str.length());
        return new WideLeafNode(chars);
    }

    @Nullable
    private static byte[] toBytesIfPossible(CharSequence seq) {
        if (seq instanceof ByteArrayCharSequence) {
            return ((ByteArrayCharSequence)seq).getBytes();
        }
        byte[] bytes = new byte[seq.length()];
        char[] chars = CharArrayUtil.fromSequenceWithoutCopying(seq);
        if (chars == null) {
            for (int i = 0; i < bytes.length; ++i) {
                char c = seq.charAt(i);
                if ((c & 0xFF00) != 0) {
                    return null;
                }
                bytes[i] = (byte)c;
            }
        } else {
            for (int i = 0; i < bytes.length; ++i) {
                char c = chars[i];
                if ((c & 0xFF00) != 0) {
                    return null;
                }
                bytes[i] = (byte)c;
            }
        }
        return bytes;
    }

    private ImmutableText ensureChunked() {
        if (this.length() > 64 && this.myNode instanceof LeafNode) {
            return new ImmutableText(ImmutableText.nodeOf((LeafNode)this.myNode, 0, this.length()));
        }
        return this;
    }

    private static Node nodeOf(@NotNull LeafNode node, int offset2, int length) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "org/jetbrains/kotlin/com/intellij/util/text/ImmutableText", "nodeOf"));
        }
        if (length <= 64) {
            return node.subNode(offset2, offset2 + length);
        }
        int half = length + 64 >> 1 & 0xFFFFFFC0;
        return new CompositeNode(ImmutableText.nodeOf(node, offset2, half), ImmutableText.nodeOf(node, offset2 + half, length - half));
    }

    @Override
    public int length() {
        return this.myNode.length();
    }

    private ImmutableText concat(ImmutableText that) {
        return that.length() == 0 ? this : (this.length() == 0 ? that : new ImmutableText(ImmutableText.concatNodes(this.ensureChunked().myNode, that.ensureChunked().myNode)));
    }

    private ImmutableText subtext(int start) {
        return this.subtext(start, this.length());
    }

    private ImmutableText insert(int index2, ImmutableText txt) {
        return this.subtext(0, index2).concat(txt).concat(this.subtext(index2));
    }

    @Override
    public ImmutableText insert(int index2, @NotNull CharSequence seq) {
        if (seq == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "seq", "org/jetbrains/kotlin/com/intellij/util/text/ImmutableText", "insert"));
        }
        return this.insert(index2, ImmutableText.valueOf(seq));
    }

    @Override
    public ImmutableText delete(int start, int end) {
        if (start == end) {
            return this;
        }
        if (start > end) {
            throw new IndexOutOfBoundsException();
        }
        return this.ensureChunked().subtext(0, start).concat(this.subtext(end));
    }

    @Override
    public CharSequence subSequence(int start, int end) {
        if (start == 0 && end == this.length()) {
            return this;
        }
        return new CharSequenceSubSequence(this, start, end);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof ImmutableText)) {
            return false;
        }
        return CharArrayUtil.regionMatches(this, 0, (ImmutableText)obj);
    }

    public int hashCode() {
        int h = this.hash;
        if (h == 0) {
            this.hash = h = StringUtil.stringHashCode(this, 0, this.length());
        }
        return h;
    }

    @Override
    public char charAt(int index2) {
        InnerLeaf leaf = this.myLastLeaf;
        if (leaf == null || index2 < leaf.offset || index2 >= leaf.end) {
            this.myLastLeaf = leaf = this.findLeaf(index2);
        }
        return leaf.leafNode.charAt(index2 - leaf.offset);
    }

    private InnerLeaf findLeaf(int index2) {
        Node node = this.myNode;
        if (index2 < 0 || index2 >= node.length()) {
            throw new IndexOutOfBoundsException("Index out of range: " + index2);
        }
        int offset2 = 0;
        while (true) {
            if (index2 >= node.length()) {
                throw new IndexOutOfBoundsException();
            }
            if (node instanceof LeafNode) {
                return new InnerLeaf((LeafNode)node, offset2);
            }
            CompositeNode composite = (CompositeNode)node;
            if (index2 < composite.head.length()) {
                node = composite.head;
                continue;
            }
            offset2 += composite.head.length();
            index2 -= composite.head.length();
            node = composite.tail;
        }
    }

    @Override
    public ImmutableText subtext(int start, int end) {
        if (start < 0 || start > end || end > this.length()) {
            throw new IndexOutOfBoundsException();
        }
        if (start == 0 && end == this.length()) {
            return this;
        }
        if (start == end) {
            return EMPTY;
        }
        return new ImmutableText(this.myNode.subNode(start, end));
    }

    @Override
    public void getChars(int start, int end, @NotNull char[] dest, int destPos) {
        if (dest == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dest", "org/jetbrains/kotlin/com/intellij/util/text/ImmutableText", "getChars"));
        }
        this.myNode.getChars(start, end, dest, destPos);
    }

    @Override
    @NotNull
    public String toString() {
        String string = this.myNode.toString();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/util/text/ImmutableText", "toString"));
        }
        return string;
    }

    @NotNull
    private static Node concatNodes(@NotNull Node node1, @NotNull Node node2) {
        if (node1 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node1", "org/jetbrains/kotlin/com/intellij/util/text/ImmutableText", "concatNodes"));
        }
        if (node2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node2", "org/jetbrains/kotlin/com/intellij/util/text/ImmutableText", "concatNodes"));
        }
        int length = node1.length() + node2.length();
        if (length <= 64) {
            LeafNode leafNode = ImmutableText.createLeafNode(new MergingCharSequence(node1, node2));
            if (leafNode == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/util/text/ImmutableText", "concatNodes"));
            }
            return leafNode;
        }
        Node head = node1;
        Node tail = node2;
        if (head.length() << 1 < tail.length() && tail instanceof CompositeNode) {
            if (((CompositeNode)tail).head.length() > ((CompositeNode)tail).tail.length()) {
                tail = ((CompositeNode)tail).rightRotation();
            }
            head = ImmutableText.concatNodes(head, ((CompositeNode)tail).head);
            tail = ((CompositeNode)tail).tail;
        } else if (tail.length() << 1 < head.length() && head instanceof CompositeNode) {
            if (((CompositeNode)head).tail.length() > ((CompositeNode)head).head.length()) {
                head = ((CompositeNode)head).leftRotation();
            }
            tail = ImmutableText.concatNodes(((CompositeNode)head).tail, tail);
            head = ((CompositeNode)head).head;
        }
        CompositeNode compositeNode = new CompositeNode(head, tail);
        if (compositeNode == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/util/text/ImmutableText", "concatNodes"));
        }
        return compositeNode;
    }

    private static class CompositeNode
    extends Node {
        final int count;
        final Node head;
        final Node tail;

        CompositeNode(Node head, Node tail) {
            this.count = head.length() + tail.length();
            this.head = head;
            this.tail = tail;
        }

        @Override
        public int length() {
            return this.count;
        }

        @Override
        public char charAt(int index2) {
            int headLength = this.head.length();
            return index2 < headLength ? this.head.charAt(index2) : this.tail.charAt(index2 - headLength);
        }

        Node rightRotation() {
            Node P3 = this.head;
            if (!(P3 instanceof CompositeNode)) {
                return this;
            }
            Node A = ((CompositeNode)P3).head;
            Node B = ((CompositeNode)P3).tail;
            Node C = this.tail;
            return new CompositeNode(A, new CompositeNode(B, C));
        }

        Node leftRotation() {
            Node Q = this.tail;
            if (!(Q instanceof CompositeNode)) {
                return this;
            }
            Node B = ((CompositeNode)Q).head;
            Node C = ((CompositeNode)Q).tail;
            Node A = this.head;
            return new CompositeNode(new CompositeNode(A, B), C);
        }

        @Override
        void getChars(int start, int end, @NotNull char[] dest, int destPos) {
            if (dest == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dest", "org/jetbrains/kotlin/com/intellij/util/text/ImmutableText$CompositeNode", "getChars"));
            }
            int cesure = this.head.length();
            if (end <= cesure) {
                this.head.getChars(start, end, dest, destPos);
            } else if (start >= cesure) {
                this.tail.getChars(start - cesure, end - cesure, dest, destPos);
            } else {
                this.head.getChars(start, cesure, dest, destPos);
                this.tail.getChars(0, end - cesure, dest, destPos + cesure - start);
            }
        }

        @Override
        Node subNode(int start, int end) {
            int cesure = this.head.length();
            if (end <= cesure) {
                return this.head.subNode(start, end);
            }
            if (start >= cesure) {
                return this.tail.subNode(start - cesure, end - cesure);
            }
            if (start == 0 && end == this.count) {
                return this;
            }
            return ImmutableText.concatNodes(this.head.subNode(start, cesure), this.tail.subNode(0, end - cesure));
        }
    }

    private static class Leaf8BitNode
    extends LeafNode {
        private final byte[] data;

        Leaf8BitNode(@NotNull byte[] data) {
            if (data == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "data", "org/jetbrains/kotlin/com/intellij/util/text/ImmutableText$Leaf8BitNode", "<init>"));
            }
            this.data = data;
        }

        @Override
        public int length() {
            return this.data.length;
        }

        @Override
        void getChars(int start, int end, @NotNull char[] dest, int destPos) {
            if (dest == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dest", "org/jetbrains/kotlin/com/intellij/util/text/ImmutableText$Leaf8BitNode", "getChars"));
            }
            if (start < 0 || end > this.length() || start > end) {
                throw new IndexOutOfBoundsException();
            }
            for (int i = start; i < end; ++i) {
                dest[destPos++] = Leaf8BitNode.byteToChar(this.data[i]);
            }
        }

        @Override
        LeafNode subNode(int start, int end) {
            if (start == 0 && end == this.length()) {
                return this;
            }
            int length = end - start;
            byte[] chars = new byte[length];
            System.arraycopy(this.data, start, chars, 0, length);
            return new Leaf8BitNode(chars);
        }

        @Override
        public char charAt(int index2) {
            return Leaf8BitNode.byteToChar(this.data[index2]);
        }

        private static char byteToChar(byte b) {
            return (char)(b & 0xFF);
        }
    }

    private static class WideLeafNode
    extends LeafNode {
        private final char[] data;

        WideLeafNode(@NotNull char[] data) {
            if (data == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "data", "org/jetbrains/kotlin/com/intellij/util/text/ImmutableText$WideLeafNode", "<init>"));
            }
            this.data = data;
        }

        @Override
        public int length() {
            return this.data.length;
        }

        @Override
        void getChars(int start, int end, @NotNull char[] dest, int destPos) {
            if (dest == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dest", "org/jetbrains/kotlin/com/intellij/util/text/ImmutableText$WideLeafNode", "getChars"));
            }
            if (start < 0 || end > this.length() || start > end) {
                throw new IndexOutOfBoundsException();
            }
            System.arraycopy(this.data, start, dest, destPos, end - start);
        }

        @Override
        Node subNode(int start, int end) {
            if (start == 0 && end == this.length()) {
                return this;
            }
            return ImmutableText.createLeafNode(new CharArrayCharSequence(this.data, start, end));
        }

        @Override
        @NotNull
        public String toString() {
            String string = StringFactory.createShared(this.data);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/util/text/ImmutableText$WideLeafNode", "toString"));
            }
            return string;
        }

        @Override
        public char charAt(int index2) {
            return this.data[index2];
        }
    }

    private static abstract class LeafNode
    extends Node {
        private LeafNode() {
        }
    }

    private static abstract class Node
    implements CharSequence {
        private Node() {
        }

        abstract void getChars(int var1, int var2, @NotNull char[] var3, int var4);

        abstract Node subNode(int var1, int var2);

        @Override
        @NotNull
        public String toString() {
            int len = this.length();
            char[] data = new char[len];
            this.getChars(0, len, data, 0);
            String string = StringFactory.createShared(data);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/util/text/ImmutableText$Node", "toString"));
            }
            return string;
        }

        @Override
        public CharSequence subSequence(int start, int end) {
            return this.subNode(start, end);
        }
    }

    private static class InnerLeaf {
        final LeafNode leafNode;
        final int offset;
        final int end;

        private InnerLeaf(@NotNull LeafNode leafNode, int offset2) {
            if (leafNode == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "leafNode", "org/jetbrains/kotlin/com/intellij/util/text/ImmutableText$InnerLeaf", "<init>"));
            }
            this.leafNode = leafNode;
            this.offset = offset2;
            this.end = offset2 + leafNode.length();
        }
    }
}

