/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.publish.tasks;

import com.google.common.collect.ImmutableSet;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import javax.inject.Inject;
import org.gradle.api.Buildable;
import org.gradle.api.DefaultTask;
import org.gradle.api.Incubating;
import org.gradle.api.UncheckedIOException;
import org.gradle.api.artifacts.PublishArtifact;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.RegularFile;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.internal.artifacts.ivyservice.projectmodule.ProjectDependencyPublicationResolver;
import org.gradle.api.internal.component.SoftwareComponentInternal;
import org.gradle.api.internal.component.UsageContext;
import org.gradle.api.internal.file.FileCollectionFactory;
import org.gradle.api.internal.file.collections.MinimalFileSet;
import org.gradle.api.internal.tasks.DefaultTaskDependency;
import org.gradle.api.provider.ListProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.publish.Publication;
import org.gradle.api.publish.internal.ModuleMetadataFileGenerator;
import org.gradle.api.publish.internal.PublicationInternal;
import org.gradle.api.specs.Specs;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.OutputFile;
import org.gradle.api.tasks.TaskAction;
import org.gradle.api.tasks.TaskDependency;
import org.gradle.internal.Cast;
import org.gradle.internal.scopeids.id.BuildInvocationScopeId;

@Incubating
public class GenerateModuleMetadata
extends DefaultTask {
    private final Property<Publication> publication = this.getProject().getObjects().property(Publication.class);
    private final ListProperty<Publication> publications = this.getProject().getObjects().listProperty(Publication.class);
    private final RegularFileProperty outputFile = this.newOutputFile();

    public GenerateModuleMetadata() {
        this.getOutputs().upToDateWhen(Specs.satisfyNone());
    }

    @Internal
    public Property<Publication> getPublication() {
        return this.publication;
    }

    @Internal
    public ListProperty<Publication> getPublications() {
        return this.publications;
    }

    @InputFiles
    FileCollection getArtifacts() {
        return this.getFileCollectionFactory().create((MinimalFileSet)new VariantFiles());
    }

    @Inject
    protected FileCollectionFactory getFileCollectionFactory() {
        throw new UnsupportedOperationException();
    }

    @Inject
    protected BuildInvocationScopeId getBuildInvocationScopeId() {
        throw new UnsupportedOperationException();
    }

    @Inject
    protected ProjectDependencyPublicationResolver getProjectDependencyPublicationResolver() {
        throw new UnsupportedOperationException();
    }

    @OutputFile
    public RegularFileProperty getOutputFile() {
        return this.outputFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @TaskAction
    void run() {
        File file = ((RegularFile)this.outputFile.get()).getAsFile();
        PublicationInternal publication = (PublicationInternal)this.publication.get();
        List publications = (List)Cast.uncheckedCast((Object)this.publications.get());
        try (BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), "utf8"));){
            new ModuleMetadataFileGenerator(this.getBuildInvocationScopeId(), this.getProjectDependencyPublicationResolver()).generateTo(publication, publications, writer);
        }
        catch (IOException e) {
            throw new UncheckedIOException("Could not generate metadata file " + this.outputFile.get(), (Throwable)e);
        }
    }

    private class VariantFiles
    implements MinimalFileSet,
    Buildable {
        private VariantFiles() {
        }

        public TaskDependency getBuildDependencies() {
            PublicationInternal publication = (PublicationInternal)GenerateModuleMetadata.this.publication.get();
            SoftwareComponentInternal component = publication.getComponent();
            DefaultTaskDependency dependency = new DefaultTaskDependency();
            if (component == null) {
                return dependency;
            }
            for (UsageContext usageContext : component.getUsages()) {
                for (PublishArtifact publishArtifact : usageContext.getArtifacts()) {
                    dependency.add(new Object[]{publishArtifact});
                }
            }
            return dependency;
        }

        public Set<File> getFiles() {
            PublicationInternal publication = (PublicationInternal)GenerateModuleMetadata.this.publication.get();
            SoftwareComponentInternal component = publication.getComponent();
            if (component == null) {
                return ImmutableSet.of();
            }
            LinkedHashSet<File> files = new LinkedHashSet<File>();
            for (UsageContext usageContext : component.getUsages()) {
                for (PublishArtifact publishArtifact : usageContext.getArtifacts()) {
                    files.add(publishArtifact.getFile());
                }
            }
            return files;
        }

        public String getDisplayName() {
            return "files of " + GenerateModuleMetadata.this.getPath();
        }
    }
}

