/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.tagging.presets.items;

import java.awt.Component;
import java.awt.Dimension;
import java.io.File;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import java.util.stream.Collectors;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Tag;
import org.openstreetmap.josm.gui.tagging.presets.TaggingPresetReader;
import org.openstreetmap.josm.gui.tagging.presets.items.KeyedItem;
import org.openstreetmap.josm.spi.preferences.Config;
import org.openstreetmap.josm.tools.AlphanumComparator;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Logging;
import org.openstreetmap.josm.tools.Utils;

public abstract class ComboMultiSelect
extends KeyedItem {
    private static final Renderer RENDERER = new Renderer();
    public String locale_text;
    public String values;
    public String values_from;
    public String values_context;
    public boolean values_no_i18n;
    public boolean values_sort = true;
    public String display_values;
    public String locale_display_values;
    public String short_descriptions;
    public String locale_short_descriptions;
    public String default_;
    public String delimiter = ";";
    public String use_last_as_default = "false";
    public String values_searchable = "false";
    protected JComponent component;
    protected final Map<String, PresetListEntry> lhm = new LinkedHashMap<String, PresetListEntry>();
    private boolean initialized;
    protected KeyedItem.Usage usage;
    protected Object originalValue;

    public static String[] splitEscaped(char delimiter, String s) {
        if (s == null) {
            return new String[0];
        }
        ArrayList<String> result = new ArrayList<String>();
        boolean backslash = false;
        StringBuilder item = new StringBuilder();
        for (int i = 0; i < s.length(); ++i) {
            char ch = s.charAt(i);
            if (backslash) {
                item.append(ch);
                backslash = false;
                continue;
            }
            if (ch == '\\') {
                backslash = true;
                continue;
            }
            if (ch == delimiter) {
                result.add(item.toString());
                item.setLength(0);
                continue;
            }
            item.append(ch);
        }
        if (item.length() > 0) {
            result.add(item.toString());
        }
        return result.toArray(new String[0]);
    }

    protected abstract Object getSelectedItem();

    protected abstract void addToPanelAnchor(JPanel var1, String var2, boolean var3);

    protected char getDelChar() {
        return this.delimiter.isEmpty() ? (char)';' : this.delimiter.charAt(0);
    }

    @Override
    public Collection<String> getValues() {
        this.initListEntries();
        return this.lhm.keySet();
    }

    public Collection<String> getDisplayValues() {
        this.initListEntries();
        return this.lhm.values().stream().map(x -> x.getDisplayValue(true)).collect(Collectors.toList());
    }

    @Override
    public boolean addToPanel(JPanel p, Collection<OsmPrimitive> sel, boolean presetInitiallyMatches) {
        this.initListEntries();
        this.usage = ComboMultiSelect.determineTextUsage(sel, this.key);
        if (!this.usage.hasUniqueValue() && !this.usage.unused()) {
            this.lhm.put(DIFFERENT, new PresetListEntry(DIFFERENT));
        }
        JLabel label = new JLabel(I18n.tr("{0}:", this.locale_text));
        label.setToolTipText(this.getKeyTooltipText());
        p.add((Component)label, GBC.std().insets(0, 0, 10, 0));
        this.addToPanelAnchor(p, this.default_, presetInitiallyMatches);
        label.setLabelFor(this.component);
        this.component.setToolTipText(this.getKeyTooltipText());
        return true;
    }

    private void initListEntries() {
        if (this.initialized) {
            this.lhm.remove(DIFFERENT);
            return;
        }
        if (this.lhm.isEmpty()) {
            this.initListEntriesFromAttributes();
        } else {
            if (this.values != null) {
                Logging.warn(I18n.tr("Warning in tagging preset \"{0}-{1}\": Ignoring ''{2}'' attribute as ''{3}'' elements are given.", this.key, this.text, "values", "list_entry"));
            }
            if (this.display_values != null || this.locale_display_values != null) {
                Logging.warn(I18n.tr("Warning in tagging preset \"{0}-{1}\": Ignoring ''{2}'' attribute as ''{3}'' elements are given.", this.key, this.text, "display_values", "list_entry"));
            }
            if (this.short_descriptions != null || this.locale_short_descriptions != null) {
                Logging.warn(I18n.tr("Warning in tagging preset \"{0}-{1}\": Ignoring ''{2}'' attribute as ''{3}'' elements are given.", this.key, this.text, "short_descriptions", "list_entry"));
            }
            for (PresetListEntry e : this.lhm.values()) {
                if (e.value_context != null) continue;
                e.value_context = this.values_context;
            }
        }
        if (this.locale_text == null) {
            this.locale_text = ComboMultiSelect.getLocaleText(this.text, this.text_context, null);
        }
        this.initialized = true;
    }

    private void initListEntriesFromAttributes() {
        String descr;
        Object[] shortDescriptionsArray;
        String[] classMethod;
        char delChar = this.getDelChar();
        Object[] valueArray = null;
        if (this.values_from != null && (classMethod = this.values_from.split("#")).length == 2) {
            try {
                Method method = Class.forName(classMethod[0]).getMethod(classMethod[1], new Class[0]);
                int mod = method.getModifiers();
                if (Modifier.isPublic(mod) && Modifier.isStatic(mod) && method.getReturnType().equals(String[].class) && method.getParameterTypes().length == 0) {
                    valueArray = (String[])method.invoke(null, new Object[0]);
                } else {
                    Logging.error(I18n.tr("Broken tagging preset \"{0}-{1}\" - Java method given in ''values_from'' is not \"{2}\"", this.key, this.text, "public static String[] methodName()"));
                }
            }
            catch (ReflectiveOperationException e) {
                Logging.error(I18n.tr("Broken tagging preset \"{0}-{1}\" - Java method given in ''values_from'' threw {2} ({3})", this.key, this.text, e.getClass().getName(), e.getMessage()));
                Logging.debug(e);
            }
        }
        if (valueArray == null) {
            valueArray = ComboMultiSelect.splitEscaped(delChar, this.values);
        }
        Object[] displayArray = valueArray;
        if (!this.values_no_i18n) {
            String displ = Utils.firstNonNull(this.locale_display_values, this.display_values);
            displayArray = displ == null ? valueArray : ComboMultiSelect.splitEscaped(delChar, displ);
        }
        Object[] objectArray = shortDescriptionsArray = (descr = Utils.firstNonNull(this.locale_short_descriptions, this.short_descriptions)) == null ? null : ComboMultiSelect.splitEscaped(delChar, descr);
        if (displayArray.length != valueArray.length) {
            Logging.error(I18n.tr("Broken tagging preset \"{0}-{1}\" - number of items in ''display_values'' must be the same as in ''values''", this.key, this.text));
            Logging.error(I18n.tr("Detailed information: {0} <> {1}", Arrays.toString(displayArray), Arrays.toString(valueArray)));
            displayArray = valueArray;
        }
        if (shortDescriptionsArray != null && shortDescriptionsArray.length != valueArray.length) {
            Logging.error(I18n.tr("Broken tagging preset \"{0}-{1}\" - number of items in ''short_descriptions'' must be the same as in ''values''", this.key, this.text));
            Logging.error(I18n.tr("Detailed information: {0} <> {1}", Arrays.toString(shortDescriptionsArray), Arrays.toString(valueArray)));
            shortDescriptionsArray = null;
        }
        ArrayList<PresetListEntry> entries = new ArrayList<PresetListEntry>(valueArray.length);
        for (int i = 0; i < valueArray.length; ++i) {
            PresetListEntry e = new PresetListEntry(valueArray[i]);
            Object object = e.locale_display_value = this.locale_display_values != null || this.values_no_i18n ? displayArray[i] : I18n.trc(this.values_context, ComboMultiSelect.fixPresetString((String)displayArray[i]));
            if (shortDescriptionsArray != null) {
                e.locale_short_description = this.locale_short_descriptions != null ? shortDescriptionsArray[i] : I18n.tr(ComboMultiSelect.fixPresetString((String)shortDescriptionsArray[i]), new Object[0]);
            }
            entries.add(e);
        }
        if (this.values_sort && Config.getPref().getBoolean("taggingpreset.sortvalues", true)) {
            Collections.sort(entries);
        }
        for (PresetListEntry i : entries) {
            this.lhm.put(i.value, i);
        }
    }

    protected String getDisplayIfNull() {
        return null;
    }

    @Override
    public void addCommands(List<Tag> changedTags) {
        Object obj = this.getSelectedItem();
        String display = obj == null ? this.getDisplayIfNull() : obj.toString();
        String value = null;
        if (display != null) {
            for (Map.Entry<String, PresetListEntry> entry : this.lhm.entrySet()) {
                String k = entry.getValue().toString();
                if (!k.equals(display)) continue;
                value = entry.getKey();
                break;
            }
            if (value == null) {
                value = display;
            }
        } else {
            value = "";
        }
        value = Tag.removeWhiteSpaces(value);
        if (this.originalValue == null ? value.isEmpty() : value.equals(this.originalValue.toString())) {
            return;
        }
        if (!"false".equals(this.use_last_as_default)) {
            LAST_VALUES.put(this.key, value);
        }
        changedTags.add(new Tag(this.key, value));
    }

    public void addListEntry(PresetListEntry e) {
        this.lhm.put(e.value, e);
    }

    public void addListEntries(Collection<PresetListEntry> e) {
        for (PresetListEntry i : e) {
            this.addListEntry(i);
        }
    }

    protected ListCellRenderer<PresetListEntry> getListCellRenderer() {
        return RENDERER;
    }

    @Override
    public KeyedItem.MatchType getDefaultMatch() {
        return KeyedItem.MatchType.NONE;
    }

    public static class PresetListEntry
    implements Comparable<PresetListEntry> {
        public String value;
        public String value_context;
        public String display_value;
        public String short_description;
        public String icon;
        public String icon_size;
        public String locale_display_value;
        public String locale_short_description;
        private final File zipIcons = TaggingPresetReader.getZipIcons();
        public int prefferedWidth = -1;
        public int prefferedHeight = -1;

        public PresetListEntry() {
        }

        public PresetListEntry(String value) {
            this.value = value;
        }

        public String getListDisplay() {
            if (this.value.equals(KeyedItem.DIFFERENT)) {
                return "<b>" + Utils.escapeReservedCharactersHTML(KeyedItem.DIFFERENT) + "</b>";
            }
            String displayValue = Utils.escapeReservedCharactersHTML(this.getDisplayValue(true));
            String shortDescription = this.getShortDescription(true);
            if (displayValue.isEmpty() && (shortDescription == null || shortDescription.isEmpty())) {
                return "&nbsp;";
            }
            StringBuilder res = new StringBuilder("<b>").append(displayValue).append("</b>");
            if (shortDescription != null) {
                res.append("<div style=\"width:300px; padding:0 0 5px 5px\">").append(shortDescription).append("</div>");
            }
            return res.toString();
        }

        public ImageIcon getIcon() {
            return this.icon == null ? null : ComboMultiSelect.loadImageIcon(this.icon, this.zipIcons, ComboMultiSelect.parseInteger(this.icon_size));
        }

        public String getDisplayValue(boolean translated) {
            return translated ? Utils.firstNonNull(this.locale_display_value, I18n.tr(this.display_value, new Object[0]), I18n.trc(this.value_context, this.value)) : Utils.firstNonNull(this.display_value, this.value);
        }

        public String getShortDescription(boolean translated) {
            return translated ? Utils.firstNonNull(this.locale_short_description, I18n.tr(this.short_description, new Object[0])) : this.short_description;
        }

        public String toString() {
            if (KeyedItem.DIFFERENT.equals(this.value)) {
                return KeyedItem.DIFFERENT;
            }
            String displayValue = this.getDisplayValue(true);
            return displayValue != null ? displayValue.replaceAll("<.*>", "") : "";
        }

        @Override
        public int compareTo(PresetListEntry o) {
            return AlphanumComparator.getInstance().compare(this.getDisplayValue(true), o.getDisplayValue(true));
        }
    }

    protected static class ConcatenatingJList
    extends JList<PresetListEntry> {
        private final String delimiter;

        protected ConcatenatingJList(String del, PresetListEntry ... o) {
            super(o);
            this.delimiter = del;
        }

        public void setSelectedItem(Object o) {
            if (o == null) {
                this.clearSelection();
            } else {
                String s = o.toString();
                TreeSet<String> parts = new TreeSet<String>(Arrays.asList(s.split(this.delimiter)));
                ListModel lm = this.getModel();
                int[] intParts = new int[lm.getSize()];
                int j = 0;
                for (int i = 0; i < lm.getSize(); ++i) {
                    String value = ((PresetListEntry)lm.getElementAt((int)i)).value;
                    if (!parts.contains(value)) continue;
                    intParts[j++] = i;
                    parts.remove(value);
                }
                this.setSelectedIndices(Arrays.copyOf(intParts, j));
                this.setEnabled(parts.isEmpty());
            }
        }

        public String getSelectedItem() {
            ListModel lm = this.getModel();
            int[] si = this.getSelectedIndices();
            StringBuilder builder = new StringBuilder();
            for (int i = 0; i < si.length; ++i) {
                if (i > 0) {
                    builder.append(this.delimiter);
                }
                builder.append(((PresetListEntry)lm.getElementAt((int)si[i])).value);
            }
            return builder.toString();
        }
    }

    private static final class Renderer
    implements ListCellRenderer<PresetListEntry> {
        private final JLabel lbl = new JLabel();

        private Renderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList<? extends PresetListEntry> list, PresetListEntry item, int index, boolean isSelected, boolean cellHasFocus) {
            if (list == null || item == null) {
                return this.lbl;
            }
            if (!list.isShowing() && item.prefferedWidth != -1 && item.prefferedHeight != -1) {
                if (index == -1) {
                    this.lbl.setPreferredSize(new Dimension(item.prefferedWidth, 10));
                } else {
                    this.lbl.setPreferredSize(new Dimension(item.prefferedWidth, item.prefferedHeight));
                }
                return this.lbl;
            }
            this.lbl.setPreferredSize(null);
            if (isSelected) {
                this.lbl.setBackground(list.getSelectionBackground());
                this.lbl.setForeground(list.getSelectionForeground());
            } else {
                this.lbl.setBackground(list.getBackground());
                this.lbl.setForeground(list.getForeground());
            }
            this.lbl.setOpaque(true);
            this.lbl.setFont(this.lbl.getFont().deriveFont(0));
            this.lbl.setText("<html>" + item.getListDisplay() + "</html>");
            this.lbl.setIcon(item.getIcon());
            this.lbl.setEnabled(list.isEnabled());
            item.prefferedWidth = this.lbl.getPreferredSize().width;
            item.prefferedHeight = this.lbl.getPreferredSize().height;
            if (index == -1) {
                this.lbl.setPreferredSize(new Dimension(this.lbl.getPreferredSize().width, 10));
            }
            return this.lbl;
        }
    }
}

