/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.LinkedList;
import java.util.List;
import org.openstreetmap.josm.plugins.PluginException;
import org.openstreetmap.josm.plugins.PluginHandler;
import org.openstreetmap.josm.plugins.PluginInformation;
import org.openstreetmap.josm.plugins.PluginListParseException;
import org.openstreetmap.josm.plugins.PluginProxy;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Logging;

public class PluginListParser {
    public static PluginInformation createInfo(String name, String url, String manifest) throws PluginListParseException {
        try {
            return new PluginInformation(new ByteArrayInputStream(manifest.getBytes(StandardCharsets.UTF_8)), name.substring(0, name.length() - 4), url);
        }
        catch (PluginException e) {
            throw new PluginListParseException(I18n.tr("Failed to create plugin information from manifest for plugin ''{0}''", name), e);
        }
    }

    public List<PluginInformation> parse(InputStream in) throws PluginListParseException {
        LinkedList<PluginInformation> ret = new LinkedList<PluginInformation>();
        BufferedReader r = null;
        try {
            r = new BufferedReader(new InputStreamReader(in, StandardCharsets.UTF_8));
            String name = null;
            String url = null;
            StringBuilder manifest = new StringBuilder();
            String line = r.readLine();
            while (line != null) {
                if (line.startsWith("\t")) {
                    line = line.substring(1);
                    while (line.length() > 70) {
                        manifest.append(line.substring(0, 70)).append('\n');
                        line = ' ' + line.substring(70);
                    }
                    manifest.append(line).append('\n');
                } else {
                    PluginListParser.addPluginInformation(ret, name, url, manifest.toString());
                    String[] x = line.split(";");
                    if (x.length != 2) {
                        throw new IOException(I18n.tr("Illegal entry in plugin list.", new Object[0]));
                    }
                    name = x[0];
                    url = x[1];
                    manifest = new StringBuilder();
                }
                line = r.readLine();
            }
            PluginListParser.addPluginInformation(ret, name, url, manifest.toString());
            return ret;
        }
        catch (IOException e) {
            throw new PluginListParseException(e);
        }
    }

    private static void addPluginInformation(List<PluginInformation> ret, String name, String url, String manifest) {
        try {
            if (name != null) {
                PluginInformation info = PluginListParser.createInfo(name, url, manifest);
                for (PluginProxy plugin : PluginHandler.pluginList) {
                    if (!plugin.getPluginInformation().name.equals(info.getName())) continue;
                    info.localversion = plugin.getPluginInformation().localversion;
                }
                ret.add(info);
            }
        }
        catch (PluginListParseException ex) {
            Logging.error(ex);
        }
    }
}

