/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owlapi.io;

import javax.annotation.Nonnull;
import org.semanticweb.owlapi.io.RDFResource;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.NodeID;
import org.semanticweb.owlapi.util.OWLAPIPreconditions;

public class RDFResourceBlankNode
extends RDFResource {
    private static final long serialVersionUID = 40000L;
    @Nonnull
    private final IRI resource;
    private final boolean isIndividual;
    private final boolean forceIdOutput;

    public RDFResourceBlankNode(@Nonnull IRI resource, boolean isIndividual, boolean forceId) {
        this.resource = OWLAPIPreconditions.checkNotNull(resource, "resource cannot be null");
        this.isIndividual = isIndividual;
        this.forceIdOutput = forceId;
    }

    public RDFResourceBlankNode(int anonId, boolean isIndividual, boolean forceId) {
        this(NodeID.nodeId(anonId), isIndividual, forceId);
    }

    public RDFResourceBlankNode(boolean isIndividual, boolean forceId) {
        this(NodeID.nextFreshNodeId(), isIndividual, forceId);
    }

    @Override
    public boolean isIndividual() {
        return this.isIndividual;
    }

    @Override
    public boolean shouldOutputId() {
        return this.forceIdOutput;
    }

    @Override
    public boolean isLiteral() {
        return false;
    }

    @Override
    public boolean isAnonymous() {
        return true;
    }

    public int hashCode() {
        return this.resource.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof RDFResourceBlankNode)) {
            return false;
        }
        RDFResourceBlankNode other = (RDFResourceBlankNode)obj;
        return this.resource.equals(other.resource);
    }

    @Nonnull
    public String toString() {
        return this.resource.toString();
    }

    @Override
    public IRI getIRI() {
        return this.resource;
    }

    @Override
    public IRI getResource() {
        return this.resource;
    }
}

