/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.owl.ui.library;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.IOException;
import javax.swing.JOptionPane;
import org.protege.editor.owl.model.library.OntologyCatalogManager;
import org.protege.editor.owl.ui.action.ProtegeOWLAction;
import org.protege.editor.owl.ui.library.OntologyLibraryPanel;
import org.protege.xmlcatalog.XMLCatalog;
import org.slf4j.LoggerFactory;

public class EditActiveOntologyLibraryAction
extends ProtegeOWLAction {
    public void actionPerformed(ActionEvent e) {
        try {
            OntologyCatalogManager catalogManager = this.getOWLModelManager().getOntologyCatalogManager();
            XMLCatalog activeCatalog = catalogManager.getActiveCatalog();
            if (activeCatalog == null) {
                this.showCatalogNotPresentMessage();
                return;
            }
            File catalogFile = OntologyCatalogManager.getCatalogFile(activeCatalog);
            if (!catalogFile.exists()) {
                this.showCatalogNotPresentMessage();
                return;
            }
            OntologyLibraryPanel.showDialog(this.getOWLEditorKit(), catalogFile);
        }
        catch (IOException ex) {
            LoggerFactory.getLogger(EditActiveOntologyLibraryAction.class).error("An error occurred whilst attempting to edit the active ontology library: {}", (Throwable)ex);
        }
    }

    private void showCatalogNotPresentMessage() {
        JOptionPane.showMessageDialog((Component)this.getWorkspace(), "<html><body><b>The catalog file for the active ontology is not present.</b><br>Please save your ontology first.</body></html>", "Catalog not present", 1);
    }

    public void initialise() throws Exception {
    }

    public void dispose() {
    }
}

