/*
 * Decompiled with CFR 0.152.
 */
package javax.media.j3d;

import javax.media.j3d.PointSoundRetained;
import javax.media.j3d.SoundRetained;
import javax.media.j3d.Transform3D;
import javax.media.j3d.TransformGroupRetained;
import javax.vecmath.Point2f;
import javax.vecmath.Point3f;
import javax.vecmath.Tuple3f;
import javax.vecmath.Vector3f;

class ConeSoundRetained
extends PointSoundRetained {
    Vector3f direction = new Vector3f(0.0f, 0.0f, 1.0f);
    Vector3f xformDirection = new Vector3f(0.0f, 0.0f, 1.0f);
    static final int NO_FILTERING = -1;
    static final int LOW_PASS = 1;
    float[] backAttenuationDistance = null;
    float[] backAttenuationGain = null;
    float[] angularDistance = new float[]{0.0f, 1.5707964f};
    float[] angularGain = new float[]{1.0f, 0.0f};
    int filterType = -1;
    float[] frequencyCutoff = new float[]{-1.0f, -1.0f};

    ConeSoundRetained() {
        this.nodeType = 14;
    }

    void setDistanceGain(Point2f[] point2fArray, Point2f[] point2fArray2) {
        this.setDistanceGain(point2fArray);
        this.setBackDistanceGain(point2fArray2);
    }

    void setDistanceGain(float[] fArray, float[] fArray2, float[] fArray3, float[] fArray4) {
        this.setDistanceGain(fArray, fArray2);
        this.setBackDistanceGain(fArray3, fArray4);
    }

    void setBackDistanceGain(Point2f[] point2fArray) {
        if (point2fArray == null) {
            this.backAttenuationDistance = null;
            this.backAttenuationGain = null;
        } else {
            int n = point2fArray.length;
            if (n == 0) {
                this.backAttenuationDistance = null;
                this.backAttenuationGain = null;
            } else {
                this.backAttenuationDistance = new float[n];
                this.backAttenuationGain = new float[n];
                for (int i = 0; i < n; ++i) {
                    this.backAttenuationDistance[i] = point2fArray[i].x;
                    this.backAttenuationGain[i] = point2fArray[i].y;
                }
            }
        }
        this.dispatchAttribChange(256, point2fArray);
        if (this.source != null && this.source.isLive()) {
            this.notifySceneGraphChanged(false);
        }
    }

    void setBackDistanceGain(float[] fArray, float[] fArray2) {
        int n;
        int n2 = 0;
        if (fArray == null || fArray2 == null) {
            this.backAttenuationDistance = null;
            this.backAttenuationGain = null;
        } else {
            int n3 = fArray2.length;
            n2 = fArray.length;
            if (n2 == 0 || n3 == 0) {
                this.backAttenuationDistance = null;
                this.backAttenuationGain = null;
            } else {
                this.backAttenuationDistance = new float[n2];
                this.backAttenuationGain = new float[n2];
                System.arraycopy(fArray, 0, this.backAttenuationDistance, 0, n2);
                if (n2 <= n3) {
                    System.arraycopy(fArray2, 0, this.backAttenuationGain, 0, n2);
                } else {
                    System.arraycopy(fArray2, 0, this.backAttenuationGain, 0, n3);
                    for (n = n3; n < n2; ++n) {
                        this.backAttenuationGain[n] = fArray2[n3 - 1];
                    }
                }
            }
        }
        Point2f[] point2fArray = new Point2f[n2];
        for (n = 0; n < n2; ++n) {
            point2fArray[n] = new Point2f(this.backAttenuationDistance[n], this.backAttenuationGain[n]);
        }
        this.dispatchAttribChange(256, point2fArray);
        if (this.source != null && this.source.isLive()) {
            this.notifySceneGraphChanged(false);
        }
    }

    void getDistanceGain(Point2f[] point2fArray, Point2f[] point2fArray2) {
        this.getDistanceGain(point2fArray);
        this.getBackDistanceGain(point2fArray2);
    }

    void getDistanceGain(float[] fArray, float[] fArray2, float[] fArray3, float[] fArray4) {
        this.getDistanceGain(fArray, fArray2);
        this.getBackDistanceGain(fArray3, fArray4);
    }

    void getBackDistanceGain(Point2f[] point2fArray) {
        if (point2fArray == null) {
            return;
        }
        if (this.backAttenuationDistance == null || this.backAttenuationGain == null) {
            return;
        }
        int n = this.backAttenuationDistance.length;
        int n2 = point2fArray.length;
        if (n < n2) {
            n = n2;
        }
        for (int i = 0; i < n; ++i) {
            point2fArray[i].x = this.backAttenuationDistance[i];
            point2fArray[i].y = this.backAttenuationGain[i];
        }
    }

    void getBackDistanceGain(float[] fArray, float[] fArray2) {
        if (fArray == null || fArray2 == null) {
            return;
        }
        if (this.backAttenuationDistance == null || this.backAttenuationGain == null) {
            return;
        }
        int n = this.backAttenuationDistance.length;
        int n2 = fArray.length;
        if (n > n2) {
            n = n2;
        }
        System.arraycopy(this.backAttenuationDistance, 0, fArray, 0, n);
        n = this.backAttenuationGain.length;
        int n3 = fArray2.length;
        if (n > n3) {
            n = n3;
        }
        System.arraycopy(this.backAttenuationGain, 0, fArray2, 0, n);
    }

    void setDirection(Vector3f vector3f) {
        if (this.staticTransform != null) {
            this.staticTransform.transform.transform(vector3f, this.direction);
        } else {
            this.direction.set((Tuple3f)vector3f);
        }
        this.dispatchAttribChange(512, new Vector3f(this.direction));
        if (this.source != null && this.source.isLive()) {
            this.notifySceneGraphChanged(false);
        }
    }

    void setDirection(float f, float f2, float f3) {
        this.direction.x = f;
        this.direction.y = f2;
        this.direction.z = f3;
        if (this.staticTransform != null) {
            this.staticTransform.transform.transform(this.direction);
        }
        this.dispatchAttribChange(512, new Vector3f(this.direction));
        if (this.source != null && this.source.isLive()) {
            this.notifySceneGraphChanged(false);
        }
    }

    void getDirection(Vector3f vector3f) {
        if (this.staticTransform != null) {
            Transform3D transform3D = this.staticTransform.getInvTransform();
            transform3D.transform(this.direction, vector3f);
        } else {
            vector3f.set((Tuple3f)this.direction);
        }
    }

    void getXformDirection(Vector3f vector3f) {
        vector3f.set((Tuple3f)this.xformDirection);
    }

    void setAngularAttenuation(Point2f[] point2fArray) {
        int n = 0;
        this.filterType = -1;
        if (point2fArray == null) {
            this.angularDistance = null;
            this.angularGain = null;
        } else {
            n = point2fArray.length;
            if (n == 0) {
                this.angularDistance = null;
                this.angularGain = null;
            } else {
                this.angularDistance = new float[n];
                this.angularGain = new float[n];
                for (int i = 0; i < n; ++i) {
                    this.angularDistance[i] = point2fArray[i].x;
                    this.angularGain[i] = point2fArray[i].y;
                }
            }
        }
        Point3f[] point3fArray = new Point3f[n];
        for (int i = 0; i < n; ++i) {
            point3fArray[i] = new Point3f(this.angularDistance[i], this.angularGain[i], -1.0f);
        }
        this.dispatchAttribChange(1024, point3fArray);
        if (this.source != null && this.source.isLive()) {
            this.notifySceneGraphChanged(false);
        }
    }

    void setAngularAttenuation(Point3f[] point3fArray) {
        if (point3fArray == null) {
            this.angularDistance = null;
            this.angularGain = null;
            this.frequencyCutoff = null;
            this.filterType = -1;
        } else {
            int n = point3fArray.length;
            if (n == 0) {
                this.angularDistance = null;
                this.angularGain = null;
                this.frequencyCutoff = null;
                this.filterType = -1;
            } else {
                this.angularDistance = new float[n];
                this.angularGain = new float[n];
                this.frequencyCutoff = new float[n];
                this.filterType = 1;
                for (int i = 0; i < n; ++i) {
                    this.angularDistance[i] = point3fArray[i].x;
                    this.angularGain[i] = point3fArray[i].y;
                    this.frequencyCutoff[i] = point3fArray[i].z;
                }
            }
        }
        this.dispatchAttribChange(1024, point3fArray);
        if (this.source != null && this.source.isLive()) {
            this.notifySceneGraphChanged(false);
        }
    }

    void setAngularAttenuation(float[] fArray, float[] fArray2, float[] fArray3) {
        int n;
        int n2 = 0;
        if (fArray == null || fArray2 == null || fArray3 == null) {
            this.angularDistance = null;
            this.angularGain = null;
            this.frequencyCutoff = null;
            this.filterType = -1;
        } else {
            n2 = fArray.length;
            int n3 = fArray2.length;
            if (n2 == 0 || n3 == 0) {
                this.angularDistance = null;
                this.angularGain = null;
                this.frequencyCutoff = null;
                this.filterType = -1;
            } else {
                int n4;
                n = fArray3.length;
                this.angularDistance = new float[n2];
                this.angularGain = new float[n2];
                this.frequencyCutoff = new float[n2];
                System.arraycopy(fArray, 0, this.angularDistance, 0, n2);
                if (n2 <= n3) {
                    System.arraycopy(fArray2, 0, this.angularGain, 0, n2);
                } else {
                    System.arraycopy(fArray2, 0, this.angularGain, 0, n3);
                    for (n4 = n3; n4 < n2; ++n4) {
                        this.angularGain[n4] = fArray2[n3 - 1];
                    }
                }
                if (n == 0) {
                    this.filterType = -1;
                } else {
                    this.filterType = 1;
                    if (n2 <= n) {
                        System.arraycopy(fArray3, 0, this.frequencyCutoff, 0, n2);
                    } else {
                        System.arraycopy(fArray3, 0, this.frequencyCutoff, 0, n);
                        for (n4 = n; n4 < n2; ++n4) {
                            this.frequencyCutoff[n4] = fArray3[n - 1];
                        }
                    }
                }
            }
        }
        Point3f[] point3fArray = new Point3f[n2];
        for (n = 0; n < n2; ++n) {
            point3fArray[n] = this.filterType != -1 ? new Point3f(this.angularDistance[n], this.angularGain[n], this.frequencyCutoff[n]) : new Point3f(this.angularDistance[n], this.angularGain[n], -1.0f);
        }
        this.dispatchAttribChange(1024, point3fArray);
        if (this.source != null && this.source.isLive()) {
            this.notifySceneGraphChanged(false);
        }
    }

    int getAngularAttenuationLength() {
        if (this.angularDistance == null) {
            return 0;
        }
        return this.angularDistance.length;
    }

    void getAngularAttenuation(Point3f[] point3fArray) {
        if (this.angularDistance == null || this.angularGain == null) {
            return;
        }
        if (point3fArray == null) {
            return;
        }
        int n = this.angularDistance.length;
        if (point3fArray.length < n) {
            n = point3fArray.length;
        }
        for (int i = 0; i < n; ++i) {
            point3fArray[i].x = this.angularDistance[i];
            point3fArray[i].y = this.angularGain[i];
            if (this.filterType == -1 || this.frequencyCutoff == null) {
                point3fArray[i].z = -1.0f;
                continue;
            }
            if (this.filterType != 1) continue;
            point3fArray[i].z = this.frequencyCutoff[i];
        }
    }

    void getAngularAttenuation(float[] fArray, float[] fArray2, float[] fArray3) {
        if (fArray == null || fArray2 == null || fArray3 == null) {
            return;
        }
        if (this.angularDistance == null || this.angularGain == null) {
            return;
        }
        int n = this.angularDistance.length;
        if (fArray.length < n) {
            n = fArray.length;
        }
        System.arraycopy(this.angularDistance, 0, fArray, 0, n);
        int n2 = this.angularGain.length;
        if (fArray2.length < n2) {
            n2 = fArray2.length;
        }
        System.arraycopy(this.angularGain, 0, fArray2, 0, n2);
        int n3 = 0;
        if (this.frequencyCutoff == null || this.filterType == -1) {
            n3 = fArray3.length;
        } else {
            n3 = this.frequencyCutoff.length;
            if (fArray3.length < n3) {
                n3 = fArray3.length;
            }
        }
        if (this.filterType == -1 || this.frequencyCutoff == null) {
            for (int i = 0; i < n3; ++i) {
                fArray3[i] = -1.0f;
            }
        }
        if (this.filterType == 1) {
            System.arraycopy(this.frequencyCutoff, 0, fArray3, 0, n3);
        }
    }

    void updateMirrorObject(Object[] objectArray) {
        int n = (Integer)objectArray[1];
        int n2 = (Integer)objectArray[2];
        SoundRetained[] soundRetainedArray = (SoundRetained[])objectArray[3];
        if (n == -1) {
            this.initMirrorObject((ConeSoundRetained)objectArray[2]);
            return;
        }
        if ((n & 0x200) != 0) {
            for (int i = 0; i < n2; ++i) {
                ConeSoundRetained coneSoundRetained = (ConeSoundRetained)soundRetainedArray[i];
                coneSoundRetained.direction = (Vector3f)objectArray[4];
                coneSoundRetained.getLastLocalToVworld().transform(coneSoundRetained.direction, coneSoundRetained.xformDirection);
                coneSoundRetained.xformDirection.normalize();
            }
        }
        super.updateMirrorObject(objectArray);
    }

    synchronized void initMirrorObject(ConeSoundRetained coneSoundRetained) {
        super.initMirrorObject(coneSoundRetained);
        coneSoundRetained.direction.set((Tuple3f)this.direction);
        coneSoundRetained.xformDirection.set((Tuple3f)this.xformDirection);
    }

    void updateTransformChange() {
        Transform3D transform3D = this.getLastLocalToVworld();
        super.updateTransformChange();
        transform3D.transform(this.direction, this.xformDirection);
        this.xformDirection.normalize();
    }

    void mergeTransform(TransformGroupRetained transformGroupRetained) {
        super.mergeTransform(transformGroupRetained);
        transformGroupRetained.transform.transform(this.direction);
    }
}

