// **********************************************************************
//
// Copyright (c) 2003-2017 ZeroC, Inc. All rights reserved.
//
// This copy of Ice is licensed to you under the terms described in the
// ICE_LICENSE file included in this distribution.
//
// **********************************************************************
//
// Ice version 3.7.0
//
// <auto-generated>
//
// Generated from file `IceBox.ice'
//
// Warning: do not edit this file.
//
// </auto-generated>
//

#ifndef __IceBox_IceBox_h__
#define __IceBox_IceBox_h__

#include <IceUtil/PushDisableWarnings.h>
#include <Ice/ProxyF.h>
#include <Ice/ObjectF.h>
#include <Ice/ValueF.h>
#include <Ice/Exception.h>
#include <Ice/LocalObject.h>
#include <Ice/StreamHelpers.h>
#include <Ice/Comparable.h>
#include <Ice/Proxy.h>
#include <Ice/Object.h>
#include <Ice/GCObject.h>
#include <Ice/Value.h>
#include <Ice/Incoming.h>
#include <Ice/FactoryTableInit.h>
#include <IceUtil/ScopedArray.h>
#include <Ice/Optional.h>
#include <Ice/ExceptionHelpers.h>
#include <Ice/BuiltinSequences.h>
#include <Ice/CommunicatorF.h>
#include <Ice/PropertiesF.h>
#include <Ice/SliceChecksumDict.h>
#include <IceUtil/UndefSysMacros.h>
#include <IceBox/Config.h>

#ifndef ICE_IGNORE_VERSION
#   if ICE_INT_VERSION / 100 != 307
#       error Ice version mismatch!
#   endif
#   if ICE_INT_VERSION % 100 > 50
#       error Beta header file detected
#   endif
#   if ICE_INT_VERSION % 100 < 0
#       error Ice patch level mismatch!
#   endif
#endif

#ifndef ICEBOX_API
#   if defined(ICE_STATIC_LIBS)
#       define ICEBOX_API /**/
#   elif defined(ICEBOX_API_EXPORTS)
#       define ICEBOX_API ICE_DECLSPEC_EXPORT
#   else
#       define ICEBOX_API ICE_DECLSPEC_IMPORT
#   endif
#endif

#ifdef ICE_CPP11_MAPPING // C++11 mapping

namespace IceBox
{

class Service;
class ServiceObserver;
class ServiceObserverPrx;
class ServiceManager;
class ServiceManagerPrx;

}

namespace IceBox
{

class ICE_CLASS(ICEBOX_API) FailureException : public ::Ice::LocalExceptionHelper<FailureException, ::Ice::LocalException>
{
public:

    ICE_MEMBER(ICEBOX_API) virtual ~FailureException();

    FailureException(const FailureException&) = default;

    FailureException(const char* file_, int line_) : ::Ice::LocalExceptionHelper<FailureException, ::Ice::LocalException>(file_, line_)
    {
    }

    FailureException(const char* file_, int line_, const ::std::string& iceP_reason) : ::Ice::LocalExceptionHelper<FailureException, ::Ice::LocalException>(file_, line_),
        reason(::std::move(iceP_reason))
    {
    }

    std::tuple<const ::std::string&> ice_tuple() const
    {
        return std::tie(reason);
    }

    ICE_MEMBER(ICEBOX_API) static const ::std::string& ice_staticId();
    ICE_MEMBER(ICEBOX_API) virtual void ice_print(::std::ostream&) const override;

    ::std::string reason;
};

class ICE_CLASS(ICEBOX_API) AlreadyStartedException : public ::Ice::UserExceptionHelper<AlreadyStartedException, ::Ice::UserException>
{
public:

    ICE_MEMBER(ICEBOX_API) virtual ~AlreadyStartedException();

    AlreadyStartedException(const AlreadyStartedException&) = default;

    AlreadyStartedException() = default;

    std::tuple<> ice_tuple() const
    {
        return std::tie();
    }

    ICE_MEMBER(ICEBOX_API) static const ::std::string& ice_staticId();
};

static AlreadyStartedException _iceS_AlreadyStartedException_init;

class ICE_CLASS(ICEBOX_API) AlreadyStoppedException : public ::Ice::UserExceptionHelper<AlreadyStoppedException, ::Ice::UserException>
{
public:

    ICE_MEMBER(ICEBOX_API) virtual ~AlreadyStoppedException();

    AlreadyStoppedException(const AlreadyStoppedException&) = default;

    AlreadyStoppedException() = default;

    std::tuple<> ice_tuple() const
    {
        return std::tie();
    }

    ICE_MEMBER(ICEBOX_API) static const ::std::string& ice_staticId();
};

class ICE_CLASS(ICEBOX_API) NoSuchServiceException : public ::Ice::UserExceptionHelper<NoSuchServiceException, ::Ice::UserException>
{
public:

    ICE_MEMBER(ICEBOX_API) virtual ~NoSuchServiceException();

    NoSuchServiceException(const NoSuchServiceException&) = default;

    NoSuchServiceException() = default;

    std::tuple<> ice_tuple() const
    {
        return std::tie();
    }

    ICE_MEMBER(ICEBOX_API) static const ::std::string& ice_staticId();
};

}

namespace IceBox
{

class ICE_CLASS(ICEBOX_API) Service
{
public:

    ICE_MEMBER(ICEBOX_API) virtual ~Service();

    virtual void start(const ::std::string&, const ::std::shared_ptr<::Ice::Communicator>&, const ::Ice::StringSeq&) = 0;

    virtual void stop() = 0;
};

}

namespace IceBox
{

class ICEBOX_API ServiceObserver : public virtual ::Ice::Object
{
public:

    using ProxyType = ServiceObserverPrx;

    virtual bool ice_isA(::std::string, const ::Ice::Current&) const override;
    virtual ::std::vector<::std::string> ice_ids(const ::Ice::Current&) const override;
    virtual ::std::string ice_id(const ::Ice::Current&) const override;

    static const ::std::string& ice_staticId();

    virtual void servicesStarted(::Ice::StringSeq, const ::Ice::Current&) = 0;
    bool _iceD_servicesStarted(::IceInternal::Incoming&, const ::Ice::Current&);

    virtual void servicesStopped(::Ice::StringSeq, const ::Ice::Current&) = 0;
    bool _iceD_servicesStopped(::IceInternal::Incoming&, const ::Ice::Current&);

    virtual bool _iceDispatch(::IceInternal::Incoming&, const ::Ice::Current&) override;
};

class ICEBOX_API ServiceManager : public virtual ::Ice::Object
{
public:

    using ProxyType = ServiceManagerPrx;

    virtual bool ice_isA(::std::string, const ::Ice::Current&) const override;
    virtual ::std::vector<::std::string> ice_ids(const ::Ice::Current&) const override;
    virtual ::std::string ice_id(const ::Ice::Current&) const override;

    static const ::std::string& ice_staticId();

    virtual ::Ice::SliceChecksumDict getSliceChecksums(const ::Ice::Current&) const = 0;
    bool _iceD_getSliceChecksums(::IceInternal::Incoming&, const ::Ice::Current&) const;

    virtual void startService(::std::string, const ::Ice::Current&) = 0;
    bool _iceD_startService(::IceInternal::Incoming&, const ::Ice::Current&);

    virtual void stopService(::std::string, const ::Ice::Current&) = 0;
    bool _iceD_stopService(::IceInternal::Incoming&, const ::Ice::Current&);

    virtual void addObserver(::std::shared_ptr<::IceBox::ServiceObserverPrx>, const ::Ice::Current&) = 0;
    bool _iceD_addObserver(::IceInternal::Incoming&, const ::Ice::Current&);

    virtual void shutdown(const ::Ice::Current&) = 0;
    bool _iceD_shutdown(::IceInternal::Incoming&, const ::Ice::Current&);

    virtual bool _iceDispatch(::IceInternal::Incoming&, const ::Ice::Current&) override;
};

}

namespace IceBox
{

class ICE_CLASS(ICEBOX_API) ServiceObserverPrx : public virtual ::Ice::Proxy<ServiceObserverPrx, ::Ice::ObjectPrx>
{
public:

    void servicesStarted(const ::Ice::StringSeq& iceP_services, const ::Ice::Context& context = Ice::noExplicitContext)
    {
        _makePromiseOutgoing<void>(true, this, &IceBox::ServiceObserverPrx::_iceI_servicesStarted, iceP_services, context).get();
    }

    template<template<typename> class P = ::std::promise>
    auto servicesStartedAsync(const ::Ice::StringSeq& iceP_services, const ::Ice::Context& context = Ice::noExplicitContext)
        -> decltype(::std::declval<P<void>>().get_future())
    {
        return _makePromiseOutgoing<void, P>(false, this, &IceBox::ServiceObserverPrx::_iceI_servicesStarted, iceP_services, context);
    }

    ::std::function<void()>
    servicesStartedAsync(const ::Ice::StringSeq& iceP_services,
                         ::std::function<void()> response,
                         ::std::function<void(::std::exception_ptr)> ex = nullptr,
                         ::std::function<void(bool)> sent = nullptr,
                         const ::Ice::Context& context = Ice::noExplicitContext)
    {
        return _makeLamdaOutgoing<void>(response, ex, sent, this, &IceBox::ServiceObserverPrx::_iceI_servicesStarted, iceP_services, context);
    }

    ICE_MEMBER(ICEBOX_API) void _iceI_servicesStarted(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<void>>&, const ::Ice::StringSeq&, const ::Ice::Context&);

    void servicesStopped(const ::Ice::StringSeq& iceP_services, const ::Ice::Context& context = Ice::noExplicitContext)
    {
        _makePromiseOutgoing<void>(true, this, &IceBox::ServiceObserverPrx::_iceI_servicesStopped, iceP_services, context).get();
    }

    template<template<typename> class P = ::std::promise>
    auto servicesStoppedAsync(const ::Ice::StringSeq& iceP_services, const ::Ice::Context& context = Ice::noExplicitContext)
        -> decltype(::std::declval<P<void>>().get_future())
    {
        return _makePromiseOutgoing<void, P>(false, this, &IceBox::ServiceObserverPrx::_iceI_servicesStopped, iceP_services, context);
    }

    ::std::function<void()>
    servicesStoppedAsync(const ::Ice::StringSeq& iceP_services,
                         ::std::function<void()> response,
                         ::std::function<void(::std::exception_ptr)> ex = nullptr,
                         ::std::function<void(bool)> sent = nullptr,
                         const ::Ice::Context& context = Ice::noExplicitContext)
    {
        return _makeLamdaOutgoing<void>(response, ex, sent, this, &IceBox::ServiceObserverPrx::_iceI_servicesStopped, iceP_services, context);
    }

    ICE_MEMBER(ICEBOX_API) void _iceI_servicesStopped(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<void>>&, const ::Ice::StringSeq&, const ::Ice::Context&);

    ICE_MEMBER(ICEBOX_API) static const ::std::string& ice_staticId();

protected:

    ServiceObserverPrx() = default;
    friend ::std::shared_ptr<ServiceObserverPrx> IceInternal::createProxy<ServiceObserverPrx>();

    ICE_MEMBER(ICEBOX_API) virtual ::std::shared_ptr<::Ice::ObjectPrx> _newInstance() const override;
};

class ICE_CLASS(ICEBOX_API) ServiceManagerPrx : public virtual ::Ice::Proxy<ServiceManagerPrx, ::Ice::ObjectPrx>
{
public:

    ::Ice::SliceChecksumDict getSliceChecksums(const ::Ice::Context& context = Ice::noExplicitContext)
    {
        return _makePromiseOutgoing<::Ice::SliceChecksumDict>(true, this, &IceBox::ServiceManagerPrx::_iceI_getSliceChecksums, context).get();
    }

    template<template<typename> class P = ::std::promise>
    auto getSliceChecksumsAsync(const ::Ice::Context& context = Ice::noExplicitContext)
        -> decltype(::std::declval<P<::Ice::SliceChecksumDict>>().get_future())
    {
        return _makePromiseOutgoing<::Ice::SliceChecksumDict, P>(false, this, &IceBox::ServiceManagerPrx::_iceI_getSliceChecksums, context);
    }

    ::std::function<void()>
    getSliceChecksumsAsync(::std::function<void(::Ice::SliceChecksumDict)> response,
                           ::std::function<void(::std::exception_ptr)> ex = nullptr,
                           ::std::function<void(bool)> sent = nullptr,
                           const ::Ice::Context& context = Ice::noExplicitContext)
    {
        return _makeLamdaOutgoing<::Ice::SliceChecksumDict>(response, ex, sent, this, &IceBox::ServiceManagerPrx::_iceI_getSliceChecksums, context);
    }

    ICE_MEMBER(ICEBOX_API) void _iceI_getSliceChecksums(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<::Ice::SliceChecksumDict>>&, const ::Ice::Context&);

    void startService(const ::std::string& iceP_service, const ::Ice::Context& context = Ice::noExplicitContext)
    {
        _makePromiseOutgoing<void>(true, this, &IceBox::ServiceManagerPrx::_iceI_startService, iceP_service, context).get();
    }

    template<template<typename> class P = ::std::promise>
    auto startServiceAsync(const ::std::string& iceP_service, const ::Ice::Context& context = Ice::noExplicitContext)
        -> decltype(::std::declval<P<void>>().get_future())
    {
        return _makePromiseOutgoing<void, P>(false, this, &IceBox::ServiceManagerPrx::_iceI_startService, iceP_service, context);
    }

    ::std::function<void()>
    startServiceAsync(const ::std::string& iceP_service,
                      ::std::function<void()> response,
                      ::std::function<void(::std::exception_ptr)> ex = nullptr,
                      ::std::function<void(bool)> sent = nullptr,
                      const ::Ice::Context& context = Ice::noExplicitContext)
    {
        return _makeLamdaOutgoing<void>(response, ex, sent, this, &IceBox::ServiceManagerPrx::_iceI_startService, iceP_service, context);
    }

    ICE_MEMBER(ICEBOX_API) void _iceI_startService(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<void>>&, const ::std::string&, const ::Ice::Context&);

    void stopService(const ::std::string& iceP_service, const ::Ice::Context& context = Ice::noExplicitContext)
    {
        _makePromiseOutgoing<void>(true, this, &IceBox::ServiceManagerPrx::_iceI_stopService, iceP_service, context).get();
    }

    template<template<typename> class P = ::std::promise>
    auto stopServiceAsync(const ::std::string& iceP_service, const ::Ice::Context& context = Ice::noExplicitContext)
        -> decltype(::std::declval<P<void>>().get_future())
    {
        return _makePromiseOutgoing<void, P>(false, this, &IceBox::ServiceManagerPrx::_iceI_stopService, iceP_service, context);
    }

    ::std::function<void()>
    stopServiceAsync(const ::std::string& iceP_service,
                     ::std::function<void()> response,
                     ::std::function<void(::std::exception_ptr)> ex = nullptr,
                     ::std::function<void(bool)> sent = nullptr,
                     const ::Ice::Context& context = Ice::noExplicitContext)
    {
        return _makeLamdaOutgoing<void>(response, ex, sent, this, &IceBox::ServiceManagerPrx::_iceI_stopService, iceP_service, context);
    }

    ICE_MEMBER(ICEBOX_API) void _iceI_stopService(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<void>>&, const ::std::string&, const ::Ice::Context&);

    void addObserver(const ::std::shared_ptr<::IceBox::ServiceObserverPrx>& iceP_observer, const ::Ice::Context& context = Ice::noExplicitContext)
    {
        _makePromiseOutgoing<void>(true, this, &IceBox::ServiceManagerPrx::_iceI_addObserver, iceP_observer, context).get();
    }

    template<template<typename> class P = ::std::promise>
    auto addObserverAsync(const ::std::shared_ptr<::IceBox::ServiceObserverPrx>& iceP_observer, const ::Ice::Context& context = Ice::noExplicitContext)
        -> decltype(::std::declval<P<void>>().get_future())
    {
        return _makePromiseOutgoing<void, P>(false, this, &IceBox::ServiceManagerPrx::_iceI_addObserver, iceP_observer, context);
    }

    ::std::function<void()>
    addObserverAsync(const ::std::shared_ptr<::IceBox::ServiceObserverPrx>& iceP_observer,
                     ::std::function<void()> response,
                     ::std::function<void(::std::exception_ptr)> ex = nullptr,
                     ::std::function<void(bool)> sent = nullptr,
                     const ::Ice::Context& context = Ice::noExplicitContext)
    {
        return _makeLamdaOutgoing<void>(response, ex, sent, this, &IceBox::ServiceManagerPrx::_iceI_addObserver, iceP_observer, context);
    }

    ICE_MEMBER(ICEBOX_API) void _iceI_addObserver(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<void>>&, const ::std::shared_ptr<::IceBox::ServiceObserverPrx>&, const ::Ice::Context&);

    void shutdown(const ::Ice::Context& context = Ice::noExplicitContext)
    {
        _makePromiseOutgoing<void>(true, this, &IceBox::ServiceManagerPrx::_iceI_shutdown, context).get();
    }

    template<template<typename> class P = ::std::promise>
    auto shutdownAsync(const ::Ice::Context& context = Ice::noExplicitContext)
        -> decltype(::std::declval<P<void>>().get_future())
    {
        return _makePromiseOutgoing<void, P>(false, this, &IceBox::ServiceManagerPrx::_iceI_shutdown, context);
    }

    ::std::function<void()>
    shutdownAsync(::std::function<void()> response,
                  ::std::function<void(::std::exception_ptr)> ex = nullptr,
                  ::std::function<void(bool)> sent = nullptr,
                  const ::Ice::Context& context = Ice::noExplicitContext)
    {
        return _makeLamdaOutgoing<void>(response, ex, sent, this, &IceBox::ServiceManagerPrx::_iceI_shutdown, context);
    }

    ICE_MEMBER(ICEBOX_API) void _iceI_shutdown(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<void>>&, const ::Ice::Context&);

    ICE_MEMBER(ICEBOX_API) static const ::std::string& ice_staticId();

protected:

    ServiceManagerPrx() = default;
    friend ::std::shared_ptr<ServiceManagerPrx> IceInternal::createProxy<ServiceManagerPrx>();

    ICE_MEMBER(ICEBOX_API) virtual ::std::shared_ptr<::Ice::ObjectPrx> _newInstance() const override;
};

}

namespace Ice
{

}

namespace IceBox
{

using ServicePtr = ::std::shared_ptr<Service>;

using ServiceObserverPtr = ::std::shared_ptr<ServiceObserver>;
using ServiceObserverPrxPtr = ::std::shared_ptr<ServiceObserverPrx>;

using ServiceManagerPtr = ::std::shared_ptr<ServiceManager>;
using ServiceManagerPrxPtr = ::std::shared_ptr<ServiceManagerPrx>;

}

#else // C++98 mapping

namespace IceProxy
{

namespace IceBox
{

class ServiceObserver;
ICEBOX_API void _readProxy(::Ice::InputStream*, ::IceInternal::ProxyHandle< ::IceProxy::IceBox::ServiceObserver>&);
ICEBOX_API ::IceProxy::Ice::Object* upCast(::IceProxy::IceBox::ServiceObserver*);

class ServiceManager;
ICEBOX_API void _readProxy(::Ice::InputStream*, ::IceInternal::ProxyHandle< ::IceProxy::IceBox::ServiceManager>&);
ICEBOX_API ::IceProxy::Ice::Object* upCast(::IceProxy::IceBox::ServiceManager*);

}

}

namespace IceBox
{

class Service;
ICEBOX_API ::Ice::LocalObject* upCast(::IceBox::Service*);
typedef ::IceInternal::Handle< ::IceBox::Service> ServicePtr;

class ServiceObserver;
ICEBOX_API ::Ice::Object* upCast(::IceBox::ServiceObserver*);
typedef ::IceInternal::Handle< ::IceBox::ServiceObserver> ServiceObserverPtr;
typedef ::IceInternal::ProxyHandle< ::IceProxy::IceBox::ServiceObserver> ServiceObserverPrx;
typedef ServiceObserverPrx ServiceObserverPrxPtr;
ICEBOX_API void _icePatchObjectPtr(ServiceObserverPtr&, const ::Ice::ObjectPtr&);

class ServiceManager;
ICEBOX_API ::Ice::Object* upCast(::IceBox::ServiceManager*);
typedef ::IceInternal::Handle< ::IceBox::ServiceManager> ServiceManagerPtr;
typedef ::IceInternal::ProxyHandle< ::IceProxy::IceBox::ServiceManager> ServiceManagerPrx;
typedef ServiceManagerPrx ServiceManagerPrxPtr;
ICEBOX_API void _icePatchObjectPtr(ServiceManagerPtr&, const ::Ice::ObjectPtr&);

}

namespace IceBox
{

class ICEBOX_API FailureException : public ::Ice::LocalException
{
public:

    FailureException(const char*, int);
    FailureException(const char*, int, const ::std::string&);
    virtual ~FailureException() throw();

    virtual ::std::string ice_id() const;
    virtual void ice_print(::std::ostream&) const;
    virtual FailureException* ice_clone() const;
    virtual void ice_throw() const;

    ::std::string reason;
};

class ICEBOX_API AlreadyStartedException : public ::Ice::UserException
{
public:

    AlreadyStartedException() {}
    virtual ~AlreadyStartedException() throw();

    virtual ::std::string ice_id() const;
    virtual AlreadyStartedException* ice_clone() const;
    virtual void ice_throw() const;

protected:

    virtual void _writeImpl(::Ice::OutputStream*) const;
    virtual void _readImpl(::Ice::InputStream*);
};

static AlreadyStartedException _iceS_AlreadyStartedException_init;

class ICEBOX_API AlreadyStoppedException : public ::Ice::UserException
{
public:

    AlreadyStoppedException() {}
    virtual ~AlreadyStoppedException() throw();

    virtual ::std::string ice_id() const;
    virtual AlreadyStoppedException* ice_clone() const;
    virtual void ice_throw() const;

protected:

    virtual void _writeImpl(::Ice::OutputStream*) const;
    virtual void _readImpl(::Ice::InputStream*);
};

class ICEBOX_API NoSuchServiceException : public ::Ice::UserException
{
public:

    NoSuchServiceException() {}
    virtual ~NoSuchServiceException() throw();

    virtual ::std::string ice_id() const;
    virtual NoSuchServiceException* ice_clone() const;
    virtual void ice_throw() const;

protected:

    virtual void _writeImpl(::Ice::OutputStream*) const;
    virtual void _readImpl(::Ice::InputStream*);
};

}

namespace IceBox
{

class Callback_ServiceObserver_servicesStarted_Base : public virtual ::IceInternal::CallbackBase { };
typedef ::IceUtil::Handle< Callback_ServiceObserver_servicesStarted_Base> Callback_ServiceObserver_servicesStartedPtr;

class Callback_ServiceObserver_servicesStopped_Base : public virtual ::IceInternal::CallbackBase { };
typedef ::IceUtil::Handle< Callback_ServiceObserver_servicesStopped_Base> Callback_ServiceObserver_servicesStoppedPtr;

class Callback_ServiceManager_getSliceChecksums_Base : public virtual ::IceInternal::CallbackBase { };
typedef ::IceUtil::Handle< Callback_ServiceManager_getSliceChecksums_Base> Callback_ServiceManager_getSliceChecksumsPtr;

class Callback_ServiceManager_startService_Base : public virtual ::IceInternal::CallbackBase { };
typedef ::IceUtil::Handle< Callback_ServiceManager_startService_Base> Callback_ServiceManager_startServicePtr;

class Callback_ServiceManager_stopService_Base : public virtual ::IceInternal::CallbackBase { };
typedef ::IceUtil::Handle< Callback_ServiceManager_stopService_Base> Callback_ServiceManager_stopServicePtr;

class Callback_ServiceManager_addObserver_Base : public virtual ::IceInternal::CallbackBase { };
typedef ::IceUtil::Handle< Callback_ServiceManager_addObserver_Base> Callback_ServiceManager_addObserverPtr;

class Callback_ServiceManager_shutdown_Base : public virtual ::IceInternal::CallbackBase { };
typedef ::IceUtil::Handle< Callback_ServiceManager_shutdown_Base> Callback_ServiceManager_shutdownPtr;

}

namespace IceProxy
{

namespace IceBox
{

class ICE_CLASS(ICEBOX_API) ServiceObserver : public virtual ::Ice::Proxy<ServiceObserver, ::IceProxy::Ice::Object>
{
public:

    ICE_MEMBER(ICEBOX_API) void servicesStarted(const ::Ice::StringSeq& iceP_services, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        end_servicesStarted(_iceI_begin_servicesStarted(iceP_services, context, ::IceInternal::dummyCallback, 0, true));
    }

    ::Ice::AsyncResultPtr begin_servicesStarted(const ::Ice::StringSeq& iceP_services, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _iceI_begin_servicesStarted(iceP_services, context, ::IceInternal::dummyCallback, 0);
    }

    ::Ice::AsyncResultPtr begin_servicesStarted(const ::Ice::StringSeq& iceP_services, const ::Ice::CallbackPtr& del, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_servicesStarted(iceP_services, ::Ice::noExplicitContext, del, cookie);
    }

    ::Ice::AsyncResultPtr begin_servicesStarted(const ::Ice::StringSeq& iceP_services, const ::Ice::Context& context, const ::Ice::CallbackPtr& del, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_servicesStarted(iceP_services, context, del, cookie);
    }

    ::Ice::AsyncResultPtr begin_servicesStarted(const ::Ice::StringSeq& iceP_services, const ::IceBox::Callback_ServiceObserver_servicesStartedPtr& del, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_servicesStarted(iceP_services, ::Ice::noExplicitContext, del, cookie);
    }

    ::Ice::AsyncResultPtr begin_servicesStarted(const ::Ice::StringSeq& iceP_services, const ::Ice::Context& context, const ::IceBox::Callback_ServiceObserver_servicesStartedPtr& del, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_servicesStarted(iceP_services, context, del, cookie);
    }

    ICE_MEMBER(ICEBOX_API) void end_servicesStarted(const ::Ice::AsyncResultPtr&);

private:

    ICE_MEMBER(ICEBOX_API) ::Ice::AsyncResultPtr _iceI_begin_servicesStarted(const ::Ice::StringSeq&, const ::Ice::Context&, const ::IceInternal::CallbackBasePtr&, const ::Ice::LocalObjectPtr& cookie = 0, bool sync = false);

public:

    ICE_MEMBER(ICEBOX_API) void servicesStopped(const ::Ice::StringSeq& iceP_services, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        end_servicesStopped(_iceI_begin_servicesStopped(iceP_services, context, ::IceInternal::dummyCallback, 0, true));
    }

    ::Ice::AsyncResultPtr begin_servicesStopped(const ::Ice::StringSeq& iceP_services, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _iceI_begin_servicesStopped(iceP_services, context, ::IceInternal::dummyCallback, 0);
    }

    ::Ice::AsyncResultPtr begin_servicesStopped(const ::Ice::StringSeq& iceP_services, const ::Ice::CallbackPtr& del, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_servicesStopped(iceP_services, ::Ice::noExplicitContext, del, cookie);
    }

    ::Ice::AsyncResultPtr begin_servicesStopped(const ::Ice::StringSeq& iceP_services, const ::Ice::Context& context, const ::Ice::CallbackPtr& del, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_servicesStopped(iceP_services, context, del, cookie);
    }

    ::Ice::AsyncResultPtr begin_servicesStopped(const ::Ice::StringSeq& iceP_services, const ::IceBox::Callback_ServiceObserver_servicesStoppedPtr& del, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_servicesStopped(iceP_services, ::Ice::noExplicitContext, del, cookie);
    }

    ::Ice::AsyncResultPtr begin_servicesStopped(const ::Ice::StringSeq& iceP_services, const ::Ice::Context& context, const ::IceBox::Callback_ServiceObserver_servicesStoppedPtr& del, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_servicesStopped(iceP_services, context, del, cookie);
    }

    ICE_MEMBER(ICEBOX_API) void end_servicesStopped(const ::Ice::AsyncResultPtr&);

private:

    ICE_MEMBER(ICEBOX_API) ::Ice::AsyncResultPtr _iceI_begin_servicesStopped(const ::Ice::StringSeq&, const ::Ice::Context&, const ::IceInternal::CallbackBasePtr&, const ::Ice::LocalObjectPtr& cookie = 0, bool sync = false);

public:

    ICE_MEMBER(ICEBOX_API) static const ::std::string& ice_staticId();

protected:

    ICE_MEMBER(ICEBOX_API) virtual ::IceProxy::Ice::Object* _newInstance() const;
};

class ICE_CLASS(ICEBOX_API) ServiceManager : public virtual ::Ice::Proxy<ServiceManager, ::IceProxy::Ice::Object>
{
public:

    ICE_MEMBER(ICEBOX_API) ::Ice::SliceChecksumDict getSliceChecksums(const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return end_getSliceChecksums(_iceI_begin_getSliceChecksums(context, ::IceInternal::dummyCallback, 0, true));
    }

    ::Ice::AsyncResultPtr begin_getSliceChecksums(const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _iceI_begin_getSliceChecksums(context, ::IceInternal::dummyCallback, 0);
    }

    ::Ice::AsyncResultPtr begin_getSliceChecksums(const ::Ice::CallbackPtr& del, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_getSliceChecksums(::Ice::noExplicitContext, del, cookie);
    }

    ::Ice::AsyncResultPtr begin_getSliceChecksums(const ::Ice::Context& context, const ::Ice::CallbackPtr& del, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_getSliceChecksums(context, del, cookie);
    }

    ::Ice::AsyncResultPtr begin_getSliceChecksums(const ::IceBox::Callback_ServiceManager_getSliceChecksumsPtr& del, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_getSliceChecksums(::Ice::noExplicitContext, del, cookie);
    }

    ::Ice::AsyncResultPtr begin_getSliceChecksums(const ::Ice::Context& context, const ::IceBox::Callback_ServiceManager_getSliceChecksumsPtr& del, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_getSliceChecksums(context, del, cookie);
    }

    ICE_MEMBER(ICEBOX_API) ::Ice::SliceChecksumDict end_getSliceChecksums(const ::Ice::AsyncResultPtr&);

private:

    ICE_MEMBER(ICEBOX_API) ::Ice::AsyncResultPtr _iceI_begin_getSliceChecksums(const ::Ice::Context&, const ::IceInternal::CallbackBasePtr&, const ::Ice::LocalObjectPtr& cookie = 0, bool sync = false);

public:

    ICE_MEMBER(ICEBOX_API) void startService(const ::std::string& iceP_service, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        end_startService(_iceI_begin_startService(iceP_service, context, ::IceInternal::dummyCallback, 0, true));
    }

    ::Ice::AsyncResultPtr begin_startService(const ::std::string& iceP_service, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _iceI_begin_startService(iceP_service, context, ::IceInternal::dummyCallback, 0);
    }

    ::Ice::AsyncResultPtr begin_startService(const ::std::string& iceP_service, const ::Ice::CallbackPtr& del, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_startService(iceP_service, ::Ice::noExplicitContext, del, cookie);
    }

    ::Ice::AsyncResultPtr begin_startService(const ::std::string& iceP_service, const ::Ice::Context& context, const ::Ice::CallbackPtr& del, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_startService(iceP_service, context, del, cookie);
    }

    ::Ice::AsyncResultPtr begin_startService(const ::std::string& iceP_service, const ::IceBox::Callback_ServiceManager_startServicePtr& del, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_startService(iceP_service, ::Ice::noExplicitContext, del, cookie);
    }

    ::Ice::AsyncResultPtr begin_startService(const ::std::string& iceP_service, const ::Ice::Context& context, const ::IceBox::Callback_ServiceManager_startServicePtr& del, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_startService(iceP_service, context, del, cookie);
    }

    ICE_MEMBER(ICEBOX_API) void end_startService(const ::Ice::AsyncResultPtr&);

private:

    ICE_MEMBER(ICEBOX_API) ::Ice::AsyncResultPtr _iceI_begin_startService(const ::std::string&, const ::Ice::Context&, const ::IceInternal::CallbackBasePtr&, const ::Ice::LocalObjectPtr& cookie = 0, bool sync = false);

public:

    ICE_MEMBER(ICEBOX_API) void stopService(const ::std::string& iceP_service, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        end_stopService(_iceI_begin_stopService(iceP_service, context, ::IceInternal::dummyCallback, 0, true));
    }

    ::Ice::AsyncResultPtr begin_stopService(const ::std::string& iceP_service, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _iceI_begin_stopService(iceP_service, context, ::IceInternal::dummyCallback, 0);
    }

    ::Ice::AsyncResultPtr begin_stopService(const ::std::string& iceP_service, const ::Ice::CallbackPtr& del, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_stopService(iceP_service, ::Ice::noExplicitContext, del, cookie);
    }

    ::Ice::AsyncResultPtr begin_stopService(const ::std::string& iceP_service, const ::Ice::Context& context, const ::Ice::CallbackPtr& del, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_stopService(iceP_service, context, del, cookie);
    }

    ::Ice::AsyncResultPtr begin_stopService(const ::std::string& iceP_service, const ::IceBox::Callback_ServiceManager_stopServicePtr& del, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_stopService(iceP_service, ::Ice::noExplicitContext, del, cookie);
    }

    ::Ice::AsyncResultPtr begin_stopService(const ::std::string& iceP_service, const ::Ice::Context& context, const ::IceBox::Callback_ServiceManager_stopServicePtr& del, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_stopService(iceP_service, context, del, cookie);
    }

    ICE_MEMBER(ICEBOX_API) void end_stopService(const ::Ice::AsyncResultPtr&);

private:

    ICE_MEMBER(ICEBOX_API) ::Ice::AsyncResultPtr _iceI_begin_stopService(const ::std::string&, const ::Ice::Context&, const ::IceInternal::CallbackBasePtr&, const ::Ice::LocalObjectPtr& cookie = 0, bool sync = false);

public:

    ICE_MEMBER(ICEBOX_API) void addObserver(const ::IceBox::ServiceObserverPrx& iceP_observer, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        end_addObserver(_iceI_begin_addObserver(iceP_observer, context, ::IceInternal::dummyCallback, 0, true));
    }

    ::Ice::AsyncResultPtr begin_addObserver(const ::IceBox::ServiceObserverPrx& iceP_observer, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _iceI_begin_addObserver(iceP_observer, context, ::IceInternal::dummyCallback, 0);
    }

    ::Ice::AsyncResultPtr begin_addObserver(const ::IceBox::ServiceObserverPrx& iceP_observer, const ::Ice::CallbackPtr& del, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_addObserver(iceP_observer, ::Ice::noExplicitContext, del, cookie);
    }

    ::Ice::AsyncResultPtr begin_addObserver(const ::IceBox::ServiceObserverPrx& iceP_observer, const ::Ice::Context& context, const ::Ice::CallbackPtr& del, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_addObserver(iceP_observer, context, del, cookie);
    }

    ::Ice::AsyncResultPtr begin_addObserver(const ::IceBox::ServiceObserverPrx& iceP_observer, const ::IceBox::Callback_ServiceManager_addObserverPtr& del, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_addObserver(iceP_observer, ::Ice::noExplicitContext, del, cookie);
    }

    ::Ice::AsyncResultPtr begin_addObserver(const ::IceBox::ServiceObserverPrx& iceP_observer, const ::Ice::Context& context, const ::IceBox::Callback_ServiceManager_addObserverPtr& del, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_addObserver(iceP_observer, context, del, cookie);
    }

    ICE_MEMBER(ICEBOX_API) void end_addObserver(const ::Ice::AsyncResultPtr&);

private:

    ICE_MEMBER(ICEBOX_API) ::Ice::AsyncResultPtr _iceI_begin_addObserver(const ::IceBox::ServiceObserverPrx&, const ::Ice::Context&, const ::IceInternal::CallbackBasePtr&, const ::Ice::LocalObjectPtr& cookie = 0, bool sync = false);

public:

    ICE_MEMBER(ICEBOX_API) void shutdown(const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        end_shutdown(_iceI_begin_shutdown(context, ::IceInternal::dummyCallback, 0, true));
    }

    ::Ice::AsyncResultPtr begin_shutdown(const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _iceI_begin_shutdown(context, ::IceInternal::dummyCallback, 0);
    }

    ::Ice::AsyncResultPtr begin_shutdown(const ::Ice::CallbackPtr& del, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_shutdown(::Ice::noExplicitContext, del, cookie);
    }

    ::Ice::AsyncResultPtr begin_shutdown(const ::Ice::Context& context, const ::Ice::CallbackPtr& del, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_shutdown(context, del, cookie);
    }

    ::Ice::AsyncResultPtr begin_shutdown(const ::IceBox::Callback_ServiceManager_shutdownPtr& del, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_shutdown(::Ice::noExplicitContext, del, cookie);
    }

    ::Ice::AsyncResultPtr begin_shutdown(const ::Ice::Context& context, const ::IceBox::Callback_ServiceManager_shutdownPtr& del, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_shutdown(context, del, cookie);
    }

    ICE_MEMBER(ICEBOX_API) void end_shutdown(const ::Ice::AsyncResultPtr&);

private:

    ICE_MEMBER(ICEBOX_API) ::Ice::AsyncResultPtr _iceI_begin_shutdown(const ::Ice::Context&, const ::IceInternal::CallbackBasePtr&, const ::Ice::LocalObjectPtr& cookie = 0, bool sync = false);

public:

    ICE_MEMBER(ICEBOX_API) static const ::std::string& ice_staticId();

protected:

    ICE_MEMBER(ICEBOX_API) virtual ::IceProxy::Ice::Object* _newInstance() const;
};

}

}

namespace IceBox
{

class ICEBOX_API Service : public virtual ::Ice::LocalObject
{
public:

    typedef ServicePtr PointerType;

    virtual ~Service();

    virtual void start(const ::std::string&, const ::Ice::CommunicatorPtr&, const ::Ice::StringSeq&) = 0;

    virtual void stop() = 0;
};

inline bool operator==(const Service& lhs, const Service& rhs)
{
    return static_cast<const ::Ice::LocalObject&>(lhs) == static_cast<const ::Ice::LocalObject&>(rhs);
}

inline bool operator<(const Service& lhs, const Service& rhs)
{
    return static_cast<const ::Ice::LocalObject&>(lhs) < static_cast<const ::Ice::LocalObject&>(rhs);
}

class ICEBOX_API ServiceObserver : public virtual ::Ice::Object
{
public:

    typedef ServiceObserverPrx ProxyType;
    typedef ServiceObserverPtr PointerType;

    virtual ~ServiceObserver();

    virtual bool ice_isA(const ::std::string&, const ::Ice::Current& = ::Ice::emptyCurrent) const;
    virtual ::std::vector< ::std::string> ice_ids(const ::Ice::Current& = ::Ice::emptyCurrent) const;
    virtual const ::std::string& ice_id(const ::Ice::Current& = ::Ice::emptyCurrent) const;

    static const ::std::string& ice_staticId();

    virtual void servicesStarted(const ::Ice::StringSeq&, const ::Ice::Current& = ::Ice::emptyCurrent) = 0;
    bool _iceD_servicesStarted(::IceInternal::Incoming&, const ::Ice::Current&);

    virtual void servicesStopped(const ::Ice::StringSeq&, const ::Ice::Current& = ::Ice::emptyCurrent) = 0;
    bool _iceD_servicesStopped(::IceInternal::Incoming&, const ::Ice::Current&);

    virtual bool _iceDispatch(::IceInternal::Incoming&, const ::Ice::Current&);

protected:

    virtual void _iceWriteImpl(::Ice::OutputStream*) const;
    virtual void _iceReadImpl(::Ice::InputStream*);
};

inline bool operator==(const ServiceObserver& lhs, const ServiceObserver& rhs)
{
    return static_cast<const ::Ice::Object&>(lhs) == static_cast<const ::Ice::Object&>(rhs);
}

inline bool operator<(const ServiceObserver& lhs, const ServiceObserver& rhs)
{
    return static_cast<const ::Ice::Object&>(lhs) < static_cast<const ::Ice::Object&>(rhs);
}

class ICEBOX_API ServiceManager : public virtual ::Ice::Object
{
public:

    typedef ServiceManagerPrx ProxyType;
    typedef ServiceManagerPtr PointerType;

    virtual ~ServiceManager();

    virtual bool ice_isA(const ::std::string&, const ::Ice::Current& = ::Ice::emptyCurrent) const;
    virtual ::std::vector< ::std::string> ice_ids(const ::Ice::Current& = ::Ice::emptyCurrent) const;
    virtual const ::std::string& ice_id(const ::Ice::Current& = ::Ice::emptyCurrent) const;

    static const ::std::string& ice_staticId();

    virtual ::Ice::SliceChecksumDict getSliceChecksums(const ::Ice::Current& = ::Ice::emptyCurrent) const = 0;
    bool _iceD_getSliceChecksums(::IceInternal::Incoming&, const ::Ice::Current&) const;

    virtual void startService(const ::std::string&, const ::Ice::Current& = ::Ice::emptyCurrent) = 0;
    bool _iceD_startService(::IceInternal::Incoming&, const ::Ice::Current&);

    virtual void stopService(const ::std::string&, const ::Ice::Current& = ::Ice::emptyCurrent) = 0;
    bool _iceD_stopService(::IceInternal::Incoming&, const ::Ice::Current&);

    virtual void addObserver(const ::IceBox::ServiceObserverPrx&, const ::Ice::Current& = ::Ice::emptyCurrent) = 0;
    bool _iceD_addObserver(::IceInternal::Incoming&, const ::Ice::Current&);

    virtual void shutdown(const ::Ice::Current& = ::Ice::emptyCurrent) = 0;
    bool _iceD_shutdown(::IceInternal::Incoming&, const ::Ice::Current&);

    virtual bool _iceDispatch(::IceInternal::Incoming&, const ::Ice::Current&);

protected:

    virtual void _iceWriteImpl(::Ice::OutputStream*) const;
    virtual void _iceReadImpl(::Ice::InputStream*);
};

inline bool operator==(const ServiceManager& lhs, const ServiceManager& rhs)
{
    return static_cast<const ::Ice::Object&>(lhs) == static_cast<const ::Ice::Object&>(rhs);
}

inline bool operator<(const ServiceManager& lhs, const ServiceManager& rhs)
{
    return static_cast<const ::Ice::Object&>(lhs) < static_cast<const ::Ice::Object&>(rhs);
}

}

namespace Ice
{

template<>
struct StreamableTraits< ::IceBox::AlreadyStartedException>
{
    static const StreamHelperCategory helper = StreamHelperCategoryUserException;
};

template<>
struct StreamableTraits< ::IceBox::AlreadyStoppedException>
{
    static const StreamHelperCategory helper = StreamHelperCategoryUserException;
};

template<>
struct StreamableTraits< ::IceBox::NoSuchServiceException>
{
    static const StreamHelperCategory helper = StreamHelperCategoryUserException;
};

}

namespace IceBox
{

template<class T>
class CallbackNC_ServiceObserver_servicesStarted : public Callback_ServiceObserver_servicesStarted_Base, public ::IceInternal::OnewayCallbackNC<T>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception&);
    typedef void (T::*Sent)(bool);
    typedef void (T::*Response)();

    CallbackNC_ServiceObserver_servicesStarted(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::OnewayCallbackNC<T>(obj, cb, excb, sentcb)
    {
    }
};

template<class T> Callback_ServiceObserver_servicesStartedPtr
newCallback_ServiceObserver_servicesStarted(const IceUtil::Handle<T>& instance, void (T::*cb)(), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_ServiceObserver_servicesStarted<T>(instance, cb, excb, sentcb);
}

template<class T> Callback_ServiceObserver_servicesStartedPtr
newCallback_ServiceObserver_servicesStarted(const IceUtil::Handle<T>& instance, void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_ServiceObserver_servicesStarted<T>(instance, 0, excb, sentcb);
}

template<class T> Callback_ServiceObserver_servicesStartedPtr
newCallback_ServiceObserver_servicesStarted(T* instance, void (T::*cb)(), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_ServiceObserver_servicesStarted<T>(instance, cb, excb, sentcb);
}

template<class T> Callback_ServiceObserver_servicesStartedPtr
newCallback_ServiceObserver_servicesStarted(T* instance, void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_ServiceObserver_servicesStarted<T>(instance, 0, excb, sentcb);
}

template<class T, typename CT>
class Callback_ServiceObserver_servicesStarted : public Callback_ServiceObserver_servicesStarted_Base, public ::IceInternal::OnewayCallback<T, CT>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception& , const CT&);
    typedef void (T::*Sent)(bool , const CT&);
    typedef void (T::*Response)(const CT&);

    Callback_ServiceObserver_servicesStarted(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::OnewayCallback<T, CT>(obj, cb, excb, sentcb)
    {
    }
};

template<class T, typename CT> Callback_ServiceObserver_servicesStartedPtr
newCallback_ServiceObserver_servicesStarted(const IceUtil::Handle<T>& instance, void (T::*cb)(const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_ServiceObserver_servicesStarted<T, CT>(instance, cb, excb, sentcb);
}

template<class T, typename CT> Callback_ServiceObserver_servicesStartedPtr
newCallback_ServiceObserver_servicesStarted(const IceUtil::Handle<T>& instance, void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_ServiceObserver_servicesStarted<T, CT>(instance, 0, excb, sentcb);
}

template<class T, typename CT> Callback_ServiceObserver_servicesStartedPtr
newCallback_ServiceObserver_servicesStarted(T* instance, void (T::*cb)(const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_ServiceObserver_servicesStarted<T, CT>(instance, cb, excb, sentcb);
}

template<class T, typename CT> Callback_ServiceObserver_servicesStartedPtr
newCallback_ServiceObserver_servicesStarted(T* instance, void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_ServiceObserver_servicesStarted<T, CT>(instance, 0, excb, sentcb);
}

template<class T>
class CallbackNC_ServiceObserver_servicesStopped : public Callback_ServiceObserver_servicesStopped_Base, public ::IceInternal::OnewayCallbackNC<T>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception&);
    typedef void (T::*Sent)(bool);
    typedef void (T::*Response)();

    CallbackNC_ServiceObserver_servicesStopped(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::OnewayCallbackNC<T>(obj, cb, excb, sentcb)
    {
    }
};

template<class T> Callback_ServiceObserver_servicesStoppedPtr
newCallback_ServiceObserver_servicesStopped(const IceUtil::Handle<T>& instance, void (T::*cb)(), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_ServiceObserver_servicesStopped<T>(instance, cb, excb, sentcb);
}

template<class T> Callback_ServiceObserver_servicesStoppedPtr
newCallback_ServiceObserver_servicesStopped(const IceUtil::Handle<T>& instance, void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_ServiceObserver_servicesStopped<T>(instance, 0, excb, sentcb);
}

template<class T> Callback_ServiceObserver_servicesStoppedPtr
newCallback_ServiceObserver_servicesStopped(T* instance, void (T::*cb)(), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_ServiceObserver_servicesStopped<T>(instance, cb, excb, sentcb);
}

template<class T> Callback_ServiceObserver_servicesStoppedPtr
newCallback_ServiceObserver_servicesStopped(T* instance, void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_ServiceObserver_servicesStopped<T>(instance, 0, excb, sentcb);
}

template<class T, typename CT>
class Callback_ServiceObserver_servicesStopped : public Callback_ServiceObserver_servicesStopped_Base, public ::IceInternal::OnewayCallback<T, CT>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception& , const CT&);
    typedef void (T::*Sent)(bool , const CT&);
    typedef void (T::*Response)(const CT&);

    Callback_ServiceObserver_servicesStopped(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::OnewayCallback<T, CT>(obj, cb, excb, sentcb)
    {
    }
};

template<class T, typename CT> Callback_ServiceObserver_servicesStoppedPtr
newCallback_ServiceObserver_servicesStopped(const IceUtil::Handle<T>& instance, void (T::*cb)(const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_ServiceObserver_servicesStopped<T, CT>(instance, cb, excb, sentcb);
}

template<class T, typename CT> Callback_ServiceObserver_servicesStoppedPtr
newCallback_ServiceObserver_servicesStopped(const IceUtil::Handle<T>& instance, void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_ServiceObserver_servicesStopped<T, CT>(instance, 0, excb, sentcb);
}

template<class T, typename CT> Callback_ServiceObserver_servicesStoppedPtr
newCallback_ServiceObserver_servicesStopped(T* instance, void (T::*cb)(const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_ServiceObserver_servicesStopped<T, CT>(instance, cb, excb, sentcb);
}

template<class T, typename CT> Callback_ServiceObserver_servicesStoppedPtr
newCallback_ServiceObserver_servicesStopped(T* instance, void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_ServiceObserver_servicesStopped<T, CT>(instance, 0, excb, sentcb);
}

template<class T>
class CallbackNC_ServiceManager_getSliceChecksums : public Callback_ServiceManager_getSliceChecksums_Base, public ::IceInternal::TwowayCallbackNC<T>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception&);
    typedef void (T::*Sent)(bool);
    typedef void (T::*Response)(const ::Ice::SliceChecksumDict&);

    CallbackNC_ServiceManager_getSliceChecksums(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::TwowayCallbackNC<T>(obj, cb != 0, excb, sentcb), _response(cb)
    {
    }

    virtual void completed(const ::Ice::AsyncResultPtr& result) const
    {
        ::IceBox::ServiceManagerPrx proxy = ::IceBox::ServiceManagerPrx::uncheckedCast(result->getProxy());
        ::Ice::SliceChecksumDict ret;
        try
        {
            ret = proxy->end_getSliceChecksums(result);
        }
        catch(const ::Ice::Exception& ex)
        {
            ::IceInternal::CallbackNC<T>::exception(result, ex);
            return;
        }
        if(_response)
        {
            (::IceInternal::CallbackNC<T>::_callback.get()->*_response)(ret);
        }
    }

private:

    Response _response;
};

template<class T> Callback_ServiceManager_getSliceChecksumsPtr
newCallback_ServiceManager_getSliceChecksums(const IceUtil::Handle<T>& instance, void (T::*cb)(const ::Ice::SliceChecksumDict&), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_ServiceManager_getSliceChecksums<T>(instance, cb, excb, sentcb);
}

template<class T> Callback_ServiceManager_getSliceChecksumsPtr
newCallback_ServiceManager_getSliceChecksums(T* instance, void (T::*cb)(const ::Ice::SliceChecksumDict&), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_ServiceManager_getSliceChecksums<T>(instance, cb, excb, sentcb);
}

template<class T, typename CT>
class Callback_ServiceManager_getSliceChecksums : public Callback_ServiceManager_getSliceChecksums_Base, public ::IceInternal::TwowayCallback<T, CT>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception& , const CT&);
    typedef void (T::*Sent)(bool , const CT&);
    typedef void (T::*Response)(const ::Ice::SliceChecksumDict&, const CT&);

    Callback_ServiceManager_getSliceChecksums(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::TwowayCallback<T, CT>(obj, cb != 0, excb, sentcb), _response(cb)
    {
    }

    virtual void completed(const ::Ice::AsyncResultPtr& result) const
    {
        ::IceBox::ServiceManagerPrx proxy = ::IceBox::ServiceManagerPrx::uncheckedCast(result->getProxy());
        ::Ice::SliceChecksumDict ret;
        try
        {
            ret = proxy->end_getSliceChecksums(result);
        }
        catch(const ::Ice::Exception& ex)
        {
            ::IceInternal::Callback<T, CT>::exception(result, ex);
            return;
        }
        if(_response)
        {
            (::IceInternal::Callback<T, CT>::_callback.get()->*_response)(ret, CT::dynamicCast(result->getCookie()));
        }
    }

private:

    Response _response;
};

template<class T, typename CT> Callback_ServiceManager_getSliceChecksumsPtr
newCallback_ServiceManager_getSliceChecksums(const IceUtil::Handle<T>& instance, void (T::*cb)(const ::Ice::SliceChecksumDict&, const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_ServiceManager_getSliceChecksums<T, CT>(instance, cb, excb, sentcb);
}

template<class T, typename CT> Callback_ServiceManager_getSliceChecksumsPtr
newCallback_ServiceManager_getSliceChecksums(T* instance, void (T::*cb)(const ::Ice::SliceChecksumDict&, const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_ServiceManager_getSliceChecksums<T, CT>(instance, cb, excb, sentcb);
}

template<class T>
class CallbackNC_ServiceManager_startService : public Callback_ServiceManager_startService_Base, public ::IceInternal::TwowayCallbackNC<T>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception&);
    typedef void (T::*Sent)(bool);
    typedef void (T::*Response)();

    CallbackNC_ServiceManager_startService(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::TwowayCallbackNC<T>(obj, cb != 0, excb, sentcb), _response(cb)
    {
    }

    virtual void completed(const ::Ice::AsyncResultPtr& result) const
    {
        ::IceBox::ServiceManagerPrx proxy = ::IceBox::ServiceManagerPrx::uncheckedCast(result->getProxy());
        try
        {
            proxy->end_startService(result);
        }
        catch(const ::Ice::Exception& ex)
        {
            ::IceInternal::CallbackNC<T>::exception(result, ex);
            return;
        }
        if(_response)
        {
            (::IceInternal::CallbackNC<T>::_callback.get()->*_response)();
        }
    }

private:

    Response _response;
};

template<class T> Callback_ServiceManager_startServicePtr
newCallback_ServiceManager_startService(const IceUtil::Handle<T>& instance, void (T::*cb)(), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_ServiceManager_startService<T>(instance, cb, excb, sentcb);
}

template<class T> Callback_ServiceManager_startServicePtr
newCallback_ServiceManager_startService(const IceUtil::Handle<T>& instance, void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_ServiceManager_startService<T>(instance, 0, excb, sentcb);
}

template<class T> Callback_ServiceManager_startServicePtr
newCallback_ServiceManager_startService(T* instance, void (T::*cb)(), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_ServiceManager_startService<T>(instance, cb, excb, sentcb);
}

template<class T> Callback_ServiceManager_startServicePtr
newCallback_ServiceManager_startService(T* instance, void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_ServiceManager_startService<T>(instance, 0, excb, sentcb);
}

template<class T, typename CT>
class Callback_ServiceManager_startService : public Callback_ServiceManager_startService_Base, public ::IceInternal::TwowayCallback<T, CT>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception& , const CT&);
    typedef void (T::*Sent)(bool , const CT&);
    typedef void (T::*Response)(const CT&);

    Callback_ServiceManager_startService(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::TwowayCallback<T, CT>(obj, cb != 0, excb, sentcb), _response(cb)
    {
    }

    virtual void completed(const ::Ice::AsyncResultPtr& result) const
    {
        ::IceBox::ServiceManagerPrx proxy = ::IceBox::ServiceManagerPrx::uncheckedCast(result->getProxy());
        try
        {
            proxy->end_startService(result);
        }
        catch(const ::Ice::Exception& ex)
        {
            ::IceInternal::Callback<T, CT>::exception(result, ex);
            return;
        }
        if(_response)
        {
            (::IceInternal::Callback<T, CT>::_callback.get()->*_response)(CT::dynamicCast(result->getCookie()));
        }
    }

private:

    Response _response;
};

template<class T, typename CT> Callback_ServiceManager_startServicePtr
newCallback_ServiceManager_startService(const IceUtil::Handle<T>& instance, void (T::*cb)(const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_ServiceManager_startService<T, CT>(instance, cb, excb, sentcb);
}

template<class T, typename CT> Callback_ServiceManager_startServicePtr
newCallback_ServiceManager_startService(const IceUtil::Handle<T>& instance, void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_ServiceManager_startService<T, CT>(instance, 0, excb, sentcb);
}

template<class T, typename CT> Callback_ServiceManager_startServicePtr
newCallback_ServiceManager_startService(T* instance, void (T::*cb)(const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_ServiceManager_startService<T, CT>(instance, cb, excb, sentcb);
}

template<class T, typename CT> Callback_ServiceManager_startServicePtr
newCallback_ServiceManager_startService(T* instance, void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_ServiceManager_startService<T, CT>(instance, 0, excb, sentcb);
}

template<class T>
class CallbackNC_ServiceManager_stopService : public Callback_ServiceManager_stopService_Base, public ::IceInternal::TwowayCallbackNC<T>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception&);
    typedef void (T::*Sent)(bool);
    typedef void (T::*Response)();

    CallbackNC_ServiceManager_stopService(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::TwowayCallbackNC<T>(obj, cb != 0, excb, sentcb), _response(cb)
    {
    }

    virtual void completed(const ::Ice::AsyncResultPtr& result) const
    {
        ::IceBox::ServiceManagerPrx proxy = ::IceBox::ServiceManagerPrx::uncheckedCast(result->getProxy());
        try
        {
            proxy->end_stopService(result);
        }
        catch(const ::Ice::Exception& ex)
        {
            ::IceInternal::CallbackNC<T>::exception(result, ex);
            return;
        }
        if(_response)
        {
            (::IceInternal::CallbackNC<T>::_callback.get()->*_response)();
        }
    }

private:

    Response _response;
};

template<class T> Callback_ServiceManager_stopServicePtr
newCallback_ServiceManager_stopService(const IceUtil::Handle<T>& instance, void (T::*cb)(), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_ServiceManager_stopService<T>(instance, cb, excb, sentcb);
}

template<class T> Callback_ServiceManager_stopServicePtr
newCallback_ServiceManager_stopService(const IceUtil::Handle<T>& instance, void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_ServiceManager_stopService<T>(instance, 0, excb, sentcb);
}

template<class T> Callback_ServiceManager_stopServicePtr
newCallback_ServiceManager_stopService(T* instance, void (T::*cb)(), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_ServiceManager_stopService<T>(instance, cb, excb, sentcb);
}

template<class T> Callback_ServiceManager_stopServicePtr
newCallback_ServiceManager_stopService(T* instance, void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_ServiceManager_stopService<T>(instance, 0, excb, sentcb);
}

template<class T, typename CT>
class Callback_ServiceManager_stopService : public Callback_ServiceManager_stopService_Base, public ::IceInternal::TwowayCallback<T, CT>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception& , const CT&);
    typedef void (T::*Sent)(bool , const CT&);
    typedef void (T::*Response)(const CT&);

    Callback_ServiceManager_stopService(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::TwowayCallback<T, CT>(obj, cb != 0, excb, sentcb), _response(cb)
    {
    }

    virtual void completed(const ::Ice::AsyncResultPtr& result) const
    {
        ::IceBox::ServiceManagerPrx proxy = ::IceBox::ServiceManagerPrx::uncheckedCast(result->getProxy());
        try
        {
            proxy->end_stopService(result);
        }
        catch(const ::Ice::Exception& ex)
        {
            ::IceInternal::Callback<T, CT>::exception(result, ex);
            return;
        }
        if(_response)
        {
            (::IceInternal::Callback<T, CT>::_callback.get()->*_response)(CT::dynamicCast(result->getCookie()));
        }
    }

private:

    Response _response;
};

template<class T, typename CT> Callback_ServiceManager_stopServicePtr
newCallback_ServiceManager_stopService(const IceUtil::Handle<T>& instance, void (T::*cb)(const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_ServiceManager_stopService<T, CT>(instance, cb, excb, sentcb);
}

template<class T, typename CT> Callback_ServiceManager_stopServicePtr
newCallback_ServiceManager_stopService(const IceUtil::Handle<T>& instance, void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_ServiceManager_stopService<T, CT>(instance, 0, excb, sentcb);
}

template<class T, typename CT> Callback_ServiceManager_stopServicePtr
newCallback_ServiceManager_stopService(T* instance, void (T::*cb)(const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_ServiceManager_stopService<T, CT>(instance, cb, excb, sentcb);
}

template<class T, typename CT> Callback_ServiceManager_stopServicePtr
newCallback_ServiceManager_stopService(T* instance, void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_ServiceManager_stopService<T, CT>(instance, 0, excb, sentcb);
}

template<class T>
class CallbackNC_ServiceManager_addObserver : public Callback_ServiceManager_addObserver_Base, public ::IceInternal::OnewayCallbackNC<T>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception&);
    typedef void (T::*Sent)(bool);
    typedef void (T::*Response)();

    CallbackNC_ServiceManager_addObserver(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::OnewayCallbackNC<T>(obj, cb, excb, sentcb)
    {
    }
};

template<class T> Callback_ServiceManager_addObserverPtr
newCallback_ServiceManager_addObserver(const IceUtil::Handle<T>& instance, void (T::*cb)(), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_ServiceManager_addObserver<T>(instance, cb, excb, sentcb);
}

template<class T> Callback_ServiceManager_addObserverPtr
newCallback_ServiceManager_addObserver(const IceUtil::Handle<T>& instance, void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_ServiceManager_addObserver<T>(instance, 0, excb, sentcb);
}

template<class T> Callback_ServiceManager_addObserverPtr
newCallback_ServiceManager_addObserver(T* instance, void (T::*cb)(), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_ServiceManager_addObserver<T>(instance, cb, excb, sentcb);
}

template<class T> Callback_ServiceManager_addObserverPtr
newCallback_ServiceManager_addObserver(T* instance, void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_ServiceManager_addObserver<T>(instance, 0, excb, sentcb);
}

template<class T, typename CT>
class Callback_ServiceManager_addObserver : public Callback_ServiceManager_addObserver_Base, public ::IceInternal::OnewayCallback<T, CT>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception& , const CT&);
    typedef void (T::*Sent)(bool , const CT&);
    typedef void (T::*Response)(const CT&);

    Callback_ServiceManager_addObserver(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::OnewayCallback<T, CT>(obj, cb, excb, sentcb)
    {
    }
};

template<class T, typename CT> Callback_ServiceManager_addObserverPtr
newCallback_ServiceManager_addObserver(const IceUtil::Handle<T>& instance, void (T::*cb)(const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_ServiceManager_addObserver<T, CT>(instance, cb, excb, sentcb);
}

template<class T, typename CT> Callback_ServiceManager_addObserverPtr
newCallback_ServiceManager_addObserver(const IceUtil::Handle<T>& instance, void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_ServiceManager_addObserver<T, CT>(instance, 0, excb, sentcb);
}

template<class T, typename CT> Callback_ServiceManager_addObserverPtr
newCallback_ServiceManager_addObserver(T* instance, void (T::*cb)(const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_ServiceManager_addObserver<T, CT>(instance, cb, excb, sentcb);
}

template<class T, typename CT> Callback_ServiceManager_addObserverPtr
newCallback_ServiceManager_addObserver(T* instance, void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_ServiceManager_addObserver<T, CT>(instance, 0, excb, sentcb);
}

template<class T>
class CallbackNC_ServiceManager_shutdown : public Callback_ServiceManager_shutdown_Base, public ::IceInternal::OnewayCallbackNC<T>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception&);
    typedef void (T::*Sent)(bool);
    typedef void (T::*Response)();

    CallbackNC_ServiceManager_shutdown(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::OnewayCallbackNC<T>(obj, cb, excb, sentcb)
    {
    }
};

template<class T> Callback_ServiceManager_shutdownPtr
newCallback_ServiceManager_shutdown(const IceUtil::Handle<T>& instance, void (T::*cb)(), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_ServiceManager_shutdown<T>(instance, cb, excb, sentcb);
}

template<class T> Callback_ServiceManager_shutdownPtr
newCallback_ServiceManager_shutdown(const IceUtil::Handle<T>& instance, void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_ServiceManager_shutdown<T>(instance, 0, excb, sentcb);
}

template<class T> Callback_ServiceManager_shutdownPtr
newCallback_ServiceManager_shutdown(T* instance, void (T::*cb)(), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_ServiceManager_shutdown<T>(instance, cb, excb, sentcb);
}

template<class T> Callback_ServiceManager_shutdownPtr
newCallback_ServiceManager_shutdown(T* instance, void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_ServiceManager_shutdown<T>(instance, 0, excb, sentcb);
}

template<class T, typename CT>
class Callback_ServiceManager_shutdown : public Callback_ServiceManager_shutdown_Base, public ::IceInternal::OnewayCallback<T, CT>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception& , const CT&);
    typedef void (T::*Sent)(bool , const CT&);
    typedef void (T::*Response)(const CT&);

    Callback_ServiceManager_shutdown(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::OnewayCallback<T, CT>(obj, cb, excb, sentcb)
    {
    }
};

template<class T, typename CT> Callback_ServiceManager_shutdownPtr
newCallback_ServiceManager_shutdown(const IceUtil::Handle<T>& instance, void (T::*cb)(const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_ServiceManager_shutdown<T, CT>(instance, cb, excb, sentcb);
}

template<class T, typename CT> Callback_ServiceManager_shutdownPtr
newCallback_ServiceManager_shutdown(const IceUtil::Handle<T>& instance, void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_ServiceManager_shutdown<T, CT>(instance, 0, excb, sentcb);
}

template<class T, typename CT> Callback_ServiceManager_shutdownPtr
newCallback_ServiceManager_shutdown(T* instance, void (T::*cb)(const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_ServiceManager_shutdown<T, CT>(instance, cb, excb, sentcb);
}

template<class T, typename CT> Callback_ServiceManager_shutdownPtr
newCallback_ServiceManager_shutdown(T* instance, void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_ServiceManager_shutdown<T, CT>(instance, 0, excb, sentcb);
}

}

#endif

#include <IceUtil/PopDisableWarnings.h>
#endif
