/*
 * Decompiled with CFR 0.152.
 */
package IceInternal;

import Ice.EncodingVersion;
import Ice.Identity;
import Ice.InputStream;
import Ice.Logger;
import Ice.OperationMode;
import Ice.OutputStream;
import Ice.ToStringMode;
import Ice.Util;
import IceInternal.TraceLevels;
import IceUtilInternal.StringUtil;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.HashSet;
import java.util.Set;

public final class TraceUtil {
    private static Set<String> slicingIds = new HashSet<String>();

    public static void traceSend(OutputStream str, Logger logger, TraceLevels tl) {
        if (tl.protocol >= 1) {
            int p = str.pos();
            InputStream is = new InputStream(str.instance(), str.getEncoding(), str.getBuffer(), false);
            is.pos(0);
            StringWriter s = new StringWriter();
            byte type = TraceUtil.printMessage(s, is);
            logger.trace(tl.protocolCat, "sending " + TraceUtil.getMessageTypeAsString(type) + " " + s.toString());
            str.pos(p);
        }
    }

    public static void traceRecv(InputStream str, Logger logger, TraceLevels tl) {
        if (tl.protocol >= 1) {
            int p = str.pos();
            str.pos(0);
            StringWriter s = new StringWriter();
            byte type = TraceUtil.printMessage(s, str);
            logger.trace(tl.protocolCat, "received " + TraceUtil.getMessageTypeAsString(type) + " " + s.toString());
            str.pos(p);
        }
    }

    public static void trace(String heading, OutputStream str, Logger logger, TraceLevels tl) {
        if (tl.protocol >= 1) {
            int p = str.pos();
            InputStream is = new InputStream(str.instance(), str.getEncoding(), str.getBuffer(), false);
            is.pos(0);
            StringWriter s = new StringWriter();
            s.write(heading);
            TraceUtil.printMessage(s, is);
            logger.trace(tl.protocolCat, s.toString());
            str.pos(p);
        }
    }

    public static void trace(String heading, InputStream str, Logger logger, TraceLevels tl) {
        if (tl.protocol >= 1) {
            int p = str.pos();
            str.pos(0);
            StringWriter s = new StringWriter();
            s.write(heading);
            TraceUtil.printMessage(s, str);
            logger.trace(tl.protocolCat, s.toString());
            str.pos(p);
        }
    }

    public static synchronized void traceSlicing(String kind, String typeId, String slicingCat, Logger logger) {
        if (slicingIds.add(typeId)) {
            StringWriter s = new StringWriter();
            s.write("unknown " + kind + " type `" + typeId + "'");
            logger.trace(slicingCat, s.toString());
        }
    }

    public static void dumpStream(InputStream stream) {
        int pos = stream.pos();
        stream.pos(0);
        byte[] data = stream.readBlob(stream.size());
        TraceUtil.dumpOctets(data);
        stream.pos(pos);
    }

    public static void dumpOctets(byte[] data) {
        int inc = 8;
        for (int i = 0; i < data.length; i += 8) {
            int j = i;
            while (j - i < 8) {
                if (j < data.length) {
                    int n = data[j];
                    if (n < 0) {
                        n += 256;
                    }
                    String s = n < 10 ? "  " + n : (n < 100 ? " " + n : "" + n);
                    System.out.print(s + " ");
                } else {
                    System.out.print("    ");
                }
                ++j;
            }
            System.out.print('\"');
            for (j = i; j < data.length && j - i < 8; ++j) {
                if (data[j] >= 32 && data[j] < 127) {
                    System.out.print((char)data[j]);
                    continue;
                }
                System.out.print('.');
            }
            System.out.println('\"');
        }
    }

    private static void printIdentityFacetOperation(Writer out, InputStream stream) {
        block4: {
            try {
                ToStringMode toStringMode = ToStringMode.Unicode;
                if (stream.instance() != null) {
                    toStringMode = stream.instance().toStringMode();
                }
                Identity identity = new Identity();
                identity.ice_readMembers(stream);
                out.write("\nidentity = " + Util.identityToString(identity, toStringMode));
                String[] facet = stream.readStringSeq();
                out.write("\nfacet = ");
                if (facet.length > 0) {
                    out.write(StringUtil.escapeString(facet[0], "", toStringMode));
                }
                String operation = stream.readString();
                out.write("\noperation = " + operation);
            }
            catch (IOException ex) {
                if ($assertionsDisabled) break block4;
                throw new AssertionError();
            }
        }
    }

    private static void printRequest(StringWriter s, InputStream str) {
        int requestId = str.readInt();
        s.write("\nrequest id = " + requestId);
        if (requestId == 0) {
            s.write(" (oneway)");
        }
        TraceUtil.printRequestHeader(s, str);
    }

    private static void printBatchRequest(StringWriter s, InputStream str) {
        int batchRequestNum = str.readInt();
        s.write("\nnumber of requests = " + batchRequestNum);
        for (int i = 0; i < batchRequestNum; ++i) {
            s.write("\nrequest #" + i + ':');
            TraceUtil.printRequestHeader(s, str);
        }
    }

    private static void printReply(StringWriter s, InputStream str) {
        EncodingVersion v;
        int requestId = str.readInt();
        s.write("\nrequest id = " + requestId);
        byte replyStatus = str.readByte();
        s.write("\nreply status = " + replyStatus + ' ');
        switch (replyStatus) {
            case 0: {
                s.write("(ok)");
                break;
            }
            case 1: {
                s.write("(user exception)");
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                switch (replyStatus) {
                    case 2: {
                        s.write("(object not exist)");
                        break;
                    }
                    case 3: {
                        s.write("(facet not exist)");
                        break;
                    }
                    case 4: {
                        s.write("(operation not exist)");
                        break;
                    }
                    default: {
                        assert (false);
                        break;
                    }
                }
                TraceUtil.printIdentityFacetOperation(s, str);
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                switch (replyStatus) {
                    case 7: {
                        s.write("(unknown exception)");
                        break;
                    }
                    case 5: {
                        s.write("(unknown local exception)");
                        break;
                    }
                    case 6: {
                        s.write("(unknown user exception)");
                        break;
                    }
                    default: {
                        assert (false);
                        break;
                    }
                }
                String unknown = str.readString();
                s.write("\nunknown = " + unknown);
                break;
            }
            default: {
                s.write("(unknown)");
            }
        }
        if (!(replyStatus != 0 && replyStatus != 1 || (v = str.skipEncapsulation()).equals(Util.Encoding_1_0))) {
            s.write("\nencoding = ");
            s.write(Util.encodingVersionToString(v));
        }
    }

    private static void printRequestHeader(Writer out, InputStream stream) {
        block9: {
            TraceUtil.printIdentityFacetOperation(out, stream);
            try {
                byte mode = stream.readByte();
                out.write("\nmode = " + mode + ' ');
                switch (OperationMode.values()[mode]) {
                    case Normal: {
                        out.write("(normal)");
                        break;
                    }
                    case Nonmutating: {
                        out.write("(nonmutating)");
                        break;
                    }
                    case Idempotent: {
                        out.write("(idempotent)");
                        break;
                    }
                    default: {
                        out.write("(unknown)");
                    }
                }
                int sz = stream.readSize();
                out.write("\ncontext = ");
                while (sz-- > 0) {
                    String key = stream.readString();
                    String value = stream.readString();
                    out.write(key + '/' + value);
                    if (sz <= 0) continue;
                    out.write(", ");
                }
                EncodingVersion v = stream.skipEncapsulation();
                if (!v.equals(Util.Encoding_1_0)) {
                    out.write("\nencoding = ");
                    out.write(Util.encodingVersionToString(v));
                }
            }
            catch (IOException ex) {
                if ($assertionsDisabled) break block9;
                throw new AssertionError();
            }
        }
    }

    private static byte printHeader(Writer out, InputStream stream) {
        stream.readByte();
        stream.readByte();
        stream.readByte();
        stream.readByte();
        stream.readByte();
        stream.readByte();
        stream.readByte();
        stream.readByte();
        byte type = stream.readByte();
        try {
            out.write("\nmessage type = " + type + " (" + TraceUtil.getMessageTypeAsString(type) + ')');
            byte compress = stream.readByte();
            out.write("\ncompression status = " + compress + ' ');
            switch (compress) {
                case 0: {
                    out.write("(not compressed; do not compress response, if any)");
                    break;
                }
                case 1: {
                    out.write("(not compressed; compress response, if any)");
                    break;
                }
                case 2: {
                    out.write("(compressed; compress response, if any)");
                    break;
                }
                default: {
                    out.write("(unknown)");
                }
            }
            int size = stream.readInt();
            out.write("\nmessage size = " + size);
            return type;
        }
        catch (IOException ex) {
            assert (false);
            return 0;
        }
    }

    private static byte printMessage(StringWriter s, InputStream str) {
        byte type = TraceUtil.printHeader(s, str);
        switch (type) {
            case 3: 
            case 4: {
                break;
            }
            case 0: {
                TraceUtil.printRequest(s, str);
                break;
            }
            case 1: {
                TraceUtil.printBatchRequest(s, str);
                break;
            }
            case 2: {
                TraceUtil.printReply(s, str);
                break;
            }
        }
        return type;
    }

    private static String getMessageTypeAsString(byte type) {
        switch (type) {
            case 0: {
                return "request";
            }
            case 1: {
                return "batch request";
            }
            case 2: {
                return "reply";
            }
            case 4: {
                return "close connection";
            }
            case 3: {
                return "validate connection";
            }
        }
        return "unknown";
    }
}

