/*
 * Decompiled with CFR 0.152.
 */
package IceInternal;

import Ice.EncodingVersion;
import Ice.EndpointInfo;
import Ice.EndpointParseException;
import Ice.IPEndpointInfo;
import Ice.InputStream;
import Ice.OutputStream;
import Ice.UDPEndpointInfo;
import Ice.VersionParseException;
import IceInternal.Acceptor;
import IceInternal.Connector;
import IceInternal.EndpointI;
import IceInternal.HashUtil;
import IceInternal.IPEndpointI;
import IceInternal.Network;
import IceInternal.NetworkProxy;
import IceInternal.ProtocolInstance;
import IceInternal.Transceiver;
import IceInternal.UdpConnector;
import IceInternal.UdpMulticastServerTransceiver;
import IceInternal.UdpTransceiver;
import IceInternal.Util;
import java.net.InetSocketAddress;
import java.util.ArrayList;

final class UdpEndpointI
extends IPEndpointI {
    private String _mcastInterface = "";
    private int _mcastTtl = -1;
    private boolean _connect;
    private boolean _compress;

    public UdpEndpointI(ProtocolInstance instance, String ho, int po, InetSocketAddress sourceAddr, String mcastInterface, int mttl, boolean conn, String conId, boolean co) {
        super(instance, ho, po, sourceAddr, conId);
        this._mcastInterface = mcastInterface;
        this._mcastTtl = mttl;
        this._connect = conn;
        this._compress = co;
    }

    public UdpEndpointI(ProtocolInstance instance) {
        super(instance);
        this._connect = false;
        this._compress = false;
    }

    public UdpEndpointI(ProtocolInstance instance, InputStream s) {
        super(instance, s);
        if (s.getEncoding().equals(Ice.Util.Encoding_1_0)) {
            s.readByte();
            s.readByte();
            s.readByte();
            s.readByte();
        }
        this._connect = false;
        this._compress = s.readBool();
    }

    @Override
    public EndpointInfo getInfo() {
        UDPEndpointInfo info = new UDPEndpointInfo(){

            @Override
            public short type() {
                return UdpEndpointI.this.type();
            }

            @Override
            public boolean datagram() {
                return UdpEndpointI.this.datagram();
            }

            @Override
            public boolean secure() {
                return UdpEndpointI.this.secure();
            }
        };
        this.fillEndpointInfo(info);
        return info;
    }

    @Override
    public int timeout() {
        return -1;
    }

    @Override
    public EndpointI timeout(int timeout) {
        return this;
    }

    @Override
    public boolean compress() {
        return this._compress;
    }

    @Override
    public EndpointI compress(boolean compress) {
        if (compress == this._compress) {
            return this;
        }
        return new UdpEndpointI(this._instance, this._host, this._port, this._sourceAddr, this._mcastInterface, this._mcastTtl, this._connect, this._connectionId, compress);
    }

    @Override
    public boolean datagram() {
        return true;
    }

    @Override
    public Transceiver transceiver() {
        InetSocketAddress addr = Network.getAddressForServer(this._host, this._port, this._instance.protocolSupport(), this._instance.preferIPv6());
        if (Util.isAndroid() && addr.getAddress().isMulticastAddress()) {
            return new UdpMulticastServerTransceiver(this, this._instance, addr, this._mcastInterface);
        }
        return new UdpTransceiver(this, this._instance, addr, this._mcastInterface, this._connect);
    }

    @Override
    public Acceptor acceptor(String adapterName) {
        return null;
    }

    public UdpEndpointI endpoint(UdpTransceiver transceiver) {
        int port = transceiver.effectivePort();
        if (port == this._port) {
            return this;
        }
        return new UdpEndpointI(this._instance, this._host, port, this._sourceAddr, this._mcastInterface, this._mcastTtl, this._connect, this._connectionId, this._compress);
    }

    public UdpEndpointI endpoint(UdpMulticastServerTransceiver transceiver) {
        int port = transceiver.effectivePort();
        if (port == this._port) {
            return this;
        }
        return new UdpEndpointI(this._instance, this._host, port, this._sourceAddr, this._mcastInterface, this._mcastTtl, this._connect, this._connectionId, this._compress);
    }

    @Override
    public void initWithOptions(ArrayList<String> args, boolean oaEndpoint) {
        super.initWithOptions(args, oaEndpoint);
        if (this._mcastInterface.equals("*")) {
            if (oaEndpoint) {
                this._mcastInterface = "";
            } else {
                throw new EndpointParseException("`--interface *' not valid for proxy endpoint `" + this.toString() + "'");
            }
        }
    }

    @Override
    public String options() {
        String s = super.options();
        if (this._mcastInterface.length() != 0) {
            s = s + " --interface " + this._mcastInterface;
        }
        if (this._mcastTtl != -1) {
            s = s + " --ttl " + this._mcastTtl;
        }
        if (this._connect) {
            s = s + " -c";
        }
        if (this._compress) {
            s = s + " -z";
        }
        return s;
    }

    @Override
    public int compareTo(EndpointI obj) {
        if (!(obj instanceof UdpEndpointI)) {
            return this.type() < obj.type() ? -1 : 1;
        }
        UdpEndpointI p = (UdpEndpointI)obj;
        if (this == p) {
            return 0;
        }
        if (!this._connect && p._connect) {
            return -1;
        }
        if (!p._connect && this._connect) {
            return 1;
        }
        if (!this._compress && p._compress) {
            return -1;
        }
        if (!p._compress && this._compress) {
            return 1;
        }
        if (this._mcastTtl < p._mcastTtl) {
            return -1;
        }
        if (p._mcastTtl < this._mcastTtl) {
            return 1;
        }
        int rc = this._mcastInterface.compareTo(p._mcastInterface);
        if (rc != 0) {
            return rc;
        }
        return super.compareTo(obj);
    }

    @Override
    public void streamWriteImpl(OutputStream s) {
        super.streamWriteImpl(s);
        if (s.getEncoding().equals(Ice.Util.Encoding_1_0)) {
            Ice.Util.Protocol_1_0.ice_writeMembers(s);
            Ice.Util.Encoding_1_0.ice_writeMembers(s);
        }
        s.writeBool(this._compress);
    }

    @Override
    public int hashInit(int h) {
        h = super.hashInit(h);
        h = HashUtil.hashAdd(h, this._mcastInterface);
        h = HashUtil.hashAdd(h, this._mcastTtl);
        h = HashUtil.hashAdd(h, this._connect);
        h = HashUtil.hashAdd(h, this._compress);
        return h;
    }

    @Override
    public void fillEndpointInfo(IPEndpointInfo info) {
        super.fillEndpointInfo(info);
        if (info instanceof UDPEndpointInfo) {
            UDPEndpointInfo udpInfo = (UDPEndpointInfo)info;
            udpInfo.mcastInterface = this._mcastInterface;
            udpInfo.mcastTtl = this._mcastTtl;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected boolean checkOption(String option, String argument, String endpoint) {
        if (super.checkOption(option, argument, endpoint)) {
            return true;
        }
        if (option.equals("-c")) {
            if (argument != null) {
                throw new EndpointParseException("unexpected argument `" + argument + "' provided for -c option in " + endpoint);
            }
            this._connect = true;
            return true;
        }
        if (option.equals("-z")) {
            if (argument != null) {
                throw new EndpointParseException("unexpected argument `" + argument + "' provided for -z option in " + endpoint);
            }
            this._compress = true;
            return true;
        }
        if (option.equals("-v") || option.equals("-e")) {
            if (argument == null) {
                throw new EndpointParseException("no argument provided for " + option + " option in endpoint " + endpoint);
            }
            try {
                EncodingVersion v = Ice.Util.stringToEncodingVersion(argument);
                if (v.major == 1 && v.minor == 0) return true;
                this._instance.logger().warning("deprecated udp endpoint option: " + option);
                return true;
            }
            catch (VersionParseException e) {
                throw new EndpointParseException("invalid version `" + argument + "' in endpoint " + endpoint + ":\n" + e.str);
            }
        }
        if (option.equals("--ttl")) {
            if (argument == null) {
                throw new EndpointParseException("no argument provided for --ttl option in endpoint " + endpoint);
            }
            try {
                this._mcastTtl = Integer.parseInt(argument);
            }
            catch (NumberFormatException ex) {
                throw new EndpointParseException("invalid TTL value `" + argument + "' in endpoint " + endpoint);
            }
            if (this._mcastTtl >= 0) return true;
            throw new EndpointParseException("TTL value `" + argument + "' out of range in endpoint " + endpoint);
        }
        if (!option.equals("--interface")) return false;
        if (argument == null) {
            throw new EndpointParseException("no argument provided for --interface option in endpoint " + endpoint);
        }
        this._mcastInterface = argument;
        return true;
    }

    @Override
    protected Connector createConnector(InetSocketAddress addr, NetworkProxy proxy) {
        return new UdpConnector(this._instance, addr, this._sourceAddr, this._mcastInterface, this._mcastTtl, this._connectionId);
    }

    @Override
    protected IPEndpointI createEndpoint(String host, int port, String connectionId) {
        return new UdpEndpointI(this._instance, host, port, this._sourceAddr, this._mcastInterface, this._mcastTtl, this._connect, connectionId, this._compress);
    }
}

