#!/bin/sh
export PATH='/usr/lib/distcc/bin:/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name: HTTP
version: 4000.3.11
id: HTTP-4000.3.11-BNhCkCtd1BPKUZgCyLynBs
key: HTTP-4000.3.11-BNhCkCtd1BPKUZgCyLynBs
license: BSD3
maintainer: Ganesh Sittampalam <ganesh@earth.li>
homepage: https://github.com/haskell/HTTP
synopsis: A library for client-side HTTP
description:
    The HTTP package supports client-side web programming in Haskell. It lets you set up
    HTTP connections, transmitting requests and processing the responses coming back, all
    from within the comforts of Haskell. It'\''s dependent on the network package to operate,
    but other than that, the implementation is all written in Haskell.
    .
    A basic API for issuing single HTTP requests + receiving responses is provided. On top
    of that, a session-level abstraction is also on offer  (the @BrowserAction@ monad);
    it taking care of handling the management of persistent connections, proxies,
    state (cookies) and authentication credentials required to handle multi-step
    interactions with a web server.
    .
    The representation of the bytes flowing across is extensible via the use of a type class,
    letting you pick the representation of requests and responses that best fits your use.
    Some pre-packaged, common instances are provided for you (@ByteString@, @String@).
    .
    Here'\''s an example use:
    .
    >
    >    do
    >      rsp <- Network.HTTP.simpleHTTP (getRequest "http://www.haskell.org/")
    >              -- fetch document and return it (as a '\''String'\''.)
    >      fmap (take 100) (getResponseBody rsp)
    >
    >    do
    >      (_, rsp)
    >         <- Network.Browser.browse $ do
    >               setAllowRedirects True -- handle HTTP redirects
    >               request $ getRequest "http://www.haskell.org/"
    >      return (take 100 (rspBody rsp))
    .
    __Note:__ This package does not support HTTPS connections.
    If you need HTTPS, take a look at the following packages:
    .
    * <http://hackage.haskell.org/package/http-streams http-streams>
    .
    * <http://hackage.haskell.org/package/http-client http-client> (in combination with
    <http://hackage.haskell.org/package/http-client-tls http-client-tls>)
    .
    * <http://hackage.haskell.org/package/req req>
    .
    * <http://hackage.haskell.org/package/wreq wreq>
    .
category: Network
author: Warrick Gray <warrick.gray@hotmail.com>
exposed: True
indefinite: False
exposed-modules:
    Network.Browser Network.BufferType Network.HTTP Network.HTTP.Auth
    Network.HTTP.Base Network.HTTP.Cookie Network.HTTP.HandleStream
    Network.HTTP.Headers Network.HTTP.Proxy Network.HTTP.Stream
    Network.Stream Network.StreamDebugger Network.StreamSocket
    Network.TCP
hidden-modules: Network.HTTP.Base64 Network.HTTP.MD5Aux
                Network.HTTP.Utils Paths_HTTP
abi: e528ef321bcfa912d3a89332fa0e801a
trusted: False
import-dirs: /usr/lib/ghc-8.2.2/site-local/HTTP-4000.3.11
library-dirs: /usr/lib/ghc-8.2.2/site-local/HTTP-4000.3.11
dynamic-library-dirs: /usr/lib
data-dir: /usr/share/arm-linux-ghc-8.2.2/HTTP-4000.3.11
hs-libraries: HSHTTP-4000.3.11-BNhCkCtd1BPKUZgCyLynBs
depends:
    base-4.10.1.0 parsec-3.1.13.0-F9Bf3y6KXh0ILPjymhJoOp array-0.5.2.0
    bytestring-0.10.8.2 time-1.8.0.2 mtl-2.2.2-8XubxMJDT8QLsstvlNotkc
    network-uri-2.6.1.0-6DCcjXT6KQAGJ7ruji2glJ
    network-2.6.3.4-5QQX2Kbe495F2cbHmSR7FO
abi-depends: base-4.10.1.0=0ea45191c57c268b2351cb731ab6a0d6
             parsec-3.1.13.0-F9Bf3y6KXh0ILPjymhJoOp=b942a04aec0a266706b2e8e67bd137e3
             array-0.5.2.0=567646df31883e5d21d17233cc6e3caf
             bytestring-0.10.8.2=4b2726b654ceeff6535e698a2a1e724e
             time-1.8.0.2=d7392e85059cb108aeb68d6e24815970
             mtl-2.2.2-8XubxMJDT8QLsstvlNotkc=9d788b97813db77c2d48570ade6e04a9
             network-uri-2.6.1.0-6DCcjXT6KQAGJ7ruji2glJ=17ff77631878cfceba90438df04f39d6
             network-2.6.3.4-5QQX2Kbe495F2cbHmSR7FO=1e0aca6235e9d0fee0939ce314445bf3
haddock-interfaces: /usr/share/doc/haskell-http/html/HTTP.haddock
haddock-html: /usr/share/doc/haskell-http/html
' | '/usr/bin/ghc-pkg' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

