/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.script;

import org.jmol.api.JmolScriptEvaluator;
import org.jmol.thread.JmolThread;
import org.jmol.viewer.Viewer;

class ScriptDelayThread
extends JmolThread {
    public static final int PAUSE_DELAY = -100;
    private int millis;
    private int seconds;
    private boolean doPopPush;
    private boolean isPauseDelay;

    public ScriptDelayThread(JmolScriptEvaluator eval, Viewer vwr, int millis) {
        this.setViewer(vwr, "ScriptDelayThread");
        this.millis = millis;
        this.setEval(eval);
    }

    @Override
    protected void run1(int mode) throws InterruptedException {
        while (true) {
            switch (mode) {
                case -1: {
                    this.doPopPush = this.millis > 0;
                    boolean bl = this.isPauseDelay = this.millis == -100;
                    if (!this.doPopPush) {
                        this.millis = -this.millis;
                    } else {
                        int delayMax = this.vwr.getDelayMaximumMs();
                        if (delayMax > 0 && this.millis > delayMax) {
                            this.millis = delayMax;
                        }
                    }
                    this.millis = (int)((long)this.millis - (System.currentTimeMillis() - this.startTime));
                    if (this.isJS) {
                        this.seconds = 0;
                    } else {
                        this.seconds = this.millis / 1000;
                        this.millis -= this.seconds * 1000;
                        if (this.millis <= 0) {
                            this.millis = 1;
                        }
                    }
                    if (this.doPopPush) {
                        this.vwr.popHoldRepaint("scriptDelayThread INIT");
                    }
                    mode = 0;
                    break;
                }
                case 0: {
                    if (this.stopped || this.eval.isStopped()) {
                        mode = -2;
                        break;
                    }
                    if (!this.runSleep(this.seconds-- > 0 ? 1000 : this.millis, -2)) {
                        return;
                    }
                    if (this.seconds < 0) {
                        this.millis = 0;
                    }
                    mode = this.seconds > 0 || this.millis > 0 ? 0 : -2;
                    break;
                }
                case -2: {
                    if (this.doPopPush) {
                        this.vwr.pushHoldRepaintWhy("delay FINISH");
                    }
                    if (this.isPauseDelay) {
                        this.eval.notifyResumeStatus();
                    }
                    this.resumeEval();
                    return;
                }
            }
        }
    }
}

