/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.actions;

import java.awt.event.ActionEvent;
import java.io.IOException;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.Stack;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.actions.UploadAction;
import org.openstreetmap.josm.data.APIDataSet;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.DefaultNameFormatter;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.data.osm.visitor.OsmPrimitiveVisitor;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.gui.PleaseWaitRunnable;
import org.openstreetmap.josm.gui.help.HelpUtil;
import org.openstreetmap.josm.gui.io.UploadSelectionDialog;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;
import org.openstreetmap.josm.io.OsmServerBackreferenceReader;
import org.openstreetmap.josm.io.OsmTransferException;
import org.openstreetmap.josm.tools.CheckParameterUtil;
import org.openstreetmap.josm.tools.ExceptionUtil;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Shortcut;
import org.xml.sax.SAXException;

public class UploadSelectionAction
extends JosmAction {
    public UploadSelectionAction() {
        super(I18n.tr("Upload selection", new Object[0]), "uploadselection", I18n.tr("Upload all changes in the current selection to the OSM server.", new Object[0]), Shortcut.registerShortcut("file:uploadSelection", I18n.tr("File: {0}", I18n.tr("Upload selection", new Object[0])), 85, 5010), true);
        this.putValue("help", HelpUtil.ht("/Action/UploadSelection"));
    }

    @Override
    protected void updateEnabledState() {
        this.updateEnabledStateOnCurrentSelection();
    }

    @Override
    protected void updateEnabledState(Collection<? extends OsmPrimitive> selection) {
        this.updateEnabledStateOnModifiableSelection(selection);
        OsmDataLayer editLayer = this.getLayerManager().getEditLayer();
        if (editLayer != null && !editLayer.isUploadable()) {
            this.setEnabled(false);
        }
    }

    protected Set<OsmPrimitive> getDeletedPrimitives(DataSet ds) {
        HashSet<OsmPrimitive> ret = new HashSet<OsmPrimitive>();
        for (OsmPrimitive p : ds.allPrimitives()) {
            if (!p.isDeleted() || p.isNew() || !p.isVisible() || !p.isModified()) continue;
            ret.add(p);
        }
        return ret;
    }

    protected Set<OsmPrimitive> getModifiedPrimitives(Collection<OsmPrimitive> primitives) {
        HashSet<OsmPrimitive> ret = new HashSet<OsmPrimitive>();
        for (OsmPrimitive p : primitives) {
            if (!p.isNewOrUndeleted() && (!p.isModified() || p.isIncomplete())) continue;
            ret.add(p);
        }
        return ret;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        OsmDataLayer editLayer = this.getLayerManager().getEditLayer();
        if (!this.isEnabled() || !editLayer.isUploadable()) {
            return;
        }
        if (editLayer.isUploadDiscouraged() && UploadAction.warnUploadDiscouraged(editLayer)) {
            return;
        }
        Set<OsmPrimitive> modifiedCandidates = this.getModifiedPrimitives(editLayer.data.getAllSelected());
        Set<OsmPrimitive> deletedCandidates = this.getDeletedPrimitives(editLayer.data);
        if (modifiedCandidates.isEmpty() && deletedCandidates.isEmpty()) {
            JOptionPane.showMessageDialog(Main.parent, I18n.tr("No changes to upload.", new Object[0]), I18n.tr("Warning", new Object[0]), 1);
            return;
        }
        UploadSelectionDialog dialog = new UploadSelectionDialog();
        dialog.populate(modifiedCandidates, deletedCandidates);
        dialog.setVisible(true);
        if (dialog.isCanceled()) {
            return;
        }
        Set<OsmPrimitive> toUpload = new UploadHullBuilder().build(dialog.getSelectedPrimitives());
        if (toUpload.isEmpty()) {
            JOptionPane.showMessageDialog(Main.parent, I18n.tr("No changes to upload.", new Object[0]), I18n.tr("Warning", new Object[0]), 1);
            return;
        }
        this.uploadPrimitives(editLayer, toUpload);
    }

    protected boolean hasPrimitivesToDelete(Collection<OsmPrimitive> primitives) {
        for (OsmPrimitive p : primitives) {
            if (!p.isDeleted() || !p.isModified() || p.isNew()) continue;
            return true;
        }
        return false;
    }

    public void uploadPrimitives(OsmDataLayer layer, Collection<OsmPrimitive> toUpload) {
        if (toUpload == null || toUpload.isEmpty()) {
            return;
        }
        UploadHullBuilder builder = new UploadHullBuilder();
        if (this.hasPrimitivesToDelete(toUpload = builder.build(toUpload))) {
            MainApplication.worker.submit(new DeletedParentsChecker(layer, toUpload));
        } else {
            this.processPostParentChecker(layer, toUpload);
        }
    }

    protected void processPostParentChecker(OsmDataLayer layer, Collection<OsmPrimitive> toUpload) {
        APIDataSet ds = new APIDataSet(toUpload);
        UploadAction action = new UploadAction();
        action.uploadData(layer, ds);
    }

    class DeletedParentsChecker
    extends PleaseWaitRunnable {
        private boolean canceled;
        private Exception lastException;
        private final Collection<OsmPrimitive> toUpload;
        private final OsmDataLayer layer;
        private OsmServerBackreferenceReader reader;

        DeletedParentsChecker(OsmDataLayer layer, Collection<OsmPrimitive> toUpload) {
            super(I18n.tr("Checking parents for deleted objects", new Object[0]));
            this.toUpload = toUpload;
            this.layer = layer;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void cancel() {
            this.canceled = true;
            DeletedParentsChecker deletedParentsChecker = this;
            synchronized (deletedParentsChecker) {
                if (this.reader != null) {
                    this.reader.cancel();
                }
            }
        }

        @Override
        protected void finish() {
            if (this.canceled) {
                return;
            }
            if (this.lastException != null) {
                ExceptionUtil.explainException(this.lastException);
                return;
            }
            SwingUtilities.invokeLater(() -> UploadSelectionAction.this.processPostParentChecker(this.layer, this.toUpload));
        }

        protected Set<OsmPrimitive> getPrimitivesToCheckForParents() {
            HashSet<OsmPrimitive> ret = new HashSet<OsmPrimitive>();
            for (OsmPrimitive p : this.toUpload) {
                if (!p.isDeleted() || p.isNewOrUndeleted()) continue;
                ret.add(p);
            }
            return ret;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void realRun() throws SAXException, IOException, OsmTransferException {
            try {
                Stack<OsmPrimitive> toCheck = new Stack<OsmPrimitive>();
                toCheck.addAll(this.getPrimitivesToCheckForParents());
                HashSet<OsmPrimitive> checked = new HashSet<OsmPrimitive>();
                while (!toCheck.isEmpty()) {
                    if (this.canceled) {
                        return;
                    }
                    OsmPrimitive current = (OsmPrimitive)toCheck.pop();
                    DeletedParentsChecker deletedParentsChecker = this;
                    synchronized (deletedParentsChecker) {
                        this.reader = new OsmServerBackreferenceReader(current);
                    }
                    this.getProgressMonitor().subTask(I18n.tr("Reading parents of ''{0}''", current.getDisplayName(DefaultNameFormatter.getInstance())));
                    DataSet ds = this.reader.parseOsm(this.getProgressMonitor().createSubTaskMonitor(1, false));
                    DeletedParentsChecker deletedParentsChecker2 = this;
                    synchronized (deletedParentsChecker2) {
                        this.reader = null;
                    }
                    checked.add(current);
                    this.getProgressMonitor().subTask(I18n.tr("Checking for deleted parents in the local dataset", new Object[0]));
                    for (OsmPrimitive p : ds.allPrimitives()) {
                        if (this.canceled) {
                            return;
                        }
                        OsmPrimitive myDeletedParent = this.layer.data.getPrimitiveById(p);
                        if (myDeletedParent == null || !myDeletedParent.isDeleted()) continue;
                        if (!this.toUpload.contains(myDeletedParent)) {
                            this.toUpload.add(myDeletedParent);
                        }
                        if (checked.contains(myDeletedParent)) continue;
                        toCheck.push(myDeletedParent);
                    }
                }
            }
            catch (OsmTransferException e) {
                if (this.canceled) {
                    return;
                }
                this.lastException = e;
            }
        }
    }

    static class UploadHullBuilder
    implements OsmPrimitiveVisitor {
        private Set<OsmPrimitive> hull = new HashSet<OsmPrimitive>();

        UploadHullBuilder() {
        }

        @Override
        public void visit(Node n) {
            if (n.isNewOrUndeleted() || n.isModified() || n.isDeleted()) {
                this.hull.add(n);
            }
        }

        @Override
        public void visit(Way w) {
            if (w.isNewOrUndeleted() || w.isModified() || w.isDeleted()) {
                this.hull.add(w);
                for (Node n : w.getNodes()) {
                    n.accept(this);
                }
            }
        }

        @Override
        public void visit(Relation r) {
            if (r.isNewOrUndeleted() || r.isModified() || r.isDeleted()) {
                this.hull.add(r);
                for (OsmPrimitive p : r.getMemberPrimitives()) {
                    if (!p.isNewOrUndeleted()) continue;
                    p.accept(this);
                }
            }
        }

        public Set<OsmPrimitive> build(Collection<OsmPrimitive> base) {
            CheckParameterUtil.ensureParameterNotNull(base, "base");
            this.hull = new HashSet<OsmPrimitive>();
            for (OsmPrimitive p : base) {
                p.accept(this);
            }
            return this.hull;
        }
    }
}

