/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.oauth;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import org.openstreetmap.josm.data.oauth.OAuthParameters;
import org.openstreetmap.josm.gui.HelpAwareOptionPane;
import org.openstreetmap.josm.gui.help.HelpUtil;
import org.openstreetmap.josm.gui.widgets.JosmTextField;
import org.openstreetmap.josm.gui.widgets.SelectAllOnFocusGainedDecorator;
import org.openstreetmap.josm.gui.widgets.VerticallyScrollablePanel;
import org.openstreetmap.josm.spi.preferences.Config;
import org.openstreetmap.josm.tools.CheckParameterUtil;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;

public class AdvancedOAuthPropertiesPanel
extends VerticallyScrollablePanel {
    private final JCheckBox cbUseDefaults = new JCheckBox(I18n.tr("Use default settings", new Object[0]));
    private final JosmTextField tfConsumerKey = new JosmTextField();
    private final JosmTextField tfConsumerSecret = new JosmTextField();
    private final JosmTextField tfRequestTokenURL = new JosmTextField();
    private final JosmTextField tfAccessTokenURL = new JosmTextField();
    private final JosmTextField tfAuthoriseURL = new JosmTextField();
    private final JosmTextField tfOsmLoginURL = new JosmTextField();
    private final JosmTextField tfOsmLogoutURL = new JosmTextField();
    private transient UseDefaultItemListener ilUseDefault;
    private String apiUrl;

    public AdvancedOAuthPropertiesPanel() {
        this.build();
    }

    protected final void build() {
        this.setLayout(new GridBagLayout());
        this.setBorder(BorderFactory.createEmptyBorder(3, 3, 3, 3));
        GridBagConstraints gc = new GridBagConstraints();
        gc.anchor = 18;
        gc.fill = 2;
        gc.weightx = 1.0;
        gc.insets = new Insets(0, 0, 3, 3);
        gc.gridwidth = 2;
        this.add((Component)this.cbUseDefaults, gc);
        gc.gridy = 1;
        gc.weightx = 0.0;
        gc.gridwidth = 1;
        this.add((Component)new JLabel(I18n.tr("Consumer Key:", new Object[0])), gc);
        gc.gridx = 1;
        gc.weightx = 1.0;
        this.add((Component)this.tfConsumerKey, gc);
        SelectAllOnFocusGainedDecorator.decorate(this.tfConsumerKey);
        gc.gridy = 2;
        gc.gridx = 0;
        gc.weightx = 0.0;
        this.add((Component)new JLabel(I18n.tr("Consumer Secret:", new Object[0])), gc);
        gc.gridx = 1;
        gc.weightx = 1.0;
        this.add((Component)this.tfConsumerSecret, gc);
        SelectAllOnFocusGainedDecorator.decorate(this.tfConsumerSecret);
        gc.gridy = 3;
        gc.gridx = 0;
        gc.weightx = 0.0;
        this.add((Component)new JLabel(I18n.tr("Request Token URL:", new Object[0])), gc);
        gc.gridx = 1;
        gc.weightx = 1.0;
        this.add((Component)this.tfRequestTokenURL, gc);
        SelectAllOnFocusGainedDecorator.decorate(this.tfRequestTokenURL);
        gc.gridy = 4;
        gc.gridx = 0;
        gc.weightx = 0.0;
        this.add((Component)new JLabel(I18n.tr("Access Token URL:", new Object[0])), gc);
        gc.gridx = 1;
        gc.weightx = 1.0;
        this.add((Component)this.tfAccessTokenURL, gc);
        SelectAllOnFocusGainedDecorator.decorate(this.tfAccessTokenURL);
        gc.gridy = 5;
        gc.gridx = 0;
        gc.weightx = 0.0;
        this.add((Component)new JLabel(I18n.tr("Authorize URL:", new Object[0])), gc);
        gc.gridx = 1;
        gc.weightx = 1.0;
        this.add((Component)this.tfAuthoriseURL, gc);
        SelectAllOnFocusGainedDecorator.decorate(this.tfAuthoriseURL);
        gc.gridy = 6;
        gc.gridx = 0;
        gc.weightx = 0.0;
        this.add((Component)new JLabel(I18n.tr("OSM login URL:", new Object[0])), gc);
        gc.gridx = 1;
        gc.weightx = 1.0;
        this.add((Component)this.tfOsmLoginURL, gc);
        SelectAllOnFocusGainedDecorator.decorate(this.tfOsmLoginURL);
        gc.gridy = 7;
        gc.gridx = 0;
        gc.weightx = 0.0;
        this.add((Component)new JLabel(I18n.tr("OSM logout URL:", new Object[0])), gc);
        gc.gridx = 1;
        gc.weightx = 1.0;
        this.add((Component)this.tfOsmLogoutURL, gc);
        SelectAllOnFocusGainedDecorator.decorate(this.tfOsmLogoutURL);
        this.ilUseDefault = new UseDefaultItemListener();
        this.cbUseDefaults.addItemListener(this.ilUseDefault);
    }

    protected boolean hasCustomSettings() {
        OAuthParameters params = OAuthParameters.createDefault(this.apiUrl);
        return !params.equals(this.getAdvancedParameters());
    }

    protected boolean confirmOverwriteCustomSettings() {
        HelpAwareOptionPane.ButtonSpec[] buttons = new HelpAwareOptionPane.ButtonSpec[]{new HelpAwareOptionPane.ButtonSpec(I18n.tr("Continue", new Object[0]), ImageProvider.get("ok"), I18n.tr("Click to reset the OAuth settings to default values", new Object[0]), null), new HelpAwareOptionPane.ButtonSpec(I18n.tr("Cancel", new Object[0]), ImageProvider.get("cancel"), I18n.tr("Click to abort resetting to the OAuth default values", new Object[0]), null)};
        return 0 == HelpAwareOptionPane.showOptionDialog(this, I18n.tr("<html>JOSM is about to reset the OAuth settings to default values.<br>The current custom settings are not saved.</html>", new Object[0]), I18n.tr("Overwrite custom OAuth settings?", new Object[0]), 2, null, buttons, buttons[0], HelpUtil.ht("/Dialog/OAuthAuthorisationWizard"));
    }

    protected void resetToDefaultSettings() {
        this.cbUseDefaults.setSelected(true);
        OAuthParameters params = OAuthParameters.createDefault(this.apiUrl);
        this.tfConsumerKey.setText(params.getConsumerKey());
        this.tfConsumerSecret.setText(params.getConsumerSecret());
        this.tfRequestTokenURL.setText(params.getRequestTokenUrl());
        this.tfAccessTokenURL.setText(params.getAccessTokenUrl());
        this.tfAuthoriseURL.setText(params.getAuthoriseUrl());
        this.tfOsmLoginURL.setText(params.getOsmLoginUrl());
        this.tfOsmLogoutURL.setText(params.getOsmLogoutUrl());
        this.setChildComponentsEnabled(false);
    }

    protected void setChildComponentsEnabled(boolean enabled) {
        for (Component c : this.getComponents()) {
            if (!(c instanceof JosmTextField) && !(c instanceof JLabel)) continue;
            c.setEnabled(enabled);
        }
    }

    public OAuthParameters getAdvancedParameters() {
        if (this.cbUseDefaults.isSelected()) {
            return OAuthParameters.createDefault(this.apiUrl);
        }
        return new OAuthParameters(this.tfConsumerKey.getText(), this.tfConsumerSecret.getText(), this.tfRequestTokenURL.getText(), this.tfAccessTokenURL.getText(), this.tfAuthoriseURL.getText(), this.tfOsmLoginURL.getText(), this.tfOsmLogoutURL.getText());
    }

    public void setAdvancedParameters(OAuthParameters parameters) {
        CheckParameterUtil.ensureParameterNotNull(parameters, "parameters");
        if (parameters.equals(OAuthParameters.createDefault(this.apiUrl))) {
            this.cbUseDefaults.setSelected(true);
            this.setChildComponentsEnabled(false);
        } else {
            this.cbUseDefaults.setSelected(false);
            this.setChildComponentsEnabled(true);
            this.tfConsumerKey.setText(parameters.getConsumerKey() == null ? "" : parameters.getConsumerKey());
            this.tfConsumerSecret.setText(parameters.getConsumerSecret() == null ? "" : parameters.getConsumerSecret());
            this.tfRequestTokenURL.setText(parameters.getRequestTokenUrl() == null ? "" : parameters.getRequestTokenUrl());
            this.tfAccessTokenURL.setText(parameters.getAccessTokenUrl() == null ? "" : parameters.getAccessTokenUrl());
            this.tfAuthoriseURL.setText(parameters.getAuthoriseUrl() == null ? "" : parameters.getAuthoriseUrl());
            this.tfOsmLoginURL.setText(parameters.getOsmLoginUrl() == null ? "" : parameters.getOsmLoginUrl());
            this.tfOsmLogoutURL.setText(parameters.getOsmLogoutUrl() == null ? "" : parameters.getOsmLogoutUrl());
        }
    }

    public void initialize(String paramApiUrl) {
        CheckParameterUtil.ensureParameterNotNull(paramApiUrl, "paramApiUrl");
        this.setApiUrl(paramApiUrl);
        boolean useDefault = Config.getPref().getBoolean("oauth.settings.use-default", true);
        this.ilUseDefault.setEnabled(false);
        if (useDefault) {
            this.resetToDefaultSettings();
        } else {
            this.setAdvancedParameters(OAuthParameters.createFromApiUrl(paramApiUrl));
        }
        this.ilUseDefault.setEnabled(true);
    }

    public void rememberPreferences() {
        Config.getPref().putBoolean("oauth.settings.use-default", this.cbUseDefaults.isSelected());
        if (this.cbUseDefaults.isSelected()) {
            new OAuthParameters(null, null, null, null, null, null, null).rememberPreferences();
        } else {
            this.getAdvancedParameters().rememberPreferences();
        }
    }

    public void setApiUrl(String apiUrl) {
        this.apiUrl = apiUrl;
        if (this.cbUseDefaults.isSelected()) {
            this.resetToDefaultSettings();
        }
    }

    class UseDefaultItemListener
    implements ItemListener {
        private boolean enabled;

        UseDefaultItemListener() {
        }

        @Override
        public void itemStateChanged(ItemEvent e) {
            if (!this.enabled) {
                return;
            }
            switch (e.getStateChange()) {
                case 1: {
                    if (AdvancedOAuthPropertiesPanel.this.hasCustomSettings() && !AdvancedOAuthPropertiesPanel.this.confirmOverwriteCustomSettings()) {
                        AdvancedOAuthPropertiesPanel.this.cbUseDefaults.setSelected(false);
                        return;
                    }
                    AdvancedOAuthPropertiesPanel.this.resetToDefaultSettings();
                    break;
                }
                case 2: {
                    AdvancedOAuthPropertiesPanel.this.setChildComponentsEnabled(true);
                    break;
                }
            }
        }

        public void setEnabled(boolean enabled) {
            this.enabled = enabled;
        }
    }
}

