/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.compiled;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.compiled.ClassFileDecompilers;
import com.intellij.psi.impl.compiled.ClsFileImpl;
import com.intellij.psi.impl.java.stubs.PsiJavaFileStub;
import com.intellij.psi.stubs.BinaryFileStubBuilder;
import com.intellij.psi.stubs.PsiFileStub;
import com.intellij.psi.stubs.StubElement;
import com.intellij.util.cls.ClsFormatException;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.indexing.FileContent;
import java.util.ArrayList;
import java.util.Comparator;
import org.jetbrains.annotations.NotNull;

public class ClassFileStubBuilder
implements BinaryFileStubBuilder {
    private static final Logger LOG = Logger.getInstance("#com.intellij.psi.impl.compiled.ClassFileStubBuilder");
    public static final int STUB_VERSION = 20;
    private static final Comparator<Object> CLASS_NAME_COMPARATOR = Comparator.comparing(o -> o.getClass().getName());

    @Override
    public boolean acceptsFile(@NotNull VirtualFile file2) {
        if (file2 == null) {
            ClassFileStubBuilder.$$$reportNull$$$0(0);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public StubElement buildStubTree(@NotNull FileContent fileContent) {
        if (fileContent == null) {
            ClassFileStubBuilder.$$$reportNull$$$0(1);
        }
        VirtualFile file2 = fileContent.getFile();
        byte[] content = fileContent.getContent();
        try {
            file2.setPreloadedContentHint(content);
            ClassFileDecompilers.Decompiler decompiler = ClassFileDecompilers.find(file2);
            if (decompiler instanceof ClassFileDecompilers.Full) {
                PsiFileStub<?> psiFileStub = ((ClassFileDecompilers.Full)decompiler).getStubBuilder().buildFileStub(fileContent);
                file2.setPreloadedContentHint(null);
                return psiFileStub;
            }
        }
        catch (ClsFormatException e) {
            if (LOG.isDebugEnabled()) {
                LOG.debug(file2.getPath(), e);
            }
            LOG.info(file2.getPath() + ": " + e.getMessage());
        }
        try {
            PsiJavaFileStub stub = ClsFileImpl.buildFileStub(file2, content);
            if (stub != null) return stub;
            if (fileContent.getFileName().indexOf(36) >= 0) return stub;
            LOG.info("No stub built for file " + fileContent);
            return stub;
        }
        catch (ClsFormatException e) {
            if (LOG.isDebugEnabled()) {
                LOG.debug(file2.getPath(), e);
            } else {
                LOG.info(file2.getPath() + ": " + e.getMessage());
            }
            file2.setPreloadedContentHint(null);
            return null;
        }
    }

    @Override
    public int getStubVersion() {
        int version = 20;
        ArrayList<ClassFileDecompilers.Decompiler> decompilers = ContainerUtil.newArrayList(ClassFileDecompilers.EP_NAME.getExtensions());
        decompilers.sort(CLASS_NAME_COMPARATOR);
        for (ClassFileDecompilers.Decompiler decompiler : decompilers) {
            if (!(decompiler instanceof ClassFileDecompilers.Full)) continue;
            version = version * 31 + ((ClassFileDecompilers.Full)decompiler).getStubBuilder().getStubVersion() + decompiler.getClass().getName().hashCode();
        }
        return version;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileContent";
                break;
            }
        }
        objectArray2[1] = "com/intellij/psi/impl/compiled/ClassFileStubBuilder";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "acceptsFile";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "buildStubTree";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

