/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;
import org.languagetool.AnalyzedSentence;
import org.languagetool.AnalyzedToken;
import org.languagetool.AnalyzedTokenReadings;
import org.languagetool.rules.Categories;
import org.languagetool.rules.ITSIssueType;
import org.languagetool.rules.RuleMatch;
import org.languagetool.rules.TextLevelRule;

public abstract class AbstractStyleRepeatedWordRule
extends TextLevelRule {
    private static final int MAX_TOKEN_TO_CHECK = 5;
    private static int maxDistanceOfSentences = 1;

    public AbstractStyleRepeatedWordRule(ResourceBundle messages) {
        super(messages);
        super.setCategory(Categories.STYLE.getCategory(messages));
        this.setLocQualityIssueType(ITSIssueType.Style);
        this.setDefaultOff();
    }

    @Override
    public String getId() {
        return "STYLE_REPEATED_WORD_RULE";
    }

    @Override
    public String getDescription() {
        return "Repeated words in consecutive sentences";
    }

    protected abstract String messageSameSentence();

    protected abstract String messageSentenceBefore();

    protected abstract String messageSentenceAfter();

    @Override
    public void setDefaultValue(int numSentences) {
        maxDistanceOfSentences = numSentences;
    }

    @Override
    public int getDefaultValue() {
        return maxDistanceOfSentences;
    }

    protected abstract boolean isTokenToCheck(AnalyzedTokenReadings var1);

    protected abstract boolean isTokenPair(AnalyzedTokenReadings[] var1, int var2, boolean var3);

    private static boolean hasBreakToken(AnalyzedTokenReadings[] tokens) {
        for (int i = 0; i < tokens.length && i < 5; ++i) {
            if (!tokens[i].getToken().equals("-") && !tokens[i].getToken().equals("\u2014") && !tokens[i].getToken().equals("\u2013")) continue;
            return true;
        }
        return false;
    }

    private boolean isTokenInSentence(AnalyzedTokenReadings testToken, AnalyzedTokenReadings[] tokens) {
        return this.isTokenInSentence(testToken, tokens, -1);
    }

    private boolean isTokenInSentence(AnalyzedTokenReadings testToken, AnalyzedTokenReadings[] tokens, int notCheck) {
        if (testToken != null && tokens != null) {
            List<AnalyzedToken> readings = testToken.getReadings();
            if (readings.size() < 1) {
                return false;
            }
            String testBase = readings.get(0).getLemma();
            if (testBase == null) {
                return false;
            }
            for (int i = 0; i < tokens.length; ++i) {
                String base;
                if (i == notCheck || !this.isTokenToCheck(tokens[i]) || (readings = tokens[i].getReadings()).size() <= 0 || (base = readings.get(0).getLemma()) == null || !testBase.equals(base)) continue;
                if (notCheck >= 0) {
                    if (notCheck == i - 2) {
                        return !this.isTokenPair(tokens, i, true);
                    }
                    if (notCheck == i + 2) {
                        return !this.isTokenPair(tokens, i, false);
                    }
                    if ((notCheck == i + 1 || notCheck == i - 1) && testToken.getToken().equals(tokens[i].getToken())) {
                        return false;
                    }
                }
                return true;
            }
        }
        return false;
    }

    @Override
    public RuleMatch[] match(List<AnalyzedSentence> sentences) throws IOException {
        int n;
        ArrayList<RuleMatch> ruleMatches = new ArrayList<RuleMatch>();
        ArrayList<AnalyzedTokenReadings[]> tokenList = new ArrayList<AnalyzedTokenReadings[]>();
        int pos = 0;
        for (n = 0; n < maxDistanceOfSentences && n < sentences.size(); ++n) {
            tokenList.add(sentences.get(n).getTokensWithoutWhitespace());
        }
        for (n = 0; n < sentences.size(); ++n) {
            if (n + maxDistanceOfSentences < sentences.size()) {
                tokenList.add(sentences.get(n + maxDistanceOfSentences).getTokensWithoutWhitespace());
            }
            if (tokenList.size() > 2 * maxDistanceOfSentences + 1) {
                tokenList.remove(0);
            }
            int nTok = maxDistanceOfSentences;
            if (n < maxDistanceOfSentences) {
                nTok = n;
            } else if (n >= sentences.size() - maxDistanceOfSentences) {
                nTok = tokenList.size() - (sentences.size() - n);
            }
            if (!AbstractStyleRepeatedWordRule.hasBreakToken((AnalyzedTokenReadings[])tokenList.get(nTok))) {
                for (int i = 0; i < ((AnalyzedTokenReadings[])tokenList.get(nTok)).length; ++i) {
                    int j;
                    AnalyzedTokenReadings token = ((AnalyzedTokenReadings[])tokenList.get(nTok))[i];
                    if (!this.isTokenToCheck(token)) continue;
                    int isRepeated = 0;
                    if (this.isTokenInSentence(token, (AnalyzedTokenReadings[])tokenList.get(nTok), i)) {
                        isRepeated = 1;
                    }
                    for (j = nTok - 1; isRepeated == 0 && j >= 0 && j >= nTok - maxDistanceOfSentences; --j) {
                        if (!this.isTokenInSentence(token, (AnalyzedTokenReadings[])tokenList.get(j))) continue;
                        isRepeated = 2;
                    }
                    for (j = nTok + 1; isRepeated == 0 && j < tokenList.size() && j <= nTok + maxDistanceOfSentences; ++j) {
                        if (!this.isTokenInSentence(token, (AnalyzedTokenReadings[])tokenList.get(j))) continue;
                        isRepeated = 3;
                    }
                    if (isRepeated == 0) continue;
                    String msg = isRepeated == 1 ? this.messageSameSentence() : (isRepeated == 2 ? this.messageSentenceBefore() : this.messageSentenceAfter());
                    int startPos = pos + token.getStartPos();
                    int endPos = pos + token.getEndPos();
                    RuleMatch ruleMatch = new RuleMatch(this, startPos, endPos, msg);
                    ruleMatches.add(ruleMatch);
                }
            }
            pos += sentences.get(n).getText().length();
        }
        return this.toRuleMatchArray(ruleMatches);
    }
}

