/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.tools;

import java.util.List;
import org.languagetool.JLanguageTool;
import org.languagetool.Language;
import org.languagetool.rules.Category;
import org.languagetool.rules.CategoryId;
import org.languagetool.rules.ITSIssueType;
import org.languagetool.rules.RuleMatch;
import org.languagetool.rules.patterns.AbstractPatternRule;
import org.languagetool.tools.ContextTools;
import org.languagetool.tools.StringTools;

public class RuleMatchAsXmlSerializer {
    private static final int CAPACITY = 200;

    public String getXmlStart(Language lang, Language motherTongue) {
        StringBuilder xml = new StringBuilder(200);
        xml.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n").append("<!-- THIS OUTPUT IS DEPRECATED, PLEASE SEE http://wiki.languagetool.org/http-server FOR A BETTER APPROACH -->\n").append("<matches software=\"LanguageTool\" version=\"4.1\" buildDate=\"").append(JLanguageTool.BUILD_DATE).append("\">\n");
        if (lang != null || motherTongue != null) {
            String languageXml = "<language ";
            String warning = "";
            if (lang != null) {
                languageXml = languageXml + "shortname=\"" + lang.getShortCodeWithCountryAndVariant() + "\" name=\"" + lang.getName() + "\"";
                String longCode = lang.getShortCodeWithCountryAndVariant();
                if ("en".equals(longCode) || "de".equals(longCode)) {
                    xml.append("<!-- NOTE: The language code you selected ('").append(longCode).append("') doesn't support spell checking. Consider using a code with a variant like 'en-US'. -->\n");
                }
            }
            if (!(motherTongue == null || lang != null && motherTongue.getShortCode().equals(lang.getShortCodeWithCountryAndVariant()))) {
                languageXml = languageXml + " mothertongueshortname=\"" + motherTongue.getShortCode() + "\" mothertonguename=\"" + motherTongue.getName() + "\"";
            }
            languageXml = languageXml + "/>\n";
            xml.append(languageXml);
            xml.append(warning);
        }
        return xml.toString();
    }

    public String getXmlEnd() {
        return "</matches>\n";
    }

    public String ruleMatchesToXmlSnippet(List<RuleMatch> ruleMatches, String text, int contextSize) {
        StringBuilder xml = new StringBuilder(200);
        ContextTools contextTools = new ContextTools();
        contextTools.setEscapeHtml(false);
        contextTools.setContextSize(contextSize);
        String startMarker = "__languagetool_start_marker";
        contextTools.setErrorMarkerStart(startMarker);
        contextTools.setErrorMarkerEnd("");
        for (RuleMatch match : ruleMatches) {
            ITSIssueType type;
            Category category;
            AbstractPatternRule pRule;
            String subId = "";
            if (match.getRule() instanceof AbstractPatternRule && (pRule = (AbstractPatternRule)match.getRule()).getSubId() != null) {
                subId = " subId=\"" + RuleMatchAsXmlSerializer.escapeXMLForAPIOutput(pRule.getSubId()) + "\" ";
            }
            xml.append("<error fromy=\"").append(match.getLine()).append('\"').append(" fromx=\"").append(match.getColumn() - 1).append('\"').append(" toy=\"").append(match.getEndLine()).append('\"').append(" tox=\"").append(match.getEndColumn() - 1).append('\"').append(" ruleId=\"").append(match.getRule().getId()).append('\"');
            xml.append(subId);
            String msg = match.getMessage().replaceAll("</?suggestion>", "'");
            xml.append(" msg=\"").append(RuleMatchAsXmlSerializer.escapeXMLForAPIOutput(msg)).append('\"');
            if (!match.getShortMessage().isEmpty()) {
                xml.append(" shortmsg=\"").append(RuleMatchAsXmlSerializer.escapeXMLForAPIOutput(match.getShortMessage())).append('\"');
            }
            xml.append(" replacements=\"").append(RuleMatchAsXmlSerializer.escapeXMLForAPIOutput(String.join((CharSequence)"#", match.getSuggestedReplacements()))).append('\"');
            String context = contextTools.getContext(match.getFromPos(), match.getToPos(), text);
            int contextOffset = context.indexOf(startMarker);
            context = context.replaceFirst(startMarker, "");
            context = context.replaceAll("[\n\r]", " ");
            xml.append(" context=\"").append(StringTools.escapeForXmlAttribute(context)).append('\"').append(" contextoffset=\"").append(contextOffset).append('\"').append(" offset=\"").append(match.getFromPos()).append('\"').append(" errorlength=\"").append(match.getToPos() - match.getFromPos()).append('\"');
            if (match.getRule().getUrl() != null) {
                xml.append(" url=\"").append(RuleMatchAsXmlSerializer.escapeXMLForAPIOutput(match.getRule().getUrl().toString())).append('\"');
            }
            if ((category = match.getRule().getCategory()) != null) {
                xml.append(" category=\"").append(RuleMatchAsXmlSerializer.escapeXMLForAPIOutput(category.getName())).append('\"');
                CategoryId id = category.getId();
                if (id != null) {
                    xml.append(" categoryid=\"").append(RuleMatchAsXmlSerializer.escapeXMLForAPIOutput(id.toString())).append('\"');
                }
            }
            if ((type = match.getRule().getLocQualityIssueType()) != null) {
                xml.append(" locqualityissuetype=\"").append(RuleMatchAsXmlSerializer.escapeXMLForAPIOutput(type.toString())).append('\"');
            }
            xml.append("/>\n");
        }
        return xml.toString();
    }

    public String ruleMatchesToXml(List<RuleMatch> ruleMatches, String text, int contextSize, Language lang, Language motherTongue) {
        return this.getXmlStart(lang, motherTongue) + this.ruleMatchesToXmlSnippet(ruleMatches, text, contextSize) + this.getXmlEnd();
    }

    public String ruleMatchesToXml(List<RuleMatch> ruleMatches, String text, int contextSize, Language lang) {
        return this.getXmlStart(lang, null) + this.ruleMatchesToXmlSnippet(ruleMatches, text, contextSize) + this.getXmlEnd();
    }

    public String ruleMatchesToXml(List<RuleMatch> ruleMatches, String text, int contextSize, StringTools.ApiPrintMode xmlMode, Language lang, List<String> unknownWords) {
        String xmlSnippet = this.ruleMatchesToXmlSnippet(ruleMatches, text, contextSize);
        switch (xmlMode) {
            case START_API: {
                return this.getXmlStart(lang, null) + xmlSnippet;
            }
            case CONTINUE_API: {
                return xmlSnippet;
            }
            case END_API: {
                return xmlSnippet + this.getXmlUnknownWords(unknownWords) + this.getXmlEnd();
            }
            case NORMAL_API: {
                return this.getXmlStart(lang, null) + xmlSnippet + this.getXmlUnknownWords(unknownWords) + this.getXmlEnd();
            }
        }
        throw new IllegalArgumentException("Unknown XML mode: " + (Object)((Object)xmlMode));
    }

    private String getXmlUnknownWords(List<String> unknownWords) {
        StringBuilder xml = new StringBuilder(200);
        if (!unknownWords.isEmpty()) {
            xml.append("<unknown_words>\n");
            for (String word : unknownWords) {
                xml.append("    <word>");
                xml.append(StringTools.escapeForXmlAttribute(word));
                xml.append("</word>\n");
            }
            xml.append("</unknown_words>\n");
        }
        return xml.toString();
    }

    private static String escapeXMLForAPIOutput(String s) {
        return StringTools.escapeForXmlAttribute(s).replaceAll("[\n\r]", " ");
    }
}

