/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.wagon.providers.http.httpclient.impl.cookie;

import org.apache.maven.wagon.providers.http.httpclient.annotation.Immutable;
import org.apache.maven.wagon.providers.http.httpclient.conn.util.PublicSuffixMatcher;
import org.apache.maven.wagon.providers.http.httpclient.cookie.Cookie;
import org.apache.maven.wagon.providers.http.httpclient.cookie.CookieOrigin;
import org.apache.maven.wagon.providers.http.httpclient.cookie.CookieSpec;
import org.apache.maven.wagon.providers.http.httpclient.cookie.CookieSpecProvider;
import org.apache.maven.wagon.providers.http.httpclient.cookie.MalformedCookieException;
import org.apache.maven.wagon.providers.http.httpclient.impl.cookie.BasicDomainHandler;
import org.apache.maven.wagon.providers.http.httpclient.impl.cookie.BasicExpiresHandler;
import org.apache.maven.wagon.providers.http.httpclient.impl.cookie.BasicMaxAgeHandler;
import org.apache.maven.wagon.providers.http.httpclient.impl.cookie.BasicPathHandler;
import org.apache.maven.wagon.providers.http.httpclient.impl.cookie.BasicSecureHandler;
import org.apache.maven.wagon.providers.http.httpclient.impl.cookie.LaxExpiresHandler;
import org.apache.maven.wagon.providers.http.httpclient.impl.cookie.LaxMaxAgeHandler;
import org.apache.maven.wagon.providers.http.httpclient.impl.cookie.PublicSuffixDomainFilter;
import org.apache.maven.wagon.providers.http.httpclient.impl.cookie.RFC6265LaxSpec;
import org.apache.maven.wagon.providers.http.httpclient.impl.cookie.RFC6265StrictSpec;
import org.apache.maven.wagon.providers.http.httpclient.protocol.HttpContext;

@Immutable
public class RFC6265CookieSpecProvider
implements CookieSpecProvider {
    private final CompatibilityLevel compatibilityLevel;
    private final PublicSuffixMatcher publicSuffixMatcher;
    private volatile CookieSpec cookieSpec;

    public RFC6265CookieSpecProvider(CompatibilityLevel compatibilityLevel, PublicSuffixMatcher publicSuffixMatcher) {
        this.compatibilityLevel = compatibilityLevel != null ? compatibilityLevel : CompatibilityLevel.RELAXED;
        this.publicSuffixMatcher = publicSuffixMatcher;
    }

    public RFC6265CookieSpecProvider(PublicSuffixMatcher publicSuffixMatcher) {
        this(CompatibilityLevel.RELAXED, publicSuffixMatcher);
    }

    public RFC6265CookieSpecProvider() {
        this(CompatibilityLevel.RELAXED, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CookieSpec create(HttpContext context) {
        if (this.cookieSpec == null) {
            RFC6265CookieSpecProvider rFC6265CookieSpecProvider = this;
            synchronized (rFC6265CookieSpecProvider) {
                if (this.cookieSpec == null) {
                    switch (this.compatibilityLevel) {
                        case STRICT: {
                            this.cookieSpec = new RFC6265StrictSpec(new BasicPathHandler(), PublicSuffixDomainFilter.decorate(new BasicDomainHandler(), this.publicSuffixMatcher), new BasicMaxAgeHandler(), new BasicSecureHandler(), new BasicExpiresHandler(RFC6265StrictSpec.DATE_PATTERNS));
                            break;
                        }
                        case IE_MEDIUM_SECURITY: {
                            this.cookieSpec = new RFC6265LaxSpec(new BasicPathHandler(){

                                @Override
                                public void validate(Cookie cookie, CookieOrigin origin) throws MalformedCookieException {
                                }
                            }, PublicSuffixDomainFilter.decorate(new BasicDomainHandler(), this.publicSuffixMatcher), new BasicMaxAgeHandler(), new BasicSecureHandler(), new BasicExpiresHandler(RFC6265StrictSpec.DATE_PATTERNS));
                            break;
                        }
                        default: {
                            this.cookieSpec = new RFC6265LaxSpec(new BasicPathHandler(), PublicSuffixDomainFilter.decorate(new BasicDomainHandler(), this.publicSuffixMatcher), new LaxMaxAgeHandler(), new BasicSecureHandler(), new LaxExpiresHandler());
                        }
                    }
                }
            }
        }
        return this.cookieSpec;
    }

    public static enum CompatibilityLevel {
        STRICT,
        RELAXED,
        IE_MEDIUM_SECURITY;

    }
}

