/*
 * Decompiled with CFR 0.152.
 */
package com.zeroc.IceInternal;

import com.zeroc.Ice.ConnectionLostException;
import com.zeroc.Ice.LocalException;
import com.zeroc.Ice.SocketException;
import com.zeroc.IceInternal.Buffer;
import com.zeroc.IceInternal.Network;
import com.zeroc.IceInternal.NetworkProxy;
import com.zeroc.IceInternal.ProtocolInstance;
import com.zeroc.IceUtilInternal.Assert;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.SocketChannel;

public class StreamSocket {
    private final ProtocolInstance _instance;
    private final NetworkProxy _proxy;
    private final InetSocketAddress _addr;
    private SocketChannel _fd;
    private int _maxSendPacketSize;
    private int _state;
    private String _desc;

    public StreamSocket(ProtocolInstance instance, NetworkProxy proxy, InetSocketAddress addr, InetSocketAddress sourceAddr) {
        this._instance = instance;
        this._proxy = proxy;
        this._addr = addr;
        this._fd = Network.createTcpSocket();
        this._state = 0;
        try {
            this.init();
            if (Network.doConnect(this._fd, this._proxy != null ? this._proxy.getAddress() : this._addr, sourceAddr)) {
                this._state = this._proxy != null ? 3 : 5;
            }
        }
        catch (LocalException ex) {
            assert (!this._fd.isOpen());
            this._fd = null;
            throw ex;
        }
        this._desc = Network.fdToString(this._fd, this._proxy, this._addr);
    }

    public StreamSocket(ProtocolInstance instance, SocketChannel fd) {
        this._instance = instance;
        this._proxy = null;
        this._addr = null;
        this._fd = fd;
        this._state = 5;
        try {
            this.init();
        }
        catch (LocalException ex) {
            assert (!this._fd.isOpen());
            this._fd = null;
            throw ex;
        }
        this._desc = Network.fdToString(this._fd);
    }

    protected synchronized void finalize() throws Throwable {
        try {
            Assert.FinalizerAssert(this._fd == null);
        }
        catch (Exception exception) {
        }
        finally {
            super.finalize();
        }
    }

    public void setBufferSize(int rcvSize, int sndSize) {
        Network.setTcpBufSize(this._fd, rcvSize, sndSize, this._instance);
    }

    public int connect(Buffer readBuffer, Buffer writeBuffer) {
        if (this._state == 0) {
            this._state = 1;
            return 8;
        }
        if (this._state <= 1) {
            Network.doFinishConnect(this._fd);
            this._desc = Network.fdToString(this._fd, this._proxy, this._addr);
            int n = this._state = this._proxy != null ? 3 : 5;
        }
        if (this._state == 3) {
            this._proxy.beginWrite(this._addr, writeBuffer);
            return 4;
        }
        if (this._state == 2) {
            this._proxy.beginRead(readBuffer);
            return 1;
        }
        if (this._state == 4) {
            this._proxy.finish(readBuffer, writeBuffer);
            readBuffer.clear();
            writeBuffer.clear();
            this._state = 5;
        }
        assert (this._state == 5);
        return 0;
    }

    public boolean isConnected() {
        return this._state == 5;
    }

    public SocketChannel fd() {
        return this._fd;
    }

    public int read(Buffer buf) {
        if (this._state == 2) {
            do {
                int ret;
                if ((ret = this.read(buf.b)) == 0) {
                    return 1;
                }
                this._state = this.toState(this._proxy.endRead(buf));
            } while (this._state == 2);
            return 0;
        }
        this.read(buf.b);
        return buf.b.hasRemaining() ? 1 : 0;
    }

    public int write(Buffer buf) {
        if (this._state == 3) {
            do {
                int ret;
                if ((ret = this.write(buf.b)) == 0) {
                    return 4;
                }
                this._state = this.toState(this._proxy.endWrite(buf));
            } while (this._state == 3);
            return 0;
        }
        this.write(buf.b);
        return buf.b.hasRemaining() ? 4 : 0;
    }

    public int read(ByteBuffer buf) {
        assert (this._fd != null);
        int read = 0;
        while (buf.hasRemaining()) {
            try {
                int ret = this._fd.read(buf);
                if (ret == -1) {
                    throw new ConnectionLostException();
                }
                if (ret == 0) {
                    return read;
                }
                read += ret;
            }
            catch (InterruptedIOException ex) {
            }
            catch (IOException ex) {
                throw new ConnectionLostException(ex);
            }
        }
        return read;
    }

    public int write(ByteBuffer buf) {
        assert (this._fd != null);
        int sent = 0;
        while (buf.hasRemaining()) {
            try {
                int ret;
                if (this._maxSendPacketSize > 0 && buf.remaining() > this._maxSendPacketSize) {
                    int previous = buf.limit();
                    buf.limit(buf.position() + this._maxSendPacketSize);
                    ret = this._fd.write(buf);
                    buf.limit(previous);
                } else {
                    ret = this._fd.write(buf);
                }
                if (ret == -1) {
                    throw new ConnectionLostException();
                }
                if (ret == 0) {
                    return sent;
                }
                sent += ret;
            }
            catch (InterruptedIOException ex) {
            }
            catch (IOException ex) {
                throw new SocketException(ex);
            }
        }
        return sent;
    }

    public void close() {
        assert (this._fd != null);
        try {
            this._fd.close();
        }
        catch (IOException ex) {
            throw new SocketException(ex);
        }
        finally {
            this._fd = null;
        }
    }

    public String toString() {
        return this._desc;
    }

    private void init() {
        Network.setBlock(this._fd, false);
        Network.setTcpBufSize(this._fd, this._instance);
        this._maxSendPacketSize = System.getProperty("os.name").startsWith("Windows") ? Math.max(512, Network.getSendBufferSize(this._fd) / 2) : 0;
    }

    private int toState(int operation) {
        switch (operation) {
            case 1: {
                return 2;
            }
            case 4: {
                return 3;
            }
        }
        return 4;
    }
}

