// **********************************************************************
//
// Copyright (c) 2003-2017 ZeroC, Inc. All rights reserved.
//
// This copy of Ice is licensed to you under the terms described in the
// ICE_LICENSE file included in this distribution.
//
// **********************************************************************
//
// Ice version 3.7.0
//
// <auto-generated>
//
// Generated from file `Router.ice'
//
// Warning: do not edit this file.
//
// </auto-generated>
//

package com.zeroc.Ice;

/**
 * The Ice router interface. Routers can be set either globally with
 * {@link Communicator#setDefaultRouter}, or with <tt>ice_router</tt> on specific
 * proxies.
 **/
public interface RouterPrx extends com.zeroc.Ice.ObjectPrx
{
    /**
     * Get the router's client proxy, i.e., the proxy to use for
     * forwarding requests from the client to the router.
     *
     * If a null proxy is returned, the client will forward requests
     * to the router's endpoints.
     * @return An instance of Router.GetClientProxyResult.
     **/
    default Router.GetClientProxyResult getClientProxy()
    {
        return getClientProxy(com.zeroc.Ice.ObjectPrx.noExplicitContext);
    }

    /**
     * Get the router's client proxy, i.e., the proxy to use for
     * forwarding requests from the client to the router.
     *
     * If a null proxy is returned, the client will forward requests
     * to the router's endpoints.
     * @param context The Context map to send with the invocation.
     * @return An instance of Router.GetClientProxyResult.
     **/
    default Router.GetClientProxyResult getClientProxy(java.util.Map<String, String> context)
    {
        return _iceI_getClientProxyAsync(context, true).waitForResponse();
    }

    /**
     * Get the router's client proxy, i.e., the proxy to use for
     * forwarding requests from the client to the router.
     *
     * If a null proxy is returned, the client will forward requests
     * to the router's endpoints.
     * @return A future that will be completed with an instance of Router.GetClientProxyResult.
     **/
    default java.util.concurrent.CompletableFuture<Router.GetClientProxyResult> getClientProxyAsync()
    {
        return _iceI_getClientProxyAsync(com.zeroc.Ice.ObjectPrx.noExplicitContext, false);
    }

    /**
     * Get the router's client proxy, i.e., the proxy to use for
     * forwarding requests from the client to the router.
     *
     * If a null proxy is returned, the client will forward requests
     * to the router's endpoints.
     * @param context The Context map to send with the invocation.
     * @return A future that will be completed with an instance of Router.GetClientProxyResult.
     **/
    default java.util.concurrent.CompletableFuture<Router.GetClientProxyResult> getClientProxyAsync(java.util.Map<String, String> context)
    {
        return _iceI_getClientProxyAsync(context, false);
    }

    default com.zeroc.IceInternal.OutgoingAsync<Router.GetClientProxyResult> _iceI_getClientProxyAsync(java.util.Map<String, String> context, boolean sync)
    {
        com.zeroc.IceInternal.OutgoingAsync<Router.GetClientProxyResult> f = new com.zeroc.IceInternal.OutgoingAsync<>(this, "getClientProxy", com.zeroc.Ice.OperationMode.Nonmutating, sync, null);
        f.invoke(true, context, null, null, istr -> {
                     Router.GetClientProxyResult ret = new Router.GetClientProxyResult();
                     ret.read(istr);
                     return ret;
                 });
        return f;
    }

    /**
     * Get the router's server proxy, i.e., the proxy to use for
     * forwarding requests from the server to the router.
     * @return The router's server proxy.
     **/
    default com.zeroc.Ice.ObjectPrx getServerProxy()
    {
        return getServerProxy(com.zeroc.Ice.ObjectPrx.noExplicitContext);
    }

    /**
     * Get the router's server proxy, i.e., the proxy to use for
     * forwarding requests from the server to the router.
     * @param context The Context map to send with the invocation.
     * @return The router's server proxy.
     **/
    default com.zeroc.Ice.ObjectPrx getServerProxy(java.util.Map<String, String> context)
    {
        return _iceI_getServerProxyAsync(context, true).waitForResponse();
    }

    /**
     * Get the router's server proxy, i.e., the proxy to use for
     * forwarding requests from the server to the router.
     * @return The router's server proxy.
     **/
    default java.util.concurrent.CompletableFuture<com.zeroc.Ice.ObjectPrx> getServerProxyAsync()
    {
        return _iceI_getServerProxyAsync(com.zeroc.Ice.ObjectPrx.noExplicitContext, false);
    }

    /**
     * Get the router's server proxy, i.e., the proxy to use for
     * forwarding requests from the server to the router.
     * @param context The Context map to send with the invocation.
     * @return The router's server proxy.
     **/
    default java.util.concurrent.CompletableFuture<com.zeroc.Ice.ObjectPrx> getServerProxyAsync(java.util.Map<String, String> context)
    {
        return _iceI_getServerProxyAsync(context, false);
    }

    default com.zeroc.IceInternal.OutgoingAsync<com.zeroc.Ice.ObjectPrx> _iceI_getServerProxyAsync(java.util.Map<String, String> context, boolean sync)
    {
        com.zeroc.IceInternal.OutgoingAsync<com.zeroc.Ice.ObjectPrx> f = new com.zeroc.IceInternal.OutgoingAsync<>(this, "getServerProxy", com.zeroc.Ice.OperationMode.Nonmutating, sync, null);
        f.invoke(true, context, null, null, istr -> {
                     com.zeroc.Ice.ObjectPrx ret;
                     ret = istr.readProxy();
                     return ret;
                 });
        return f;
    }

    /**
     * Add new proxy information to the router's routing table.
     * @param proxies The proxies to add.
     * @return Proxies discarded by the router.
     **/
    default com.zeroc.Ice.ObjectPrx[] addProxies(com.zeroc.Ice.ObjectPrx[] proxies)
    {
        return addProxies(proxies, com.zeroc.Ice.ObjectPrx.noExplicitContext);
    }

    /**
     * Add new proxy information to the router's routing table.
     * @param proxies The proxies to add.
     * @param context The Context map to send with the invocation.
     * @return Proxies discarded by the router.
     **/
    default com.zeroc.Ice.ObjectPrx[] addProxies(com.zeroc.Ice.ObjectPrx[] proxies, java.util.Map<String, String> context)
    {
        return _iceI_addProxiesAsync(proxies, context, true).waitForResponse();
    }

    /**
     * Add new proxy information to the router's routing table.
     * @param proxies The proxies to add.
     * @return Proxies discarded by the router.
     **/
    default java.util.concurrent.CompletableFuture<com.zeroc.Ice.ObjectPrx[]> addProxiesAsync(com.zeroc.Ice.ObjectPrx[] proxies)
    {
        return _iceI_addProxiesAsync(proxies, com.zeroc.Ice.ObjectPrx.noExplicitContext, false);
    }

    /**
     * Add new proxy information to the router's routing table.
     * @param proxies The proxies to add.
     * @param context The Context map to send with the invocation.
     * @return Proxies discarded by the router.
     **/
    default java.util.concurrent.CompletableFuture<com.zeroc.Ice.ObjectPrx[]> addProxiesAsync(com.zeroc.Ice.ObjectPrx[] proxies, java.util.Map<String, String> context)
    {
        return _iceI_addProxiesAsync(proxies, context, false);
    }

    default com.zeroc.IceInternal.OutgoingAsync<com.zeroc.Ice.ObjectPrx[]> _iceI_addProxiesAsync(com.zeroc.Ice.ObjectPrx[] iceP_proxies, java.util.Map<String, String> context, boolean sync)
    {
        com.zeroc.IceInternal.OutgoingAsync<com.zeroc.Ice.ObjectPrx[]> f = new com.zeroc.IceInternal.OutgoingAsync<>(this, "addProxies", com.zeroc.Ice.OperationMode.Idempotent, sync, null);
        f.invoke(true, context, null, ostr -> {
                     ObjectProxySeqHelper.write(ostr, iceP_proxies);
                 }, istr -> {
                     com.zeroc.Ice.ObjectPrx[] ret;
                     ret = ObjectProxySeqHelper.read(istr);
                     return ret;
                 });
        return f;
    }

    /**
     * Contacts the remote server to verify that the object implements this type.
     * Raises a local exception if a communication error occurs.
     * @param obj The untyped proxy.
     * @return A proxy for this type, or null if the object does not support this type.
     **/
    static RouterPrx checkedCast(com.zeroc.Ice.ObjectPrx obj)
    {
        return com.zeroc.Ice.ObjectPrx._checkedCast(obj, ice_staticId(), RouterPrx.class, _RouterPrxI.class);
    }

    /**
     * Contacts the remote server to verify that the object implements this type.
     * Raises a local exception if a communication error occurs.
     * @param obj The untyped proxy.
     * @param context The Context map to send with the invocation.
     * @return A proxy for this type, or null if the object does not support this type.
     **/
    static RouterPrx checkedCast(com.zeroc.Ice.ObjectPrx obj, java.util.Map<String, String> context)
    {
        return com.zeroc.Ice.ObjectPrx._checkedCast(obj, context, ice_staticId(), RouterPrx.class, _RouterPrxI.class);
    }

    /**
     * Contacts the remote server to verify that a facet of the object implements this type.
     * Raises a local exception if a communication error occurs.
     * @param obj The untyped proxy.
     * @param facet The name of the desired facet.
     * @return A proxy for this type, or null if the object does not support this type.
     **/
    static RouterPrx checkedCast(com.zeroc.Ice.ObjectPrx obj, String facet)
    {
        return com.zeroc.Ice.ObjectPrx._checkedCast(obj, facet, ice_staticId(), RouterPrx.class, _RouterPrxI.class);
    }

    /**
     * Contacts the remote server to verify that a facet of the object implements this type.
     * Raises a local exception if a communication error occurs.
     * @param obj The untyped proxy.
     * @param facet The name of the desired facet.
     * @param context The Context map to send with the invocation.
     * @return A proxy for this type, or null if the object does not support this type.
     **/
    static RouterPrx checkedCast(com.zeroc.Ice.ObjectPrx obj, String facet, java.util.Map<String, String> context)
    {
        return com.zeroc.Ice.ObjectPrx._checkedCast(obj, facet, context, ice_staticId(), RouterPrx.class, _RouterPrxI.class);
    }

    /**
     * Downcasts the given proxy to this type without contacting the remote server.
     * @param obj The untyped proxy.
     * @return A proxy for this type.
     **/
    static RouterPrx uncheckedCast(com.zeroc.Ice.ObjectPrx obj)
    {
        return com.zeroc.Ice.ObjectPrx._uncheckedCast(obj, RouterPrx.class, _RouterPrxI.class);
    }

    /**
     * Downcasts the given proxy to this type without contacting the remote server.
     * @param obj The untyped proxy.
     * @param facet The name of the desired facet.
     * @return A proxy for this type.
     **/
    static RouterPrx uncheckedCast(com.zeroc.Ice.ObjectPrx obj, String facet)
    {
        return com.zeroc.Ice.ObjectPrx._uncheckedCast(obj, facet, RouterPrx.class, _RouterPrxI.class);
    }

    /**
     * Returns a proxy that is identical to this proxy, except for the per-proxy context.
     * @param newContext The context for the new proxy.
     * @return A proxy with the specified per-proxy context.
     **/
    @Override
    default RouterPrx ice_context(java.util.Map<String, String> newContext)
    {
        return (RouterPrx)_ice_context(newContext);
    }

    /**
     * Returns a proxy that is identical to this proxy, except for the adapter ID.
     * @param newAdapterId The adapter ID for the new proxy.
     * @return A proxy with the specified adapter ID.
     **/
    @Override
    default RouterPrx ice_adapterId(String newAdapterId)
    {
        return (RouterPrx)_ice_adapterId(newAdapterId);
    }

    /**
     * Returns a proxy that is identical to this proxy, except for the endpoints.
     * @param newEndpoints The endpoints for the new proxy.
     * @return A proxy with the specified endpoints.
     **/
    @Override
    default RouterPrx ice_endpoints(com.zeroc.Ice.Endpoint[] newEndpoints)
    {
        return (RouterPrx)_ice_endpoints(newEndpoints);
    }

    /**
     * Returns a proxy that is identical to this proxy, except for the locator cache timeout.
     * @param newTimeout The new locator cache timeout (in seconds).
     * @return A proxy with the specified locator cache timeout.
     **/
    @Override
    default RouterPrx ice_locatorCacheTimeout(int newTimeout)
    {
        return (RouterPrx)_ice_locatorCacheTimeout(newTimeout);
    }

    /**
     * Returns a proxy that is identical to this proxy, except for the invocation timeout.
     * @param newTimeout The new invocation timeout (in seconds).
     * @return A proxy with the specified invocation timeout.
     **/
    @Override
    default RouterPrx ice_invocationTimeout(int newTimeout)
    {
        return (RouterPrx)_ice_invocationTimeout(newTimeout);
    }

    /**
     * Returns a proxy that is identical to this proxy, except for connection caching.
     * @param newCache <code>true</code> if the new proxy should cache connections; <code>false</code> otherwise.
     * @return A proxy with the specified caching policy.
     **/
    @Override
    default RouterPrx ice_connectionCached(boolean newCache)
    {
        return (RouterPrx)_ice_connectionCached(newCache);
    }

    /**
     * Returns a proxy that is identical to this proxy, except for the endpoint selection policy.
     * @param newType The new endpoint selection policy.
     * @return A proxy with the specified endpoint selection policy.
     **/
    @Override
    default RouterPrx ice_endpointSelection(com.zeroc.Ice.EndpointSelectionType newType)
    {
        return (RouterPrx)_ice_endpointSelection(newType);
    }

    /**
     * Returns a proxy that is identical to this proxy, except for how it selects endpoints.
     * @param b If <code>b</code> is <code>true</code>, only endpoints that use a secure transport are
     * used by the new proxy. If <code>b</code> is false, the returned proxy uses both secure and
     * insecure endpoints.
     * @return A proxy with the specified selection policy.
     **/
    @Override
    default RouterPrx ice_secure(boolean b)
    {
        return (RouterPrx)_ice_secure(b);
    }

    /**
     * Returns a proxy that is identical to this proxy, except for the encoding used to marshal parameters.
     * @param e The encoding version to use to marshal request parameters.
     * @return A proxy with the specified encoding version.
     **/
    @Override
    default RouterPrx ice_encodingVersion(com.zeroc.Ice.EncodingVersion e)
    {
        return (RouterPrx)_ice_encodingVersion(e);
    }

    /**
     * Returns a proxy that is identical to this proxy, except for its endpoint selection policy.
     * @param b If <code>b</code> is <code>true</code>, the new proxy will use secure endpoints for invocations
     * and only use insecure endpoints if an invocation cannot be made via secure endpoints. If <code>b</code> is
     * <code>false</code>, the proxy prefers insecure endpoints to secure ones.
     * @return A proxy with the specified selection policy.
     **/
    @Override
    default RouterPrx ice_preferSecure(boolean b)
    {
        return (RouterPrx)_ice_preferSecure(b);
    }

    /**
     * Returns a proxy that is identical to this proxy, except for the router.
     * @param router The router for the new proxy.
     * @return A proxy with the specified router.
     **/
    @Override
    default RouterPrx ice_router(com.zeroc.Ice.RouterPrx router)
    {
        return (RouterPrx)_ice_router(router);
    }

    /**
     * Returns a proxy that is identical to this proxy, except for the locator.
     * @param locator The locator for the new proxy.
     * @return A proxy with the specified locator.
     **/
    @Override
    default RouterPrx ice_locator(com.zeroc.Ice.LocatorPrx locator)
    {
        return (RouterPrx)_ice_locator(locator);
    }

    /**
     * Returns a proxy that is identical to this proxy, except for collocation optimization.
     * @param b <code>true</code> if the new proxy enables collocation optimization; <code>false</code> otherwise.
     * @return A proxy with the specified collocation optimization.
     **/
    @Override
    default RouterPrx ice_collocationOptimized(boolean b)
    {
        return (RouterPrx)_ice_collocationOptimized(b);
    }

    /**
     * Returns a proxy that is identical to this proxy, but uses twoway invocations.
     * @return A proxy that uses twoway invocations.
     **/
    @Override
    default RouterPrx ice_twoway()
    {
        return (RouterPrx)_ice_twoway();
    }

    /**
     * Returns a proxy that is identical to this proxy, but uses oneway invocations.
     * @return A proxy that uses oneway invocations.
     **/
    @Override
    default RouterPrx ice_oneway()
    {
        return (RouterPrx)_ice_oneway();
    }

    /**
     * Returns a proxy that is identical to this proxy, but uses batch oneway invocations.
     * @return A proxy that uses batch oneway invocations.
     **/
    @Override
    default RouterPrx ice_batchOneway()
    {
        return (RouterPrx)_ice_batchOneway();
    }

    /**
     * Returns a proxy that is identical to this proxy, but uses datagram invocations.
     * @return A proxy that uses datagram invocations.
     **/
    @Override
    default RouterPrx ice_datagram()
    {
        return (RouterPrx)_ice_datagram();
    }

    /**
     * Returns a proxy that is identical to this proxy, but uses batch datagram invocations.
     * @return A proxy that uses batch datagram invocations.
     **/
    @Override
    default RouterPrx ice_batchDatagram()
    {
        return (RouterPrx)_ice_batchDatagram();
    }

    /**
     * Returns a proxy that is identical to this proxy, except for compression.
     * @param co <code>true</code> enables compression for the new proxy; <code>false</code> disables compression.
     * @return A proxy with the specified compression setting.
     **/
    @Override
    default RouterPrx ice_compress(boolean co)
    {
        return (RouterPrx)_ice_compress(co);
    }

    /**
     * Returns a proxy that is identical to this proxy, except for its connection timeout setting.
     * @param t The connection timeout for the proxy in milliseconds.
     * @return A proxy with the specified timeout.
     **/
    @Override
    default RouterPrx ice_timeout(int t)
    {
        return (RouterPrx)_ice_timeout(t);
    }

    /**
     * Returns a proxy that is identical to this proxy, except for its connection ID.
     * @param connectionId The connection ID for the new proxy. An empty string removes the connection ID.
     * @return A proxy with the specified connection ID.
     **/
    @Override
    default RouterPrx ice_connectionId(String connectionId)
    {
        return (RouterPrx)_ice_connectionId(connectionId);
    }

    static String ice_staticId()
    {
        return "::Ice::Router";
    }
}
