// **********************************************************************
//
// Copyright (c) 2003-2017 ZeroC, Inc. All rights reserved.
//
// This copy of Ice is licensed to you under the terms described in the
// ICE_LICENSE file included in this distribution.
//
// **********************************************************************
//
// Ice version 3.7.0
//
// <auto-generated>
//
// Generated from file `Admin.ice'
//
// Warning: do not edit this file.
//
// </auto-generated>
//

package IceGrid;

/**
 * This interface provides access to IceGrid log file contents.
 *
 **/
public interface FileIteratorPrx extends Ice.ObjectPrx
{
    /**
     * Read lines from the log file.
     *
     * @param size Specifies the maximum number of bytes to be
     * received. The server will ensure that the returned message
     * doesn't exceed the given size.
     *
     * @param lines The lines read from the file. If there was nothing to
     * read from the file since the last call to read, an empty
     * sequence is returned. The last line of the sequence is always
     * incomplete (and therefore no '\n' should be added when writing
     * the last line to the to the output device).
     *
     * @return True if EOF is encountered.
     *
     * @throws FileNotAvailableException Raised if there was a problem
     * to read lines from the file.
     *
     **/
    public boolean read(int size, Ice.StringSeqHolder lines)
        throws FileNotAvailableException;

    /**
     * Read lines from the log file.
     *
     * @param size Specifies the maximum number of bytes to be
     * received. The server will ensure that the returned message
     * doesn't exceed the given size.
     *
     * @param lines The lines read from the file. If there was nothing to
     * read from the file since the last call to read, an empty
     * sequence is returned. The last line of the sequence is always
     * incomplete (and therefore no '\n' should be added when writing
     * the last line to the to the output device).
     *
     * @param context The Context map to send with the invocation.
     * @return True if EOF is encountered.
     *
     * @throws FileNotAvailableException Raised if there was a problem
     * to read lines from the file.
     *
     **/
    public boolean read(int size, Ice.StringSeqHolder lines, java.util.Map<String, String> context)
        throws FileNotAvailableException;

    /**
     * Read lines from the log file.
     *
     * @param size Specifies the maximum number of bytes to be
     * received. The server will ensure that the returned message
     * doesn't exceed the given size.
     *
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_read(int size);

    /**
     * Read lines from the log file.
     *
     * @param size Specifies the maximum number of bytes to be
     * received. The server will ensure that the returned message
     * doesn't exceed the given size.
     *
     * @param context The Context map to send with the invocation.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_read(int size, java.util.Map<String, String> context);

    /**
     * Read lines from the log file.
     *
     * @param size Specifies the maximum number of bytes to be
     * received. The server will ensure that the returned message
     * doesn't exceed the given size.
     *
     * @param cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_read(int size, Ice.Callback cb);

    /**
     * Read lines from the log file.
     *
     * @param size Specifies the maximum number of bytes to be
     * received. The server will ensure that the returned message
     * doesn't exceed the given size.
     *
     * @param context The Context map to send with the invocation.
     * @param cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_read(int size, java.util.Map<String, String> context, Ice.Callback cb);

    /**
     * Read lines from the log file.
     *
     * @param size Specifies the maximum number of bytes to be
     * received. The server will ensure that the returned message
     * doesn't exceed the given size.
     *
     * @param cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_read(int size, Callback_FileIterator_read cb);

    /**
     * Read lines from the log file.
     *
     * @param size Specifies the maximum number of bytes to be
     * received. The server will ensure that the returned message
     * doesn't exceed the given size.
     *
     * @param context The Context map to send with the invocation.
     * @param cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_read(int size, java.util.Map<String, String> context, Callback_FileIterator_read cb);

    public interface FunctionalCallback_FileIterator_read_Response
    {
        void apply(boolean ret, String[] lines);
    }

    /**
     * Read lines from the log file.
     *
     * @param size Specifies the maximum number of bytes to be
     * received. The server will ensure that the returned message
     * doesn't exceed the given size.
     *
     * @param responseCb The lambda response callback.
     * @param userExceptionCb The lambda user exception callback.
     * @param exceptionCb The lambda exception callback.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_read(int size,
                                      FunctionalCallback_FileIterator_read_Response responseCb,
                                      IceInternal.Functional_GenericCallback1<Ice.UserException> userExceptionCb,
                                      IceInternal.Functional_GenericCallback1<Ice.Exception> exceptionCb);

    /**
     * Read lines from the log file.
     *
     * @param size Specifies the maximum number of bytes to be
     * received. The server will ensure that the returned message
     * doesn't exceed the given size.
     *
     * @param responseCb The lambda response callback.
     * @param userExceptionCb The lambda user exception callback.
     * @param exceptionCb The lambda exception callback.
     * @param sentCb The lambda sent callback.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_read(int size,
                                      FunctionalCallback_FileIterator_read_Response responseCb,
                                      IceInternal.Functional_GenericCallback1<Ice.UserException> userExceptionCb,
                                      IceInternal.Functional_GenericCallback1<Ice.Exception> exceptionCb,
                                      IceInternal.Functional_BoolCallback sentCb);

    /**
     * Read lines from the log file.
     *
     * @param size Specifies the maximum number of bytes to be
     * received. The server will ensure that the returned message
     * doesn't exceed the given size.
     *
     * @param context The Context map to send with the invocation.
     * @param responseCb The lambda response callback.
     * @param userExceptionCb The lambda user exception callback.
     * @param exceptionCb The lambda exception callback.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_read(int size,
                                      java.util.Map<String, String> context,
                                      FunctionalCallback_FileIterator_read_Response responseCb,
                                      IceInternal.Functional_GenericCallback1<Ice.UserException> userExceptionCb,
                                      IceInternal.Functional_GenericCallback1<Ice.Exception> exceptionCb);

    /**
     * Read lines from the log file.
     *
     * @param size Specifies the maximum number of bytes to be
     * received. The server will ensure that the returned message
     * doesn't exceed the given size.
     *
     * @param context The Context map to send with the invocation.
     * @param responseCb The lambda response callback.
     * @param userExceptionCb The lambda user exception callback.
     * @param exceptionCb The lambda exception callback.
     * @param sentCb The lambda sent callback.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_read(int size,
                                      java.util.Map<String, String> context,
                                      FunctionalCallback_FileIterator_read_Response responseCb,
                                      IceInternal.Functional_GenericCallback1<Ice.UserException> userExceptionCb,
                                      IceInternal.Functional_GenericCallback1<Ice.Exception> exceptionCb,
                                      IceInternal.Functional_BoolCallback sentCb);

    /**
     * Read lines from the log file.
     *
     * @param lines The lines read from the file. If there was nothing to
     * read from the file since the last call to read, an empty
     * sequence is returned. The last line of the sequence is always
     * incomplete (and therefore no '\n' should be added when writing
     * the last line to the to the output device).
     *
     * @param result The asynchronous result object.
     * @return True if EOF is encountered.
     *
     * @throws FileNotAvailableException Raised if there was a problem
     * to read lines from the file.
     *
     **/
    public boolean end_read(Ice.StringSeqHolder lines, Ice.AsyncResult result)
        throws FileNotAvailableException;

    /**
     * Destroy the iterator.
     *
     **/
    public void destroy();

    /**
     * Destroy the iterator.
     *
     * @param context The Context map to send with the invocation.
     **/
    public void destroy(java.util.Map<String, String> context);

    /**
     * Destroy the iterator.
     *
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_destroy();

    /**
     * Destroy the iterator.
     *
     * @param context The Context map to send with the invocation.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_destroy(java.util.Map<String, String> context);

    /**
     * Destroy the iterator.
     *
     * @param cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_destroy(Ice.Callback cb);

    /**
     * Destroy the iterator.
     *
     * @param context The Context map to send with the invocation.
     * @param cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_destroy(java.util.Map<String, String> context, Ice.Callback cb);

    /**
     * Destroy the iterator.
     *
     * @param cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_destroy(Callback_FileIterator_destroy cb);

    /**
     * Destroy the iterator.
     *
     * @param context The Context map to send with the invocation.
     * @param cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_destroy(java.util.Map<String, String> context, Callback_FileIterator_destroy cb);

    /**
     * Destroy the iterator.
     *
     * @param responseCb The lambda response callback.
     * @param exceptionCb The lambda exception callback.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_destroy(IceInternal.Functional_VoidCallback responseCb,
                                         IceInternal.Functional_GenericCallback1<Ice.Exception> exceptionCb);

    /**
     * Destroy the iterator.
     *
     * @param responseCb The lambda response callback.
     * @param exceptionCb The lambda exception callback.
     * @param sentCb The lambda sent callback.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_destroy(IceInternal.Functional_VoidCallback responseCb,
                                         IceInternal.Functional_GenericCallback1<Ice.Exception> exceptionCb,
                                         IceInternal.Functional_BoolCallback sentCb);

    /**
     * Destroy the iterator.
     *
     * @param context The Context map to send with the invocation.
     * @param responseCb The lambda response callback.
     * @param exceptionCb The lambda exception callback.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_destroy(java.util.Map<String, String> context,
                                         IceInternal.Functional_VoidCallback responseCb,
                                         IceInternal.Functional_GenericCallback1<Ice.Exception> exceptionCb);

    /**
     * Destroy the iterator.
     *
     * @param context The Context map to send with the invocation.
     * @param responseCb The lambda response callback.
     * @param exceptionCb The lambda exception callback.
     * @param sentCb The lambda sent callback.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_destroy(java.util.Map<String, String> context,
                                         IceInternal.Functional_VoidCallback responseCb,
                                         IceInternal.Functional_GenericCallback1<Ice.Exception> exceptionCb,
                                         IceInternal.Functional_BoolCallback sentCb);

    /**
     * Destroy the iterator.
     *
     * @param result The asynchronous result object.
     **/
    public void end_destroy(Ice.AsyncResult result);
}
