/*
 * Decompiled with CFR 0.152.
 */
package com.zeroc.Ice;

import com.zeroc.Ice.InputStream;
import com.zeroc.Ice.OptionalFormat;
import com.zeroc.Ice.OutputStream;
import com.zeroc.Ice.Value;
import java.util.Optional;

public final class ObjectSeqHelper {
    public static void write(OutputStream ostr, Value[] v) {
        if (v == null) {
            ostr.writeSize(0);
        } else {
            ostr.writeSize(v.length);
            for (int i0 = 0; i0 < v.length; ++i0) {
                ostr.writeValue(v[i0]);
            }
        }
    }

    public static Value[] read(InputStream istr) {
        int len0 = istr.readAndCheckSeqSize(1);
        Value[] v = new Value[len0];
        int i0 = 0;
        while (i0 < len0) {
            int fi0 = i0++;
            istr.readValue(value -> {
                v[fi0] = value;
            }, Value.class);
        }
        return v;
    }

    public static void write(OutputStream ostr, int tag, Optional<Value[]> v) {
        if (v != null && v.isPresent()) {
            ObjectSeqHelper.write(ostr, tag, v.get());
        }
    }

    public static void write(OutputStream ostr, int tag, Value[] v) {
        if (ostr.writeOptional(tag, OptionalFormat.FSize)) {
            int pos = ostr.startSize();
            ObjectSeqHelper.write(ostr, v);
            ostr.endSize(pos);
        }
    }

    public static Optional<Value[]> read(InputStream istr, int tag) {
        if (istr.readOptional(tag, OptionalFormat.FSize)) {
            istr.skip(4);
            Value[] v = ObjectSeqHelper.read(istr);
            return Optional.of(v);
        }
        return Optional.empty();
    }
}

