/*
 * Decompiled with CFR 0.152.
 */
package com.dickimawbooks.texparserlib.html;

import com.dickimawbooks.texparserlib.TeXObject;
import com.dickimawbooks.texparserlib.TeXParser;
import com.dickimawbooks.texparserlib.TeXSettings;
import com.dickimawbooks.texparserlib.Writeable;
import com.dickimawbooks.texparserlib.latex.Tabular;
import java.io.IOException;

public class L2HTabular
extends Tabular {
    public L2HTabular() {
        this("tabular");
    }

    public L2HTabular(String string) {
        super(string);
    }

    @Override
    public Object clone() {
        return new L2HTabular(this.getName());
    }

    @Override
    protected void startTabular(TeXParser teXParser, int n, TeXObject teXObject) throws IOException {
        super.startTabular(teXParser, n, teXObject);
        Writeable writeable = teXParser.getListener().getWriteable();
        String string = "tabular-";
        switch (teXParser.getSettings().getParAlign()) {
            case 1: {
                string = string + "l";
                break;
            }
            case 2: {
                string = string + "r";
                break;
            }
            case 3: {
                string = string + "c";
            }
        }
        switch (n) {
            case 99: {
                string = string + "m";
                break;
            }
            case 98: {
                string = string + "b";
                break;
            }
            case 116: {
                string = string + "t";
            }
        }
        writeable.writeln(String.format("<table class=\"%s\">", string));
    }

    @Override
    public void end(TeXParser teXParser) throws IOException {
        Writeable writeable = teXParser.getListener().getWriteable();
        TeXSettings teXSettings = teXParser.getSettings();
        writeable.writeln("</table>");
        super.end(teXParser);
    }
}

