/*
 * Decompiled with CFR 0.152.
 */
package freemind.modes;

import freemind.main.Resources;
import freemind.modes.FreeMindFileDialog;
import java.awt.Component;
import java.awt.FileDialog;
import java.awt.Frame;
import java.awt.HeadlessException;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.logging.Logger;
import javax.swing.filechooser.FileFilter;
import javax.xml.transform.stream.StreamResult;

public class FreeMindAwtFileDialog
extends FileDialog
implements FreeMindFileDialog {
    private static final String APPLE_AWT_FILE_DIALOG_FOR_DIRECTORIES = "apple.awt.fileDialogForDirectories";
    protected static Logger logger = null;
    private FreeMindFilenameFilter mFilter;
    private FreeMindFileDialog.DirectoryResultListener mDirectoryResultListener = null;

    public FreeMindAwtFileDialog() {
        super((Frame)null);
        if (logger == null) {
            logger = Resources.getInstance().getLogger(this.getClass().getName());
        }
        this.mFilter = new FreeMindFilenameFilter();
        super.setFilenameFilter(this.mFilter);
        System.setProperty(APPLE_AWT_FILE_DIALOG_FOR_DIRECTORIES, "false");
    }

    protected void callDirectoryListener() {
        if (this.getFile() != null && this.mDirectoryResultListener != null) {
            try {
                this.mDirectoryResultListener.setChosenDirectory(this.getSelectedFile().getParentFile());
            }
            catch (Exception e) {
                Resources.getInstance().logException(e);
            }
        }
    }

    protected int getReturnValue() {
        return this.getFile() == null ? 1 : 0;
    }

    @Override
    public int showOpenDialog(Component pParent) throws HeadlessException {
        this.setMode(0);
        this.setVisible(true);
        this.callDirectoryListener();
        return this.getReturnValue();
    }

    @Override
    public int showSaveDialog(Component pParent) throws HeadlessException {
        this.setMode(1);
        this.setVisible(true);
        this.callDirectoryListener();
        return this.getReturnValue();
    }

    @Override
    public void setDialogTitle(String pDialogTitle) {
        this.setTitle(pDialogTitle);
    }

    @Override
    public void addChoosableFileFilter(FileFilter pFilter) {
        this.mFilter.setCustomFilter(pFilter);
    }

    @Override
    public void setFileSelectionMode(int pMode) {
        System.setProperty(APPLE_AWT_FILE_DIALOG_FOR_DIRECTORIES, "false");
        switch (pMode) {
            case 1: {
                this.mFilter.setPrincipalFilter(new DirFilter());
                System.setProperty(APPLE_AWT_FILE_DIALOG_FOR_DIRECTORIES, "true");
                break;
            }
            case 0: {
                this.mFilter.setPrincipalFilter(new FileOnlyFilter());
                break;
            }
            case 2: {
                this.mFilter.setPrincipalFilter(new FileAndDirFilter());
                break;
            }
            default: {
                this.mFilter.setPrincipalFilter(new NullFilter());
            }
        }
    }

    @Override
    public void setMultiSelectionEnabled(boolean pB) {
        if (pB) {
            throw new IllegalArgumentException("Not implemented yet.");
        }
    }

    @Override
    public boolean isMultiSelectionEnabled() {
        return false;
    }

    @Override
    public File[] getSelectedFiles() {
        throw new IllegalArgumentException("Not implemented yet.");
    }

    @Override
    public File getSelectedFile() {
        return new File(this.getDirectory(), this.getFile());
    }

    @Override
    public void setCurrentDirectory(File pDir) {
        if (pDir == null) {
            return;
        }
        logger.info("Setting dir to " + pDir);
        super.setDirectory(pDir.getAbsolutePath());
    }

    @Override
    public void setSelectedFile(File pFile) {
        super.setFile(pFile.getName());
    }

    @Override
    public void registerDirectoryResultListener(FreeMindFileDialog.DirectoryResultListener pDirectoryResultListener) {
        this.mDirectoryResultListener = pDirectoryResultListener;
    }

    public static void main(String[] args) throws IOException {
        FreeMindAwtFileDialog dialog = new FreeMindAwtFileDialog();
        dialog.setFileSelectionMode(1);
        dialog.showOpenDialog(null);
        File selectedFile = dialog.getSelectedFile();
        System.out.println("Dir '" + dialog.getDirectory() + "', File: '" + dialog.getFile() + "', selected File: '" + selectedFile + "'");
        System.exit(0);
        dialog.showSaveDialog(null);
        selectedFile = dialog.getSelectedFile();
        System.out.println("Dir '" + dialog.getDirectory() + "', File: '" + dialog.getFile() + "', selected File: '" + selectedFile + "'");
        StreamResult streamResult = new StreamResult(new FileOutputStream(selectedFile));
        streamResult.getOutputStream().write("bla".getBytes());
        streamResult.getOutputStream().close();
        System.out.println("File exists: " + selectedFile.exists());
    }

    @Override
    public void addChoosableFileFilterAsDefault(FileFilter pFilter) {
        this.addChoosableFileFilter(pFilter);
    }

    private final class FreeMindFilenameFilter
    implements FilenameFilter {
        private FileFilter mCustomFilter = new NullFilter();
        private FileFilter mPrincipalFilter = new NullFilter();

        private FreeMindFilenameFilter() {
        }

        @Override
        public boolean accept(File pDir, String pName) {
            File file = new File(pDir, pName);
            return this.mPrincipalFilter.accept(file) && this.mCustomFilter.accept(file);
        }

        public FileFilter getCustomFilter() {
            return this.mCustomFilter;
        }

        public void setCustomFilter(FileFilter pFilter) {
            this.mCustomFilter = pFilter;
        }

        public FileFilter getPrincipalFilter() {
            return this.mPrincipalFilter;
        }

        public void setPrincipalFilter(FileFilter pPrincipalFilter) {
            this.mPrincipalFilter = pPrincipalFilter;
        }
    }

    private final class FileAndDirFilter
    extends FileFilter {
        private FileAndDirFilter() {
        }

        @Override
        public boolean accept(File pF) {
            return pF.isFile() || pF.isDirectory();
        }

        @Override
        public String getDescription() {
            return "FileAndDirFilter";
        }
    }

    private final class FileOnlyFilter
    extends FileFilter {
        private FileOnlyFilter() {
        }

        @Override
        public boolean accept(File pF) {
            return pF.isFile();
        }

        @Override
        public String getDescription() {
            return "FileFilter";
        }
    }

    private final class DirFilter
    extends FileFilter {
        private DirFilter() {
        }

        @Override
        public boolean accept(File pF) {
            return pF.isDirectory();
        }

        @Override
        public String getDescription() {
            return "DirFilter";
        }
    }

    private static final class NullFilter
    extends FileFilter {
        private NullFilter() {
        }

        @Override
        public boolean accept(File pF) {
            return true;
        }

        @Override
        public String getDescription() {
            return "NullFilter";
        }
    }
}

