/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.nativeplatform.tasks;

import org.gradle.api.DefaultTask;
import org.gradle.api.Incubating;
import org.gradle.api.file.RegularFile;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.tasks.InputFile;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.Nested;
import org.gradle.api.tasks.OutputFile;
import org.gradle.api.tasks.TaskAction;
import org.gradle.api.tasks.WorkResult;
import org.gradle.internal.Cast;
import org.gradle.internal.operations.logging.BuildOperationLogger;
import org.gradle.internal.operations.logging.BuildOperationLoggerFactory;
import org.gradle.language.base.internal.compile.CompileSpec;
import org.gradle.language.base.internal.compile.Compiler;
import org.gradle.nativeplatform.internal.BuildOperationLoggingCompilerDecorator;
import org.gradle.nativeplatform.internal.DefaultStripperSpec;
import org.gradle.nativeplatform.platform.NativePlatform;
import org.gradle.nativeplatform.platform.internal.NativePlatformInternal;
import org.gradle.nativeplatform.toolchain.NativeToolChain;
import org.gradle.nativeplatform.toolchain.internal.NativeToolChainInternal;

@Incubating
public class StripSymbols
extends DefaultTask {
    private NativeToolChainInternal toolChain;
    private NativePlatformInternal targetPlatform;
    private RegularFileProperty binaryFile = this.newInputFile();
    private RegularFileProperty outputFile = this.newOutputFile();

    @InputFile
    public RegularFileProperty getBinaryFile() {
        return this.binaryFile;
    }

    @OutputFile
    public RegularFileProperty getOutputFile() {
        return this.outputFile;
    }

    @Internal
    public NativeToolChain getToolChain() {
        return this.toolChain;
    }

    public void setToolChain(NativeToolChain toolChain) {
        this.toolChain = (NativeToolChainInternal)toolChain;
    }

    @Nested
    public NativePlatform getTargetPlatform() {
        return this.targetPlatform;
    }

    public void setTargetPlatform(NativePlatform targetPlatform) {
        this.targetPlatform = (NativePlatformInternal)targetPlatform;
    }

    @TaskAction
    public void stripSymbols() {
        BuildOperationLogger operationLogger = ((BuildOperationLoggerFactory)this.getServices().get(BuildOperationLoggerFactory.class)).newOperationLogger(this.getName(), this.getTemporaryDir());
        DefaultStripperSpec spec = new DefaultStripperSpec();
        spec.setBinaryFile(((RegularFile)this.binaryFile.get()).getAsFile());
        spec.setOutputFile(((RegularFile)this.outputFile.get()).getAsFile());
        spec.setOperationLogger(operationLogger);
        Compiler symbolStripper = (Compiler)Cast.uncheckedCast((Object)this.toolChain.select(this.targetPlatform).newCompiler(spec.getClass()));
        symbolStripper = BuildOperationLoggingCompilerDecorator.wrap(symbolStripper);
        WorkResult result = symbolStripper.execute((CompileSpec)spec);
        this.setDidWork(result.getDidWork());
    }
}

