/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.ide.visualstudio.tasks;

import java.io.File;
import org.gradle.api.Action;
import org.gradle.api.Incubating;
import org.gradle.api.tasks.Internal;
import org.gradle.ide.visualstudio.TextProvider;
import org.gradle.ide.visualstudio.VisualStudioSolution;
import org.gradle.ide.visualstudio.internal.DefaultVisualStudioSolution;
import org.gradle.ide.visualstudio.tasks.internal.VisualStudioSolutionFile;
import org.gradle.plugins.ide.api.GeneratorTask;
import org.gradle.plugins.ide.internal.generator.generator.PersistableConfigurationObjectGenerator;

@Incubating
public class GenerateSolutionFileTask
extends GeneratorTask<VisualStudioSolutionFile> {
    private DefaultVisualStudioSolution solution;

    public GenerateSolutionFileTask() {
        this.generator = new ConfigurationObjectGenerator();
    }

    public void setVisualStudioSolution(VisualStudioSolution solution) {
        this.solution = (DefaultVisualStudioSolution)solution;
    }

    @Internal
    public VisualStudioSolution getSolution() {
        return this.solution;
    }

    public File getInputFile() {
        return null;
    }

    public File getOutputFile() {
        return this.solution.getSolutionFile().getLocation();
    }

    private class ConfigurationObjectGenerator
    extends PersistableConfigurationObjectGenerator<VisualStudioSolutionFile> {
        private ConfigurationObjectGenerator() {
        }

        public VisualStudioSolutionFile create() {
            return new VisualStudioSolutionFile();
        }

        public void configure(VisualStudioSolutionFile solutionFile) {
            DefaultVisualStudioSolution solution = (DefaultVisualStudioSolution)GenerateSolutionFileTask.this.getSolution();
            solutionFile.setProjects(solution.getProjectArtifacts());
            solutionFile.setProjectConfigurations(solution.getProjectConfigurationArtifacts());
            for (Action<? super TextProvider> textAction : solution.getSolutionFile().getTextActions()) {
                solutionFile.getActions().add(textAction);
            }
        }
    }
}

