/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.publish.maven.internal.publisher;

import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.lang.ObjectUtils;
import org.apache.maven.model.Model;
import org.apache.maven.model.io.xpp3.MavenXpp3Reader;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;
import org.gradle.api.UncheckedIOException;
import org.gradle.api.artifacts.repositories.MavenArtifactRepository;
import org.gradle.api.publish.internal.PublicationFieldValidator;
import org.gradle.api.publish.maven.InvalidMavenPublicationException;
import org.gradle.api.publish.maven.MavenArtifact;
import org.gradle.api.publish.maven.internal.publisher.MavenNormalizedPublication;
import org.gradle.api.publish.maven.internal.publisher.MavenProjectIdentity;
import org.gradle.api.publish.maven.internal.publisher.MavenPublisher;

public class ValidatingMavenPublisher
implements MavenPublisher {
    private static final String ID_REGEX = "[A-Za-z0-9_\\-.]+";
    private final MavenPublisher delegate;

    public ValidatingMavenPublisher(MavenPublisher delegate) {
        this.delegate = delegate;
    }

    @Override
    public void publish(MavenNormalizedPublication publication, MavenArtifactRepository artifactRepository) {
        this.validateIdentity(publication);
        this.validateArtifacts(publication);
        this.checkNoDuplicateArtifacts(publication);
        this.delegate.publish(publication, artifactRepository);
    }

    private void validateIdentity(MavenNormalizedPublication publication) {
        MavenProjectIdentity projectIdentity = publication.getProjectIdentity();
        Model model = this.parsePomFileIntoMavenModel(publication);
        this.field(publication, "groupId", projectIdentity.getGroupId()).validMavenIdentifier().matches(model.getGroupId());
        this.field(publication, "artifactId", projectIdentity.getArtifactId()).validMavenIdentifier().matches(model.getArtifactId());
        ((MavenFieldValidator)((MavenFieldValidator)this.field(publication, "version", projectIdentity.getVersion()).notEmpty()).validInFileName()).matches(model.getVersion());
    }

    private Model parsePomFileIntoMavenModel(MavenNormalizedPublication publication) {
        File pomFile = publication.getPomFile();
        try {
            Model model = this.readModelFromPom(pomFile);
            model.setPomFile(pomFile);
            return model;
        }
        catch (XmlPullParserException parseException) {
            throw new InvalidMavenPublicationException(publication.getName(), "POM file is invalid. Check any modifications you have made to the POM file.", parseException);
        }
        catch (IOException ex) {
            throw new UncheckedIOException((Throwable)ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Model readModelFromPom(File pomFile) throws IOException, XmlPullParserException {
        try (FileReader reader = new FileReader(pomFile);){
            Model model = new MavenXpp3Reader().read((Reader)reader);
            return model;
        }
    }

    private void validateArtifacts(MavenNormalizedPublication publication) {
        for (MavenArtifact artifact : publication.getArtifacts()) {
            ((MavenFieldValidator)this.field(publication, "artifact extension", artifact.getExtension()).notNull()).validInFileName();
            ((MavenFieldValidator)this.field(publication, "artifact classifier", artifact.getClassifier()).optionalNotEmpty()).validInFileName();
            this.checkCanPublish(publication.getName(), artifact);
        }
    }

    private void checkNoDuplicateArtifacts(MavenNormalizedPublication publication) {
        HashSet<MavenArtifact> verified = new HashSet<MavenArtifact>();
        for (MavenArtifact artifact : publication.getArtifacts()) {
            this.checkNotDuplicate(publication, verified, artifact.getExtension(), artifact.getClassifier());
            verified.add(artifact);
        }
        this.checkNotDuplicate(publication, verified, "pom", null);
    }

    private void checkNotDuplicate(MavenNormalizedPublication publication, Set<MavenArtifact> artifacts, String extension, String classifier) {
        for (MavenArtifact artifact : artifacts) {
            if (!ObjectUtils.equals((Object)artifact.getExtension(), (Object)extension) || !ObjectUtils.equals((Object)artifact.getClassifier(), (Object)classifier)) continue;
            String message = String.format("multiple artifacts with the identical extension and classifier ('%s', '%s').", extension, classifier);
            throw new InvalidMavenPublicationException(publication.getName(), message);
        }
    }

    private void checkCanPublish(String publicationName, MavenArtifact artifact) {
        File artifactFile = artifact.getFile();
        if (artifactFile == null || !artifactFile.exists()) {
            throw new InvalidMavenPublicationException(publicationName, String.format("artifact file does not exist: '%s'", artifactFile));
        }
        if (artifactFile.isDirectory()) {
            throw new InvalidMavenPublicationException(publicationName, String.format("artifact file is a directory: '%s'", artifactFile));
        }
    }

    private MavenFieldValidator field(MavenNormalizedPublication publication, String name, String value) {
        return new MavenFieldValidator(publication.getName(), name, value);
    }

    private static class MavenFieldValidator
    extends PublicationFieldValidator<MavenFieldValidator> {
        private MavenFieldValidator(String publicationName, String name, String value) {
            super(MavenFieldValidator.class, publicationName, name, value);
        }

        public MavenFieldValidator validMavenIdentifier() {
            this.notEmpty();
            if (!this.value.matches(ValidatingMavenPublisher.ID_REGEX)) {
                throw this.failure(String.format("%s is not a valid Maven identifier (%s).", this.name, ValidatingMavenPublisher.ID_REGEX));
            }
            return this;
        }

        public MavenFieldValidator matches(String expectedValue) {
            if (!this.value.equals(expectedValue)) {
                throw this.failure(String.format("supplied %s does not match POM file (cannot edit %1$s directly in the POM file).", this.name));
            }
            return this;
        }

        protected InvalidMavenPublicationException failure(String message) {
            return new InvalidMavenPublicationException(this.publicationName, message);
        }
    }
}

