/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.language.cpp.internal;

import java.io.File;
import java.util.LinkedHashSet;
import java.util.Set;
import javax.inject.Inject;
import org.gradle.api.artifacts.ArtifactCollection;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.ConfigurationContainer;
import org.gradle.api.artifacts.component.ModuleComponentIdentifier;
import org.gradle.api.artifacts.result.ResolvedArtifactResult;
import org.gradle.api.attributes.Usage;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.ProjectLayout;
import org.gradle.api.internal.file.FileOperations;
import org.gradle.api.internal.file.TemporaryFileProvider;
import org.gradle.api.internal.file.collections.FileCollectionAdapter;
import org.gradle.api.internal.file.collections.MinimalFileSet;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.language.cpp.CppBinary;
import org.gradle.language.cpp.CppPlatform;
import org.gradle.language.cpp.internal.NativeDependencyCache;
import org.gradle.language.cpp.tasks.CppCompile;
import org.gradle.language.internal.DefaultNativeBinary;
import org.gradle.language.nativeplatform.internal.Names;
import org.gradle.nativeplatform.toolchain.internal.NativeToolChainInternal;
import org.gradle.nativeplatform.toolchain.internal.PlatformToolProvider;

public class DefaultCppBinary
extends DefaultNativeBinary
implements CppBinary {
    private final Provider<String> baseName;
    private final boolean debuggable;
    private final boolean optimized;
    private final FileCollection sourceFiles;
    private final FileCollection includePath;
    private final FileCollection linkLibraries;
    private final FileCollection runtimeLibraries;
    private final CppPlatform targetPlatform;
    private final NativeToolChainInternal toolChain;
    private final PlatformToolProvider platformToolProvider;
    private final Configuration includePathConfiguration;
    private final Property<CppCompile> compileTaskProperty;

    public DefaultCppBinary(String name, ProjectLayout projectLayout, ObjectFactory objects, Provider<String> baseName, boolean debuggable, boolean optimized, FileCollection sourceFiles, FileCollection componentHeaderDirs, ConfigurationContainer configurations, Configuration componentImplementation, CppPlatform targetPlatform, NativeToolChainInternal toolChain, PlatformToolProvider platformToolProvider) {
        super(name, objects, projectLayout, componentImplementation);
        this.baseName = baseName;
        this.debuggable = debuggable;
        this.optimized = optimized;
        this.sourceFiles = sourceFiles;
        this.targetPlatform = targetPlatform;
        this.toolChain = toolChain;
        this.platformToolProvider = platformToolProvider;
        this.compileTaskProperty = objects.property(CppCompile.class);
        Names names = this.getNames();
        Configuration includePathConfig = (Configuration)configurations.create(names.withPrefix("cppCompile"));
        includePathConfig.setCanBeConsumed(false);
        includePathConfig.getAttributes().attribute(Usage.USAGE_ATTRIBUTE, (Object)objects.named(Usage.class, "cplusplus-api"));
        includePathConfig.getAttributes().attribute(DEBUGGABLE_ATTRIBUTE, (Object)debuggable);
        includePathConfig.getAttributes().attribute(OPTIMIZED_ATTRIBUTE, (Object)optimized);
        includePathConfig.extendsFrom(new Configuration[]{this.getImplementationDependencies()});
        Configuration nativeLink = (Configuration)configurations.create(names.withPrefix("nativeLink"));
        nativeLink.setCanBeConsumed(false);
        nativeLink.getAttributes().attribute(Usage.USAGE_ATTRIBUTE, (Object)objects.named(Usage.class, "native-link"));
        nativeLink.getAttributes().attribute(DEBUGGABLE_ATTRIBUTE, (Object)debuggable);
        nativeLink.getAttributes().attribute(OPTIMIZED_ATTRIBUTE, (Object)optimized);
        nativeLink.extendsFrom(new Configuration[]{this.getImplementationDependencies()});
        Configuration nativeRuntime = (Configuration)configurations.create(names.withPrefix("nativeRuntime"));
        nativeRuntime.setCanBeConsumed(false);
        nativeRuntime.getAttributes().attribute(Usage.USAGE_ATTRIBUTE, (Object)objects.named(Usage.class, "native-runtime"));
        nativeRuntime.getAttributes().attribute(DEBUGGABLE_ATTRIBUTE, (Object)debuggable);
        nativeRuntime.getAttributes().attribute(OPTIMIZED_ATTRIBUTE, (Object)optimized);
        nativeRuntime.extendsFrom(new Configuration[]{this.getImplementationDependencies()});
        this.includePathConfiguration = includePathConfig;
        this.includePath = componentHeaderDirs.plus((FileCollection)new FileCollectionAdapter((MinimalFileSet)new IncludePath(includePathConfig)));
        this.linkLibraries = nativeLink;
        this.runtimeLibraries = nativeRuntime;
    }

    @Inject
    protected FileOperations getFileOperations() {
        throw new UnsupportedOperationException();
    }

    @Inject
    protected TemporaryFileProvider getTemporaryFileProvider() {
        throw new UnsupportedOperationException();
    }

    @Inject
    protected NativeDependencyCache getNativeDependencyCache() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Provider<String> getBaseName() {
        return this.baseName;
    }

    @Override
    public boolean isDebuggable() {
        return this.debuggable;
    }

    @Override
    public boolean isOptimized() {
        return this.optimized;
    }

    @Override
    public FileCollection getCppSource() {
        return this.sourceFiles;
    }

    @Override
    public FileCollection getCompileIncludePath() {
        return this.includePath;
    }

    @Override
    public FileCollection getLinkLibraries() {
        return this.linkLibraries;
    }

    @Override
    public FileCollection getRuntimeLibraries() {
        return this.runtimeLibraries;
    }

    public Configuration getIncludePathConfiguration() {
        return this.includePathConfiguration;
    }

    @Override
    public CppPlatform getTargetPlatform() {
        return this.targetPlatform;
    }

    public NativeToolChainInternal getToolChain() {
        return this.toolChain;
    }

    public Property<CppCompile> getCompileTask() {
        return this.compileTaskProperty;
    }

    public PlatformToolProvider getPlatformToolProvider() {
        return this.platformToolProvider;
    }

    private class IncludePath
    implements MinimalFileSet {
        private final Configuration includePathConfig;
        private Set<File> result;

        IncludePath(Configuration includePathConfig) {
            this.includePathConfig = includePathConfig;
        }

        public String getDisplayName() {
            return "Include path for " + DefaultCppBinary.this.toString();
        }

        public Set<File> getFiles() {
            if (this.result == null) {
                ArtifactCollection artifacts = this.includePathConfig.getIncoming().getArtifacts();
                LinkedHashSet<File> files = new LinkedHashSet<File>();
                if (!artifacts.getArtifacts().isEmpty()) {
                    NativeDependencyCache cache = DefaultCppBinary.this.getNativeDependencyCache();
                    for (ResolvedArtifactResult artifact : artifacts) {
                        if (artifact.getId().getComponentIdentifier() instanceof ModuleComponentIdentifier) {
                            ModuleComponentIdentifier id = (ModuleComponentIdentifier)artifact.getId().getComponentIdentifier();
                            File headerDir = cache.getUnpackedHeaders(artifact.getFile(), id.getModule() + "-" + id.getVersion());
                            files.add(headerDir);
                            continue;
                        }
                        files.add(artifact.getFile());
                    }
                }
                this.result = files;
            }
            return this.result;
        }
    }
}

