/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.language.swift.plugins;

import javax.inject.Inject;
import org.gradle.api.Action;
import org.gradle.api.Incubating;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.ConfigurationContainer;
import org.gradle.api.attributes.Usage;
import org.gradle.api.internal.project.ProjectInternal;
import org.gradle.api.model.ObjectFactory;
import org.gradle.language.cpp.CppBinary;
import org.gradle.language.internal.DefaultBinaryCollection;
import org.gradle.language.internal.NativeComponentFactory;
import org.gradle.language.nativeplatform.internal.ComponentWithNames;
import org.gradle.language.nativeplatform.internal.Names;
import org.gradle.language.nativeplatform.internal.toolchains.ToolChainSelector;
import org.gradle.language.swift.SwiftApplication;
import org.gradle.language.swift.SwiftExecutable;
import org.gradle.language.swift.SwiftPlatform;
import org.gradle.language.swift.internal.DefaultSwiftApplication;
import org.gradle.language.swift.plugins.SwiftBasePlugin;
import org.gradle.util.GUtil;

@Incubating
public class SwiftApplicationPlugin
implements Plugin<ProjectInternal> {
    private final NativeComponentFactory componentFactory;
    private final ToolChainSelector toolChainSelector;

    @Inject
    public SwiftApplicationPlugin(NativeComponentFactory componentFactory, ToolChainSelector toolChainSelector) {
        this.componentFactory = componentFactory;
        this.toolChainSelector = toolChainSelector;
    }

    public void apply(ProjectInternal project) {
        project.getPluginManager().apply(SwiftBasePlugin.class);
        final ConfigurationContainer configurations = project.getConfigurations();
        final DefaultSwiftApplication application = this.componentFactory.newInstance(SwiftApplication.class, DefaultSwiftApplication.class, "main");
        project.getExtensions().add(SwiftApplication.class, "application", (Object)application);
        project.getComponents().add((Object)application);
        application.getModule().set((Object)GUtil.toCamelCase((CharSequence)project.getName()));
        project.afterEvaluate((Action)new Action<Project>(){

            public void execute(Project project) {
                ObjectFactory objectFactory = project.getObjects();
                ToolChainSelector.Result<SwiftPlatform> result = SwiftApplicationPlugin.this.toolChainSelector.select(SwiftPlatform.class);
                SwiftExecutable debugExecutable = application.addExecutable("debug", true, false, true, result.getTargetPlatform(), result.getToolChain(), result.getPlatformToolProvider());
                application.addExecutable("release", true, true, false, result.getTargetPlatform(), result.getToolChain(), result.getPlatformToolProvider());
                final Configuration implementation = application.getImplementationDependencies();
                final Usage apiUsage = (Usage)objectFactory.named(Usage.class, "swift-api");
                ((DefaultBinaryCollection)application.getBinaries()).whenElementKnown(SwiftExecutable.class, new Action<SwiftExecutable>(){

                    public void execute(SwiftExecutable executable) {
                        Names names = ((ComponentWithNames)((Object)executable)).getNames();
                        Configuration apiElements = (Configuration)configurations.create(names.withSuffix("SwiftApiElements"));
                        apiElements.extendsFrom(new Configuration[]{implementation});
                        apiElements.setCanBeResolved(false);
                        apiElements.getAttributes().attribute(Usage.USAGE_ATTRIBUTE, (Object)apiUsage);
                        apiElements.getAttributes().attribute(CppBinary.DEBUGGABLE_ATTRIBUTE, (Object)executable.isDebuggable());
                        apiElements.getAttributes().attribute(CppBinary.OPTIMIZED_ATTRIBUTE, (Object)executable.isOptimized());
                        apiElements.getOutgoing().artifact(executable.getModuleFile());
                    }
                });
                application.getDevelopmentBinary().set((Object)debugExecutable);
                ((DefaultBinaryCollection)application.getBinaries()).realizeNow();
            }
        });
    }
}

