/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.language.swift.plugins;

import java.util.Set;
import javax.inject.Inject;
import org.gradle.api.Action;
import org.gradle.api.Incubating;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.ConfigurationContainer;
import org.gradle.api.attributes.Usage;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.provider.Property;
import org.gradle.language.cpp.CppBinary;
import org.gradle.language.internal.DefaultBinaryCollection;
import org.gradle.language.internal.NativeComponentFactory;
import org.gradle.language.nativeplatform.internal.ComponentWithNames;
import org.gradle.language.nativeplatform.internal.Names;
import org.gradle.language.nativeplatform.internal.toolchains.ToolChainSelector;
import org.gradle.language.swift.SwiftLibrary;
import org.gradle.language.swift.SwiftPlatform;
import org.gradle.language.swift.SwiftSharedLibrary;
import org.gradle.language.swift.SwiftStaticLibrary;
import org.gradle.language.swift.internal.DefaultSwiftLibrary;
import org.gradle.language.swift.internal.DefaultSwiftSharedLibrary;
import org.gradle.language.swift.internal.DefaultSwiftStaticLibrary;
import org.gradle.language.swift.plugins.SwiftBasePlugin;
import org.gradle.nativeplatform.Linkage;
import org.gradle.util.GUtil;

@Incubating
public class SwiftLibraryPlugin
implements Plugin<Project> {
    private final NativeComponentFactory componentFactory;
    private final ToolChainSelector toolChainSelector;

    @Inject
    public SwiftLibraryPlugin(NativeComponentFactory componentFactory, ToolChainSelector toolChainSelector) {
        this.componentFactory = componentFactory;
        this.toolChainSelector = toolChainSelector;
    }

    public void apply(Project project) {
        project.getPluginManager().apply(SwiftBasePlugin.class);
        final ConfigurationContainer configurations = project.getConfigurations();
        final ObjectFactory objectFactory = project.getObjects();
        final DefaultSwiftLibrary library = this.componentFactory.newInstance(SwiftLibrary.class, DefaultSwiftLibrary.class, "main");
        project.getExtensions().add(SwiftLibrary.class, "library", (Object)library);
        project.getComponents().add((Object)library);
        Property<String> module = library.getModule();
        module.set((Object)GUtil.toCamelCase((CharSequence)project.getName()));
        project.afterEvaluate((Action)new Action<Project>(){

            public void execute(Project project) {
                library.getLinkage().lockNow();
                if (((Set)library.getLinkage().get()).isEmpty()) {
                    throw new IllegalArgumentException("A linkage needs to be specified for the library.");
                }
                boolean sharedLibs = ((Set)library.getLinkage().get()).contains(Linkage.SHARED);
                boolean staticLibs = ((Set)library.getLinkage().get()).contains(Linkage.STATIC);
                ToolChainSelector.Result<SwiftPlatform> result = SwiftLibraryPlugin.this.toolChainSelector.select(SwiftPlatform.class);
                if (sharedLibs) {
                    String linkageNameSuffix = staticLibs ? "Shared" : "";
                    SwiftSharedLibrary debugSharedLibrary = library.addSharedLibrary("debug" + linkageNameSuffix, true, false, true, result.getTargetPlatform(), result.getToolChain(), result.getPlatformToolProvider());
                    library.addSharedLibrary("release" + linkageNameSuffix, true, true, false, result.getTargetPlatform(), result.getToolChain(), result.getPlatformToolProvider());
                    library.getDevelopmentBinary().set((Object)debugSharedLibrary);
                    ((DefaultBinaryCollection)library.getBinaries()).whenElementKnown(SwiftSharedLibrary.class, new Action<SwiftSharedLibrary>(){

                        public void execute(SwiftSharedLibrary sharedLibrary) {
                            Names names = ((ComponentWithNames)((Object)sharedLibrary)).getNames();
                            Configuration apiElements = (Configuration)configurations.create(names.withSuffix("SwiftApiElements"));
                            apiElements.extendsFrom(new Configuration[]{((DefaultSwiftSharedLibrary)sharedLibrary).getImplementationDependencies()});
                            apiElements.setCanBeResolved(false);
                            apiElements.getAttributes().attribute(Usage.USAGE_ATTRIBUTE, (Object)objectFactory.named(Usage.class, "swift-api"));
                            apiElements.getAttributes().attribute(CppBinary.LINKAGE_ATTRIBUTE, (Object)Linkage.SHARED);
                            apiElements.getAttributes().attribute(CppBinary.DEBUGGABLE_ATTRIBUTE, (Object)sharedLibrary.isDebuggable());
                            apiElements.getAttributes().attribute(CppBinary.OPTIMIZED_ATTRIBUTE, (Object)sharedLibrary.isOptimized());
                            apiElements.getOutgoing().artifact(sharedLibrary.getModuleFile());
                        }
                    });
                }
                SwiftStaticLibrary debugStaticLibrary = null;
                if (staticLibs) {
                    String linkageNameSuffix = sharedLibs ? "Static" : "";
                    debugStaticLibrary = library.addStaticLibrary("debug" + linkageNameSuffix, true, false, true, result.getTargetPlatform(), result.getToolChain(), result.getPlatformToolProvider());
                    library.addStaticLibrary("release" + linkageNameSuffix, true, true, false, result.getTargetPlatform(), result.getToolChain(), result.getPlatformToolProvider());
                    if (!library.getDevelopmentBinary().isPresent()) {
                        library.getDevelopmentBinary().set((Object)debugStaticLibrary);
                    }
                    ((DefaultBinaryCollection)library.getBinaries()).whenElementKnown(SwiftStaticLibrary.class, new Action<SwiftStaticLibrary>(){

                        public void execute(SwiftStaticLibrary staticLibrary) {
                            Names names = ((ComponentWithNames)((Object)staticLibrary)).getNames();
                            Configuration apiElements = (Configuration)configurations.create(names.withSuffix("SwiftApiElements"));
                            apiElements.extendsFrom(new Configuration[]{((DefaultSwiftStaticLibrary)staticLibrary).getImplementationDependencies()});
                            apiElements.setCanBeResolved(false);
                            apiElements.getAttributes().attribute(Usage.USAGE_ATTRIBUTE, (Object)objectFactory.named(Usage.class, "swift-api"));
                            apiElements.getAttributes().attribute(CppBinary.LINKAGE_ATTRIBUTE, (Object)Linkage.STATIC);
                            apiElements.getAttributes().attribute(CppBinary.DEBUGGABLE_ATTRIBUTE, (Object)staticLibrary.isDebuggable());
                            apiElements.getAttributes().attribute(CppBinary.OPTIMIZED_ATTRIBUTE, (Object)staticLibrary.isOptimized());
                            apiElements.getOutgoing().artifact(staticLibrary.getModuleFile());
                        }
                    });
                }
                ((DefaultBinaryCollection)library.getBinaries()).realizeNow();
            }
        });
    }
}

