/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.ivyservice.moduleconverter;

import java.util.Collection;
import java.util.Set;
import org.gradle.api.internal.artifacts.configurations.ConfigurationInternal;
import org.gradle.api.internal.artifacts.configurations.Configurations;
import org.gradle.api.internal.artifacts.configurations.OutgoingVariant;
import org.gradle.api.internal.artifacts.ivyservice.moduleconverter.LocalComponentMetadataBuilder;
import org.gradle.api.internal.artifacts.ivyservice.moduleconverter.dependencies.LocalConfigurationMetadataBuilder;
import org.gradle.internal.component.local.model.BuildableLocalComponentMetadata;
import org.gradle.internal.component.local.model.BuildableLocalConfigurationMetadata;

public class DefaultLocalComponentMetadataBuilder
implements LocalComponentMetadataBuilder {
    private final LocalConfigurationMetadataBuilder configurationMetadataBuilder;

    public DefaultLocalComponentMetadataBuilder(LocalConfigurationMetadataBuilder configurationMetadataBuilder) {
        this.configurationMetadataBuilder = configurationMetadataBuilder;
    }

    @Override
    public void addConfigurations(BuildableLocalComponentMetadata metaData, Collection<? extends ConfigurationInternal> configurations) {
        for (ConfigurationInternal configurationInternal : configurations) {
            this.addConfiguration(metaData, configurationInternal);
            metaData.addDependenciesAndExcludesForConfiguration(configurationInternal, this.configurationMetadataBuilder);
            OutgoingVariant outgoingVariant = configurationInternal.convertToOutgoingVariant();
            metaData.addArtifacts(configurationInternal.getName(), outgoingVariant.getArtifacts());
            for (OutgoingVariant outgoingVariant2 : outgoingVariant.getChildren()) {
                metaData.addVariant(configurationInternal.getName(), outgoingVariant2);
            }
        }
    }

    private BuildableLocalConfigurationMetadata addConfiguration(BuildableLocalComponentMetadata metaData, ConfigurationInternal configuration) {
        configuration.preventFromFurtherMutation();
        Set<String> hierarchy = Configurations.getNames(configuration.getHierarchy());
        Set<String> extendsFrom = Configurations.getNames(configuration.getExtendsFrom());
        return metaData.addConfiguration(configuration.getName(), configuration.getDescription(), extendsFrom, hierarchy, configuration.isVisible(), configuration.isTransitive(), configuration.getAttributes().asImmutable(), configuration.isCanBeConsumed(), configuration.isCanBeResolved());
    }
}

