// **********************************************************************
//
// Copyright (c) 2003-2017 ZeroC, Inc. All rights reserved.
//
// This copy of Ice is licensed to you under the terms described in the
// ICE_LICENSE file included in this distribution.
//
// **********************************************************************
//
// Ice version 3.7.0
//
// <auto-generated>
//
// Generated from file `Metrics.ice'
//
// Warning: do not edit this file.
//
// </auto-generated>
//

package IceMX;

/**
 * Provides information on Glacier2 sessions.
 *
 **/
public class SessionMetrics extends Metrics
{
    public SessionMetrics()
    {
        super();
        this.forwardedClient = 0;
        this.forwardedServer = 0;
        this.routingTableSize = 0;
        this.queuedClient = 0;
        this.queuedServer = 0;
        this.overriddenClient = 0;
        this.overriddenServer = 0;
    }

    public SessionMetrics(String id, long total, int current, long totalLifetime, int failures, int forwardedClient, int forwardedServer, int routingTableSize, int queuedClient, int queuedServer, int overriddenClient, int overriddenServer)
    {
        super(id, total, current, totalLifetime, failures);
        this.forwardedClient = forwardedClient;
        this.forwardedServer = forwardedServer;
        this.routingTableSize = routingTableSize;
        this.queuedClient = queuedClient;
        this.queuedServer = queuedServer;
        this.overriddenClient = overriddenClient;
        this.overriddenServer = overriddenServer;
    }

    private static class _F implements Ice.ValueFactory
    {
        public Ice.Object create(String type)
        {
            assert(type.equals(ice_staticId()));
            return new SessionMetrics();
        }
    }
    private static Ice.ValueFactory _factory = new _F();

    public static Ice.ValueFactory
    ice_factory()
    {
        return _factory;
    }

    private static final String[] _ids =
    {
        "::Ice::Object",
        "::IceMX::Metrics",
        "::IceMX::SessionMetrics"
    };

    public boolean ice_isA(String s)
    {
        return java.util.Arrays.binarySearch(_ids, s) >= 0;
    }

    public boolean ice_isA(String s, Ice.Current current)
    {
        return java.util.Arrays.binarySearch(_ids, s) >= 0;
    }

    public String[] ice_ids()
    {
        return _ids;
    }

    public String[] ice_ids(Ice.Current current)
    {
        return _ids;
    }

    public String ice_id()
    {
        return _ids[2];
    }

    public String ice_id(Ice.Current current)
    {
        return _ids[2];
    }

    public static String ice_staticId()
    {
        return _ids[2];
    }

    protected void _iceWriteImpl(Ice.OutputStream ostr_)
    {
        ostr_.startSlice(ice_staticId(), -1, false);
        ostr_.writeInt(forwardedClient);
        ostr_.writeInt(forwardedServer);
        ostr_.writeInt(routingTableSize);
        ostr_.writeInt(queuedClient);
        ostr_.writeInt(queuedServer);
        ostr_.writeInt(overriddenClient);
        ostr_.writeInt(overriddenServer);
        ostr_.endSlice();
        super._iceWriteImpl(ostr_);
    }

    protected void _iceReadImpl(Ice.InputStream istr_)
    {
        istr_.startSlice();
        forwardedClient = istr_.readInt();
        forwardedServer = istr_.readInt();
        routingTableSize = istr_.readInt();
        queuedClient = istr_.readInt();
        queuedServer = istr_.readInt();
        overriddenClient = istr_.readInt();
        overriddenServer = istr_.readInt();
        istr_.endSlice();
        super._iceReadImpl(istr_);
    }

    /**
     * Number of client requests forwared.
     *
     **/
    public int forwardedClient;

    /**
     * Number of server requests forwared.
     *
     **/
    public int forwardedServer;

    /**
     * The size of the routing table.
     *
     **/
    public int routingTableSize;

    /**
     * Number of client requests queued.
     *
     **/
    public int queuedClient;

    /**
     * Number of server requests queued.
     *
     **/
    public int queuedServer;

    /**
     * Number of client requests overridden.
     *
     **/
    public int overriddenClient;

    /**
     * Number of server requests overridden.
     *
     **/
    public int overriddenServer;

    public SessionMetrics
    clone()
    {
        return (SessionMetrics)super.clone();
    }

    public static final long serialVersionUID = 2992020973376844179L;
}
