/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core;

import ch.qos.logback.core.BasicStatusManager;
import ch.qos.logback.core.Context;
import ch.qos.logback.core.LifeCycleManager;
import ch.qos.logback.core.spi.LifeCycle;
import ch.qos.logback.core.spi.LogbackLock;
import ch.qos.logback.core.status.StatusManager;
import ch.qos.logback.core.util.EnvUtil;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ContextBase
implements Context {
    private long birthTime = System.currentTimeMillis();
    private String name;
    private StatusManager sm = new BasicStatusManager();
    Map<String, String> propertyMap = new HashMap<String, String>();
    Map<String, Object> objectMap = new HashMap<String, Object>();
    LogbackLock configurationLock = new LogbackLock();
    private static final int CORE_POOL_SIZE = EnvUtil.isJDK5() ? 1 : 0;
    private static int MAX_POOL_SIZE = 32;
    ExecutorService executorService = new ThreadPoolExecutor(CORE_POOL_SIZE, MAX_POOL_SIZE, 0L, TimeUnit.MILLISECONDS, new SynchronousQueue<Runnable>());
    private LifeCycleManager lifeCycleManager;

    @Override
    public StatusManager getStatusManager() {
        return this.sm;
    }

    public void setStatusManager(StatusManager statusManager) {
        if (this.sm == null) {
            throw new IllegalArgumentException("null StatusManager not allowed");
        }
        this.sm = statusManager;
    }

    @Override
    public Map<String, String> getCopyOfPropertyMap() {
        return new HashMap<String, String>(this.propertyMap);
    }

    @Override
    public void putProperty(String key2, String val2) {
        this.propertyMap.put(key2, val2);
    }

    @Override
    public String getProperty(String key2) {
        if ("CONTEXT_NAME".equals(key2)) {
            return this.getName();
        }
        return this.propertyMap.get(key2);
    }

    @Override
    public Object getObject(String key2) {
        return this.objectMap.get(key2);
    }

    @Override
    public void putObject(String key2, Object value) {
        this.objectMap.put(key2, value);
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void reset() {
        this.getLifeCycleManager().reset();
        this.propertyMap.clear();
        this.objectMap.clear();
    }

    @Override
    public void setName(String name2) throws IllegalStateException {
        if (name2 != null && name2.equals(this.name)) {
            return;
        }
        if (this.name != null && !"default".equals(this.name)) {
            throw new IllegalStateException("Context has been already given a name");
        }
        this.name = name2;
    }

    @Override
    public long getBirthTime() {
        return this.birthTime;
    }

    @Override
    public Object getConfigurationLock() {
        return this.configurationLock;
    }

    @Override
    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    @Override
    public void register(LifeCycle component) {
        this.getLifeCycleManager().register(component);
    }

    synchronized LifeCycleManager getLifeCycleManager() {
        if (this.lifeCycleManager == null) {
            this.lifeCycleManager = new LifeCycleManager();
        }
        return this.lifeCycleManager;
    }

    public String toString() {
        return this.name;
    }
}

