/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.s3.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.services.s3.internal.XmlWriter;
import com.amazonaws.services.s3.model.AccessControlList;
import com.amazonaws.services.s3.model.CanonicalGrantee;
import com.amazonaws.services.s3.model.EmailAddressGrantee;
import com.amazonaws.services.s3.model.Grant;
import com.amazonaws.services.s3.model.Grantee;
import com.amazonaws.services.s3.model.GroupGrantee;
import com.amazonaws.services.s3.model.Owner;

public class AclXmlFactory {
    public byte[] convertToXmlByteArray(AccessControlList acl) throws SdkClientException {
        Owner owner = acl.getOwner();
        if (owner == null) {
            throw new SdkClientException("Invalid AccessControlList: missing an S3Owner");
        }
        XmlWriter xml2 = new XmlWriter();
        xml2.start("AccessControlPolicy", "xmlns", "http://s3.amazonaws.com/doc/2006-03-01/");
        xml2.start("Owner");
        if (owner.getId() != null) {
            xml2.start("ID").value(owner.getId()).end();
        }
        if (owner.getDisplayName() != null) {
            xml2.start("DisplayName").value(owner.getDisplayName()).end();
        }
        xml2.end();
        xml2.start("AccessControlList");
        for (Grant grant : acl.getGrantsAsList()) {
            xml2.start("Grant");
            this.convertToXml(grant.getGrantee(), xml2);
            xml2.start("Permission").value(grant.getPermission().toString()).end();
            xml2.end();
        }
        xml2.end();
        xml2.end();
        return xml2.getBytes();
    }

    protected XmlWriter convertToXml(Grantee grantee, XmlWriter xml2) throws SdkClientException {
        if (grantee instanceof CanonicalGrantee) {
            return this.convertToXml((CanonicalGrantee)grantee, xml2);
        }
        if (grantee instanceof EmailAddressGrantee) {
            return this.convertToXml((EmailAddressGrantee)grantee, xml2);
        }
        if (grantee instanceof GroupGrantee) {
            return this.convertToXml((GroupGrantee)grantee, xml2);
        }
        throw new SdkClientException("Unknown Grantee type: " + grantee.getClass().getName());
    }

    protected XmlWriter convertToXml(CanonicalGrantee grantee, XmlWriter xml2) {
        xml2.start("Grantee", new String[]{"xmlns:xsi", "xsi:type"}, new String[]{"http://www.w3.org/2001/XMLSchema-instance", "CanonicalUser"});
        xml2.start("ID").value(grantee.getIdentifier()).end();
        xml2.end();
        return xml2;
    }

    protected XmlWriter convertToXml(EmailAddressGrantee grantee, XmlWriter xml2) {
        xml2.start("Grantee", new String[]{"xmlns:xsi", "xsi:type"}, new String[]{"http://www.w3.org/2001/XMLSchema-instance", "AmazonCustomerByEmail"});
        xml2.start("EmailAddress").value(grantee.getIdentifier()).end();
        xml2.end();
        return xml2;
    }

    protected XmlWriter convertToXml(GroupGrantee grantee, XmlWriter xml2) {
        xml2.start("Grantee", new String[]{"xmlns:xsi", "xsi:type"}, new String[]{"http://www.w3.org/2001/XMLSchema-instance", "Group"});
        xml2.start("URI").value(grantee.getIdentifier()).end();
        xml2.end();
        return xml2;
    }
}

