/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3.text.translate;

import java.io.IOException;
import java.io.Writer;
import org.apache.commons.lang3.text.translate.CharSequenceTranslator;

public class UnicodeUnescaper
extends CharSequenceTranslator {
    @Override
    public int translate(CharSequence input, int index2, Writer out) throws IOException {
        if (input.charAt(index2) == '\\' && index2 + 1 < input.length() && input.charAt(index2 + 1) == 'u') {
            int i = 2;
            while (index2 + i < input.length() && input.charAt(index2 + i) == 'u') {
                ++i;
            }
            if (index2 + i < input.length() && input.charAt(index2 + i) == '+') {
                ++i;
            }
            if (index2 + i + 4 <= input.length()) {
                CharSequence unicode = input.subSequence(index2 + i, index2 + i + 4);
                try {
                    int value = Integer.parseInt(unicode.toString(), 16);
                    out.write((char)value);
                }
                catch (NumberFormatException nfe) {
                    throw new IllegalArgumentException("Unable to parse unicode value: " + unicode, nfe);
                }
                return i + 4;
            }
            throw new IllegalArgumentException("Less than 4 hex digits in unicode value: '" + input.subSequence(index2, input.length()) + "' due to end of CharSequence");
        }
        return 0;
    }
}

