/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivy.plugins.report;

import java.io.File;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.apache.ivy.core.cache.ArtifactOrigin;
import org.apache.ivy.core.module.descriptor.Artifact;
import org.apache.ivy.core.module.descriptor.DefaultArtifact;
import org.apache.ivy.core.module.id.ModuleRevisionId;
import org.apache.ivy.core.report.ArtifactDownloadReport;
import org.apache.ivy.core.report.DownloadStatus;
import org.apache.ivy.core.report.MetadataArtifactDownloadReport;
import org.apache.ivy.util.DateUtil;
import org.apache.ivy.util.extendable.ExtendableItemHelper;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class XmlReportParser {
    private SaxXmlReportParser parser = null;

    public void parse(File file) throws ParseException {
        if (!file.exists()) {
            throw new IllegalStateException("Report file '" + file.getAbsolutePath() + "' does not exist.");
        }
        this.parser = new SaxXmlReportParser(file);
        try {
            this.parser.parse();
        }
        catch (Exception exception) {
            ParseException parseException = new ParseException("failed to parse report: " + file + ": " + exception.getMessage(), 0);
            parseException.initCause(exception);
            throw parseException;
        }
    }

    public Artifact[] getArtifacts() {
        return this.parser.getArtifacts().toArray(new Artifact[this.parser.getArtifacts().size()]);
    }

    public ArtifactDownloadReport[] getArtifactReports() {
        return this.parser.getArtifactReports().toArray(new ArtifactDownloadReport[this.parser.getArtifactReports().size()]);
    }

    public ModuleRevisionId[] getDependencyRevisionIds() {
        return this.parser.getModuleRevisionIds().toArray(new ModuleRevisionId[this.parser.getModuleRevisionIds().size()]);
    }

    public ModuleRevisionId[] getRealDependencyRevisionIds() {
        return this.parser.getRealModuleRevisionIds().toArray(new ModuleRevisionId[this.parser.getRealModuleRevisionIds().size()]);
    }

    public MetadataArtifactDownloadReport getMetadataArtifactReport(ModuleRevisionId moduleRevisionId) {
        return this.parser.getMetadataArtifactReport(moduleRevisionId);
    }

    public ModuleRevisionId getResolvedModule() {
        return this.parser.getResolvedModule();
    }

    public boolean hasError() {
        return this.parser.hasError;
    }

    private static class SaxXmlReportParser {
        private List mrids;
        private List defaultMrids;
        private List realMrids;
        private List artifacts = new ArrayList();
        private List artifactReports = new ArrayList();
        private Map metadataReports;
        private ModuleRevisionId mRevisionId;
        private File report;
        private boolean hasError = false;

        SaxXmlReportParser(File file) {
            this.mrids = new ArrayList();
            this.defaultMrids = new ArrayList();
            this.realMrids = new ArrayList();
            this.metadataReports = new HashMap();
            this.report = file;
        }

        public void parse() throws Exception {
            SAXParser sAXParser = SAXParserFactory.newInstance().newSAXParser();
            sAXParser.parse(this.report, (DefaultHandler)new XmlReportParserHandler());
        }

        private static boolean parseBoolean(String string) {
            return string != null && string.equalsIgnoreCase("true");
        }

        public List getArtifacts() {
            return this.artifacts;
        }

        public List getArtifactReports() {
            return this.artifactReports;
        }

        public List getModuleRevisionIds() {
            return this.mrids;
        }

        public List getRealModuleRevisionIds() {
            return this.realMrids;
        }

        public ModuleRevisionId getResolvedModule() {
            return this.mRevisionId;
        }

        public MetadataArtifactDownloadReport getMetadataArtifactReport(ModuleRevisionId moduleRevisionId) {
            return (MetadataArtifactDownloadReport)this.metadataReports.get(moduleRevisionId);
        }

        private final class XmlReportParserHandler
        extends DefaultHandler {
            private String organisation;
            private String module;
            private String branch;
            private String revision;
            private int position;
            private Date pubdate;
            private boolean skip;
            private ModuleRevisionId mrid;
            private boolean isDefault;
            private SortedMap revisionsMap = new TreeMap();
            private List revisionArtifacts = null;

            private XmlReportParserHandler() {
            }

            @Override
            public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
                if ("module".equals(string3)) {
                    this.organisation = attributes.getValue("organisation");
                    this.module = attributes.getValue("name");
                } else if ("revision".equals(string3)) {
                    this.revisionArtifacts = new ArrayList();
                    this.branch = attributes.getValue("branch");
                    this.revision = attributes.getValue("name");
                    this.isDefault = Boolean.valueOf(attributes.getValue("default"));
                    String string4 = attributes.getValue("position");
                    int n = this.position = string4 == null ? this.getMaxPos() + 1 : Integer.valueOf(string4);
                    if (attributes.getValue("error") != null) {
                        SaxXmlReportParser.this.hasError = true;
                        this.skip = true;
                    } else if (attributes.getValue("evicted") != null) {
                        this.skip = true;
                    } else {
                        Object object;
                        this.revisionsMap.put(new Integer(this.position), this.revisionArtifacts);
                        this.mrid = ModuleRevisionId.newInstance(this.organisation, this.module, this.branch, this.revision, ExtendableItemHelper.getExtraAttributes(attributes, "extra-"));
                        SaxXmlReportParser.this.mrids.add(this.mrid);
                        if (this.isDefault) {
                            SaxXmlReportParser.this.defaultMrids.add(this.mrid);
                        } else {
                            object = DefaultArtifact.newIvyArtifact(this.mrid, this.pubdate);
                            MetadataArtifactDownloadReport metadataArtifactDownloadReport = new MetadataArtifactDownloadReport((Artifact)object);
                            SaxXmlReportParser.this.metadataReports.put(this.mrid, metadataArtifactDownloadReport);
                            SaxXmlReportParser.this.realMrids.add(this.mrid);
                        }
                        try {
                            object = attributes.getValue("pubdate");
                            if (object != null) {
                                this.pubdate = DateUtil.parse((String)object);
                            }
                            this.skip = false;
                        }
                        catch (ParseException parseException) {
                            throw new IllegalArgumentException("invalid publication date for " + this.organisation + " " + this.module + " " + this.revision + ": " + attributes.getValue("pubdate"));
                        }
                    }
                } else if ("metadata-artifact".equals(string3)) {
                    if (this.skip) {
                        return;
                    }
                    MetadataArtifactDownloadReport metadataArtifactDownloadReport = (MetadataArtifactDownloadReport)SaxXmlReportParser.this.metadataReports.get(this.mrid);
                    if (metadataArtifactDownloadReport != null) {
                        metadataArtifactDownloadReport.setDownloadStatus(DownloadStatus.fromString(attributes.getValue("status")));
                        metadataArtifactDownloadReport.setDownloadDetails(attributes.getValue("details"));
                        metadataArtifactDownloadReport.setSize(Long.parseLong(attributes.getValue("size")));
                        metadataArtifactDownloadReport.setDownloadTimeMillis(Long.parseLong(attributes.getValue("time")));
                        metadataArtifactDownloadReport.setSearched(SaxXmlReportParser.parseBoolean(attributes.getValue("searched")));
                        if (attributes.getValue("location") != null) {
                            metadataArtifactDownloadReport.setLocalFile(new File(attributes.getValue("location")));
                        }
                        if (attributes.getValue("original-local-location") != null) {
                            metadataArtifactDownloadReport.setOriginalLocalFile(new File(attributes.getValue("original-local-location")));
                        }
                        if (attributes.getValue("origin-location") != null) {
                            if (ArtifactOrigin.isUnknown(attributes.getValue("origin-location"))) {
                                metadataArtifactDownloadReport.setArtifactOrigin(ArtifactOrigin.unkwnown(metadataArtifactDownloadReport.getArtifact()));
                            } else {
                                metadataArtifactDownloadReport.setArtifactOrigin(new ArtifactOrigin(metadataArtifactDownloadReport.getArtifact(), SaxXmlReportParser.parseBoolean(attributes.getValue("origin-is-local")), attributes.getValue("origin-location")));
                            }
                        }
                    }
                } else if ("artifact".equals(string3)) {
                    if (this.skip) {
                        return;
                    }
                    String string5 = attributes.getValue("status");
                    String string6 = attributes.getValue("name");
                    String string7 = attributes.getValue("type");
                    String string8 = attributes.getValue("ext");
                    DefaultArtifact defaultArtifact = new DefaultArtifact(this.mrid, this.pubdate, string6, string7, string8, ExtendableItemHelper.getExtraAttributes(attributes, "extra-"));
                    ArtifactDownloadReport artifactDownloadReport = new ArtifactDownloadReport(defaultArtifact);
                    artifactDownloadReport.setDownloadStatus(DownloadStatus.fromString(string5));
                    artifactDownloadReport.setDownloadDetails(attributes.getValue("details"));
                    artifactDownloadReport.setSize(Long.parseLong(attributes.getValue("size")));
                    artifactDownloadReport.setDownloadTimeMillis(Long.parseLong(attributes.getValue("time")));
                    if (attributes.getValue("location") != null) {
                        artifactDownloadReport.setLocalFile(new File(attributes.getValue("location")));
                    }
                    this.revisionArtifacts.add(artifactDownloadReport);
                } else if ("origin-location".equals(string3)) {
                    if (this.skip) {
                        return;
                    }
                    ArtifactDownloadReport artifactDownloadReport = (ArtifactDownloadReport)this.revisionArtifacts.get(this.revisionArtifacts.size() - 1);
                    if (ArtifactOrigin.isUnknown(attributes.getValue("location"))) {
                        artifactDownloadReport.setArtifactOrigin(ArtifactOrigin.unkwnown(artifactDownloadReport.getArtifact()));
                    } else {
                        artifactDownloadReport.setArtifactOrigin(new ArtifactOrigin(artifactDownloadReport.getArtifact(), SaxXmlReportParser.parseBoolean(attributes.getValue("is-local")), attributes.getValue("location")));
                    }
                } else if ("info".equals(string3)) {
                    String string9 = attributes.getValue("organisation");
                    String string10 = attributes.getValue("module");
                    String string11 = attributes.getValue("branch");
                    String string12 = attributes.getValue("revision");
                    HashMap<String, String> hashMap = new HashMap<String, String>();
                    for (int i = 0; i < attributes.getLength(); ++i) {
                        String string13 = attributes.getQName(i);
                        if (!string13.startsWith("extra-")) continue;
                        String string14 = string13.substring("extra-".length());
                        String string15 = attributes.getValue(i);
                        hashMap.put(string14, string15);
                    }
                    SaxXmlReportParser.this.mRevisionId = ModuleRevisionId.newInstance(string9, string10, string11, string12, hashMap);
                }
            }

            @Override
            public void endElement(String string, String string2, String string3) throws SAXException {
                if ("dependencies".equals(string3)) {
                    for (List list : this.revisionsMap.values()) {
                        SaxXmlReportParser.this.artifactReports.addAll(list);
                        for (ArtifactDownloadReport artifactDownloadReport : list) {
                            if (artifactDownloadReport.getDownloadStatus() == DownloadStatus.FAILED) continue;
                            SaxXmlReportParser.this.artifacts.add(artifactDownloadReport.getArtifact());
                        }
                    }
                }
            }

            private int getMaxPos() {
                return this.revisionsMap.isEmpty() ? -1 : (Integer)this.revisionsMap.keySet().toArray()[this.revisionsMap.size() - 1];
            }
        }
    }
}

