/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.io.importer.impl;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.LineNumberReader;
import java.io.OutputStream;
import java.io.Reader;
import java.util.ArrayList;
import org.gephi.io.importer.api.Container;
import org.gephi.io.importer.api.ContainerUnloader;
import org.gephi.io.importer.api.Database;
import org.gephi.io.importer.api.FileType;
import org.gephi.io.importer.api.ImportController;
import org.gephi.io.importer.api.ImportUtils;
import org.gephi.io.importer.api.Report;
import org.gephi.io.importer.spi.DatabaseImporter;
import org.gephi.io.importer.spi.DatabaseImporterBuilder;
import org.gephi.io.importer.spi.FileImporter;
import org.gephi.io.importer.spi.FileImporterBuilder;
import org.gephi.io.importer.spi.Importer;
import org.gephi.io.importer.spi.ImporterUI;
import org.gephi.io.importer.spi.ImporterWizardUI;
import org.gephi.io.importer.spi.WizardImporter;
import org.gephi.io.importer.spi.WizardImporterBuilder;
import org.gephi.io.processor.spi.Processor;
import org.gephi.io.processor.spi.Scaler;
import org.gephi.project.api.Workspace;
import org.gephi.utils.TempDirUtils;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Lookup;
import org.openide.util.io.ReaderInputStream;

public class ImportControllerImpl
implements ImportController {
    private final FileImporterBuilder[] fileImporterBuilders = Lookup.getDefault().lookupAll(FileImporterBuilder.class).toArray(new FileImporterBuilder[0]);
    private final DatabaseImporterBuilder[] databaseImporterBuilders = Lookup.getDefault().lookupAll(DatabaseImporterBuilder.class).toArray(new DatabaseImporterBuilder[0]);
    private final WizardImporterBuilder[] wizardImporterBuilders = Lookup.getDefault().lookupAll(WizardImporterBuilder.class).toArray(new WizardImporterBuilder[0]);
    private final ImporterUI[] uis = Lookup.getDefault().lookupAll(ImporterUI.class).toArray(new ImporterUI[0]);
    private final ImporterWizardUI[] wizardUis = Lookup.getDefault().lookupAll(ImporterWizardUI.class).toArray(new ImporterWizardUI[0]);

    @Override
    public FileImporter getFileImporter(File file) {
        if (file != null) {
            return this.getFileImporter(FileUtil.toFileObject((File)file));
        }
        return null;
    }

    @Override
    public FileImporter getFileImporter(FileObject fileObject) {
        if (fileObject != null) {
            fileObject = ImportUtils.getArchivedFile(fileObject);
            FileImporterBuilder builder = this.getMatchingImporter(fileObject);
            if (fileObject != null && builder != null) {
                FileImporter fi = builder.buildImporter();
                return fi;
            }
        }
        return null;
    }

    @Override
    public FileImporter getFileImporter(String importerName) {
        FileImporterBuilder builder = this.getMatchingImporter(importerName);
        if (builder != null) {
            return builder.buildImporter();
        }
        return null;
    }

    @Override
    public Container importFile(File file) throws FileNotFoundException {
        FileObject fileObject = FileUtil.toFileObject((File)file);
        if (fileObject != null) {
            fileObject = ImportUtils.getArchivedFile(fileObject);
            file = FileUtil.toFile((FileObject)fileObject);
            FileImporterBuilder builder = this.getMatchingImporter(fileObject);
            if (fileObject != null && builder != null) {
                Container c = this.importFile(fileObject.getInputStream(), builder.buildImporter(), file);
                return c;
            }
        }
        return null;
    }

    @Override
    public Container importFile(File file, FileImporter importer) throws FileNotFoundException {
        FileObject fileObject = FileUtil.toFileObject((File)file);
        if (fileObject != null) {
            fileObject = ImportUtils.getArchivedFile(fileObject);
            file = FileUtil.toFile((FileObject)fileObject);
            if (fileObject != null) {
                Container c = this.importFile(fileObject.getInputStream(), importer, file);
                return c;
            }
        }
        return null;
    }

    @Override
    public Container importFile(Reader reader, FileImporter importer) {
        return this.importFile(reader, importer, null);
    }

    public Container importFile(Reader reader, FileImporter importer, File file) {
        Container container = ((Container.Factory)Lookup.getDefault().lookup(Container.Factory.class)).newContainer();
        Report report = new Report();
        container.setReport(report);
        if (importer instanceof FileImporter.FileAware) {
            if (file == null) {
                try {
                    file = TempDirUtils.createTempDir().createFile("file_copy");
                    try (FileOutputStream fos = new FileOutputStream(file);){
                        FileUtil.copy((InputStream)new ReaderInputStream(reader, "UTF-8"), (OutputStream)fos);
                    }
                }
                catch (IOException ex) {
                    throw new RuntimeException(ex);
                }
            }
            ((FileImporter.FileAware)((Object)importer)).setFile(file);
        } else {
            importer.setReader(reader);
        }
        try {
            if (importer.execute(container.getLoader())) {
                if (importer.getReport() != null && importer.getReport() != report) {
                    report.append(importer.getReport());
                }
                report.close();
                Container ex = container;
                return ex;
            }
        }
        catch (RuntimeException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
        finally {
            try {
                reader.close();
            }
            catch (IOException iOException) {}
        }
        return null;
    }

    @Override
    public Container importFile(InputStream stream, FileImporter importer) {
        return this.importFile(stream, importer, null);
    }

    public Container importFile(InputStream stream, FileImporter importer, File file) {
        try {
            LineNumberReader reader = ImportUtils.getTextReader(stream);
            Container container = this.importFile(reader, importer, file);
            return container;
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
        finally {
            try {
                stream.close();
            }
            catch (IOException ex) {
                throw new RuntimeException(ex);
            }
        }
    }

    @Override
    public Container importDatabase(Database database, DatabaseImporter importer) {
        Container container = ((Container.Factory)Lookup.getDefault().lookup(Container.Factory.class)).newContainer();
        Report report = new Report();
        container.setReport(report);
        importer.setDatabase(database);
        try {
            if (importer.execute(container.getLoader())) {
                if (importer.getReport() != null && importer.getReport() != report) {
                    report.append(importer.getReport());
                }
                report.close();
                return container;
            }
        }
        catch (RuntimeException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
        return null;
    }

    @Override
    public Container importWizard(WizardImporter importer) {
        Container container = ((Container.Factory)Lookup.getDefault().lookup(Container.Factory.class)).newContainer();
        Report report = new Report();
        container.setReport(report);
        try {
            if (importer.execute(container.getLoader())) {
                if (importer.getReport() != null) {
                    report.append(importer.getReport());
                }
                report.close();
                return container;
            }
        }
        catch (RuntimeException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
        return null;
    }

    @Override
    public void process(Container container) {
        Processor processor = (Processor)Lookup.getDefault().lookup(Processor.class);
        if (processor == null) {
            throw new RuntimeException("Impossible to find Default Processor");
        }
        this.process(container, processor, null);
    }

    @Override
    public void process(Container container, Processor processor, Workspace workspace) {
        Scaler scaler;
        container.closeLoader();
        if (container.getUnloader().isAutoScale() && (scaler = (Scaler)Lookup.getDefault().lookup(Scaler.class)) != null) {
            scaler.doScale(container);
        }
        processor.setContainers(new ContainerUnloader[]{container.getUnloader()});
        processor.setWorkspace(workspace);
        processor.process();
    }

    @Override
    public void process(Container[] containers, Processor processor, Workspace workspace) {
        ContainerUnloader[] unloaders = new ContainerUnloader[containers.length];
        int i = 0;
        for (Container container : containers) {
            Scaler scaler;
            container.closeLoader();
            if (container.getUnloader().isAutoScale() && (scaler = (Scaler)Lookup.getDefault().lookup(Scaler.class)) != null) {
                scaler.doScale(container);
            }
            unloaders[i++] = container.getUnloader();
        }
        processor.setContainers(unloaders);
        processor.setWorkspace(workspace);
        processor.process();
    }

    private FileImporterBuilder getMatchingImporter(FileObject fileObject) {
        if (fileObject == null) {
            return null;
        }
        for (FileImporterBuilder im : this.fileImporterBuilders) {
            if (!im.isMatchingImporter(fileObject)) continue;
            return im;
        }
        return null;
    }

    private FileImporterBuilder getMatchingImporter(String extension) {
        if (extension.startsWith(".")) {
            extension = extension.substring(1);
        }
        for (FileImporterBuilder im : this.fileImporterBuilders) {
            for (FileType ft : im.getFileTypes()) {
                for (String ext : ft.getExtensions()) {
                    if (ext.startsWith(".")) {
                        ext = ext.substring(1);
                    }
                    if (!ext.equalsIgnoreCase(extension)) continue;
                    return im;
                }
            }
        }
        return null;
    }

    @Override
    public FileType[] getFileTypes() {
        ArrayList<FileType> list = new ArrayList<FileType>();
        for (FileImporterBuilder im : this.fileImporterBuilders) {
            for (FileType ft : im.getFileTypes()) {
                list.add(ft);
            }
        }
        return list.toArray(new FileType[0]);
    }

    @Override
    public boolean isFileSupported(File file) {
        FileObject fileObject = FileUtil.toFileObject((File)file);
        for (FileImporterBuilder im : this.fileImporterBuilders) {
            if (!im.isMatchingImporter(fileObject)) continue;
            return true;
        }
        return fileObject.getExt().equalsIgnoreCase("zip") || fileObject.getExt().equalsIgnoreCase("gz") || fileObject.getExt().equalsIgnoreCase("bz2");
    }

    @Override
    public ImporterUI getUI(Importer importer) {
        for (ImporterUI ui : this.uis) {
            if (!ui.isUIForImporter(importer)) continue;
            return ui;
        }
        return null;
    }

    @Override
    public ImporterWizardUI getWizardUI(Importer importer) {
        for (ImporterWizardUI ui : this.wizardUis) {
            if (!ui.isUIForImporter(importer)) continue;
            return ui;
        }
        return null;
    }
}

