/*
 * Decompiled with CFR 0.152.
 */
package org.grails.encoder.impl;

import grails.util.GrailsNameUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.grails.encoder.ChainedDecoder;
import org.grails.encoder.ChainedEncoder;
import org.grails.encoder.ChainedEncoders;
import org.grails.encoder.CodecFactory;
import org.grails.encoder.CodecIdentifierProvider;
import org.grails.encoder.CodecLookup;
import org.grails.encoder.Decoder;
import org.grails.encoder.Encoder;
import org.grails.encoder.StreamingEncoder;
import org.grails.encoder.impl.NoneEncoder;
import org.springframework.beans.factory.InitializingBean;

public class BasicCodecLookup
implements CodecLookup,
InitializingBean {
    private static final String NONE_CODEC_NAME = "none";
    protected ConcurrentMap<String, Encoder> encoders;
    protected ConcurrentMap<String, Decoder> decoders;
    public static final StreamingEncoder NONE_ENCODER = new NoneEncoder();

    @Override
    public Encoder lookupEncoder(String codecName) {
        return this.lookupCodec(codecName, this.encoders, Encoder.class);
    }

    @Override
    public Decoder lookupDecoder(String codecName) {
        return this.lookupCodec(codecName, this.decoders, Decoder.class);
    }

    protected <T extends CodecIdentifierProvider> T lookupCodec(String codecName, ConcurrentMap<String, T> map, Class<T> returnType) {
        if (codecName != null && codecName.length() > 0) {
            if (NONE_CODEC_NAME.equalsIgnoreCase(codecName)) {
                if (returnType == Encoder.class) {
                    return (T)NONE_ENCODER;
                }
            } else {
                CodecIdentifierProvider resultObject = (CodecIdentifierProvider)map.get(codecName);
                if (resultObject == null) {
                    resultObject = this.createCodec(codecName, map, returnType);
                }
                return (T)resultObject;
            }
        }
        return null;
    }

    protected <T extends CodecIdentifierProvider> T createCodec(String codecName, ConcurrentMap<String, T> map, Class<T> returnType) {
        if (codecName.indexOf(44) > -1) {
            T createdInstance = this.createChainedCodecInstance(codecName, map, returnType);
            if (createdInstance != null) {
                createdInstance = this.putChainedCodecInstance(codecName, map, createdInstance);
            }
            return createdInstance;
        }
        return null;
    }

    protected <T extends CodecIdentifierProvider> T putChainedCodecInstance(String codecName, ConcurrentMap<String, T> map, T createdInstance) {
        CodecIdentifierProvider previousInstance = (CodecIdentifierProvider)map.putIfAbsent(codecName, createdInstance);
        if (previousInstance != null) {
            return (T)previousInstance;
        }
        return createdInstance;
    }

    protected <T extends CodecIdentifierProvider> T createChainedCodecInstance(String codecName, ConcurrentMap<String, T> map, Class<T> returnType) {
        String[] codecs = codecName.split(",");
        ArrayList<Encoder> codecInstances = new ArrayList<Encoder>(codecs.length);
        for (int i = 0; i < codecs.length; ++i) {
            CodecIdentifierProvider codecInstance = (CodecIdentifierProvider)map.get(codecs[i]);
            if (codecInstance == null) continue;
            codecInstances.add((Encoder)codecInstance);
        }
        if (returnType == Encoder.class) {
            List<StreamingEncoder> streamingEncoders = ChainedEncoders.toStreamingEncoders(codecInstances);
            if (streamingEncoders == null) {
                throw new RuntimeException("ChainedEncoder only supports StreamingEncoder instances. Couldn't build chained encoder for '" + codecName + "'");
            }
            return (T)ChainedEncoder.createFor(streamingEncoders);
        }
        Collections.reverse(codecInstances);
        return (T)new ChainedDecoder(codecInstances.toArray(new Decoder[codecInstances.size()]));
    }

    protected synchronized <T extends CodecIdentifierProvider> void registerWithNameVaritions(Map<String, T> destinationMap, T target) {
        String name = target.getCodecIdentifier().getCodecName();
        this.registerVariationsOfName(destinationMap, target, name);
        Set<String> aliases = target.getCodecIdentifier().getCodecAliases();
        if (aliases != null) {
            for (String alias : aliases) {
                this.registerVariationsOfName(destinationMap, target, alias);
            }
        }
    }

    protected <T extends CodecIdentifierProvider> void registerVariationsOfName(Map<String, T> destinationMap, T target, String name) {
        Collection<String> nameVariations = this.createNameVariations(name, target);
        for (String nameVariation : nameVariations) {
            destinationMap.put(nameVariation, target);
        }
    }

    protected Collection<String> createNameVariations(String name, CodecIdentifierProvider target) {
        LinkedHashSet<String> nameVariations = new LinkedHashSet<String>();
        nameVariations.add(name);
        nameVariations.add(name.toLowerCase());
        nameVariations.add(name.toUpperCase());
        nameVariations.add(GrailsNameUtils.getPropertyNameRepresentation((String)name));
        return nameVariations;
    }

    public void registerCodecFactory(CodecFactory codecFactory) {
        Decoder decoder;
        Encoder encoder = codecFactory.getEncoder();
        if (encoder != null) {
            this.registerEncoder(encoder);
        }
        if ((decoder = codecFactory.getDecoder()) != null) {
            this.registerDecoder(decoder);
        }
    }

    public void registerDecoder(Decoder decoder) {
        this.registerWithNameVaritions(this.decoders, decoder);
    }

    public void registerEncoder(Encoder encoder) {
        this.registerWithNameVaritions(this.encoders, encoder);
    }

    public void reInitialize() {
        this.encoders = new ConcurrentHashMap<String, Encoder>();
        this.decoders = new ConcurrentHashMap<String, Decoder>();
        this.registerCodecs();
    }

    protected void registerCodecs() {
    }

    public void afterPropertiesSet() throws Exception {
        this.reInitialize();
    }
}

