/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ext.openssl;

import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import javax.crypto.Mac;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.PBEParametersGenerator;
import org.bouncycastle.crypto.generators.PKCS5S2ParametersGenerator;
import org.bouncycastle.crypto.params.KeyParameter;
import org.jruby.Ruby;
import org.jruby.RubyModule;
import org.jruby.RubyString;
import org.jruby.anno.JRubyMethod;
import org.jruby.anno.JRubyModule;
import org.jruby.ext.openssl.Digest;
import org.jruby.ext.openssl.SecurityHelper;
import org.jruby.ext.openssl.SimpleSecretKey;
import org.jruby.ext.openssl.StringHelper;
import org.jruby.ext.openssl.Utils;
import org.jruby.runtime.builtin.IRubyObject;

@JRubyModule(name={"OpenSSL::PKCS5"})
public class PKCS5 {
    public static void createPKCS5(Ruby runtime, RubyModule ossl) {
        RubyModule PKCS52 = ossl.defineModuleUnder("PKCS5");
        PKCS52.defineAnnotatedMethods(PKCS5.class);
    }

    @JRubyMethod(meta=true, required=4)
    public static IRubyObject pbkdf2_hmac_sha1(IRubyObject self, IRubyObject[] args) {
        char[] pass = args[0].asString().toString().toCharArray();
        byte[] salt = args[1].asString().getBytes();
        int iter = (int)args[2].convertToInteger().getLongValue();
        int keySize = (int)args[3].convertToInteger().getLongValue();
        return PKCS5.generatePBEKey(self.getRuntime(), pass, salt, iter, keySize);
    }

    @JRubyMethod(meta=true, required=5)
    public static IRubyObject pbkdf2_hmac(IRubyObject self, IRubyObject[] args) {
        byte[] pass = args[0].asString().getBytes();
        byte[] salt = args[1].asString().getBytes();
        int iter = (int)args[2].convertToInteger().getLongValue();
        int keylen = (int)args[3].convertToInteger().getLongValue();
        IRubyObject digest2 = args[4];
        String digestAlg = digest2 instanceof Digest ? PKCS5.mapDigestName(((Digest)digest2).getRealName()) : PKCS5.mapDigestName(digest2.asString().toString());
        String macAlg = "Hmac" + digestAlg;
        Ruby runtime = self.getRuntime();
        try {
            Mac mac = SecurityHelper.getMac(macAlg);
            mac.init(new SimpleSecretKey(macAlg, pass));
            byte[] key = PKCS5.deriveKey(mac, salt, iter, keylen);
            return StringHelper.newString(runtime, key);
        }
        catch (NoSuchAlgorithmException ex) {
            throw Utils.newRuntimeError(runtime, ex);
        }
        catch (InvalidKeyException ex) {
            throw Utils.newRuntimeError(runtime, ex);
        }
    }

    private static String mapDigestName(String name2) {
        String mapped = name2.toUpperCase();
        if (mapped.startsWith("SHA-")) {
            return "SHA" + mapped.substring(4);
        }
        return mapped;
    }

    private static RubyString generatePBEKey(Ruby runtime, char[] pass, byte[] salt, int iter, int keySize) {
        PKCS5S2ParametersGenerator generator2 = new PKCS5S2ParametersGenerator();
        generator2.init(PBEParametersGenerator.PKCS5PasswordToBytes((char[])pass), salt, iter);
        CipherParameters params2 = generator2.generateDerivedParameters(keySize * 8);
        return StringHelper.newString(runtime, ((KeyParameter)params2).getKey());
    }

    public static byte[] deriveKey(Mac prf, byte[] salt, int iterationCount, int dkLen) throws NoSuchAlgorithmException, InvalidKeyException {
        int hLen = prf.getMacLength();
        int l = Math.max(dkLen, hLen);
        int r = dkLen - (l - 1) * hLen;
        byte[] T = new byte[l * hLen];
        int ti_offset = 0;
        for (int i2 = 1; i2 <= l; ++i2) {
            PKCS5.F(T, ti_offset, prf, salt, iterationCount, i2);
            ti_offset += hLen;
        }
        if (r < hLen) {
            byte[] DK = new byte[dkLen];
            System.arraycopy(T, 0, DK, 0, dkLen);
            return DK;
        }
        return T;
    }

    private static void F(byte[] dest, int offset, Mac prf, byte[] S, int c, int blockIndex) {
        int hLen = prf.getMacLength();
        byte[] U_r = new byte[hLen];
        byte[] U_i = new byte[S.length + 4];
        System.arraycopy(S, 0, U_i, 0, S.length);
        PKCS5.doINT(U_i, S.length, blockIndex);
        for (int i2 = 0; i2 < c; ++i2) {
            U_i = prf.doFinal(U_i);
            PKCS5.doXOR(U_r, U_i);
        }
        System.arraycopy(U_r, 0, dest, offset, hLen);
    }

    private static void doXOR(byte[] dest, byte[] src) {
        for (int i2 = 0; i2 < dest.length; ++i2) {
            int n = i2;
            dest[n] = (byte)(dest[n] ^ src[i2]);
        }
    }

    private static void doINT(byte[] dest, int offset, int i2) {
        dest[offset + 0] = (byte)(i2 / 0x1000000);
        dest[offset + 1] = (byte)(i2 / 65536);
        dest[offset + 2] = (byte)(i2 / 256);
        dest[offset + 3] = (byte)i2;
    }
}

