/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.javasupport.ext;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Modifier;
import org.jruby.Ruby;
import org.jruby.RubyBoolean;
import org.jruby.RubyClass;
import org.jruby.RubyModule;
import org.jruby.RubyString;
import org.jruby.anno.JRubyClass;
import org.jruby.anno.JRubyMethod;
import org.jruby.javasupport.Java;
import org.jruby.javasupport.JavaUtil;
import org.jruby.runtime.Helpers;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;

public abstract class JavaLangReflect {
    public static void define(Ruby runtime) {
        Constructor.define(runtime);
        Field.define(runtime);
        Method.define(runtime);
    }

    static RubyBoolean isAbstract(IRubyObject self2, int mod) {
        return self2.getRuntime().newBoolean(Modifier.isAbstract(mod));
    }

    static RubyBoolean isPublic(IRubyObject self2, int mod) {
        return self2.getRuntime().newBoolean(Modifier.isPublic(mod));
    }

    static RubyBoolean isProtected(IRubyObject self2, int mod) {
        return self2.getRuntime().newBoolean(Modifier.isProtected(mod));
    }

    static RubyBoolean isPrivate(IRubyObject self2, int mod) {
        return self2.getRuntime().newBoolean(Modifier.isPrivate(mod));
    }

    static RubyBoolean isFinal(IRubyObject self2, int mod) {
        return self2.getRuntime().newBoolean(Modifier.isFinal(mod));
    }

    static RubyBoolean isStatic(IRubyObject self2, int mod) {
        return self2.getRuntime().newBoolean(Modifier.isStatic(mod));
    }

    @JRubyClass(name={"Java::JavaLangReflect::Field"})
    public static class Field {
        static RubyClass define(Ruby runtime) {
            RubyModule Field2 = Java.getProxyClass(runtime, java.lang.reflect.Field.class);
            Field2.defineAnnotatedMethods(Field.class);
            return (RubyClass)Field2;
        }

        @JRubyMethod
        public static IRubyObject value_type(ThreadContext context, IRubyObject self2) {
            java.lang.reflect.Field field2 = (java.lang.reflect.Field)JavaUtil.unwrapJavaObject(self2);
            return JavaUtil.convertJavaToUsableRubyObject(context.runtime, field2.getName());
        }

        @JRubyMethod
        public static IRubyObject value(ThreadContext context, IRubyObject self2, IRubyObject obj) {
            java.lang.reflect.Field field2 = (java.lang.reflect.Field)JavaUtil.unwrapJavaObject(self2);
            try {
                return JavaUtil.convertJavaToUsableRubyObject(context.runtime, field2.get(JavaUtil.unwrapJavaObject(obj)));
            }
            catch (IllegalAccessException e) {
                Helpers.throwException(e);
                return null;
            }
        }

        @JRubyMethod
        public static IRubyObject set_value(ThreadContext context, IRubyObject self2, IRubyObject obj, IRubyObject value2) {
            java.lang.reflect.Field field2 = (java.lang.reflect.Field)JavaUtil.unwrapJavaObject(self2);
            try {
                Object val = value2.toJava(field2.getType());
                field2.set(JavaUtil.unwrapJavaObject(obj), val);
            }
            catch (IllegalAccessException e) {
                Helpers.throwException(e);
                return null;
            }
            return context.nil;
        }

        @JRubyMethod
        public static IRubyObject static_value(ThreadContext context, IRubyObject self2) {
            java.lang.reflect.Field field2 = (java.lang.reflect.Field)JavaUtil.unwrapJavaObject(self2);
            try {
                return JavaUtil.convertJavaToUsableRubyObject(context.runtime, field2.get(null));
            }
            catch (IllegalAccessException e) {
                Helpers.throwException(e);
                return null;
            }
        }

        @JRubyMethod
        public static IRubyObject set_static_value(ThreadContext context, IRubyObject self2, IRubyObject value2) {
            java.lang.reflect.Field field2 = (java.lang.reflect.Field)JavaUtil.unwrapJavaObject(self2);
            try {
                Object val = value2.toJava(field2.getType());
                field2.set(null, val);
            }
            catch (IllegalAccessException e) {
                Helpers.throwException(e);
                return null;
            }
            return context.nil;
        }

        @JRubyMethod
        public static IRubyObject inspect(ThreadContext context, IRubyObject self2) {
            AccessibleObject thiz = (AccessibleObject)JavaUtil.unwrapJavaObject(self2);
            return RubyString.newString(context.runtime, thiz.toString());
        }

        @JRubyMethod(name={"public?"})
        public static IRubyObject public_p(IRubyObject self2) {
            java.lang.reflect.Field thiz = (java.lang.reflect.Field)JavaUtil.unwrapJavaObject(self2);
            return JavaLangReflect.isPublic(self2, thiz.getModifiers());
        }

        @JRubyMethod(name={"protected?"})
        public static IRubyObject protected_p(IRubyObject self2) {
            java.lang.reflect.Field thiz = (java.lang.reflect.Field)JavaUtil.unwrapJavaObject(self2);
            return JavaLangReflect.isProtected(self2, thiz.getModifiers());
        }

        @JRubyMethod(name={"private?"})
        public static IRubyObject private_p(IRubyObject self2) {
            java.lang.reflect.Field thiz = (java.lang.reflect.Field)JavaUtil.unwrapJavaObject(self2);
            return JavaLangReflect.isPrivate(self2, thiz.getModifiers());
        }

        @JRubyMethod(name={"final?"})
        public static IRubyObject final_p(IRubyObject self2) {
            java.lang.reflect.Field thiz = (java.lang.reflect.Field)JavaUtil.unwrapJavaObject(self2);
            return JavaLangReflect.isFinal(self2, thiz.getModifiers());
        }

        @JRubyMethod(name={"static?"})
        public static IRubyObject static_p(IRubyObject self2) {
            java.lang.reflect.Field thiz = (java.lang.reflect.Field)JavaUtil.unwrapJavaObject(self2);
            return JavaLangReflect.isStatic(self2, thiz.getModifiers());
        }
    }

    @JRubyClass(name={"Java::JavaLangReflect::Method"})
    public static class Method {
        static RubyClass define(Ruby runtime) {
            RubyModule Method2 = Java.getProxyClass(runtime, java.lang.reflect.Method.class);
            Method2.defineAnnotatedMethods(Method.class);
            return (RubyClass)Method2;
        }

        @JRubyMethod
        public static IRubyObject return_type(ThreadContext context, IRubyObject self2) {
            java.lang.reflect.Method thiz = (java.lang.reflect.Method)JavaUtil.unwrapJavaObject(self2);
            return JavaUtil.convertJavaToUsableRubyObject(context.runtime, thiz.getReturnType());
        }

        @JRubyMethod
        public static IRubyObject argument_types(ThreadContext context, IRubyObject self2) {
            java.lang.reflect.Method thiz = (java.lang.reflect.Method)JavaUtil.unwrapJavaObject(self2);
            return JavaUtil.convertJavaToUsableRubyObject(context.runtime, thiz.getParameterTypes());
        }

        @JRubyMethod(rest=true)
        public static IRubyObject invoke_static(ThreadContext context, IRubyObject self2, IRubyObject[] args2) {
            java.lang.reflect.Method thiz = (java.lang.reflect.Method)JavaUtil.unwrapJavaObject(self2);
            Object[] javaArgs = JavaUtil.convertArguments(args2, thiz.getParameterTypes());
            try {
                return JavaUtil.convertJavaToUsableRubyObject(context.runtime, thiz.invoke(null, javaArgs));
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                Helpers.throwException(e);
                return null;
            }
        }

        @JRubyMethod
        public static IRubyObject inspect(ThreadContext context, IRubyObject self2) {
            AccessibleObject thiz = (AccessibleObject)JavaUtil.unwrapJavaObject(self2);
            return RubyString.newString(context.runtime, thiz.toString());
        }

        @JRubyMethod(name={"abstract?"})
        public static IRubyObject abstract_p(IRubyObject self2) {
            java.lang.reflect.Field thiz = (java.lang.reflect.Field)JavaUtil.unwrapJavaObject(self2);
            return JavaLangReflect.isAbstract(self2, thiz.getModifiers());
        }

        @JRubyMethod(name={"public?"})
        public static IRubyObject public_p(IRubyObject self2) {
            java.lang.reflect.Method thiz = (java.lang.reflect.Method)JavaUtil.unwrapJavaObject(self2);
            return JavaLangReflect.isPublic(self2, thiz.getModifiers());
        }

        @JRubyMethod(name={"protected?"})
        public static IRubyObject protected_p(IRubyObject self2) {
            java.lang.reflect.Method thiz = (java.lang.reflect.Method)JavaUtil.unwrapJavaObject(self2);
            return JavaLangReflect.isProtected(self2, thiz.getModifiers());
        }

        @JRubyMethod(name={"private?"})
        public static IRubyObject private_p(IRubyObject self2) {
            java.lang.reflect.Method thiz = (java.lang.reflect.Method)JavaUtil.unwrapJavaObject(self2);
            return JavaLangReflect.isPrivate(self2, thiz.getModifiers());
        }

        @JRubyMethod(name={"final?"})
        public static IRubyObject final_p(IRubyObject self2) {
            java.lang.reflect.Method thiz = (java.lang.reflect.Method)JavaUtil.unwrapJavaObject(self2);
            return JavaLangReflect.isFinal(self2, thiz.getModifiers());
        }

        @JRubyMethod(name={"static?"})
        public static IRubyObject static_p(IRubyObject self2) {
            java.lang.reflect.Method thiz = (java.lang.reflect.Method)JavaUtil.unwrapJavaObject(self2);
            return JavaLangReflect.isStatic(self2, thiz.getModifiers());
        }
    }

    @JRubyClass(name={"Java::JavaLangReflect::Constructor"})
    public static class Constructor {
        static RubyClass define(Ruby runtime) {
            RubyModule Constructor2 = Java.getProxyClass(runtime, java.lang.reflect.Constructor.class);
            Constructor2.defineAnnotatedMethods(Constructor.class);
            return (RubyClass)Constructor2;
        }

        @JRubyMethod
        public static IRubyObject return_type(ThreadContext context, IRubyObject self2) {
            return context.nil;
        }

        @JRubyMethod
        public static IRubyObject argument_types(ThreadContext context, IRubyObject self2) {
            java.lang.reflect.Constructor thiz = (java.lang.reflect.Constructor)JavaUtil.unwrapJavaObject(self2);
            return JavaUtil.convertJavaToUsableRubyObject(context.runtime, thiz.getParameterTypes());
        }

        @JRubyMethod
        public static IRubyObject inspect(ThreadContext context, IRubyObject self2) {
            AccessibleObject thiz = (AccessibleObject)JavaUtil.unwrapJavaObject(self2);
            return RubyString.newString(context.runtime, thiz.toString());
        }

        @JRubyMethod(name={"public?"})
        public static IRubyObject public_p(IRubyObject self2) {
            java.lang.reflect.Constructor thiz = (java.lang.reflect.Constructor)JavaUtil.unwrapJavaObject(self2);
            return JavaLangReflect.isPublic(self2, thiz.getModifiers());
        }

        @JRubyMethod(name={"protected?"})
        public static IRubyObject protected_p(IRubyObject self2) {
            java.lang.reflect.Constructor thiz = (java.lang.reflect.Constructor)JavaUtil.unwrapJavaObject(self2);
            return JavaLangReflect.isProtected(self2, thiz.getModifiers());
        }

        @JRubyMethod(name={"private?"})
        public static IRubyObject private_p(IRubyObject self2) {
            java.lang.reflect.Constructor thiz = (java.lang.reflect.Constructor)JavaUtil.unwrapJavaObject(self2);
            return JavaLangReflect.isPrivate(self2, thiz.getModifiers());
        }

        @JRubyMethod(name={"final?"})
        public static IRubyObject final_p(IRubyObject self2) {
            java.lang.reflect.Constructor thiz = (java.lang.reflect.Constructor)JavaUtil.unwrapJavaObject(self2);
            return JavaLangReflect.isFinal(self2, thiz.getModifiers());
        }

        @JRubyMethod(name={"static?"})
        public static IRubyObject static_p(IRubyObject self2) {
            java.lang.reflect.Constructor thiz = (java.lang.reflect.Constructor)JavaUtil.unwrapJavaObject(self2);
            return JavaLangReflect.isStatic(self2, thiz.getModifiers());
        }
    }
}

