/*
 * Decompiled with CFR 0.152.
 */
package jogamp.graph.font.typecast.ot.table;

import java.io.DataInputStream;
import java.io.IOException;
import jogamp.graph.font.typecast.ot.table.Feature;
import jogamp.graph.font.typecast.ot.table.FeatureRecord;
import jogamp.graph.font.typecast.ot.table.LangSys;

public class FeatureList {
    private final int _featureCount;
    private final FeatureRecord[] _featureRecords;
    private final Feature[] _features;

    public FeatureList(DataInputStream dataInputStream, int n) throws IOException {
        int n2;
        dataInputStream.reset();
        dataInputStream.skipBytes(n);
        this._featureCount = dataInputStream.readUnsignedShort();
        this._featureRecords = new FeatureRecord[this._featureCount];
        this._features = new Feature[this._featureCount];
        for (n2 = 0; n2 < this._featureCount; ++n2) {
            this._featureRecords[n2] = new FeatureRecord(dataInputStream);
        }
        for (n2 = 0; n2 < this._featureCount; ++n2) {
            dataInputStream.reset();
            dataInputStream.skipBytes(n + this._featureRecords[n2].getOffset());
            this._features[n2] = new Feature(dataInputStream);
        }
    }

    public int getFeatureCount() {
        return this._featureCount;
    }

    public FeatureRecord getFeatureRecord(int n) {
        return this._featureRecords[n];
    }

    public Feature getFeature(int n) {
        return this._features[n];
    }

    public Feature findFeature(LangSys langSys, String string) {
        if (string.length() != 4) {
            return null;
        }
        int n = string.charAt(0) << 24 | string.charAt(1) << 16 | string.charAt(2) << 8 | string.charAt(3);
        for (int i = 0; i < this._featureCount; ++i) {
            if (this._featureRecords[i].getTag() != n || !langSys.isFeatureIndexed(i)) continue;
            return this._features[i];
        }
        return null;
    }
}

