/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.snaptracer.impl;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;
import org.netbeans.lib.profiler.results.cpu.PrestimeCPUCCTNode;
import org.netbeans.modules.profiler.snaptracer.PackageStateHandler;
import org.netbeans.modules.profiler.snaptracer.Positionable;
import org.netbeans.modules.profiler.snaptracer.ProbeStateHandler;
import org.netbeans.modules.profiler.snaptracer.TracerPackage;
import org.netbeans.modules.profiler.snaptracer.TracerProbe;
import org.netbeans.modules.profiler.snaptracer.TracerProbeDescriptor;
import org.netbeans.modules.profiler.snaptracer.impl.IdeSnapshot;
import org.netbeans.modules.profiler.snaptracer.impl.TracerController;
import org.netbeans.modules.profiler.snaptracer.impl.TracerSupportImpl;
import org.netbeans.modules.profiler.snaptracer.impl.timeline.TimelineSupport;
import org.openide.util.Exceptions;

final class TracerModel {
    private static final Logger LOGGER = Logger.getLogger(TracerController.class.getName());
    private final IdeSnapshot snapshot;
    private final Map<TracerPackage, List<TracerProbe>> probesCache = new HashMap<TracerPackage, List<TracerProbe>>();
    private final Map<TracerProbe, TracerProbeDescriptor> descriptorsCache = new HashMap<TracerProbe, TracerProbeDescriptor>();
    private final Set<Listener> listeners = new HashSet<Listener>();
    private final TimelineSupport timelineSupport;

    TracerModel(IdeSnapshot ideSnapshot) {
        this.snapshot = ideSnapshot;
        this.timelineSupport = new TimelineSupport(new TimelineSupport.DescriptorResolver(){

            @Override
            public TracerProbeDescriptor getDescriptor(TracerProbe tracerProbe) {
                return TracerModel.this.getDescriptor(tracerProbe);
            }
        }, ideSnapshot);
    }

    IdeSnapshot getSnapshot() {
        return this.snapshot;
    }

    int getSamplesCount() {
        return this.snapshot.getSamplesCount();
    }

    long firstTimestamp() {
        return this.getTimestamp(0);
    }

    long lastTimestamp() {
        return this.getTimestamp(this.getSamplesCount() - 1);
    }

    long getTimestamp(int n) {
        try {
            return this.snapshot.getTimestamp(n) / 1000000L;
        }
        catch (IOException iOException) {
            Exceptions.printStackTrace((Throwable)iOException);
            return -1L;
        }
    }

    List<TracerPackage> getPackages() {
        try {
            return TracerSupportImpl.getInstance().getPackages(this.snapshot);
        }
        catch (Throwable throwable) {
            LOGGER.log(Level.INFO, "Package exception in getPackages", throwable);
            return null;
        }
    }

    void addDescriptor(final TracerPackage tracerPackage, final TracerProbeDescriptor tracerProbeDescriptor) {
        TracerSupportImpl.getInstance().perform(new Runnable(){

            @Override
            public void run() {
                TracerModel.this.addProbe(tracerPackage, tracerProbeDescriptor);
            }
        });
    }

    void removeDescriptor(final TracerPackage tracerPackage, final TracerProbeDescriptor tracerProbeDescriptor) {
        TracerSupportImpl.getInstance().perform(new Runnable(){

            @Override
            public void run() {
                TracerModel.this.removeProbe(tracerPackage, tracerProbeDescriptor);
            }
        });
    }

    void addDescriptors(TracerPackage tracerPackage, TracerProbeDescriptor[] tracerProbeDescriptorArray) {
        for (TracerProbeDescriptor tracerProbeDescriptor : tracerProbeDescriptorArray) {
            this.addProbe(tracerPackage, tracerProbeDescriptor);
        }
    }

    void removeDescriptors(TracerPackage tracerPackage, TracerProbeDescriptor[] tracerProbeDescriptorArray) {
        for (TracerProbeDescriptor tracerProbeDescriptor : tracerProbeDescriptorArray) {
            this.removeProbe(tracerPackage, tracerProbeDescriptor);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    TracerProbeDescriptor getDescriptor(TracerProbe tracerProbe) {
        Map<TracerProbe, TracerProbeDescriptor> map = this.descriptorsCache;
        synchronized (map) {
            return this.descriptorsCache.get(tracerProbe);
        }
    }

    List<TracerProbe> getDefinedProbes() {
        ArrayList<TracerProbe> arrayList = new ArrayList<TracerProbe>();
        arrayList.addAll(this.timelineSupport.getProbes());
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Set<Map.Entry<TracerPackage, List<TracerProbe>>> getDefinedProbeSets() {
        Comparator<Map.Entry<TracerPackage, List<TracerProbe>>> comparator = new Comparator<Map.Entry<TracerPackage, List<TracerProbe>>>(){

            @Override
            public int compare(Map.Entry<TracerPackage, List<TracerProbe>> entry, Map.Entry<TracerPackage, List<TracerProbe>> entry2) {
                return Positionable.STRONG_COMPARATOR.compare(entry.getKey(), entry2.getKey());
            }
        };
        TreeSet<Map.Entry<TracerPackage, List<TracerProbe>>> treeSet = new TreeSet<Map.Entry<TracerPackage, List<TracerProbe>>>(comparator);
        Map<TracerPackage, List<TracerProbe>> map = this.probesCache;
        synchronized (map) {
            treeSet.addAll(this.probesCache.entrySet());
        }
        return treeSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean areProbesDefined() {
        Map<TracerPackage, List<TracerProbe>> map = this.probesCache;
        synchronized (map) {
            return !this.probesCache.isEmpty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addProbe(TracerPackage tracerPackage, TracerProbeDescriptor tracerProbeDescriptor) {
        TracerProbe tracerProbe = tracerPackage.getProbe(tracerProbeDescriptor);
        Map<Object, Object> map = this.descriptorsCache;
        synchronized (map) {
            this.descriptorsCache.put(tracerProbe, tracerProbeDescriptor);
        }
        map = this.probesCache;
        synchronized (map) {
            List<TracerProbe> list = this.probesCache.get(tracerPackage);
            if (list == null) {
                list = new ArrayList<TracerProbe>();
                this.probesCache.put(tracerPackage, list);
            }
            list.add(tracerProbe);
        }
        this.timelineSupport.addProbe(tracerProbe);
        this.notifyProbeAdded(tracerPackage, tracerProbe);
        this.fireProbeAdded(tracerProbe);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeProbe(TracerPackage tracerPackage, TracerProbeDescriptor tracerProbeDescriptor) {
        TracerProbe tracerProbe = null;
        boolean bl = true;
        Map<Object, Object> map = this.descriptorsCache;
        synchronized (map) {
            for (Map.Entry<TracerProbe, TracerProbeDescriptor> entry : this.descriptorsCache.entrySet()) {
                if (entry.getValue() != tracerProbeDescriptor) continue;
                tracerProbe = entry.getKey();
                break;
            }
            this.descriptorsCache.remove(tracerProbe);
        }
        map = this.probesCache;
        synchronized (map) {
            List<TracerProbe> list = this.probesCache.get(tracerPackage);
            list.remove(tracerProbe);
            if (list.isEmpty()) {
                this.probesCache.remove(tracerPackage);
                bl = !this.probesCache.isEmpty();
            }
        }
        this.timelineSupport.removeProbe(tracerProbe);
        this.notifyProbeRemoved(tracerPackage, tracerProbe);
        this.fireProbeRemoved(tracerProbe, bl);
    }

    private void notifyProbeAdded(TracerPackage tracerPackage, TracerProbe tracerProbe) {
        ProbeStateHandler probeStateHandler;
        PackageStateHandler packageStateHandler = tracerPackage.getStateHandler();
        if (packageStateHandler != null) {
            try {
                packageStateHandler.probeAdded(tracerProbe, this.snapshot);
            }
            catch (Throwable throwable) {
                LOGGER.log(Level.INFO, "Package exception in probeAdded", throwable);
            }
        }
        if ((probeStateHandler = tracerProbe.getStateHandler()) != null) {
            try {
                probeStateHandler.probeAdded(this.snapshot);
            }
            catch (Throwable throwable) {
                LOGGER.log(Level.INFO, "Probe exception in probeAdded", throwable);
            }
        }
    }

    private void notifyProbeRemoved(TracerPackage tracerPackage, TracerProbe tracerProbe) {
        ProbeStateHandler probeStateHandler;
        PackageStateHandler packageStateHandler = tracerPackage.getStateHandler();
        if (packageStateHandler != null) {
            try {
                packageStateHandler.probeRemoved(tracerProbe, this.snapshot);
            }
            catch (Throwable throwable) {
                LOGGER.log(Level.INFO, "Package exception in probeRemoved", throwable);
            }
        }
        if ((probeStateHandler = tracerProbe.getStateHandler()) != null) {
            try {
                probeStateHandler.probeRemoved(this.snapshot);
            }
            catch (Throwable throwable) {
                LOGGER.log(Level.INFO, "Probe exception in probeRemoved", throwable);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addListener(Listener listener) {
        Set<Listener> set = this.listeners;
        synchronized (set) {
            this.listeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeListener(Listener listener) {
        Set<Listener> set = this.listeners;
        synchronized (set) {
            this.listeners.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireProbeAdded(final TracerProbe tracerProbe) {
        final HashSet<Listener> hashSet = new HashSet<Listener>();
        Set<Listener> set = this.listeners;
        synchronized (set) {
            hashSet.addAll(this.listeners);
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                for (Listener listener : hashSet) {
                    listener.probeAdded(tracerProbe);
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireProbeRemoved(final TracerProbe tracerProbe, final boolean bl) {
        final HashSet<Listener> hashSet = new HashSet<Listener>();
        Set<Listener> set = this.listeners;
        synchronized (set) {
            hashSet.addAll(this.listeners);
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                for (Listener listener : hashSet) {
                    listener.probeRemoved(tracerProbe, bl);
                }
            }
        });
    }

    TimelineSupport getTimelineSupport() {
        return this.timelineSupport;
    }

    List<Integer> getIntervals(PrestimeCPUCCTNode prestimeCPUCCTNode) throws IOException {
        TimelineSupport timelineSupport = this.getTimelineSupport();
        int n = Math.min(timelineSupport.getStartIndex(), timelineSupport.getEndIndex());
        int n2 = Math.max(timelineSupport.getStartIndex(), timelineSupport.getEndIndex());
        return this.getSnapshot().getIntervals(n, n2, prestimeCPUCCTNode);
    }

    static interface Listener {
        public void probeAdded(TracerProbe var1);

        public void probeRemoved(TracerProbe var1, boolean var2);
    }
}

